/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.services.graphql.internal.schema.mutation.viewpoints;

import graphql.Scalars;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.services.common.api.SiriusServicesCommonOptionalUtils;
import org.eclipse.sirius.services.graphql.internal.SiriusGraphQLOptionalUtils;
import org.eclipse.sirius.services.graphql.internal.schema.mutation.resources.SiriusGraphQLProjectNameArgument;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public final class SiriusGraphQLCreateRepresentationField {
    private static final String CREATE_REPRESENTATION_FIELD = "createRepresentation";
    private static final String RESOURCE_PATH_ARG = "resourcePath";
    private static final String DESCRIPTION_ARG = "description";

    private SiriusGraphQLCreateRepresentationField() {
    }

    public static GraphQLFieldDefinition build() {
        return GraphQLFieldDefinition.newFieldDefinition().name(CREATE_REPRESENTATION_FIELD).argument(SiriusGraphQLProjectNameArgument.build()).argument(SiriusGraphQLCreateRepresentationField.getResourcePathArgument()).argument(SiriusGraphQLCreateRepresentationField.getDescriptionArgument()).type((GraphQLOutputType)new GraphQLTypeReference("Project")).dataFetcher(SiriusGraphQLCreateRepresentationField.getCreateRepresentationDataFetcher()).build();
    }

    private static GraphQLArgument getResourcePathArgument() {
        return GraphQLArgument.newArgument().name(RESOURCE_PATH_ARG).type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString)).build();
    }

    private static GraphQLArgument getDescriptionArgument() {
        return GraphQLArgument.newArgument().name(DESCRIPTION_ARG).type((GraphQLInputType)new GraphQLNonNull((GraphQLType)new GraphQLTypeReference("RepresentationCreationDescription"))).build();
    }

    private static DataFetcher<IProject> getCreateRepresentationDataFetcher() {
        return environment -> {
            Optional<IProject> optionalProject = SiriusGraphQLOptionalUtils.projectFromName(environment.getArgument("projectName"));
            Optional optionalSession = optionalProject.flatMap(SiriusServicesCommonOptionalUtils::toSession);
            Function<IProject, Optional> getFile = iProject -> Optional.of(environment.getArgument(RESOURCE_PATH_ARG)).filter(String.class::isInstance).map(String.class::cast).map(Path::new).map(arg_0 -> ((IProject)iProject).getFile(arg_0));
            Optional optionalFile = optionalProject.flatMap(getFile);
            Optional<EObject> optionalResource = optionalFile.flatMap(iFile -> optionalSession.flatMap(session -> SiriusServicesCommonOptionalUtils.toResource((Session)session, (IFile)iFile)));
            Map description = (Map)environment.getArgument(DESCRIPTION_ARG);
            String viewpointIdentifier = (String)description.get("viewpointIdentifier");
            String representationIdentifier = (String)description.get("representationIdentifier");
            String eObjectFragment = (String)description.get("eObjectFragment");
            String name = (String)description.get("name");
            Optional<Viewpoint> optionalViewpoint = SiriusGraphQLOptionalUtils.viewpointFromIdentifier(viewpointIdentifier);
            Optional optionalRepresentationDescription = optionalViewpoint.flatMap(viewpoint -> viewpoint.getOwnedRepresentations().stream().filter(representationDescription -> representationIdentifier.equals(representationDescription.getName())).findFirst());
            Optional<EObject> optionalEObject = optionalResource.map(resource -> resource.getEObject(eObjectFragment));
            optionalSession.ifPresent(session -> optionalRepresentationDescription.ifPresent(representationDescription -> optionalEObject.ifPresent(eObject -> {
                boolean canCreate = DialectManager.INSTANCE.canCreate(eObject, representationDescription, true);
                if (canCreate) {
                    SiriusGraphQLCreateRepresentationField.createRepresentation(session, representationDescription, name, eObject);
                }
            })));
            return optionalProject.orElse(null);
        };
    }

    private static void createRepresentation(final Session session, final RepresentationDescription representationDescription, final String name, final EObject eObject) {
        RecordingCommand command = new RecordingCommand(session.getTransactionalEditingDomain()){

            protected void doExecute() {
                DialectManager.INSTANCE.createRepresentation(name, eObject, representationDescription, session, (IProgressMonitor)new NullProgressMonitor());
            }
        };
        session.getTransactionalEditingDomain().getCommandStack().execute((Command)command);
    }
}

