/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.services.graphql.internal.schema.query.emf;

import graphql.Scalars;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import graphql.schema.TypeResolver;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.sirius.services.graphql.internal.schema.ISiriusGraphQLTypesBuilder;
import org.eclipse.sirius.services.graphql.internal.schema.query.emf.SiriusGraphQLEObjectFragmentField;

public class SiriusGraphQLEClassTypesBuilder
implements ISiriusGraphQLTypesBuilder {
    private static final String IMPL_SUFFIX = "Impl";
    private EClass eClass;

    public SiriusGraphQLEClassTypesBuilder(EClass eClass) {
        this.eClass = eClass;
    }

    @Override
    public Set<GraphQLType> getTypes() {
        LinkedHashSet<GraphQLType> types = new LinkedHashSet<GraphQLType>();
        GraphQLInterfaceType interfaceType = this.buildInterfaceType();
        types.add((GraphQLType)interfaceType);
        if (!this.eClass.isAbstract() && !this.eClass.isInterface()) {
            types.add((GraphQLType)this.buildObjectType(interfaceType));
        }
        return types;
    }

    private GraphQLInterfaceType buildInterfaceType() {
        return GraphQLInterfaceType.newInterface().name(this.eClass.getName()).fields(this.getFields()).typeResolver(this.getTypeResolver()).build();
    }

    private TypeResolver getTypeResolver() {
        return environment -> Optional.of(environment.getObject()).filter(EObject.class::isInstance).map(EObject.class::cast).map(EObject::eClass).map(ENamedElement::getName).map(name -> environment.getSchema().getObjectType(String.valueOf(name) + IMPL_SUFFIX)).orElse(null);
    }

    private GraphQLObjectType buildObjectType(GraphQLInterfaceType interfaceType) {
        return GraphQLObjectType.newObject().name(String.valueOf(this.eClass.getName()) + IMPL_SUFFIX).fields(this.getFields()).withInterface(interfaceType).withInterfaces(this.getInterfaces()).withInterface(new GraphQLTypeReference("EObject")).build();
    }

    private GraphQLTypeReference[] getInterfaces() {
        return (GraphQLTypeReference[])this.eClass.getEAllSuperTypes().stream().map(ENamedElement::getName).map(GraphQLTypeReference::new).toArray(GraphQLTypeReference[]::new);
    }

    private List<GraphQLFieldDefinition> getFields() {
        ArrayList<GraphQLFieldDefinition> fields = new ArrayList<GraphQLFieldDefinition>();
        fields.add(SiriusGraphQLEObjectFragmentField.build());
        this.eClass.getEAllStructuralFeatures().stream().filter(this::isSupported).map(this::getField).forEach(fields::add);
        return fields;
    }

    private boolean isSupported(EStructuralFeature eStructuralFeature) {
        boolean isSupported = eStructuralFeature instanceof EAttribute && this.getScalar(((EAttribute)eStructuralFeature).getEAttributeType()) != null;
        isSupported = isSupported || eStructuralFeature instanceof EReference;
        return isSupported;
    }

    private GraphQLFieldDefinition getField(EStructuralFeature eStructuralFeature) {
        return GraphQLFieldDefinition.newFieldDefinition().name(eStructuralFeature.getName()).type(this.getType(eStructuralFeature)).build();
    }

    private GraphQLOutputType getType(EStructuralFeature eStructuralFeature) {
        Object type = null;
        if (eStructuralFeature instanceof EAttribute) {
            EAttribute eAttribute = (EAttribute)eStructuralFeature;
            type = this.getScalar(eAttribute.getEAttributeType());
            if (Scalars.GraphQLBoolean.equals(type) || Scalars.GraphQLInt.equals(type)) {
                type = new GraphQLNonNull((GraphQLType)type);
            }
        } else if (eStructuralFeature instanceof EReference) {
            EReference eReference = (EReference)eStructuralFeature;
            type = eReference.isMany() ? new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)new GraphQLTypeReference(eReference.getEReferenceType().getName())))) : new GraphQLTypeReference(eReference.getEReferenceType().getName());
        }
        return type;
    }

    private GraphQLOutputType getScalar(EDataType eDataType) {
        GraphQLScalarType type = null;
        if (EcorePackage.eINSTANCE.getEBigDecimal().equals(eDataType)) {
            type = Scalars.GraphQLBigDecimal;
        } else if (EcorePackage.eINSTANCE.getEBigInteger().equals(eDataType)) {
            type = Scalars.GraphQLBigInteger;
        } else if (EcorePackage.eINSTANCE.getEBoolean().equals(eDataType)) {
            type = Scalars.GraphQLBoolean;
        } else if (EcorePackage.eINSTANCE.getEByte().equals(eDataType)) {
            type = Scalars.GraphQLByte;
        } else if (EcorePackage.eINSTANCE.getEChar().equals(eDataType)) {
            type = Scalars.GraphQLChar;
        } else if (EcorePackage.eINSTANCE.getEFloat().equals(eDataType)) {
            type = Scalars.GraphQLFloat;
        } else if (EcorePackage.eINSTANCE.getEInt().equals(eDataType)) {
            type = Scalars.GraphQLInt;
        } else if (EcorePackage.eINSTANCE.getELong().equals(eDataType)) {
            type = Scalars.GraphQLLong;
        } else if (EcorePackage.eINSTANCE.getEShort().equals(eDataType)) {
            type = Scalars.GraphQLShort;
        } else if (EcorePackage.eINSTANCE.getEString().equals(eDataType)) {
            type = Scalars.GraphQLString;
        }
        return type;
    }
}

