/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.services.graphql.internal.schema.query.pagination;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLArgument;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.sirius.services.graphql.internal.SiriusGraphQLMessages;
import org.eclipse.sirius.services.graphql.internal.entities.SiriusGraphQLConnection;
import org.eclipse.sirius.services.graphql.internal.entities.SiriusGraphQLEdge;
import org.eclipse.sirius.services.graphql.internal.entities.SiriusGraphQLPageInfo;
import org.eclipse.sirius.services.graphql.internal.schema.SiriusGraphQLContext;
import org.eclipse.sirius.services.graphql.internal.schema.query.pagination.SiriusGraphQLCursorSwitch;

public final class SiriusGraphQLPaginationDataFetcher {
    private SiriusGraphQLPaginationDataFetcher() {
    }

    public static <T> DataFetcher<SiriusGraphQLConnection> build(Function<DataFetchingEnvironment, List<T>> callback) {
        return environment -> {
            Integer first = SiriusGraphQLPaginationDataFetcher.getFirst(environment);
            Integer last = SiriusGraphQLPaginationDataFetcher.getLast(environment);
            String after = SiriusGraphQLPaginationDataFetcher.getAfter(environment);
            String before = SiriusGraphQLPaginationDataFetcher.getBefore(environment);
            SiriusGraphQLPaginationDataFetcher.assertArguments(environment);
            int cost = SiriusGraphQLPaginationDataFetcher.getCost(environment);
            Optional.ofNullable(environment.getContext()).filter(SiriusGraphQLContext.class::isInstance).map(SiriusGraphQLContext.class::cast).ifPresent(context -> context.add(cost));
            List allEdges = (List)callback.apply(environment);
            List edgesToReturn = SiriusGraphQLPaginationDataFetcher.getEdgesToReturn(allEdges, before, after, first, last);
            List<SiriusGraphQLEdge> edges = edgesToReturn.stream().map(edge -> new SiriusGraphQLEdge(edge, new SiriusGraphQLCursorSwitch().doSwitch(edge))).collect(Collectors.toList());
            int totalCount = allEdges.size();
            boolean hasPreviousPage = SiriusGraphQLPaginationDataFetcher.hasPreviousPage(allEdges, edgesToReturn);
            boolean hasNextPage = SiriusGraphQLPaginationDataFetcher.hasNextPage(allEdges, edgesToReturn);
            SiriusGraphQLPageInfo pageInfo = new SiriusGraphQLPageInfo(hasPreviousPage, hasNextPage);
            return new SiriusGraphQLConnection(totalCount, edges, pageInfo);
        };
    }

    private static void assertArguments(DataFetchingEnvironment environment) {
        boolean hasBackwardPaginationArguments;
        Integer first = SiriusGraphQLPaginationDataFetcher.getFirst(environment);
        Integer last = SiriusGraphQLPaginationDataFetcher.getLast(environment);
        boolean hasFowardPaginationArguments = first != null && environment.containsArgument("after");
        boolean bl = hasBackwardPaginationArguments = last != null && environment.containsArgument("before");
        if (!hasFowardPaginationArguments && !hasBackwardPaginationArguments) {
            throw new IllegalArgumentException(SiriusGraphQLMessages.SiriusGraphQLPaginationDataFetcher_invalidArguments);
        }
    }

    private static Integer getFirst(DataFetchingEnvironment environment) {
        return Optional.ofNullable(environment.getArgument("first")).filter(Integer.class::isInstance).map(Integer.class::cast).orElse(null);
    }

    private static Integer getLast(DataFetchingEnvironment environment) {
        return Optional.ofNullable(environment.getArgument("last")).filter(Integer.class::isInstance).map(Integer.class::cast).orElse(null);
    }

    private static String getAfter(DataFetchingEnvironment environment) {
        return Optional.ofNullable(environment.getArgument("after")).filter(String.class::isInstance).map(String.class::cast).orElse(null);
    }

    private static String getBefore(DataFetchingEnvironment environment) {
        return Optional.ofNullable(environment.getArgument("before")).filter(String.class::isInstance).map(String.class::cast).orElse(null);
    }

    private static int getComplexity(DataFetchingEnvironment environment) {
        return Optional.ofNullable(environment.getFieldDefinition().getDirective("cost")).map(directive -> directive.getArgument("complexity")).map(GraphQLArgument::getDefaultValue).filter(Integer.class::isInstance).map(Integer.class::cast).orElse(0);
    }

    private static List<String> getMultipliers(DataFetchingEnvironment environment) {
        return Optional.ofNullable(environment.getFieldDefinition().getDirective("cost")).map(directive -> directive.getArgument("multipliers")).map(GraphQLArgument::getDefaultValue).map(value -> {
            if (value instanceof List) {
                return ((List)value).stream().filter(String.class::isInstance).map(String.class::cast).collect(Collectors.toList());
            }
            return new ArrayList();
        }).orElseGet(ArrayList::new);
    }

    private static int getCost(DataFetchingEnvironment environment) {
        int complexity = SiriusGraphQLPaginationDataFetcher.getComplexity(environment);
        List<String> multipliers = SiriusGraphQLPaginationDataFetcher.getMultipliers(environment);
        int cost = 0;
        for (String multiplier : multipliers) {
            int value = Optional.ofNullable(environment.getArgument(multiplier)).filter(Integer.class::isInstance).map(Integer.class::cast).orElse(0);
            cost += value * complexity;
        }
        return cost;
    }

    private static <T> boolean hasPreviousPage(List<T> edges, List<T> edgesToReturn) {
        return edges.size() > 0 && (edgesToReturn.isEmpty() || edges.indexOf(edgesToReturn.get(0)) > 0);
    }

    private static <T> boolean hasNextPage(List<T> edges, List<T> edgesToReturn) {
        return edges.size() > 0 && !edgesToReturn.isEmpty() && edges.indexOf(edgesToReturn.get(edgesToReturn.size() - 1)) < edges.size() - 1;
    }

    private static <T> List<T> getEdgesToReturn(List<T> allEdges, String before, String after, Integer first, Integer last) {
        List<T> edges = SiriusGraphQLPaginationDataFetcher.applyCursorsToEdges(allEdges, before, after);
        if (Objects.nonNull(first) && first > 0 && edges.size() > first) {
            edges = edges.subList(0, first);
        }
        if (Objects.nonNull(last) && last > 0 && edges.size() > last) {
            edges = edges.subList(edges.size() - last, edges.size());
        }
        return edges;
    }

    private static <T> List<T> applyCursorsToEdges(List<T> allEdges, String before, String after) {
        Optional<Object> optionalBeforeEdge;
        List<T> edges = allEdges;
        if (Objects.nonNull(after) && !after.isEmpty()) {
            Optional<Object> optionalAfterEdge = edges.stream().filter(anEdge -> after.equals(new SiriusGraphQLCursorSwitch().doSwitch(anEdge))).findFirst();
            if (optionalAfterEdge.isPresent()) {
                Object afterEdge = optionalAfterEdge.get();
                int afterEdgeIndex = edges.indexOf(afterEdge);
                edges = edges.subList(afterEdgeIndex + 1, edges.size());
            }
        } else if (Objects.nonNull(before) && !before.isEmpty() && (optionalBeforeEdge = edges.stream().filter(anEdge -> before.equals(new SiriusGraphQLCursorSwitch().doSwitch(anEdge))).findFirst()).isPresent()) {
            Object beforeEdge = optionalBeforeEdge.get();
            int beforeEdgeIndex = edges.indexOf(beforeEdge);
            edges = edges.subList(0, beforeEdgeIndex);
        }
        return edges;
    }
}

