/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.services.graphql.internal.schema.query.resources;

import graphql.schema.DataFetcher;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLTypeReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.sirius.services.graphql.internal.SiriusGraphQLPlugin;
import org.eclipse.sirius.services.graphql.internal.entities.SiriusGraphQLConnection;
import org.eclipse.sirius.services.graphql.internal.schema.directives.SiriusGraphQLCostDirective;
import org.eclipse.sirius.services.graphql.internal.schema.query.pagination.SiriusGraphQLPaginationArguments;
import org.eclipse.sirius.services.graphql.internal.schema.query.pagination.SiriusGraphQLPaginationDataFetcher;

public final class SiriusGraphQLContainerResourcesField {
    private static final String RESOURCES_FIELD = "resources";
    private static final int COMPLEXITY = 1;

    private SiriusGraphQLContainerResourcesField() {
    }

    public static GraphQLFieldDefinition build() {
        ArrayList<String> multipliers = new ArrayList<String>();
        multipliers.add("first");
        multipliers.add("last");
        return GraphQLFieldDefinition.newFieldDefinition().name(RESOURCES_FIELD).type((GraphQLOutputType)new GraphQLTypeReference("ContainerResourceConnection")).argument(SiriusGraphQLPaginationArguments.build()).withDirective(new SiriusGraphQLCostDirective(1, multipliers).build()).dataFetcher(SiriusGraphQLContainerResourcesField.getResourcesDataFetcher()).build();
    }

    private static DataFetcher<SiriusGraphQLConnection> getResourcesDataFetcher() {
        return SiriusGraphQLPaginationDataFetcher.build(environment -> Optional.of(environment.getSource()).filter(IContainer.class::isInstance).map(IContainer.class::cast).map(SiriusGraphQLContainerResourcesField::getResources).map(iResourceArray -> Arrays.asList(iResourceArray)).orElseGet(ArrayList::new));
    }

    private static IResource[] getResources(IContainer iContainer) {
        try {
            return iContainer.members();
        }
        catch (CoreException exception) {
            Status status = new Status(4, "org.eclipse.sirius.services.graphql", exception.getMessage(), (Throwable)exception);
            SiriusGraphQLPlugin.getPlugin().log(status);
            return new IResource[0];
        }
    }
}

