/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.support.internal.helper;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.emf.core.util.CrossReferenceAdapter;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.resource.AirdResource;
import org.junit.Assert;

public final class CrossReferenceAdapterDetector {
    public static final String SKIP_CROSS_REFERENCE_ADAPTER_DETECTION = "org.eclipse.sirius.tests.skipCrossReferenceAdapterDetection";
    private final Collection<URI> resourcesWithDetectedCrossReferenceAdapter = new ArrayList<URI>();

    public void checkNoCrossReferenceAdapter() {
        for (Session session : SessionManager.INSTANCE.getSessions()) {
            TransactionalEditingDomain domain = session.getTransactionalEditingDomain();
            if (domain == null) continue;
            this.checkNoCrossReferenceAdapter(domain.getResourceSet());
        }
    }

    public void checkNoCrossReferenceAdapter(ResourceSet resourceSet) {
        if (CrossReferenceAdapterDetector.hasCrossReferenceAdapter((Notifier)resourceSet)) {
            Iterable airdResources = Iterables.filter((Iterable)resourceSet.getResources(), AirdResource.class);
            if (airdResources.iterator().hasNext()) {
                for (AirdResource airdResource : Iterables.filter((Iterable)resourceSet.getResources(), AirdResource.class)) {
                    this.resourcesWithDetectedCrossReferenceAdapter.add(airdResource.getURI());
                }
            } else {
                this.resourcesWithDetectedCrossReferenceAdapter.add(((Resource)resourceSet.getResources().get(0)).getURI());
            }
        } else {
            for (Resource resource : resourceSet.getResources()) {
                if (!CrossReferenceAdapterDetector.hasCrossReferenceAdapter((Notifier)resource)) continue;
                this.resourcesWithDetectedCrossReferenceAdapter.add(resource.getURI());
            }
        }
    }

    public static boolean hasCrossReferenceAdapter(Notifier notifier) {
        return Iterables.any((Iterable)notifier.eAdapters(), (Predicate)Predicates.instanceOf(CrossReferenceAdapter.class));
    }

    public boolean shouldSkipCrossReferenceAdapterDetectionReport() {
        return "true".equals(System.getProperty(SKIP_CROSS_REFERENCE_ADAPTER_DETECTION));
    }

    public void assertNoCrossReferenceAdapterFound() {
        if (!this.shouldSkipCrossReferenceAdapterDetectionReport() && !this.resourcesWithDetectedCrossReferenceAdapter.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (URI uri : this.resourcesWithDetectedCrossReferenceAdapter) {
                sb.append("This resource should not have a CrossReferenceAdapter: ").append(uri.path()).append("\n");
            }
            Assert.fail((String)sb.toString());
        }
    }
}

