/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.swtbot.support.api.editor;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.AbstractBorderedShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.ruler.SnapToGridEx;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.util.ReflectionHelper;
import org.eclipse.sirius.diagram.ui.business.internal.dialect.DiagramDialectUIServices;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramBorderNodeEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramNameEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramNodeEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DEdgeBeginNameEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DEdgeEndNameEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DEdgeNameEditPart;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.tools.api.preferences.SiriusDiagramUiPreferencesKeys;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.draw2d.figure.FigureUtilities;
import org.eclipse.sirius.tests.swtbot.support.api.bot.SWTDesignerBot;
import org.eclipse.sirius.tests.swtbot.support.api.business.UIDiagramRepresentation;
import org.eclipse.sirius.tests.swtbot.support.api.condition.SessionSavedCondition;
import org.eclipse.sirius.tests.swtbot.support.api.editor.SWTBotSiriusGefViewer;
import org.eclipse.sirius.tests.swtbot.support.api.view.DesignerViews;
import org.eclipse.sirius.tests.swtbot.support.api.view.SiriusOutlineView;
import org.eclipse.sirius.tests.swtbot.support.api.widget.SWTBotSiriusFigureCanvas;
import org.eclipse.sirius.tests.swtbot.support.utils.SWTBotUtils;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.gef.finder.matchers.IsInstanceOf;
import org.eclipse.swtbot.eclipse.gef.finder.widgets.SWTBotGefConnectionEditPart;
import org.eclipse.swtbot.eclipse.gef.finder.widgets.SWTBotGefEditPart;
import org.eclipse.swtbot.eclipse.gef.finder.widgets.SWTBotGefEditor;
import org.eclipse.swtbot.eclipse.gef.finder.widgets.SWTBotGefFigureCanvas;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.matchers.WidgetMatcherFactory;
import org.eclipse.swtbot.swt.finder.results.BoolResult;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.utils.SWTUtils;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotMenu;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotToolbarDropDownButton;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PlatformUI;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class SWTBotSiriusDiagramEditor
extends SWTBotGefEditor {
    static final String EXPECTED_TO_FIND_WIDGET_S = "Expected to find widget %s";
    private static final String EXPECTED_TO_FIND_WIDGET_X_Y = "Expected to find widget at %s, %s";
    private static final String EXPECTED_TO_FIND_WIDGET_OF_TYPE_T = "Expected to find widget of type %s";
    private static final String EXPECTED_TO_FIND_GRAPHICAL_EDIT_PART_S = "Expected to find widget %s of type IGraphicalEditPart";
    protected SWTDesignerBot designerBot = new SWTDesignerBot();

    public SWTBotSiriusDiagramEditor(IEditorReference reference, SWTWorkbenchBot bot) throws WidgetNotFoundException {
        super(reference, bot);
        GraphicalViewer graphicalViewer = (GraphicalViewer)UIThreadRunnable.syncExec((Result)new Result<GraphicalViewer>(){

            public GraphicalViewer run() {
                IEditorPart editor = ((IEditorReference)SWTBotSiriusDiagramEditor.this.partReference).getEditor(true);
                return (GraphicalViewer)editor.getAdapter(GraphicalViewer.class);
            }
        });
        ReflectionHelper.setFieldValueWithoutException((Object)((Object)this), (String)"viewer", (Object)((Object)new SWTBotSiriusGefViewer(graphicalViewer)), ((Object)((Object)this)).getClass().getSuperclass());
    }

    public void save() {
        Session session;
        DRepresentation dRepresentation;
        super.save();
        IEditorPart editor = ((IEditorReference)this.partReference).getEditor(false);
        if (editor instanceof DialectEditor && (dRepresentation = ((DialectEditor)editor).getRepresentation()) != null && (session = new EObjectQuery((EObject)dRepresentation).getSession()) != null) {
            this.designerBot.waitUntil((ICondition)new SessionSavedCondition(session));
        }
    }

    public SWTBotGefFigureCanvas getCanvas() {
        Option fieldValueWithoutException = ReflectionHelper.getFieldValueWithoutException((Object)this.getSWTBotGefViewer(), (String)"canvas", this.getSWTBotGefViewer().getClass().getSuperclass());
        if (fieldValueWithoutException.some() && fieldValueWithoutException.get() instanceof SWTBotGefFigureCanvas) {
            return (SWTBotGefFigureCanvas)fieldValueWithoutException.get();
        }
        return null;
    }

    public void click(String label) {
        SWTBotGefEditPart selectedEP = this.getEditPart(label);
        if (selectedEP == null) {
            throw new WidgetNotFoundException(String.format(EXPECTED_TO_FIND_WIDGET_S, label));
        }
        Rectangle bounds = ((GraphicalEditPart)selectedEP.part()).getFigure().getBounds().getCopy();
        ((GraphicalEditPart)selectedEP.part()).getFigure().translateToAbsolute((Translatable)bounds);
        this.click(bounds.x, bounds.y + bounds.height - 1);
    }

    public void click(String label, Class<? extends EditPart> expectedEditPartType) {
        SWTBotGefEditPart selectedEP = this.getEditPart(label, expectedEditPartType);
        if (selectedEP == null) {
            throw new WidgetNotFoundException(String.format(EXPECTED_TO_FIND_WIDGET_S, label));
        }
        Rectangle bounds = ((GraphicalEditPart)selectedEP.part()).getFigure().getBounds().getCopy();
        ((GraphicalEditPart)selectedEP.part()).getFigure().translateToAbsolute((Translatable)bounds);
        this.click(bounds.x, bounds.y + bounds.height - 1);
    }

    public void click(Point point) {
        this.click(point.x, point.y);
    }

    public void click(Point point, boolean displayFeedback) {
        ((SWTBotSiriusGefViewer)this.getSWTBotGefViewer()).click(point.x, point.y, displayFeedback);
    }

    public Rectangle clickCentered(String label) {
        Rectangle bounds;
        SWTBotGefEditPart selectedEP = this.getEditPart(label);
        if (selectedEP == null) {
            throw new WidgetNotFoundException(String.format(EXPECTED_TO_FIND_WIDGET_S, label));
        }
        if (selectedEP.part() instanceof AbstractDiagramNameEditPart) {
            bounds = ((GraphicalEditPart)selectedEP.part().getParent()).getFigure().getBounds().getCopy();
            ((GraphicalEditPart)selectedEP.part().getParent()).getFigure().translateToAbsolute((Translatable)bounds);
        } else {
            bounds = ((GraphicalEditPart)selectedEP.part()).getFigure().getBounds().getCopy();
            ((GraphicalEditPart)selectedEP.part()).getFigure().translateToAbsolute((Translatable)bounds);
        }
        this.click(bounds.x + bounds.width / 2, bounds.y + bounds.height / 2);
        return bounds;
    }

    public Rectangle clickCentered(String label, Class<? extends EditPart> expectedEditPartType) {
        SWTBotGefEditPart selectedEP = this.getEditPart(label, expectedEditPartType);
        if (selectedEP == null) {
            throw new WidgetNotFoundException(String.format(EXPECTED_TO_FIND_WIDGET_S, label));
        }
        return this.clickCentered(selectedEP);
    }

    public Rectangle clickCentered(SWTBotGefEditPart partToClick) {
        Assert.assertTrue((String)"This editPart should be a GraphicalEditPart.", (boolean)(partToClick.part() instanceof GraphicalEditPart));
        Rectangle bounds = ((GraphicalEditPart)partToClick.part()).getFigure().getBounds().getCopy();
        ((GraphicalEditPart)partToClick.part()).getFigure().translateToAbsolute((Translatable)bounds);
        this.click(bounds.x + bounds.width / 2, bounds.y + bounds.height / 2);
        return bounds;
    }

    public Rectangle clickNorth(SWTBotGefEditPart partToClick) {
        Assert.assertTrue((String)"This editPart should be a GraphicalEditPart.", (boolean)(partToClick.part() instanceof GraphicalEditPart));
        Rectangle bounds = ((GraphicalEditPart)partToClick.part()).getFigure().getBounds().getCopy();
        ((GraphicalEditPart)partToClick.part()).getFigure().translateToAbsolute((Translatable)bounds);
        this.click(bounds.getTop().x, bounds.getTop().y + 1);
        return bounds;
    }

    public void drag(String label, int toXPosition, int toYPosition) {
        SWTBotGefEditPart selectedEP = this.getEditPart(label);
        if (selectedEP == null) {
            throw new WidgetNotFoundException(String.format(EXPECTED_TO_FIND_WIDGET_S, label));
        }
        Rectangle bounds = ((GraphicalEditPart)selectedEP.part()).getFigure().getBounds();
        this.drag(bounds.x, bounds.y + bounds.height / 2, toXPosition, toYPosition);
    }

    public void dragCentered(String label, int toXPosition, int toYPosition) {
        SWTBotGefEditPart selectedEP = this.getEditPart(label);
        if (selectedEP == null) {
            throw new WidgetNotFoundException(String.format(EXPECTED_TO_FIND_WIDGET_S, label));
        }
        Rectangle bounds = ((GraphicalEditPart)selectedEP.part()).getFigure().getBounds();
        this.drag(bounds.x + bounds.width / 2, bounds.y + bounds.height / 2, toXPosition, toYPosition);
    }

    public void dragCentered(String label, Class<? extends EditPart> editPartClass, int toXPosition, int toYPosition) {
        SWTBotGefEditPart selectedEP = this.getEditPart(label, editPartClass);
        if (selectedEP == null) {
            throw new WidgetNotFoundException(String.format(EXPECTED_TO_FIND_WIDGET_S, label));
        }
        Rectangle bounds = ((GraphicalEditPart)selectedEP.part()).getFigure().getBounds();
        this.drag(bounds.x + bounds.width / 2, bounds.y + bounds.height / 2, toXPosition, toYPosition);
    }

    public SWTBotGefEditPart getEditPart(Point location, Class<? extends EditPart> expectedEditPartType) {
        return this.getEditPart(this.mainEditPart(), location, expectedEditPartType);
    }

    public SWTBotGefEditPart getEditPart(SWTBotGefEditPart editPartBotWhereToSearch, Point location, Class<? extends EditPart> expectedEditPartType) {
        SWTBotGefEditPart result = null;
        if (!editPartBotWhereToSearch.children().isEmpty()) {
            for (SWTBotGefEditPart childEditPartBot : editPartBotWhereToSearch.children()) {
                SWTBotGefEditPart candidate = this.getEditPart(childEditPartBot, location, expectedEditPartType);
                if (candidate == null && this.getBounds(childEditPartBot).contains(location) && expectedEditPartType.isInstance(childEditPartBot.part())) {
                    candidate = childEditPartBot;
                }
                if (candidate != null && result != null) {
                    boolean indexSuperior;
                    boolean sameParent = result.part().getParent().equals(candidate.part().getParent());
                    boolean bl = indexSuperior = candidate.part().getParent().getChildren().indexOf(candidate.part()) > result.part().getParent().getChildren().indexOf(result.part());
                    if (!sameParent || !indexSuperior) continue;
                    result = candidate;
                    continue;
                }
                if (result != null) continue;
                result = candidate;
            }
        } else if (this.getBounds(editPartBotWhereToSearch).contains(location) && expectedEditPartType.isInstance(editPartBotWhereToSearch.part())) {
            result = editPartBotWhereToSearch;
        }
        return result;
    }

    public SWTBotGefEditPart getEditPart(String label) {
        SWTBotGefEditPart selectedEP = super.getEditPart(label);
        if (selectedEP == null) {
            throw new WidgetNotFoundException(String.format(EXPECTED_TO_FIND_WIDGET_S, label));
        }
        return selectedEP;
    }

    public SWTBotGefEditPart getEditPart(String label, Class<? extends EditPart> expectedEditPartType) {
        SWTBotGefEditPart selectedEP = super.getEditPart(label);
        if (selectedEP == null) {
            throw new WidgetNotFoundException(String.format(EXPECTED_TO_FIND_WIDGET_S, label));
        }
        if (!expectedEditPartType.isInstance(selectedEP.part())) {
            selectedEP = this.getParentEditPart(selectedEP, expectedEditPartType);
        }
        return selectedEP;
    }

    private SWTBotGefEditPart getParentEditPart(SWTBotGefEditPart editPart, Class<? extends EditPart> expectedEditPartType) {
        SWTBotGefEditPart parent = editPart.parent();
        if (parent == null || parent.part() == null) {
            throw new WidgetNotFoundException(String.format(EXPECTED_TO_FIND_WIDGET_OF_TYPE_T, expectedEditPartType.getCanonicalName()));
        }
        if (!expectedEditPartType.isInstance(parent.part())) {
            parent = this.getParentEditPart(parent, expectedEditPartType);
        }
        return parent;
    }

    public SWTBotGefEditPart getPaletteRootEditPartBot() {
        return ((SWTBotSiriusGefViewer)this.getSWTBotGefViewer()).getPaletteRootEditPartBot();
    }

    public SWTBotGefEditPart getSiriusPaletteGroupEditPartBot() {
        return ((SWTBotSiriusGefViewer)this.getSWTBotGefViewer()).getSiriusPaletteGroupEditPartBot();
    }

    public List<SWTBotGefConnectionEditPart> getConnectionEditPart(SWTBotGefEditPart sourceEditPart, SWTBotGefEditPart targetEditPart) {
        HashSet sourceConnections = new HashSet(sourceEditPart.sourceConnections());
        HashSet targetConnections = new HashSet(targetEditPart.targetConnections());
        sourceConnections.retainAll(targetConnections);
        return new ArrayList<SWTBotGefConnectionEditPart>(sourceConnections);
    }

    public List<SWTBotGefConnectionEditPart> getConnectionsEditPart() {
        HashSet resultList = new HashSet();
        resultList.addAll(this.mainEditPart().sourceConnections());
        resultList.addAll(this.mainEditPart().targetConnections());
        for (SWTBotGefEditPart currentEditPart : this.getAllChildrenSWTBotGefEditPart(this.mainEditPart())) {
            resultList.addAll(currentEditPart.sourceConnections());
            resultList.addAll(currentEditPart.targetConnections());
        }
        return new ArrayList<SWTBotGefConnectionEditPart>(resultList);
    }

    public ISelection getSelection() {
        return ((IEditorReference)this.partReference).getPage().getSelection();
    }

    public void directNodeEditType(String editPartLabel, String text) {
        this.directEditType(text, this.getEditPart(editPartLabel));
    }

    public boolean isDirectEditPossible(SWTBotGefEditPart swtBotGefEditPart) {
        boolean isDirectEditPossible = false;
        final EditPart editPart = swtBotGefEditPart.part();
        final DirectEditRequest request = new DirectEditRequest();
        request.getExtendedData().put("directedit_extendeddata_initial_char", Character.valueOf('_'));
        if (editPart instanceof GraphicalEditPart) {
            GraphicalEditPart gep = (GraphicalEditPart)editPart;
            request.setLocation(gep.getFigure().getBounds().getLocation());
        }
        isDirectEditPossible = (Boolean)UIThreadRunnable.syncExec((Result)new Result<Boolean>(){

            public Boolean run() {
                editPart.performRequest((Request)request);
                Matcher matcher = WidgetMatcherFactory.allOf((Matcher[])new Matcher[]{WidgetMatcherFactory.widgetOfType(Text.class)});
                List findControls = SWTBotSiriusDiagramEditor.this.bot().getFinder().findControls(matcher);
                return !findControls.isEmpty();
            }
        });
        return isDirectEditPossible;
    }

    public boolean directEditType(String text, SWTBotGefEditPart swtBotGefEditPart) {
        EditPart editPart = swtBotGefEditPart.part();
        return this.directEditType(text, editPart);
    }

    private boolean directEditType(String text, final EditPart editPart) {
        DirectEditRequest request = new DirectEditRequest();
        request.getExtendedData().put("directedit_extendeddata_initial_char", Character.valueOf('_'));
        return (Boolean)UIThreadRunnable.syncExec((Result)new Result<Boolean>((Request)request, text){
            private final /* synthetic */ Request val$request;
            private final /* synthetic */ String val$text;
            {
                this.val$request = request;
                this.val$text = string;
            }

            public Boolean run() {
                Boolean result = false;
                try {
                    editPart.performRequest(this.val$request);
                    SWTBotSiriusDiagramEditor.this.directEditType(this.val$text);
                    result = true;
                }
                catch (Exception exception) {}
                return result;
            }
        });
    }

    public boolean directEdgeEditType(String sourceEditPartLabel, String targetEditPartLabel, String text) {
        return this.directEdgeEditType(sourceEditPartLabel, targetEditPartLabel, text, 0, DEdgeNameEditPart.class);
    }

    public boolean directEdgeEditTypeBeginLabel(String sourceEditPartLabel, String targetEditPartLabel, String text) {
        return this.directEdgeEditType(sourceEditPartLabel, targetEditPartLabel, text, 0, DEdgeBeginNameEditPart.class);
    }

    public void directEdgeEditTypeCenterLabel(String sourceEditPartLabel, String targetEditPartLabel, String text) {
        this.directEdgeEditType(sourceEditPartLabel, targetEditPartLabel, text);
    }

    public boolean directEdgeEditTypeEndLabel(String sourceEditPartLabel, String targetEditPartLabel, String text) {
        return this.directEdgeEditType(sourceEditPartLabel, targetEditPartLabel, text, 0, DEdgeEndNameEditPart.class);
    }

    public void directEdgeEditTypeExtendedToBorderNodes(String sourceEditPartLabel, String targetEditPartLabel, String text) {
        this.directEdgeEditTypeExtendedToBorderNodes(sourceEditPartLabel, targetEditPartLabel, text, 0);
    }

    public void directEdgeEditTypeOnBorderNodesOnly(String sourceEditPartLabel, String targetEditPartLabel, String text) {
        this.directEdgeEditTypeOnBorderNodesOnly(sourceEditPartLabel, targetEditPartLabel, text, 0);
    }

    public boolean directEdgeEditType(String sourceEditPartLabel, String targetEditPartLabel, String text, int index, Class<? extends EditPart> labelClass) {
        List<SWTBotGefConnectionEditPart> connectionEditPart = this.getConnectionEditPart(this.getEditPart(sourceEditPartLabel).parent(), this.getEditPart(targetEditPartLabel).parent());
        SWTBotGefConnectionEditPart swtBotGefConnectionEditPart = connectionEditPart.get(index);
        return this.directEditType(text, (EditPart)Iterables.getOnlyElement((Iterable)Iterables.filter((Iterable)swtBotGefConnectionEditPart.part().getChildren(), labelClass)));
    }

    public void directEdgeEditTypeOnBorderNodesOnly(String sourceEditPartLabel, String targetEditPartLabel, String text, int index) {
        ArrayList<SWTBotGefConnectionEditPart> connectionEditPart = new ArrayList<SWTBotGefConnectionEditPart>();
        SWTBotGefEditPart parentSource = this.getEditPart(sourceEditPartLabel).parent();
        SWTBotGefEditPart parentTarget = this.getEditPart(targetEditPartLabel).parent();
        List<SWTBotGefEditPart> sourceChildren = this.getAllChildrenSWTBotGefEditPart(parentSource);
        List<SWTBotGefEditPart> targetChildren = this.getAllChildrenSWTBotGefEditPart(parentTarget);
        for (SWTBotGefEditPart sourceChild : sourceChildren) {
            for (SWTBotGefEditPart targetChild : targetChildren) {
                connectionEditPart.addAll(this.getConnectionEditPart(sourceChild, targetChild));
            }
        }
        SWTBotGefConnectionEditPart swtBotGefConnectionEditPart = (SWTBotGefConnectionEditPart)connectionEditPart.get(index);
        this.directEditType(text, (EditPart)swtBotGefConnectionEditPart.part().getChildren().get(0));
    }

    public void directEdgeEditTypeExtendedToBorderNodes(String sourceEditPartLabel, String targetEditPartLabel, String text, int index) {
        SWTBotGefEditPart parentSource = this.getEditPart(sourceEditPartLabel).parent();
        SWTBotGefEditPart parentTarget = this.getEditPart(targetEditPartLabel).parent();
        List<SWTBotGefConnectionEditPart> connectionEditPart = this.getConnectionEditPart(parentSource, parentTarget);
        List<SWTBotGefEditPart> sourceChildren = this.getAllChildrenSWTBotGefEditPart(parentSource);
        List<SWTBotGefEditPart> targetChildren = this.getAllChildrenSWTBotGefEditPart(parentTarget);
        for (SWTBotGefEditPart sourceChild : sourceChildren) {
            connectionEditPart.addAll(this.getConnectionEditPart(sourceChild, parentTarget));
            for (SWTBotGefEditPart targetChild : targetChildren) {
                connectionEditPart.addAll(this.getConnectionEditPart(parentSource, targetChild));
                connectionEditPart.addAll(this.getConnectionEditPart(sourceChild, targetChild));
            }
        }
        SWTBotGefConnectionEditPart swtBotGefConnectionEditPart = connectionEditPart.get(index);
        this.directEditType(text, (EditPart)swtBotGefConnectionEditPart.part().getChildren().get(0));
    }

    private List<SWTBotGefEditPart> getAllChildrenSWTBotGefEditPart(SWTBotGefEditPart swtbotGefEditPart) {
        ArrayList<SWTBotGefEditPart> swtbotGefEditPartList = new ArrayList<SWTBotGefEditPart>();
        swtbotGefEditPartList.addAll(swtbotGefEditPart.children());
        for (SWTBotGefEditPart swtBotGefEditPartChild : swtbotGefEditPart.children()) {
            swtbotGefEditPartList.addAll(this.getAllChildrenSWTBotGefEditPart(swtBotGefEditPartChild));
        }
        return swtbotGefEditPartList;
    }

    public SWTBotGefEditor clickContextMenu(String text) throws WidgetNotFoundException {
        SWTBotGefEditor swtBotGefEditor = super.clickContextMenu(text);
        SWTBotUtils.waitAllUiEvents();
        return swtBotGefEditor;
    }

    public void clickContextMenu(final Point rightClickLocation, String text) throws WidgetNotFoundException {
        this.click(rightClickLocation);
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                FigureCanvas control = (FigureCanvas)SWTBotSiriusDiagramEditor.this.rootEditPart().part().getRoot().getViewer().getControl();
                org.eclipse.swt.graphics.Point relativeSWTPoint = control.toDisplay(rightClickLocation.x, rightClickLocation.y);
                Event event = new Event();
                event.type = 5;
                event.x = relativeSWTPoint.x;
                event.y = relativeSWTPoint.y;
                SWTBotSiriusDiagramEditor.this.bot.getDisplay().post(event);
            }
        });
        SWTBotUtils.waitAllUiEvents();
        super.clickContextMenu(text);
        SWTBotUtils.waitAllUiEvents();
    }

    public void refresh() throws WidgetNotFoundException {
        this.bot.toolbarButtonWithTooltip(DiagramDialectUIServices.REFRESH_DIAGRAM).click();
    }

    public void drag(Point from, Point to) {
        super.drag(from.x, from.y, to.x, to.y);
    }

    public void drag(Point from, int toXPosition, int toYPosition) {
        super.drag(from.x, from.y, toXPosition, toYPosition);
    }

    @Deprecated
    public void dragWithKey(int fromXPosition, int fromYPosition, int toXPosition, int toYPosition, int keyCode, AtomicBoolean dragFinished) {
        ((SWTBotSiriusGefViewer)this.getSWTBotGefViewer()).dragWithKey(fromXPosition, fromYPosition, toXPosition, toYPosition, keyCode, dragFinished);
    }

    public void dragWithKeys(int fromXPosition, int fromYPosition, int toXPosition, int toYPosition, AtomicBoolean dragFinished, int ... keyModifiers) {
        ((SWTBotSiriusGefViewer)this.getSWTBotGefViewer()).dragWithKeys(fromXPosition, fromYPosition, toXPosition, toYPosition, dragFinished, keyModifiers);
    }

    public void mouseScrollWithKey(int xPosition, int yPosition, int keyCode, int zoomIncrement) {
        ((SWTBotSiriusGefViewer)this.getSWTBotGefViewer()).mouseScrollWithKey(xPosition, yPosition, keyCode, zoomIncrement);
    }

    public void drag(SWTBotGefEditPart editPartBot, Point toPosition) {
        this.drag(editPartBot, toPosition.x, toPosition.y);
    }

    public void reveal(String label) {
        ((SWTBotSiriusGefViewer)this.getSWTBotGefViewer()).reveal(label);
    }

    public void reveal(EditPart revealedEP) {
        ((SWTBotSiriusGefViewer)this.getSWTBotGefViewer()).reveal(revealedEP);
    }

    public void scrollTo(Point location) {
        ((SWTBotSiriusGefViewer)this.getSWTBotGefViewer()).scrollTo(location);
    }

    public void scrollTo(int x, int y) {
        ((SWTBotSiriusGefViewer)this.getSWTBotGefViewer()).scrollTo(x, y);
    }

    public void doubleClick(String label, Class<? extends EditPart> editPartClass) {
        SWTBotGefEditPart selectedEP = this.getEditPart(label, editPartClass);
        if (selectedEP == null) {
            throw new WidgetNotFoundException(String.format(EXPECTED_TO_FIND_WIDGET_S, label));
        }
        Rectangle bounds = ((GraphicalEditPart)selectedEP.part()).getFigure().getBounds();
        this.doubleClick(bounds.x, bounds.y + 3);
    }

    public void doubleClickCentered(String label, Class<? extends EditPart> editPartClass) {
        SWTBotGefEditPart selectedEP = this.getEditPart(label, editPartClass);
        if (selectedEP == null) {
            throw new WidgetNotFoundException(String.format(EXPECTED_TO_FIND_WIDGET_S, label));
        }
        Rectangle bounds = ((GraphicalEditPart)selectedEP.part()).getFigure().getBounds();
        this.doubleClick(bounds.x + bounds.width / 2, bounds.y + bounds.height / 2 + 3);
    }

    public Point getLocation(String editPartName, Class<? extends EditPart> expectedEditPartType) {
        SWTBotGefEditPart editPartBot = this.getEditPart(editPartName, expectedEditPartType);
        if (editPartBot == null) {
            throw new WidgetNotFoundException(String.format(EXPECTED_TO_FIND_WIDGET_S, editPartName));
        }
        return this.getLocation(editPartBot);
    }

    public Point getLocation(SWTBotGefEditPart editPart) {
        return this.getBounds(editPart).getLocation();
    }

    public Rectangle getBounds(SWTBotGefEditPart swtBotGefEditPart) {
        if (swtBotGefEditPart == null) {
            throw new NullPointerException();
        }
        EditPart editPart = swtBotGefEditPart.part();
        if (!(editPart instanceof IGraphicalEditPart)) {
            throw new WidgetNotFoundException(String.format(EXPECTED_TO_FIND_GRAPHICAL_EDIT_PART_S, swtBotGefEditPart));
        }
        IGraphicalEditPart part = (IGraphicalEditPart)editPart;
        Rectangle figureLocation = part.getFigure().getBounds().getCopy();
        part.getFigure().translateToAbsolute((Translatable)figureLocation);
        return figureLocation;
    }

    public Rectangle getBounds(SWTBotGefConnectionEditPart swtBotGefConnectionEditPart) {
        if (swtBotGefConnectionEditPart == null) {
            throw new NullPointerException();
        }
        ConnectionEditPart connectionEditPart = swtBotGefConnectionEditPart.part();
        if (!(connectionEditPart instanceof AbstractConnectionEditPart)) {
            throw new WidgetNotFoundException(String.format(EXPECTED_TO_FIND_GRAPHICAL_EDIT_PART_S, swtBotGefConnectionEditPart));
        }
        AbstractConnectionEditPart part = (AbstractConnectionEditPart)connectionEditPart;
        Rectangle figureLocation = part.getConnectionFigure().getPoints().getBounds();
        part.getFigure().translateToAbsolute((Translatable)figureLocation);
        return figureLocation;
    }

    public Dimension getDimension(String editPartName, Class<? extends EditPart> expectedEditPartType) {
        SWTBotGefEditPart editPartBot = this.getEditPart(editPartName, expectedEditPartType);
        if (editPartBot == null) {
            throw new WidgetNotFoundException(String.format(EXPECTED_TO_FIND_WIDGET_S, editPartName));
        }
        EditPart editPart = editPartBot.part();
        if (!(editPart instanceof IGraphicalEditPart)) {
            throw new WidgetNotFoundException(String.format(EXPECTED_TO_FIND_GRAPHICAL_EDIT_PART_S, editPartName));
        }
        IGraphicalEditPart part = (IGraphicalEditPart)editPart;
        Dimension figureDimension = part.getFigure().getBounds().getSize();
        part.getFigure().translateToAbsolute((Translatable)figureDimension);
        return figureDimension;
    }

    public Rectangle getAbsoluteBounds(SWTBotGefEditPart swtBotGefEditPart) {
        if (swtBotGefEditPart == null) {
            throw new NullPointerException();
        }
        EditPart editPart = swtBotGefEditPart.part();
        if (!(editPart instanceof IGraphicalEditPart)) {
            throw new WidgetNotFoundException(String.format(EXPECTED_TO_FIND_GRAPHICAL_EDIT_PART_S, swtBotGefEditPart));
        }
        IGraphicalEditPart part = (IGraphicalEditPart)editPart;
        Rectangle figureBounds = part.getFigure().getBounds().getCopy();
        return figureBounds;
    }

    public Point getAbsoluteLocation(String editPartName, Class<? extends EditPart> expectedEditPartType) {
        SWTBotGefEditPart editPartBot = this.getEditPart(editPartName, expectedEditPartType);
        if (editPartBot == null) {
            throw new WidgetNotFoundException(String.format(EXPECTED_TO_FIND_WIDGET_S, editPartName));
        }
        EditPart editPart = editPartBot.part();
        if (!(editPart instanceof IGraphicalEditPart)) {
            throw new WidgetNotFoundException(String.format(EXPECTED_TO_FIND_GRAPHICAL_EDIT_PART_S, editPartName));
        }
        IGraphicalEditPart part = (IGraphicalEditPart)editPart;
        return this.getAbsoluteLocation((GraphicalEditPart)part);
    }

    public Point getAbsoluteLocation(GraphicalEditPart editPart) {
        Point figureLocation = editPart.getFigure().getBounds().getLocation();
        FigureUtilities.translateToAbsoluteByIgnoringScrollbar((IFigure)editPart.getFigure(), (Point)figureLocation);
        return figureLocation;
    }

    public Point getAbsoluteCenter(GraphicalEditPart editPart) {
        Point figureCenter = editPart.getFigure().getBounds().getCenter();
        FigureUtilities.translateToAbsoluteByIgnoringScrollbar((IFigure)editPart.getFigure(), (Point)figureCenter);
        return figureCenter;
    }

    protected SWTBotGefEditPart getNearestEditPart(int xPosition, int yPosition) {
        List allEditParts = this.mainEditPart().children();
        allEditParts.addAll(this.mainEditPart().sourceConnections());
        return this.getNearestEditPart(new Point(xPosition, yPosition), allEditParts);
    }

    protected SWTBotGefEditPart getNearestEditPart(Point searchedPosition, List<SWTBotGefEditPart> allEditParts) {
        SWTBotGefEditPart nearest = null;
        int distance = Integer.MAX_VALUE;
        for (SWTBotGefEditPart child : allEditParts) {
            IFigure figure = ((GraphicalEditPart)child.part()).getFigure();
            if (distance <= figure.getBounds().getCenter().getDistance2(searchedPosition)) continue;
            distance = figure.getBounds().getCenter().getDistance2(searchedPosition);
            nearest = child;
        }
        if (nearest.children().size() > 0) {
            nearest = this.getNearestEditPart(searchedPosition, nearest.children());
        }
        return nearest;
    }

    public void clickNearest(int xPosition, int yPosition) {
        SWTBotGefEditPart selectedEP = this.getNearestEditPart(xPosition, yPosition);
        if (selectedEP == null) {
            throw new WidgetNotFoundException(String.format(EXPECTED_TO_FIND_WIDGET_X_Y, xPosition, yPosition));
        }
        Rectangle bounds = ((GraphicalEditPart)selectedEP.part()).getFigure().getBounds();
        ((GraphicalEditPart)selectedEP.part()).getFigure().translateToAbsolute((Translatable)bounds);
        this.click(bounds.x, bounds.y + bounds.height);
    }

    public void clickNearestFoldingFigure(int xPosition, int yPosition) {
        IFigure foldingFigure = this.getNearestFoldingFigure(new Point(xPosition, yPosition));
        if (foldingFigure == null) {
            throw new WidgetNotFoundException(String.format(EXPECTED_TO_FIND_WIDGET_X_Y, xPosition, yPosition));
        }
        Rectangle bounds = foldingFigure.getBounds();
        this.click(bounds.getCenter().x, bounds.getCenter().y);
    }

    protected IFigure getNearestFoldingFigure(Point searchedPosition) {
        List allEditParts = this.mainEditPart().children();
        allEditParts.addAll(this.mainEditPart().sourceConnections());
        return this.getNearestFoldingFigure(searchedPosition, allEditParts);
    }

    protected IFigure getNearestFoldingFigure(Point searchedPosition, List<SWTBotGefEditPart> allEditParts) {
        IFigure nearestFoldingFigure = null;
        SWTBotGefEditPart nearestEditPart = null;
        int distance = Integer.MAX_VALUE;
        for (SWTBotGefEditPart child : allEditParts) {
            IFigure figure = ((GraphicalEditPart)child.part()).getFigure();
            if (distance <= figure.getBounds().getCenter().getDistance2(searchedPosition)) continue;
            distance = figure.getBounds().getCenter().getDistance2(searchedPosition);
            nearestEditPart = child;
        }
        if (!(nearestEditPart == null || ((GraphicalEditPart)nearestEditPart.part()).getSourceConnections().isEmpty() && ((GraphicalEditPart)nearestEditPart.part()).getTargetConnections().isEmpty())) {
            ArrayList connections = new ArrayList();
            GraphicalEditPart graphicalEditPart = (GraphicalEditPart)nearestEditPart.part();
            connections.addAll(graphicalEditPart.getSourceConnections());
            connections.addAll(graphicalEditPart.getTargetConnections());
            nearestFoldingFigure = this.getNearestFoldingFigureInConnections(searchedPosition, connections);
        }
        return nearestFoldingFigure;
    }

    protected IFigure getNearestFoldingFigureInConnections(Point searchedPosition, List connections) {
        return null;
    }

    public ToolEntry getActiveTool() {
        return this.getSWTBotGefViewer().getActiveTool();
    }

    public void maximize() {
        UIThreadRunnable.syncExec((Display)SWTUtils.display(), (VoidResult)new VoidResult(){

            public void run() {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().setPartState(SWTBotSiriusDiagramEditor.this.partReference, 1);
            }
        });
    }

    public void restore() {
        UIThreadRunnable.syncExec((Display)SWTUtils.display(), (VoidResult)new VoidResult(){

            public void run() {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().setPartState(SWTBotSiriusDiagramEditor.this.partReference, 2);
            }
        });
    }

    @Deprecated
    public void disableSnapToGrid() {
        this.setSnapToGrid(false);
    }

    public void setSnapToGrid(final boolean snap) {
        UIThreadRunnable.syncExec((Display)SWTUtils.display(), (VoidResult)new VoidResult(){

            public void run() {
                ((DiagramGraphicalViewer)SWTBotSiriusDiagramEditor.this.getDiagramGraphicalViewer()).getWorkspaceViewerPreferenceStore().setValue("rulergrid.snaptogrid", snap);
            }
        });
    }

    public void setSnapToShape(final boolean snap) {
        UIThreadRunnable.syncExec((Display)SWTUtils.display(), (VoidResult)new VoidResult(){

            public void run() {
                ((DiagramGraphicalViewer)SWTBotSiriusDiagramEditor.this.getDiagramGraphicalViewer()).getWorkspaceViewerPreferenceStore().setValue("rulergrid.snaptogeometry", snap);
            }
        });
    }

    public boolean isSnapToShape() {
        BoolResult snapToShape = new BoolResult(){

            public Boolean run() {
                return ((DiagramGraphicalViewer)SWTBotSiriusDiagramEditor.this.getDiagramGraphicalViewer()).getWorkspaceViewerPreferenceStore().getBoolean("rulergrid.snaptogeometry");
            }
        };
        return (Boolean)UIThreadRunnable.syncExec((Result)snapToShape);
    }

    public void setSnapToGrid(final boolean snap, final double gridSpacing, final int rulerUnits) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ((DiagramGraphicalViewer)SWTBotSiriusDiagramEditor.this.getDiagramGraphicalViewer()).getWorkspaceViewerPreferenceStore().setValue("rulergrid.snaptogrid", snap);
                ((DiagramGraphicalViewer)SWTBotSiriusDiagramEditor.this.getDiagramGraphicalViewer()).getWorkspaceViewerPreferenceStore().setValue("rulergrid.viewgrid", snap);
                ((DiagramGraphicalViewer)SWTBotSiriusDiagramEditor.this.getDiagramGraphicalViewer()).getWorkspaceViewerPreferenceStore().setValue("rulergrid.gridspacing", gridSpacing);
                ((DiagramGraphicalViewer)SWTBotSiriusDiagramEditor.this.getDiagramGraphicalViewer()).getWorkspaceViewerPreferenceStore().setValue("rulergrid.rulerunit", rulerUnits);
            }
        });
    }

    public boolean isSnapToGrid() {
        BoolResult snapToGrid = new BoolResult(){

            public Boolean run() {
                return ((DiagramGraphicalViewer)SWTBotSiriusDiagramEditor.this.getDiagramGraphicalViewer()).getWorkspaceViewerPreferenceStore().getBoolean("rulergrid.snaptogrid");
            }
        };
        return (Boolean)UIThreadRunnable.syncExec((Result)snapToGrid);
    }

    protected IDiagramWorkbenchPart getDiagramWorkbenchPart() {
        IDiagramWorkbenchPart diagramPart = null;
        IEditorPart editorPart = ((IEditorReference)this.partReference).getEditor(false);
        if (editorPart instanceof IDiagramWorkbenchPart) {
            diagramPart = (IDiagramWorkbenchPart)editorPart;
        } else if (editorPart != null) {
            diagramPart = (IDiagramWorkbenchPart)editorPart.getAdapter(IDiagramWorkbenchPart.class);
        }
        return diagramPart;
    }

    protected IDiagramGraphicalViewer getDiagramGraphicalViewer() {
        IDiagramWorkbenchPart part = this.getDiagramWorkbenchPart();
        return part != null ? part.getDiagramGraphicalViewer() : null;
    }

    public SWTBotSiriusDiagramEditor zoom(final UIDiagramRepresentation.ZoomLevel zoomLevel) {
        UIThreadRunnable.syncExec((Display)SWTUtils.display(), (VoidResult)new VoidResult(){

            public void run() {
                ZoomManager zoomManager = (ZoomManager)((IEditorReference)SWTBotSiriusDiagramEditor.this.partReference).getEditor(false).getAdapter(ZoomManager.class);
                zoomManager.setZoomAsText(zoomLevel.getLevel());
            }
        });
        return this;
    }

    public SWTBotSiriusDiagramEditor zoomFromToolbar(final UIDiagramRepresentation.ZoomLevel zoomLevel) {
        final ToolItem item = this.designerBot.toolbarSpecialDropDownButtonWithTooltip(DiagramUIMessages.ZoomActionMenu_ZoomLabel);
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                Combo control = (Combo)item.getControl();
                control.setFocus();
                control.setText(zoomLevel.getLevel());
                control.select(control.indexOf(zoomLevel.getLevel()));
                if (SWTBotSiriusDiagramEditor.this.useTabbar()) {
                    control.notifyListeners(14, new Event());
                } else {
                    control.notifyListeners(1, this.createCarriageReturnKeyPressedEvent((Widget)control));
                }
            }

            private Event createCarriageReturnKeyPressedEvent(Widget control) {
                Event keyEvent = new Event();
                keyEvent.time = (int)System.currentTimeMillis();
                keyEvent.widget = control;
                keyEvent.display = SWTBotSiriusDiagramEditor.this.designerBot.getDisplay();
                keyEvent.stateMask = 0;
                keyEvent.character = (char)13;
                keyEvent.keyCode = 13;
                return keyEvent;
            }
        });
        return this;
    }

    public SWTBotSiriusDiagramEditor zoomDefault() {
        return this.zoom(UIDiagramRepresentation.ZOOM_DEFAULT);
    }

    private boolean useTabbar() {
        return !DiagramUIPlugin.getPlugin().getPreferenceStore().getBoolean(SiriusDiagramUiPreferencesKeys.PREF_OLD_UI.name());
    }

    public SWTBotGefEditPart getSelectableEditPart(String label) {
        SWTBotGefEditPart selectedEP = super.getEditPart(label);
        if (selectedEP == null) {
            throw new WidgetNotFoundException(String.format(EXPECTED_TO_FIND_WIDGET_S, label));
        }
        if (!this.isSelectableEditPart(selectedEP.part())) {
            selectedEP = this.getSelectableParentEditPart(selectedEP);
        }
        return selectedEP;
    }

    private boolean isSelectableEditPart(EditPart editPart) {
        return editPart instanceof AbstractBorderedShapeEditPart || editPart instanceof AbstractDiagramNodeEditPart || editPart instanceof AbstractDiagramBorderNodeEditPart;
    }

    private SWTBotGefEditPart getSelectableParentEditPart(SWTBotGefEditPart editPart) {
        SWTBotGefEditPart parent = editPart.parent();
        if (parent == null || parent.part() == null) {
            throw new WidgetNotFoundException(String.format(EXPECTED_TO_FIND_GRAPHICAL_EDIT_PART_S, editPart));
        }
        if (!this.isSelectableEditPart(parent.part())) {
            parent = this.getSelectableParentEditPart(parent);
        }
        return parent;
    }

    public void directEditTypeSuffix(String text) throws WidgetNotFoundException {
        this.bot().text();
        List controls = this.bot().getFinder().findControls(this.getWidget(), (Matcher)new IsInstanceOf(Text.class), true);
        if (controls.size() == 1) {
            Text textControl = (Text)controls.get(0);
            SWTBotGefFigureCanvas canvas = this.getCanvas();
            if (canvas instanceof SWTBotSiriusFigureCanvas) {
                ((SWTBotSiriusFigureCanvas)canvas).typeSuffixText(textControl, text);
            } else {
                canvas.typeText(textControl, text);
            }
        } else {
            throw new WidgetNotFoundException(String.format("Expected to find one text control, but found %s.  Is the editor in direct-edit mode?", controls.size()));
        }
    }

    public DiagramEditPart getDiagramEditPart() {
        List parts = this.editParts((Matcher)new BaseMatcher<EditPart>(){

            public void describeTo(Description description) {
            }

            public boolean matches(Object item) {
                return item instanceof DiagramEditPart;
            }
        });
        return (DiagramEditPart)((SWTBotGefEditPart)parts.iterator().next()).part();
    }

    public PrecisionPoint adaptLocationToSnap(Point expectedAbsoluteLocation) {
        DiagramEditPart diagramEditPart = this.getDiagramEditPart();
        SnapToGridEx snapToHelper = new SnapToGridEx((GraphicalEditPart)diagramEditPart);
        PrecisionPoint preciseLocation = new PrecisionPoint(expectedAbsoluteLocation);
        diagramEditPart.getFigure().translateToAbsolute((Translatable)preciseLocation);
        PrecisionPoint result = new PrecisionPoint((Point)preciseLocation);
        snapToHelper.snapPoint((Request)new CreateRequest(), 192, preciseLocation, result);
        diagramEditPart.getFigure().translateToRelative((Translatable)result);
        return result;
    }

    public void changeLayerActivation(String layerName) {
        if (this.useTabbar()) {
            SWTBotToolbarDropDownButton button = this.designerBot.toolbarDropDownButtonWithTooltip("Layers");
            Matcher withLayerName = WidgetMatcherFactory.withText((String)layerName);
            SWTBotMenu layerButton = button.menuItem(withLayerName);
            layerButton.click();
            layerButton.pressShortcut(new KeyStroke[]{KeyStroke.getInstance((int)27)});
        } else {
            DesignerViews designerViews = new DesignerViews(this.designerBot);
            SiriusOutlineView outlineView = designerViews.getOutlineView().layers();
            outlineView.activateLayer(layerName);
        }
    }

    public DRepresentation getDRepresentation() {
        DRepresentation dRepresentation = null;
        IEditorPart editorPart = ((IEditorReference)this.getReference()).getEditor(false);
        if (editorPart instanceof DialectEditor) {
            DialectEditor dialectEditor = (DialectEditor)editorPart;
            dRepresentation = dialectEditor.getRepresentation();
        }
        return dRepresentation;
    }

    public void saveAndClose() {
        this.save();
        SWTBotUtils.waitAllUiEvents();
        this.close();
    }
}

