/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.swtbot.support.utils;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.File;
import java.lang.reflect.Field;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.tests.swtbot.support.api.condition.SessionSavedCondition;
import org.eclipse.sirius.tests.swtbot.support.api.editor.SWTBotSiriusDiagramEditor;
import org.eclipse.sirius.tests.swtbot.support.api.view.DesignerViews;
import org.eclipse.sirius.tests.swtbot.support.api.view.SiriusOutlineView;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.eclipse.gef.finder.widgets.SWTBotGefConnectionEditPart;
import org.eclipse.swtbot.eclipse.gef.finder.widgets.SWTBotGefEditPart;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;

public final class SWTBotCommonHelper {
    private static final String FILE = "File";
    private static SWTWorkbenchBot bot = new SWTWorkbenchBot();

    private SWTBotCommonHelper() {
    }

    public static void closeCurrentEditor() {
        bot.menu(FILE).menu("Close").click();
    }

    public static void openEditor(String project, String editorPath) {
        String[] path;
        SWTBot packageExplorerBot = bot.viewByTitle("Model Explorer").bot();
        SWTBotTree wizardTree = packageExplorerBot.tree();
        wizardTree.expandNode(new String[]{project});
        SWTBotTreeItem treeItem = wizardTree.getTreeItem(project);
        treeItem.expand();
        String[] stringArray = path = editorPath.split(Pattern.quote(File.separator));
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            treeItem = treeItem.expandNode(new String[]{s});
            ++n2;
        }
        treeItem.setFocus();
        treeItem.select().contextMenu("Open").click();
    }

    public static void saveCurrentEditor() {
        bot.menu(FILE).menu("Save").click();
    }

    public static void saveCurrentEditor(Session session) {
        bot.menu(FILE).menu("Save").click();
        bot.waitUntil((ICondition)new SessionSavedCondition(session));
    }

    public static List<EdgeData> getEdgeData(SWTBotGefEditPart source, SWTBotGefEditPart target, SWTBotSiriusDiagramEditor editor) {
        List<SWTBotGefConnectionEditPart> connectionEditParts = editor.getConnectionEditPart(source, target);
        return Lists.transform(connectionEditParts, (Function)new Function<SWTBotGefConnectionEditPart, EdgeData>(){

            public EdgeData apply(SWTBotGefConnectionEditPart from) {
                ConnectionEditPart connectionEditPart = from.part();
                PolylineConnectionEx connection = (PolylineConnectionEx)connectionEditPart.getFigure();
                EdgeData result = new EdgeData();
                result.swtBotEditPart = from;
                result.source = connection.getSourceAnchor().getReferencePoint();
                result.target = connection.getTargetAnchor().getReferencePoint();
                result.points = connection.getPoints().getCopy();
                return result;
            }
        });
    }

    public static SWTBotView getOutlineView(DesignerViews designerViews) throws NoSuchFieldException {
        try {
            SiriusOutlineView outlineView = designerViews.openOutlineView();
            Field field = SiriusOutlineView.class.getDeclaredField("view");
            field.setAccessible(true);
            SWTBotView view = (SWTBotView)field.get(outlineView);
            view.toolbarButton("Outline").click();
            return view;
        }
        catch (IllegalArgumentException e) {
            throw new NoSuchFieldException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new NoSuchFieldException(e.getMessage());
        }
    }

    public static class EdgeData {
        protected Point source;
        protected Point target;
        protected PointList points;
        protected SWTBotGefConnectionEditPart swtBotEditPart;

        public Point getSource() {
            return this.source;
        }

        public Point getTarget() {
            return this.target;
        }

        public PointList getPoints() {
            return this.points;
        }

        public SWTBotGefConnectionEditPart getSwtBotEditPart() {
            return this.swtBotEditPart;
        }
    }
}

