/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.editor;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.internal.ui.rulers.RulerEditPart;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gef.tools.SimpleDragTracker;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DDiagramEditPart;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.command.GMFCommandWrapper;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.SiriusRulerEditPart;
import org.eclipse.sirius.ext.draw2d.figure.InsertBlankSpaceGuide;
import org.eclipse.swt.graphics.Cursor;

public class SiriusBlankSpacesDragTracker
extends SimpleDragTracker {
    protected AbstractGraphicalEditPart source;
    private int startLocation;
    private int startLocationForFeedback;
    private int endLocation;
    private InsertBlankSpaceGuide blankSpaceGuide;
    private GraphicalViewer diagramViewer;

    public SiriusBlankSpacesDragTracker(AbstractGraphicalEditPart editPart, GraphicalViewer diagramViewer) {
        this.source = editPart;
        this.diagramViewer = diagramViewer;
    }

    protected org.eclipse.gef.commands.Command getCommand() {
        UnexecutableCommand result = UnexecutableCommand.INSTANCE;
        if (this.startLocation == 0 && this.endLocation == 0 || this.startLocation != 0 && this.endLocation != this.startLocation) {
            result = SiriusBlankSpacesDragTracker.isHorizontal(this.source) ? SiriusBlankSpacesDragTracker.createInsertOrRemoveHorizontalBlankSpaceCommand(this.startLocation, this.endLocation - this.startLocation, this.diagramViewer) : SiriusBlankSpacesDragTracker.createInsertOrRemoveVerticalBlankSpaceCommand(this.startLocation, this.endLocation - this.startLocation, this.diagramViewer);
        }
        return result;
    }

    protected boolean handleButtonDown(int button) {
        this.startLocation = this.getCurrentPosition();
        this.startLocationForFeedback = this.getCurrentPositionZoomed();
        return super.handleButtonDown(button);
    }

    protected boolean handleDragInProgress() {
        this.endLocation = this.getCurrentPosition();
        return super.handleDragInProgress();
    }

    protected boolean handleButtonUp(int button) {
        boolean result = super.handleButtonUp(button);
        this.startLocation = 0;
        this.startLocationForFeedback = 0;
        this.endLocation = 0;
        return result;
    }

    protected Cursor calculateCursor() {
        if (this.getCommand().canExecute()) {
            return SiriusBlankSpacesDragTracker.isHorizontal(this.source) ? SharedCursors.SIZEWE : SharedCursors.SIZENS;
        }
        return SharedCursors.NO;
    }

    protected void showSourceFeedback() {
        if (this.blankSpaceGuide == null) {
            this.blankSpaceGuide = new InsertBlankSpaceGuide(ColorConstants.blue, !SiriusBlankSpacesDragTracker.isHorizontal(this.source));
            this.getFeedbackLayer().add((IFigure)this.blankSpaceGuide);
        }
        Rectangle bounds = this.getFeedbackLayer().getBounds().getCopy();
        if (SiriusBlankSpacesDragTracker.isHorizontal(this.source)) {
            bounds.x = this.startLocationForFeedback;
            bounds.width = this.getCurrentPositionZoomed() - this.startLocationForFeedback;
        } else {
            bounds.y = this.startLocationForFeedback;
            bounds.height = this.getCurrentPositionZoomed() - this.startLocationForFeedback;
            if (bounds.height < 0) {
                bounds.y += bounds.height;
                bounds.height = Math.abs(bounds.height);
            }
        }
        this.blankSpaceGuide.setBounds(bounds);
    }

    protected void eraseSourceFeedback() {
        if (this.blankSpaceGuide != null) {
            this.getFeedbackLayer().remove((IFigure)this.blankSpaceGuide);
            this.blankSpaceGuide = null;
        }
    }

    protected IFigure getFeedbackLayer() {
        return SiriusBlankSpacesDragTracker.getFeedbackLayer(this.diagramViewer);
    }

    protected int getCurrentPositionZoomed() {
        double zoom;
        Point pt = this.getLocation();
        DDiagramEditPart diagramEditPart = this.getDDiagramEditPart((EditPart)this.source);
        diagramEditPart.getFigure().translateToRelative((Translatable)pt);
        if (!(this.source instanceof SiriusRulerEditPart) && (zoom = this.getZoom()) != 0.0) {
            pt.performScale(zoom);
        }
        int position = SiriusBlankSpacesDragTracker.isHorizontal(this.source) ? pt.x : pt.y;
        return position;
    }

    private DDiagramEditPart getDDiagramEditPart(EditPart part) {
        DDiagramEditPart result = null;
        if (part instanceof DDiagramEditPart) {
            result = (DDiagramEditPart)part;
        } else if (part.getParent() != null) {
            result = this.getDDiagramEditPart(part.getParent());
        }
        return result;
    }

    protected int getCurrentPosition() {
        int position = this.getCurrentPositionZoomed();
        double zoom = this.getZoom();
        if (zoom != 0.0) {
            position = (int)Math.round((double)position / zoom);
        }
        return position;
    }

    protected double getZoom() {
        double zoom = 0.0;
        ZoomManager zoomManager = this.source instanceof SiriusRulerEditPart ? ((SiriusRulerEditPart)this.source).getZoomManager() : (ZoomManager)this.getCurrentViewer().getProperty(ZoomManager.class.toString());
        if (zoomManager != null) {
            zoom = zoomManager.getZoom();
        }
        return zoom;
    }

    protected String getCommandName() {
        if (this.startLocation > this.endLocation) {
            return Messages.RemoveBlankSpace_cmdName;
        }
        return Messages.InsertBlankSpace_cmdName;
    }

    public static DragTracker getDragTracker(AbstractGraphicalEditPart graphicalEditPart, GraphicalViewer diagramViewer, Request request, boolean controlKeyRequirement, boolean shiftKeyRequirement) {
        SiriusBlankSpacesDragTracker result = null;
        if (request.getType().equals("selection")) {
            SelectionRequest selectionRequest = (SelectionRequest)request;
            if (selectionRequest.getLastButtonPressed() != 1) {
                result = null;
            } else if (!(controlKeyRequirement && !selectionRequest.isControlKeyPressed() || shiftKeyRequirement && !selectionRequest.isShiftKeyPressed())) {
                try {
                    if (SiriusBlankSpacesDragTracker.isHorizontal(graphicalEditPart)) {
                        SiriusBlankSpacesDragTracker.createInsertOrRemoveHorizontalBlankSpaceCommand(0, 0, diagramViewer);
                    } else {
                        SiriusBlankSpacesDragTracker.createInsertOrRemoveVerticalBlankSpaceCommand(0, 0, diagramViewer);
                    }
                    result = new SiriusBlankSpacesDragTracker(graphicalEditPart, diagramViewer);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
            }
        }
        return result;
    }

    private static org.eclipse.gef.commands.Command createInsertOrRemoveHorizontalBlankSpaceCommand(int startLocation, int spaceToInsertOrRemove, GraphicalViewer diagramViewer) {
        return SiriusBlankSpacesDragTracker.createInsertOrRemoveBlankSpaceCommand(startLocation, spaceToInsertOrRemove, true, diagramViewer);
    }

    private static org.eclipse.gef.commands.Command createInsertOrRemoveVerticalBlankSpaceCommand(int startLocation, int spaceToInsert, GraphicalViewer diagramViewer) {
        return SiriusBlankSpacesDragTracker.createInsertOrRemoveBlankSpaceCommand(startLocation, spaceToInsert, false, diagramViewer);
    }

    private static boolean isHorizontal(AbstractGraphicalEditPart editPart) {
        boolean isHorizontal = false;
        if (!(editPart instanceof DDiagramEditPart) && editPart instanceof RulerEditPart) {
            isHorizontal = ((RulerEditPart)editPart).isHorizontal();
        }
        return isHorizontal;
    }

    private static org.eclipse.gef.commands.Command createInsertOrRemoveBlankSpaceCommand(int startLocation, int spaceToInsertOrRemove, boolean horizontal, GraphicalViewer diagramViewer) {
        if (diagramViewer.getRootEditPart().getContents() instanceof IGraphicalEditPart) {
            IGraphicalEditPart diagramEditPart = (IGraphicalEditPart)diagramViewer.getRootEditPart().getContents();
            TransactionalEditingDomain ted = diagramEditPart.getEditingDomain();
            Object property = diagramViewer.getProperty("org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorID");
            if (property instanceof DDiagramEditor) {
                DDiagramEditor diagramEditor = (DDiagramEditor)property;
                if (horizontal) {
                    throw new UnsupportedOperationException(Messages.UndoRedoCapableEMFCommandFactory_insertHorizontalBlankSpaceNotImplemented);
                }
                Command command = diagramEditor.getEmfCommandFactoryProvider().getCommandFactory(ted).buildInsertVerticalBlankSpaceCommand((DDiagram)diagramEditPart.getNotationView().getElement(), startLocation, spaceToInsertOrRemove);
                return new ICommandProxy((ICommand)new GMFCommandWrapper(ted, command));
            }
        }
        return UnexecutableCommand.INSTANCE;
    }

    private static IFigure getFeedbackLayer(GraphicalViewer diagramViewer) {
        LayerManager lm = (LayerManager)diagramViewer.getEditPartRegistry().get(LayerManager.ID);
        if (lm != null) {
            return lm.getLayer((Object)"Feedback Layer");
        }
        return null;
    }
}

