/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.query;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.business.api.query.DiagramDescriptionQuery;
import org.eclipse.sirius.diagram.business.api.query.DiagramElementMappingQuery;
import org.eclipse.sirius.diagram.business.api.query.DiagramExtensionDescriptionQuery;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.DiagramComponentizationHelper;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.DiagramExtensionDescription;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class AbstractNodeMappingApplicabilityTester {
    private Iterable<? extends AbstractNodeMapping> mappingsToCreate;

    public AbstractNodeMappingApplicabilityTester(Iterable<? extends AbstractNodeMapping> mappingsToCreate) {
        this.mappingsToCreate = mappingsToCreate;
    }

    private boolean canCreateIn(AbstractNodeMapping containerMapping) {
        boolean canCreateIn = false;
        List<DiagramElementMapping> selfAndSuperTypes = this.createSelfAndSuperType(containerMapping);
        Iterator<DiagramElementMapping> superTypes = selfAndSuperTypes.iterator();
        while (!canCreateIn && superTypes.hasNext()) {
            DiagramElementMapping selfOrSuper = superTypes.next();
            if (selfOrSuper instanceof ContainerMapping) {
                if (!this.checkValidSubMappingsAreSubtypeOf((ContainerMapping)selfOrSuper, this.mappingsToCreate)) continue;
                canCreateIn = true;
                continue;
            }
            if (!(selfOrSuper instanceof NodeMapping) || !this.checkValidSubMappingsAreSubtypeOf((NodeMapping)selfOrSuper, this.mappingsToCreate)) continue;
            canCreateIn = true;
        }
        return canCreateIn;
    }

    public boolean canCreateIn(DDiagram diagram) {
        if (diagram.getDescription() != null) {
            return this.canCreateIn(diagram.getDescription());
        }
        return false;
    }

    private boolean canCreateIn(DiagramDescription description) {
        if (Iterables.isEmpty(this.mappingsToCreate)) {
            return false;
        }
        boolean canCreateIn = false;
        List<DiagramDescription> selfAndSuperTypes = this.createSelfAndSuperType(description);
        Iterator<DiagramDescription> superTypes = selfAndSuperTypes.iterator();
        while (!canCreateIn && superTypes.hasNext()) {
            DiagramDescription selfOrSuper = superTypes.next();
            if (this.checkValidSubMappingsAreSubtypeOf(selfOrSuper, this.mappingsToCreate)) {
                canCreateIn = true;
            }
            EObject eContainerValue = null;
            if (!Iterables.isEmpty(this.mappingsToCreate)) {
                eContainerValue = (EObject)this.mappingsToCreate.iterator().next();
                while (!(eContainerValue instanceof DiagramExtensionDescription) && eContainerValue.eContainer() != null) {
                    eContainerValue = eContainerValue.eContainer();
                }
            }
            if (!(eContainerValue instanceof DiagramExtensionDescription)) continue;
            DiagramExtensionDescription diagramExtensionDescription = (DiagramExtensionDescription)eContainerValue;
            ArrayList<Viewpoint> viewpoints = new ArrayList<Viewpoint>();
            viewpoints.add((Viewpoint)selfOrSuper.eContainer());
            DiagramDescription diagramDescription = DiagramComponentizationHelper.getDiagramDescription(diagramExtensionDescription, viewpoints);
            if (!selfOrSuper.equals(diagramDescription) || !this.checkValidSubMappingsAreSubtypeOf(diagramExtensionDescription, this.mappingsToCreate)) continue;
            canCreateIn = true;
        }
        return canCreateIn;
    }

    private boolean checkValidSubMappingsAreSubtypeOf(DiagramDescription description, Iterable<? extends AbstractNodeMapping> collectToolNodeMappings) {
        for (AbstractNodeMapping validChild : Iterables.concat(description.getAllNodeMappings(), description.getAllContainerMappings())) {
            if (!this.doCheckAtLeastOneIsSubTypeOf(validChild, collectToolNodeMappings)) continue;
            return true;
        }
        return false;
    }

    private boolean checkValidSubMappingsAreSubtypeOf(DiagramExtensionDescription description, Iterable<? extends AbstractNodeMapping> collectToolNodeMappings) {
        DiagramExtensionDescriptionQuery extensionQuery = new DiagramExtensionDescriptionQuery(description);
        for (AbstractNodeMapping child : Iterables.concat(extensionQuery.getAllNodeMappings(), extensionQuery.getAllContainerMappings())) {
            if (!this.doCheckAtLeastOneIsSubTypeOf(child, collectToolNodeMappings)) continue;
            return true;
        }
        return false;
    }

    private List<DiagramDescription> createSelfAndSuperType(DiagramDescription description) {
        ArrayList<DiagramDescription> selfAndSuperTypes = new ArrayList<DiagramDescription>();
        selfAndSuperTypes.add(description);
        Iterators.addAll(selfAndSuperTypes, new DiagramDescriptionQuery(description).superTypes());
        return selfAndSuperTypes;
    }

    public boolean canCreateIn(DDiagramElementContainer container) {
        ContainerMapping containerMapping = container.getActualMapping();
        if (containerMapping != null) {
            return this.canCreateIn(containerMapping);
        }
        return false;
    }

    public boolean canCreateIn(DNode node) {
        NodeMapping nodeMapping = node.getActualMapping();
        if (nodeMapping != null) {
            return this.canCreateIn(nodeMapping);
        }
        return false;
    }

    private boolean checkValidSubMappingsAreSubtypeOf(ContainerMapping containerMapping, Iterable<? extends AbstractNodeMapping> toolDefinedMappings) {
        for (AbstractNodeMapping validChild : Iterables.concat(containerMapping.getAllNodeMappings(), containerMapping.getAllBorderedNodeMappings(), containerMapping.getAllContainerMappings())) {
            if (!this.doCheckAtLeastOneIsSubTypeOf(validChild, toolDefinedMappings)) continue;
            return true;
        }
        return false;
    }

    private boolean checkValidSubMappingsAreSubtypeOf(NodeMapping selfOrSuper, Iterable<? extends AbstractNodeMapping> collectToolNodeMappings) {
        for (AbstractNodeMapping validChild : selfOrSuper.getAllBorderedNodeMappings()) {
            if (!this.doCheckAtLeastOneIsSubTypeOf(validChild, collectToolNodeMappings)) continue;
            return true;
        }
        return false;
    }

    private List<DiagramElementMapping> createSelfAndSuperType(AbstractNodeMapping containerMapping) {
        ArrayList<DiagramElementMapping> selfAndSuperTypes = new ArrayList<DiagramElementMapping>();
        selfAndSuperTypes.add(containerMapping);
        Iterators.addAll(selfAndSuperTypes, new DiagramElementMappingQuery(containerMapping).superTypes());
        return selfAndSuperTypes;
    }

    private boolean doCheckAtLeastOneIsSubTypeOf(AbstractNodeMapping validChild, Iterable<? extends AbstractNodeMapping> toolDefinedMappings) {
        DiagramElementMappingQuery query = new DiagramElementMappingQuery(validChild);
        for (AbstractNodeMapping abstractNodeMapping : toolDefinedMappings) {
            if (!query.isSuperTypeOf(abstractNodeMapping)) continue;
            return true;
        }
        return false;
    }
}

