/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.server.diagram.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.modelingproject.ModelingProject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.services.diagram.api.SiriusDiagramMessage;
import org.eclipse.sirius.services.diagram.api.SiriusDiagramService;
import org.eclipse.sirius.viewpoint.SiriusPlugin;

public class SiriusServerDiagramServiceManager {
    private Map<String, SiriusDiagramService> representation2services = new HashMap<String, SiriusDiagramService>();
    private Map<SiriusDiagramService, String> service2representations = new HashMap<SiriusDiagramService, String>();
    private Map<SiriusDiagramService, List<String>> service2identifiers = new HashMap<SiriusDiagramService, List<String>>();
    private Map<String, SiriusDiagramService> identifier2services = new HashMap<String, SiriusDiagramService>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SiriusDiagramService acquire(String identifier, String projectName, String representationName, Consumer<SiriusDiagramMessage> callback) {
        Map<String, SiriusDiagramService> map = this.representation2services;
        synchronized (map) {
            String representationId = String.valueOf(projectName) + representationName;
            SiriusDiagramService diagramService = this.representation2services.get(representationId);
            if (diagramService == null) {
                Optional<Session> optionalSession = this.getSession(projectName);
                Optional optionalDDiagram = optionalSession.flatMap(session -> this.getDDiagramFromSession((Session)session, representationName));
                if (optionalSession.isPresent() && optionalDDiagram.isPresent()) {
                    Session session2 = optionalSession.get();
                    DDiagram dDiagram = (DDiagram)optionalDDiagram.get();
                    diagramService = new SiriusDiagramService(session2, dDiagram, callback);
                    diagramService.initialize();
                    this.representation2services.put(representationId, diagramService);
                    this.service2representations.put(diagramService, representationId);
                    this.identifier2services.put(identifier, diagramService);
                    List identifiers = this.service2identifiers.getOrDefault(diagramService, new ArrayList());
                    identifiers.add(identifier);
                    this.service2identifiers.put(diagramService, identifiers);
                }
            }
            return diagramService;
        }
    }

    private Optional<Session> getSession(String projectName) {
        Optional<IProject> optionalProject = Optional.of(ResourcesPlugin.getWorkspace().getRoot().getProject(projectName));
        Optional<ModelingProject> optionalModelingProject = optionalProject.filter(ModelingProject::hasModelingProjectNature).map(iProject -> (ModelingProject)ModelingProject.asModelingProject((IProject)iProject).get());
        return optionalModelingProject.map(modelingProject -> {
            Session session = modelingProject.getSession();
            if (session == null) {
                URI sessionResourceURI = (URI)modelingProject.getMainRepresentationsFileURI((IProgressMonitor)new NullProgressMonitor()).get();
                session = SessionManager.INSTANCE.openSession(sessionResourceURI, (IProgressMonitor)new NullProgressMonitor(), SiriusPlugin.getDefault().getUiCallback());
            }
            return session;
        });
    }

    private Optional<DDiagram> getDDiagramFromSession(Session session, String representationName) {
        Collection representations = DialectManager.INSTANCE.getAllRepresentations(session);
        Optional<DDiagram> optionalDDiagram = representations.stream().filter(DDiagram.class::isInstance).map(DDiagram.class::cast).filter(dDiagram -> Optional.ofNullable(representationName).orElse("").equals(dDiagram.getName())).findFirst();
        return optionalDDiagram;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(String identifier) {
        Map<String, SiriusDiagramService> map = this.representation2services;
        synchronized (map) {
            Optional<SiriusDiagramService> optionalDiagramService = Optional.ofNullable(this.identifier2services.remove(identifier));
            optionalDiagramService.ifPresent(diagramService -> {
                this.service2identifiers.remove(diagramService);
                String representationId = this.service2representations.remove(diagramService);
                this.representation2services.remove(representationId);
                diagramService.dispose();
            });
        }
    }
}

