/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.migration;

import java.util.Optional;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.migration.AbstractRepresentationsFileMigrationParticipant;
import org.eclipse.sirius.business.api.resource.ResourceDescriptor;
import org.eclipse.sirius.business.internal.query.DRepresentationDescriptorInternalHelper;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.osgi.framework.Version;

public class DRepInDViewToRootObjectsAndWithDRepDescRepPathMigrationParticipant
extends AbstractRepresentationsFileMigrationParticipant {
    public static final Version MIGRATION_VERSION_REP_IN_DVIEW_TO_ROOT_OBJECT = new Version("11.1.0.201608251200");
    public static final Version MIGRATION_VERSION_REP_PATH_XMIID = new Version("12.0.0.201704191300");
    public static final Version MIGRATION_VERSION_REP_PATH_UID = new Version("12.1.0.201707281200");
    public static final String DVIEW_OWNED_REPRESENTATIONS_UNKNOWN_FEATURE = "ownedRepresentations";

    @Override
    public Version getMigrationVersion() {
        return MIGRATION_VERSION_REP_PATH_UID;
    }

    @Override
    protected void handleFeature(EObject owner, EStructuralFeature unkownFeature, Object valueOfUnknownFeature) {
        if (DVIEW_OWNED_REPRESENTATIONS_UNKNOWN_FEATURE.equals(unkownFeature.getName()) && valueOfUnknownFeature instanceof DRepresentation && owner instanceof DView) {
            DRepresentation representation = (DRepresentation)valueOfUnknownFeature;
            owner.eResource().getContents().add((Object)representation);
            DRepresentationDescriptor descriptor = DRepresentationDescriptorInternalHelper.createDescriptor(representation);
            ((DView)owner).getOwnedRepresentationDescriptors().add((Object)descriptor);
        }
    }

    @Override
    public Object getValue(EObject object, EStructuralFeature feature, Object value, String loadedVersion) {
        if (Version.parseVersion((String)loadedVersion).compareTo(MIGRATION_VERSION_REP_IN_DVIEW_TO_ROOT_OBJECT) >= 0 && Version.parseVersion((String)loadedVersion).compareTo(MIGRATION_VERSION_REP_PATH_XMIID) < 0 && ViewpointPackage.eINSTANCE.getDRepresentationDescriptor_Representation().equals(feature) && value instanceof DRepresentation) {
            DRepresentation rep = (DRepresentation)value;
            URI repURI = EcoreUtil.getURI((EObject)rep);
            URI newRepURI = URI.createHierarchicalURI((String)repURI.scheme(), (String)repURI.authority(), (String)repURI.device(), (String[])repURI.segments(), (String)repURI.query(), (String)rep.getUid());
            return newRepURI.toString();
        }
        return super.getValue(object, feature, value, loadedVersion);
    }

    @Override
    public EStructuralFeature getAffiliation(EClass eClass, EStructuralFeature eStructuralFeature, String loadedVersion) {
        if (Version.parseVersion((String)loadedVersion).compareTo(MIGRATION_VERSION_REP_IN_DVIEW_TO_ROOT_OBJECT) >= 0 && Version.parseVersion((String)loadedVersion).compareTo(MIGRATION_VERSION_REP_PATH_XMIID) < 0 && ViewpointPackage.eINSTANCE.getDRepresentationDescriptor_Representation().equals(eStructuralFeature)) {
            return ViewpointPackage.eINSTANCE.getDRepresentationDescriptor_RepPath();
        }
        return super.getAffiliation(eClass, eStructuralFeature, loadedVersion);
    }

    @Override
    protected void postLoad(DAnalysis dAnalysis, Version loadedVersion) {
        if (loadedVersion.compareTo(MIGRATION_VERSION_REP_PATH_XMIID) >= 0 && loadedVersion.compareTo(MIGRATION_VERSION_REP_PATH_UID) < 0) {
            dAnalysis.getOwnedViews().stream().flatMap(view -> view.getOwnedRepresentationDescriptors().stream()).forEach(repDesc -> Optional.ofNullable(this.getRepresentationFromURI((DRepresentationDescriptor)repDesc)).ifPresent(rep -> repDesc.updateRepresentation((DRepresentation)rep)));
            super.postLoad(dAnalysis, loadedVersion);
        }
    }

    private DRepresentation getRepresentationFromURI(DRepresentationDescriptor repDescriptor) {
        ResourceDescriptor resourceDescriptor = repDescriptor.getRepPath();
        Resource resource = repDescriptor.eResource();
        if (resourceDescriptor != null) {
            try {
                return Optional.ofNullable(resource).map(Resource::getResourceSet).map(rSet -> rSet.getEObject(resourceDescriptor.getResourceURI(), true)).filter(DRepresentation.class::isInstance).map(DRepresentation.class::cast).orElse(null);
            }
            catch (WrappedException wrappedException) {}
        }
        return null;
    }
}

