/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.spore.p1structure;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.elk.alg.common.BowyerWatsonTriangulation;
import org.eclipse.elk.alg.common.spore.InternalProperties;
import org.eclipse.elk.alg.spore.SPOrEPhases;
import org.eclipse.elk.alg.spore.graph.Graph;
import org.eclipse.elk.core.alg.ILayoutPhase;
import org.eclipse.elk.core.alg.LayoutProcessorConfiguration;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public class DelaunayTriangulationPhase
implements ILayoutPhase<SPOrEPhases, Graph> {
    public LayoutProcessorConfiguration<SPOrEPhases, Graph> getLayoutProcessorConfiguration(Graph graph) {
        return LayoutProcessorConfiguration.create();
    }

    public void process(Graph graph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Delaunay triangulation", 1.0f);
        ArrayList vertices = Lists.newArrayList();
        graph.vertices.forEach(v -> {
            boolean bl = vertices.add(v.originalVertex);
        });
        String debugOutput = null;
        if (((Boolean)graph.getProperty(InternalProperties.DEBUG_SVG)).booleanValue()) {
            debugOutput = String.valueOf(ElkUtil.debugFolderPath((String)"spore")) + "10bw";
        }
        if (graph.tEdges == null) {
            graph.tEdges = BowyerWatsonTriangulation.triangulate((List)vertices, debugOutput);
        } else {
            graph.tEdges.addAll(BowyerWatsonTriangulation.triangulate((List)vertices, debugOutput));
        }
        progressMonitor.done();
    }
}

