/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.ui.tools.internal.interpreter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.common.tools.api.contentassist.ContentContext;
import org.eclipse.sirius.common.tools.api.contentassist.ContentInstanceContext;
import org.eclipse.sirius.common.tools.api.contentassist.ContentProposal;
import org.eclipse.sirius.common.tools.api.contentassist.IProposalProvider;
import org.eclipse.sirius.common.tools.api.interpreter.CompoundInterpreter;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.internal.assist.ProposalProviderRegistry;
import org.eclipse.sirius.common.tools.internal.interpreter.IMonomorphicService;
import org.eclipse.sirius.common.tools.internal.interpreter.IPolymorphicService;
import org.eclipse.sirius.common.tools.internal.interpreter.IService;
import org.eclipse.sirius.common.tools.internal.interpreter.ServiceInterpreter;
import org.eclipse.sirius.common.tools.internal.interpreter.VariableInterpreter;
import org.eclipse.sirius.common.ui.Messages;
import org.eclipse.sirius.ext.base.Option;

public class ServiceProposalProvider
implements IProposalProvider {
    public ContentProposal getNewEmtpyExpression() {
        return new ContentProposal("service:", "service:", Messages.ServiceProposalProvider_newVariableExpression, "service:".length());
    }

    public List<ContentProposal> getProposals(IInterpreter interpreter, ContentContext context) {
        List<ContentProposal> proposals;
        if (context == null || !(interpreter instanceof ServiceInterpreter)) {
            proposals = Collections.emptyList();
        } else if (context.getContents() == null || context.getContents().length() == 0) {
            proposals = Collections.singletonList(this.getNewEmtpyExpression());
        } else {
            ServiceInterpreter serviceInterpreter = (ServiceInterpreter)interpreter;
            Resource vsmResource = context.getInterpreterContext().getElement().eResource();
            if (vsmResource != null) {
                serviceInterpreter.setProperty((Object)"files", new ArrayList<String>(Arrays.asList(vsmResource.getURI().toPlatformString(true))));
            }
            for (String dependency : context.getInterpreterContext().getDependencies()) {
                serviceInterpreter.addImport(dependency);
            }
            proposals = this.getProposals(context.getContents(), context.getPosition(), serviceInterpreter.getServices());
            ContentContext varContext = new ContentContext(context.getContents().replaceFirst("service:", "var:"), context.getPosition() - "service:".length() + "var:".length(), context.getInterpreterContext());
            proposals.addAll(this.getVariableProposals(context.getContents(), varContext));
        }
        return proposals;
    }

    public List<ContentProposal> getProposals(IInterpreter interpreter, ContentInstanceContext context) {
        List<ContentProposal> proposals;
        if (context == null || !(interpreter instanceof ServiceInterpreter)) {
            proposals = Collections.emptyList();
        } else if (context.getCurrentSelected() == null) {
            proposals = Collections.singletonList(this.getNewEmtpyExpression());
        } else {
            ServiceInterpreter serviceInterpreter = (ServiceInterpreter)interpreter;
            proposals = this.getProposals(context.getTextSoFar(), context.getCursorPosition(), serviceInterpreter.getServices());
            ContentInstanceContext varContext = new ContentInstanceContext(context.getCurrentSelected(), context.getTextSoFar().replaceFirst("service:", "var:"), context.getCursorPosition() - "service:".length() + "var:".length(), context.getEditingDomain());
            proposals.addAll(this.getVariableProposals(context.getTextSoFar(), varContext));
        }
        return proposals;
    }

    private List<ContentProposal> getProposals(String writtenExpression, int cursorPosition, Map<String, IService> services) {
        ArrayList<ContentProposal> proposals = new ArrayList<ContentProposal>();
        String serviceNamePrefix = writtenExpression.substring(0, cursorPosition);
        if ((serviceNamePrefix = serviceNamePrefix.trim()).length() >= "service:".length()) {
            Option receiverVariableName = ServiceInterpreter.getReceiverVariableName((String)(serviceNamePrefix = serviceNamePrefix.substring("service:".length())));
            if (receiverVariableName.some()) {
                serviceNamePrefix = serviceNamePrefix.substring(((String)receiverVariableName.get()).length() + 1);
            }
            for (Map.Entry<String, IService> entry : services.entrySet()) {
                String serviceName = entry.getKey();
                if (!serviceName.startsWith(serviceNamePrefix)) continue;
                IService service = entry.getValue();
                if (service instanceof IPolymorphicService) {
                    this.addAllImplementations(proposals, (IPolymorphicService)service);
                    continue;
                }
                proposals.add(new ContentProposal(serviceName, serviceName, serviceName));
            }
        }
        return proposals;
    }

    private List<ContentProposal> getVariableProposals(String writtenExpression, Object context) {
        VariableInterpreter variableInterpreter;
        if (!(context instanceof ContentContext) && !(context instanceof ContentInstanceContext)) {
            throw new IllegalArgumentException(Messages.ServiceProposalProvider_invalidContext);
        }
        ArrayList<ContentProposal> proposals = new ArrayList<ContentProposal>();
        Option receiverVariableName = ServiceInterpreter.getReceiverVariableName((String)writtenExpression);
        if (!receiverVariableName.some() && (variableInterpreter = (VariableInterpreter)CompoundInterpreter.INSTANCE.getInterpreterForExpression("var:")) != null) {
            List proposalProviders = ProposalProviderRegistry.getProvidersFor((IInterpreter)variableInterpreter);
            for (IProposalProvider provider : proposalProviders) {
                List variableProposals = Collections.emptyList();
                if (context instanceof ContentContext) {
                    variableProposals = provider.getProposals((IInterpreter)variableInterpreter, (ContentContext)context);
                } else if (context instanceof ContentInstanceContext) {
                    variableProposals = provider.getProposals((IInterpreter)variableInterpreter, (ContentInstanceContext)context);
                }
                for (ContentProposal contentProposal : variableProposals) {
                    proposals.add(new ContentProposal(String.valueOf(contentProposal.getProposal()) + ".", String.valueOf(contentProposal.getProposal()) + "." + ": " + contentProposal.getInformation(), contentProposal.getInformation(), contentProposal.getCursorPosition() + 1));
                }
            }
        }
        return proposals;
    }

    private void addAllImplementations(List<ContentProposal> proposals, IPolymorphicService service) {
        LinkedHashSet<String> serviceNames = new LinkedHashSet<String>();
        for (IMonomorphicService monomorphicService : service.getImplementers()) {
            String serviceName = monomorphicService.getName();
            List parametersTypes = monomorphicService.getParametersTypes();
            Iterator iterator = parametersTypes.iterator();
            if (iterator.hasNext()) {
                iterator.next();
                serviceName = String.valueOf(serviceName) + "(";
                while (iterator.hasNext()) {
                    String parameter = (String)iterator.next();
                    serviceName = String.valueOf(serviceName) + parameter;
                    if (!iterator.hasNext()) continue;
                    serviceName = String.valueOf(serviceName) + ", ";
                }
                serviceName = String.valueOf(serviceName) + ")";
            }
            serviceNames.add(serviceName);
        }
        for (String serviceName : serviceNames) {
            proposals.add(new ContentProposal(serviceName, serviceName, serviceName));
        }
    }
}

