/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.server.diagram.internal;

import java.net.URISyntaxException;
import java.util.Optional;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.diagram.WorkspaceImage;
import org.eclipse.sirius.server.diagram.internal.SiriusServerDiagramPlugin;
import org.eclipse.sirius.server.internal.SiriusServerPlugin;
import org.eclipse.sirius.services.diagram.api.ISiriusDiagramImagePathProvider;

public class SiriusServerDiagramImagePathProvider
implements ISiriusDiagramImagePathProvider {
    private static final String SLASH = "/";
    private static final String PLATFORM_RESOURCE = "platform:/resource/";
    private static final String EQUAL = "=";

    public Optional<String> getStaticImagePath(WorkspaceImage workspaceImage) {
        java.net.URI serverURI = SiriusServerPlugin.getPlugin().getServerURI();
        String workspaceImagePath = workspaceImage.getWorkspacePath();
        if (workspaceImagePath.startsWith(SLASH)) {
            workspaceImagePath = workspaceImagePath.substring(SLASH.length());
        }
        String path = "/images/" + workspaceImage.getWorkspacePath();
        Optional<String> optionalPath = Optional.empty();
        try {
            java.net.URI imageURI = new java.net.URI(serverURI.getScheme(), serverURI.getUserInfo(), serverURI.getHost(), serverURI.getPort(), path, null, null);
            optionalPath = Optional.of(imageURI.toString());
        }
        catch (URISyntaxException e) {
            Status status = new Status(4, "org.eclipse.sirius.server.diagram", e.getMessage(), (Throwable)e);
            SiriusServerDiagramPlugin.getPlugin().log(status);
        }
        return optionalPath;
    }

    public Optional<String> getLabelProviderImagePath(EObject eObject) {
        java.net.URI serverURI = SiriusServerPlugin.getPlugin().getServerURI();
        URI uri = EcoreUtil.getURI((EObject)eObject);
        String resourceURI = uri.trimFragment().toString();
        if (resourceURI.startsWith(PLATFORM_RESOURCE)) {
            resourceURI = resourceURI.substring(PLATFORM_RESOURCE.length());
        }
        String uriFragment = uri.fragment();
        String path = "/images/" + resourceURI;
        String fragment = "fragment=" + uriFragment;
        Optional<String> optionalPath = Optional.empty();
        try {
            java.net.URI imageURI = new java.net.URI(serverURI.getScheme(), serverURI.getUserInfo(), serverURI.getHost(), serverURI.getPort(), path, fragment, null);
            optionalPath = Optional.of(imageURI.toString());
        }
        catch (URISyntaxException e) {
            Status status = new Status(4, "org.eclipse.sirius.server.diagram", e.getMessage(), (Throwable)e);
            SiriusServerDiagramPlugin.getPlugin().log(status);
        }
        return optionalPath;
    }
}

