/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.services.common.api;

import java.io.IOException;
import java.util.Collections;
import java.util.Optional;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.sirius.business.api.modelingproject.ModelingProject;
import org.eclipse.sirius.business.api.session.DefaultLocalSessionCreationOperation;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.services.common.internal.SiriusCommonServicesPlugin;

public class ProjectServices {
    public static boolean isAccessibleProject(String projectName) {
        IProject project = ProjectServices.internalGetProject(projectName);
        return project.isAccessible();
    }

    public static Optional<IProject> projectFromName(Object object) {
        return Optional.ofNullable(object).filter(String.class::isInstance).map(String.class::cast).map(arg_0 -> ((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getProject(arg_0));
    }

    public static void createProject(IProject project) throws CoreException {
        ProjectServices.internalCreateProject(project, new String[0]);
    }

    public static ModelingProject createModelingProject(IProject project) throws CoreException {
        ProjectServices.internalCreateProject(project, "org.eclipse.sirius.nature.modelingproject");
        ModelingProject modelingProject = (ModelingProject)ModelingProject.asModelingProject((IProject)project).get();
        ProjectServices.createDefaultAird(project);
        return modelingProject;
    }

    public static Optional<Resource> addResource(ModelingProject project, String localPath, final EObject ... rootElements) {
        Optional<Resource> result = Optional.empty();
        final URI resourceURI = URI.createPlatformResourceURI((String)project.getProject().getFullPath().append(localPath).toString(), (boolean)true);
        final Session session = project.getSession();
        final Resource resource = session.getTransactionalEditingDomain().createResource(resourceURI.toString());
        result = Optional.ofNullable(resource);
        RecordingCommand command = new RecordingCommand(session.getTransactionalEditingDomain()){

            protected void doExecute() {
                EObject[] eObjectArray = rootElements;
                int n = rootElements.length;
                int n2 = 0;
                while (n2 < n) {
                    EObject rootElement = eObjectArray[n2];
                    resource.getContents().add((Object)rootElement);
                    ++n2;
                }
                try {
                    resource.save(Collections.EMPTY_MAP);
                    session.addSemanticResource(resourceURI, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (IOException e) {
                    Status status = new Status(4, "org.eclipse.sirius.services.common", e.getMessage(), (Throwable)e);
                    SiriusCommonServicesPlugin.getPlugin().getLog().log((IStatus)status);
                }
            }
        };
        session.getTransactionalEditingDomain().getCommandStack().execute((Command)command);
        session.save((IProgressMonitor)new NullProgressMonitor());
        return result;
    }

    public static void delete(IProject project) throws CoreException {
        project.getProject().delete(true, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void createDefaultAird(IProject project) throws CoreException {
        URI representationsURI = URI.createPlatformResourceURI((String)project.getFullPath().append("representations.aird").toString(), (boolean)true);
        DefaultLocalSessionCreationOperation sessionCreationOperation = new DefaultLocalSessionCreationOperation(representationsURI, (IProgressMonitor)new NullProgressMonitor());
        sessionCreationOperation.execute();
    }

    private static void internalCreateProject(IProject project, String ... natures) throws CoreException {
        if (project.exists()) {
            throw new IllegalStateException("Project with this name already exist");
        }
        IProjectDescription projectDescription = ResourcesPlugin.getWorkspace().newProjectDescription(project.getName());
        projectDescription.setNatureIds(natures);
        project.create(projectDescription, (IProgressMonitor)new NullProgressMonitor());
        project.open((IProgressMonitor)new NullProgressMonitor());
    }

    private static IProject internalGetProject(String projectName) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
    }
}

