/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.services.common.api;

import java.util.Optional;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.services.common.api.ViewpointServices;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;

public class RepresentationServices {
    public static Optional<RepresentationDescription> representationDescriptionFromIdentifiers(Session session, String viewpointIdentifier, String representationIdentifier) {
        return ViewpointServices.viewpointFromIdentifier(session, viewpointIdentifier).flatMap(viewpoint -> viewpoint.getOwnedRepresentations().stream().filter(representationDescription -> representationIdentifier.equals(representationDescription.getName())).findFirst());
    }

    public static void createRepresentation(final Session session, final RepresentationDescription representationDescription, final String name, final EObject eObject) {
        RecordingCommand command = new RecordingCommand(session.getTransactionalEditingDomain()){

            protected void doExecute() {
                DialectManager.INSTANCE.createRepresentation(name, eObject, representationDescription, session, (IProgressMonitor)new NullProgressMonitor());
            }
        };
        session.getTransactionalEditingDomain().getCommandStack().execute((Command)command);
    }
}

