/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.services.common.api;

import java.util.Optional;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.business.api.helper.SiriusResourceHelper;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.ViewpointSelector;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class ViewpointServices {
    public static Optional<Viewpoint> viewpointFromIdentifier(Object object) {
        return Optional.ofNullable(object).filter(String.class::isInstance).map(String.class::cast).flatMap(viewpointIdentifier -> ViewpointRegistry.getInstance().getViewpoints().stream().filter(viewpoint -> viewpointIdentifier.equals(viewpoint.getName())).findFirst());
    }

    public static Optional<Viewpoint> viewpointFromIdentifier(Session session, Object object) {
        Optional<Viewpoint> viewpointFromIdentifier = ViewpointServices.viewpointFromIdentifier(object);
        return viewpointFromIdentifier.map(viewpoint -> {
            Viewpoint rest = SiriusResourceHelper.getCorrespondingViewpoint((Session)session, (Viewpoint)viewpoint);
            return rest;
        });
    }

    public static void activateViewpoint(final Session session, final Viewpoint viewpoint) {
        RecordingCommand command = new RecordingCommand(session.getTransactionalEditingDomain()){

            protected void doExecute() {
                new ViewpointSelector(session).selectViewpoint(SiriusResourceHelper.getCorrespondingViewpoint((Session)session, (Viewpoint)viewpoint), false, (IProgressMonitor)new NullProgressMonitor());
            }
        };
        session.getTransactionalEditingDomain().getCommandStack().execute((Command)command);
    }
}

