/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.services.graphql.internal.schema.mutation.viewpoints;

import graphql.Scalars;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.util.Optional;
import org.eclipse.core.resources.IProject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.services.common.api.ProjectServices;
import org.eclipse.sirius.services.common.api.SiriusServicesCommonOptionalUtils;
import org.eclipse.sirius.services.common.api.ViewpointServices;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public final class SiriusGraphQLActivateViewpointField {
    private static final String ACTIVATE_VIEWPOINT_FIELD = "activateViewpoint";
    private static final String PROJECT_NAME_ARG = "projectName";
    private static final String VIEWPOINT_IDENTIFIER_ARG = "viewpointIdentifier";

    private SiriusGraphQLActivateViewpointField() {
    }

    public static GraphQLFieldDefinition build() {
        return GraphQLFieldDefinition.newFieldDefinition().name(ACTIVATE_VIEWPOINT_FIELD).argument(SiriusGraphQLActivateViewpointField.getProjectNameArgument()).argument(SiriusGraphQLActivateViewpointField.getViewpointIdentifierArgument()).type((GraphQLOutputType)new GraphQLTypeReference("Project")).dataFetcher(SiriusGraphQLActivateViewpointField.getActivateViewpointDataFetcher()).build();
    }

    private static GraphQLArgument getProjectNameArgument() {
        return GraphQLArgument.newArgument().name(PROJECT_NAME_ARG).type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString)).build();
    }

    private static GraphQLArgument getViewpointIdentifierArgument() {
        return GraphQLArgument.newArgument().name(VIEWPOINT_IDENTIFIER_ARG).type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString)).build();
    }

    private static DataFetcher<IProject> getActivateViewpointDataFetcher() {
        return environment -> {
            Optional optionalProject = ProjectServices.projectFromName((Object)environment.getArgument(PROJECT_NAME_ARG));
            Optional optionalSession = optionalProject.flatMap(SiriusServicesCommonOptionalUtils::toSession);
            Optional optionalViewpoint = ViewpointServices.viewpointFromIdentifier((Object)environment.getArgument(VIEWPOINT_IDENTIFIER_ARG));
            optionalSession.ifPresent(session -> optionalViewpoint.ifPresent(viewpoint -> ViewpointServices.activateViewpoint((Session)session, (Viewpoint)viewpoint)));
            return optionalProject.orElse(null);
        };
    }
}

