/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.services.graphql.internal.schema.query.resources;

import graphql.schema.DataFetcher;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.services.common.api.SiriusServicesCommonOptionalUtils;
import org.eclipse.sirius.services.graphql.internal.entities.SiriusGraphQLConnection;
import org.eclipse.sirius.services.graphql.internal.schema.ISiriusGraphQLTypesBuilder;
import org.eclipse.sirius.services.graphql.internal.schema.directives.SiriusGraphQLCostDirective;
import org.eclipse.sirius.services.graphql.internal.schema.query.pagination.SiriusGraphQLConnectionTypeBuilder;
import org.eclipse.sirius.services.graphql.internal.schema.query.pagination.SiriusGraphQLEdgeTypeBuilder;
import org.eclipse.sirius.services.graphql.internal.schema.query.pagination.SiriusGraphQLPaginationArguments;
import org.eclipse.sirius.services.graphql.internal.schema.query.pagination.SiriusGraphQLPaginationDataFetcher;
import org.eclipse.sirius.services.graphql.internal.schema.query.resources.SiriusGraphQLResourceContainerField;
import org.eclipse.sirius.services.graphql.internal.schema.query.resources.SiriusGraphQLResourceNameField;
import org.eclipse.sirius.services.graphql.internal.schema.query.resources.SiriusGraphQLResourcePathField;
import org.eclipse.sirius.services.graphql.internal.schema.query.resources.SiriusGraphQLResourceProjectField;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;

public class SiriusGraphQLFileTypesBuilder
implements ISiriusGraphQLTypesBuilder {
    public static final String FILE_TYPE = "File";
    public static final String FILE_REPRESENTATION_CONNECTION_TYPE = "FileRepresentationConnection";
    public static final String FILE_REPRESENTATION_EDGE_TYPE = "FileRepresentationEdge";
    private static final String REPRESENTATIONS = "representations";
    public static final String FILE_EOBJECT_CONNECTION_TYPE = "FileEObjectConnection";
    public static final String FILE_EOBJECT_EDGE_TYPE = "FileEObjectEdge";
    private static final String EOBJECTS = "eObjects";
    private static final int REPRESENTATIONS_COMPLEXITY = 10;
    private static final int EOBJECTS_COMPLEXITY = 1;

    @Override
    public Set<GraphQLType> getTypes() {
        GraphQLObjectType representationEdge = new SiriusGraphQLEdgeTypeBuilder(FILE_REPRESENTATION_EDGE_TYPE, "Representation").build();
        GraphQLObjectType representationConnection = new SiriusGraphQLConnectionTypeBuilder(FILE_REPRESENTATION_CONNECTION_TYPE, FILE_REPRESENTATION_EDGE_TYPE).build();
        GraphQLObjectType eObjectEdge = new SiriusGraphQLEdgeTypeBuilder(FILE_EOBJECT_EDGE_TYPE, "EObject").build();
        GraphQLObjectType eObjectConnection = new SiriusGraphQLConnectionTypeBuilder(FILE_EOBJECT_CONNECTION_TYPE, FILE_EOBJECT_EDGE_TYPE).build();
        GraphQLObjectType file = GraphQLObjectType.newObject().name(FILE_TYPE).field(SiriusGraphQLResourceNameField.build()).field(SiriusGraphQLResourcePathField.build()).field(SiriusGraphQLResourceContainerField.build()).field(SiriusGraphQLResourceProjectField.build()).field(this.getRepresentationsField()).field(this.getEObjectsField()).withInterface(new GraphQLTypeReference("Resource")).build();
        LinkedHashSet<GraphQLType> types = new LinkedHashSet<GraphQLType>();
        types.add((GraphQLType)file);
        types.add((GraphQLType)representationEdge);
        types.add((GraphQLType)representationConnection);
        types.add((GraphQLType)eObjectEdge);
        types.add((GraphQLType)eObjectConnection);
        return types;
    }

    private GraphQLFieldDefinition getRepresentationsField() {
        ArrayList<String> multipliers = new ArrayList<String>();
        multipliers.add("first");
        multipliers.add("last");
        return GraphQLFieldDefinition.newFieldDefinition().name(REPRESENTATIONS).type((GraphQLOutputType)new GraphQLTypeReference(FILE_REPRESENTATION_CONNECTION_TYPE)).argument(SiriusGraphQLPaginationArguments.build()).withDirective(new SiriusGraphQLCostDirective(10, multipliers).build()).dataFetcher(this.getRepresentationsDataFetcher()).build();
    }

    private DataFetcher<SiriusGraphQLConnection> getRepresentationsDataFetcher() {
        return SiriusGraphQLPaginationDataFetcher.build(environment -> {
            Optional<IFile> optionalFile = Optional.of(environment.getSource()).filter(IFile.class::isInstance).map(IFile.class::cast);
            Optional optionalSession = optionalFile.map(IResource::getProject).flatMap(SiriusServicesCommonOptionalUtils::toSession);
            ArrayList<DRepresentation> representations = new ArrayList<DRepresentation>();
            if (optionalFile.isPresent() && optionalSession.isPresent()) {
                IFile iFile = optionalFile.get();
                Session session = (Session)optionalSession.get();
                Collection representationDescriptors = DialectManager.INSTANCE.getAllRepresentationDescriptors(session);
                for (DRepresentationDescriptor representationDescriptor : representationDescriptors) {
                    URI fileUri;
                    EObject eObject = representationDescriptor.getTarget();
                    URI uri = eObject.eResource().getURI();
                    if (!uri.equals(fileUri = URI.createPlatformResourceURI((String)iFile.getFullPath().toString(), (boolean)true))) continue;
                    representations.add(representationDescriptor.getRepresentation());
                }
            }
            return representations;
        });
    }

    private GraphQLFieldDefinition getEObjectsField() {
        ArrayList<String> multipliers = new ArrayList<String>();
        multipliers.add("first");
        multipliers.add("last");
        return GraphQLFieldDefinition.newFieldDefinition().name(EOBJECTS).type((GraphQLOutputType)new GraphQLTypeReference(FILE_EOBJECT_CONNECTION_TYPE)).argument(SiriusGraphQLPaginationArguments.build()).withDirective(new SiriusGraphQLCostDirective(1, multipliers).build()).dataFetcher(this.getEObjectsDataFetcher()).build();
    }

    private DataFetcher<SiriusGraphQLConnection> getEObjectsDataFetcher() {
        return SiriusGraphQLPaginationDataFetcher.build(environment -> {
            Optional<IFile> optionalFile = Optional.of(environment.getSource()).filter(IFile.class::isInstance).map(IFile.class::cast);
            Optional optionalSession = optionalFile.map(IResource::getProject).flatMap(SiriusServicesCommonOptionalUtils::toSession);
            Optional<EList> optionalResource = optionalFile.flatMap(iFile -> optionalSession.flatMap(session -> SiriusServicesCommonOptionalUtils.toResource((Session)session, (IFile)iFile)));
            return (List)optionalResource.map(Resource::getContents).orElseGet(BasicEList::new);
        });
    }
}

