/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.services.graphql.internal.schema.query.resources;

import graphql.Scalars;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.sirius.services.common.api.SiriusServicesCommonOptionalUtils;
import org.eclipse.sirius.services.graphql.internal.SiriusGraphQLPlugin;
import org.eclipse.sirius.services.graphql.internal.entities.SiriusGraphQLConnection;
import org.eclipse.sirius.services.graphql.internal.schema.ISiriusGraphQLTypesBuilder;
import org.eclipse.sirius.services.graphql.internal.schema.directives.SiriusGraphQLCostDirective;
import org.eclipse.sirius.services.graphql.internal.schema.query.pagination.SiriusGraphQLConnectionTypeBuilder;
import org.eclipse.sirius.services.graphql.internal.schema.query.pagination.SiriusGraphQLEdgeTypeBuilder;
import org.eclipse.sirius.services.graphql.internal.schema.query.pagination.SiriusGraphQLPaginationArguments;
import org.eclipse.sirius.services.graphql.internal.schema.query.pagination.SiriusGraphQLPaginationDataFetcher;
import org.eclipse.sirius.services.graphql.internal.schema.query.resources.SiriusGraphQLContainerResourcesField;
import org.eclipse.sirius.services.graphql.internal.schema.query.resources.SiriusGraphQLResourceContainerField;
import org.eclipse.sirius.services.graphql.internal.schema.query.resources.SiriusGraphQLResourceNameField;
import org.eclipse.sirius.services.graphql.internal.schema.query.resources.SiriusGraphQLResourcePathField;
import org.eclipse.sirius.services.graphql.internal.schema.query.resources.SiriusGraphQLResourceProjectField;

public class SiriusGraphQLProjectTypesBuilder
implements ISiriusGraphQLTypesBuilder {
    public static final String PROJECT_TYPE = "Project";
    private static final String DESCRIPTION_FIELD = "description";
    private static final String RESOURCE_BY_PATH_FIELD = "resourceByPath";
    private static final String PATH_ARG = "path";
    private static final String ACTIVATED_VIEWPOINTS = "activatedViewpoints";
    public static final String PROJECT_VIEWPOINT_CONNECTION_TYPE = "ProjectViewpointConnection";
    public static final String PROJECT_VIEWPOINT_EDGE_TYPE = "ProjectViewpointEdge";
    private static final int ACTIVATED_VIEWPOINTS_COMPLEXITY = 1;

    @Override
    public Set<GraphQLType> getTypes() {
        GraphQLObjectType activatedViewpointsEdge = new SiriusGraphQLEdgeTypeBuilder(PROJECT_VIEWPOINT_EDGE_TYPE, "Viewpoint").build();
        GraphQLObjectType activatedViewpointsConnection = new SiriusGraphQLConnectionTypeBuilder(PROJECT_VIEWPOINT_CONNECTION_TYPE, PROJECT_VIEWPOINT_EDGE_TYPE).build();
        GraphQLObjectType project = GraphQLObjectType.newObject().name(PROJECT_TYPE).field(SiriusGraphQLResourceNameField.build()).field(SiriusGraphQLResourcePathField.build()).field(SiriusGraphQLResourceContainerField.build()).field(SiriusGraphQLResourceProjectField.build()).field(SiriusGraphQLContainerResourcesField.build()).field(this.getDescriptionField()).field(this.getResourceByPathField()).field(this.getActivatedViewpointsField()).withInterface(new GraphQLTypeReference("Resource")).withInterface(new GraphQLTypeReference("Container")).build();
        LinkedHashSet<GraphQLType> types = new LinkedHashSet<GraphQLType>();
        types.add((GraphQLType)project);
        types.add((GraphQLType)activatedViewpointsEdge);
        types.add((GraphQLType)activatedViewpointsConnection);
        return types;
    }

    private GraphQLFieldDefinition getDescriptionField() {
        return GraphQLFieldDefinition.newFieldDefinition().name(DESCRIPTION_FIELD).type((GraphQLOutputType)Scalars.GraphQLString).dataFetcher(this.getDescriptionDataFetcher()).build();
    }

    private DataFetcher<String> getDescriptionDataFetcher() {
        return environment -> {
            String description = null;
            Object source = environment.getSource();
            if (source instanceof IProject) {
                IProject iProject = (IProject)source;
                try {
                    IProjectDescription projectDescription = iProject.getDescription();
                    description = projectDescription.getComment();
                }
                catch (CoreException exception) {
                    Status status = new Status(4, "org.eclipse.sirius.services.graphql", exception.getMessage(), (Throwable)exception);
                    SiriusGraphQLPlugin.getPlugin().log(status);
                }
            }
            return description;
        };
    }

    private GraphQLFieldDefinition getResourceByPathField() {
        return GraphQLFieldDefinition.newFieldDefinition().name(RESOURCE_BY_PATH_FIELD).argument(this.getResourceByPathPathArg()).type((GraphQLOutputType)new GraphQLTypeReference("Resource")).dataFetcher(this.getResourcebyPathDataFetcher()).build();
    }

    private GraphQLArgument getResourceByPathPathArg() {
        return GraphQLArgument.newArgument().name(PATH_ARG).type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString)).build();
    }

    private DataFetcher<IResource> getResourcebyPathDataFetcher() {
        return environment -> {
            Object source = environment.getSource();
            Object pathArg = environment.getArgument(PATH_ARG);
            if (source instanceof IProject && pathArg instanceof String) {
                IProject iProject = (IProject)source;
                String path = (String)pathArg;
                return iProject.findMember(path);
            }
            return null;
        };
    }

    private GraphQLFieldDefinition getActivatedViewpointsField() {
        ArrayList<String> multipliers = new ArrayList<String>();
        multipliers.add("first");
        multipliers.add("last");
        return GraphQLFieldDefinition.newFieldDefinition().name(ACTIVATED_VIEWPOINTS).type((GraphQLOutputType)new GraphQLTypeReference(PROJECT_VIEWPOINT_CONNECTION_TYPE)).argument(SiriusGraphQLPaginationArguments.build()).withDirective(new SiriusGraphQLCostDirective(1, multipliers).build()).dataFetcher(this.getActivatedViewpointsDataFetcher()).build();
    }

    private DataFetcher<SiriusGraphQLConnection> getActivatedViewpointsDataFetcher() {
        return SiriusGraphQLPaginationDataFetcher.build(environment -> {
            Optional<IProject> optionalProject = Optional.of(environment.getSource()).filter(IProject.class::isInstance).map(IProject.class::cast);
            return optionalProject.flatMap(SiriusServicesCommonOptionalUtils::toSession).map(session -> new ArrayList(session.getSelectedViewpoints(true))).orElseGet(ArrayList::new);
        });
    }
}

