/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.services.graphql.internal.schema.query.viewpoints;

import graphql.Scalars;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.services.graphql.internal.entities.SiriusGraphQLConnection;
import org.eclipse.sirius.services.graphql.internal.schema.ISiriusGraphQLTypesBuilder;
import org.eclipse.sirius.services.graphql.internal.schema.directives.SiriusGraphQLCostDirective;
import org.eclipse.sirius.services.graphql.internal.schema.query.pagination.SiriusGraphQLConnectionTypeBuilder;
import org.eclipse.sirius.services.graphql.internal.schema.query.pagination.SiriusGraphQLEdgeTypeBuilder;
import org.eclipse.sirius.services.graphql.internal.schema.query.pagination.SiriusGraphQLPaginationArguments;
import org.eclipse.sirius.services.graphql.internal.schema.query.pagination.SiriusGraphQLPaginationDataFetcher;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class SiriusGraphQLViewpointTypesBuilder
implements ISiriusGraphQLTypesBuilder {
    public static final String VIEWPOINT_TYPE = "Viewpoint";
    public static final String VIEWPOINT_REPRESENTATION_DESCRIPTION_CONNECTION_TYPE = "ViewpointRepresentationDescriptionConnection";
    public static final String VIEWPOINT_REPRESENTATION_DESCRIPTION_EDGE_TYPE = "ViewpointRepresentationDescriptionEdge";
    private static final String IDENTIFIER_FIELD = "identifier";
    private static final String NAME_FIELD = "name";
    private static final String REPRESENTATION_DESCRIPTIONS_FIELD = "representationDescriptions";
    private static final int COMPLEXITY = 1;

    @Override
    public Set<GraphQLType> getTypes() {
        GraphQLObjectType representationDescriptionEdge = new SiriusGraphQLEdgeTypeBuilder(VIEWPOINT_REPRESENTATION_DESCRIPTION_EDGE_TYPE, "RepresentationDescription").build();
        GraphQLObjectType representationDescriptionConnection = new SiriusGraphQLConnectionTypeBuilder(VIEWPOINT_REPRESENTATION_DESCRIPTION_CONNECTION_TYPE, VIEWPOINT_REPRESENTATION_DESCRIPTION_EDGE_TYPE).build();
        GraphQLObjectType viewpoint = GraphQLObjectType.newObject().name(VIEWPOINT_TYPE).field(this.getIdentifierField()).field(this.getNameField()).field(this.getRepresentationDescriptionsField()).build();
        LinkedHashSet<GraphQLType> types = new LinkedHashSet<GraphQLType>();
        types.add((GraphQLType)viewpoint);
        types.add((GraphQLType)representationDescriptionEdge);
        types.add((GraphQLType)representationDescriptionConnection);
        return types;
    }

    private GraphQLFieldDefinition getIdentifierField() {
        return GraphQLFieldDefinition.newFieldDefinition().name(IDENTIFIER_FIELD).type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString)).dataFetcher(this.getIdentifierDataFetcher()).build();
    }

    private DataFetcher<String> getIdentifierDataFetcher() {
        return environment -> Optional.of(environment.getSource()).filter(Viewpoint.class::isInstance).map(Viewpoint.class::cast).map(IdentifiedElement::getName).orElse(null);
    }

    private GraphQLFieldDefinition getNameField() {
        return GraphQLFieldDefinition.newFieldDefinition().name(NAME_FIELD).type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString)).dataFetcher(this.getNameDataFetcher()).build();
    }

    private DataFetcher<String> getNameDataFetcher() {
        return environment -> Optional.of(environment.getSource()).filter(Viewpoint.class::isInstance).map(Viewpoint.class::cast).map(IdentifiedElementQuery::new).map(IdentifiedElementQuery::getLabel).orElse(null);
    }

    private GraphQLFieldDefinition getRepresentationDescriptionsField() {
        ArrayList<String> multipliers = new ArrayList<String>();
        multipliers.add("first");
        multipliers.add("last");
        return GraphQLFieldDefinition.newFieldDefinition().name(REPRESENTATION_DESCRIPTIONS_FIELD).argument(SiriusGraphQLPaginationArguments.build()).withDirective(new SiriusGraphQLCostDirective(1, multipliers).build()).type((GraphQLOutputType)new GraphQLTypeReference(VIEWPOINT_REPRESENTATION_DESCRIPTION_CONNECTION_TYPE)).dataFetcher(this.getRepresentationDescriptionsDataFetcher()).build();
    }

    private DataFetcher<SiriusGraphQLConnection> getRepresentationDescriptionsDataFetcher() {
        return SiriusGraphQLPaginationDataFetcher.build(environment -> Optional.of(environment.getSource()).filter(Viewpoint.class::isInstance).map(Viewpoint.class::cast).map(viewpoint -> viewpoint.getOwnedRepresentations().stream().filter(DiagramDescription.class::isInstance).collect(Collectors.toList())).orElseGet(ArrayList::new));
    }
}

