/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.wizards;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelection;
import org.eclipse.sirius.ui.tools.api.actions.analysis.IAddModelDependencyWizard;
import org.eclipse.sirius.ui.tools.internal.dialogs.SemanticResourceDialog;
import org.eclipse.sirius.ui.tools.internal.operations.SemanticResourceAdditionOperation;
import org.eclipse.sirius.ui.tools.internal.wizards.pages.CreateOrAddResourceWizardPage;
import org.eclipse.sirius.ui.tools.internal.wizards.pages.GenericInitialObjectPage;
import org.eclipse.sirius.ui.tools.internal.wizards.pages.GenericModelCreationPage;
import org.eclipse.sirius.ui.tools.internal.wizards.pages.SelectMetamodelWizardPage;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class CreateOrAddResourceWizard
extends Wizard
implements IAddModelDependencyWizard {
    protected IStructuredSelection selection;
    protected CreateOrAddResourceWizardPage selectionPage;
    protected SelectMetamodelWizardPage metamodelPage;
    protected GenericInitialObjectPage initialObjectPage;
    protected GenericModelCreationPage modelCreationPage;
    private IWorkbench workbench;
    private List<Session> sessions;

    public CreateOrAddResourceWizard() {
    }

    public CreateOrAddResourceWizard(TreeSelection initialSelection) {
        this.selection = initialSelection;
    }

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    @Override
    public void setSessions(List<Session> availableSessions) {
        this.sessions = availableSessions;
    }

    public IStructuredSelection getSelection() {
        if (this.selection == null) {
            this.selection = new StructuredSelection();
        }
        return this.selection;
    }

    public void init(IWorkbench w, IStructuredSelection s) {
        this.workbench = w;
        this.selection = s;
        this.setWindowTitle(Messages.CreateOrAddResourceWizard_windowTitle);
        this.setNeedsProgressMonitor(true);
    }

    public boolean canFinish() {
        if (!this.selectionPage.createResource()) {
            return true;
        }
        return super.canFinish();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.selectionPage) {
            if (!this.selectionPage.createResource()) {
                return null;
            }
            this.createMetamodelPage(page.getControl().getParent());
        } else if (page == this.metamodelPage) {
            this.initialObjectPage.setEPackage(this.metamodelPage.getEPackage());
        }
        return super.getNextPage(page);
    }

    public void addPages() {
        this.selectionPage = new CreateOrAddResourceWizardPage("selectionPage");
        this.selectionPage.setTitle(Messages.CreateOrAddResourceWizard_windowTitle);
        this.addPage((IWizardPage)this.selectionPage);
        this.metamodelPage = new SelectMetamodelWizardPage("metamodelPage", new String[]{"ecore"}, false);
        this.metamodelPage.setTitle(Messages.CreateOrAddResourceWizard_windowTitle);
        this.addPage((IWizardPage)this.metamodelPage);
        this.initialObjectPage = new GenericInitialObjectPage("initialObjectPage");
        this.initialObjectPage.setTitle(Messages.CreateOrAddResourceWizard_windowTitle);
        this.initialObjectPage.setDescription(Messages.CreateOrAddResourceWizard_initialEObject);
        this.addPage((IWizardPage)this.initialObjectPage);
        this.modelCreationPage = new GenericModelCreationPage("modelCreationPage", (IStructuredSelection)new StructuredSelection());
        this.modelCreationPage.setTitle(Messages.CreateOrAddResourceWizard_windowTitle);
        this.modelCreationPage.setDescription(Messages.CreateOrAddResourceWizard_modelCreation);
        this.addPage((IWizardPage)this.modelCreationPage);
    }

    public void createPageControls(Composite pageContainer) {
        this.selectionPage.createControl(pageContainer);
        Assert.isNotNull((Object)this.selectionPage.getControl());
    }

    private void createMetamodelPage(Composite pageContainer) {
        if (this.metamodelPage.getControl() == null) {
            this.metamodelPage.createControl(pageContainer);
            Assert.isNotNull((Object)this.metamodelPage.getControl());
        }
    }

    public boolean performFinish() {
        boolean finished = true;
        final ArrayList<URI> uris = new ArrayList<URI>();
        if (this.selectionPage.createResource()) {
            final IFile modelFile = this.modelCreationPage.getModelFile();
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) {
                    try {
                        try {
                            monitor.beginTask("", 1);
                            ResourceSetImpl resourceSet = new ResourceSetImpl();
                            URI fileURI = URI.createPlatformResourceURI((String)modelFile.getFullPath().toString(), (boolean)true);
                            Resource resource = resourceSet.createResource(fileURI);
                            EPackage ePackage = CreateOrAddResourceWizard.this.metamodelPage.getEPackage();
                            EClass eClass = (EClass)ePackage.getEClassifier(CreateOrAddResourceWizard.this.initialObjectPage.getInitialObjectName());
                            EObject rootObject = ePackage.getEFactoryInstance().create(eClass);
                            if (rootObject != null) {
                                resource.getContents().add((Object)rootObject);
                            }
                            HashMap<String, String> options = new HashMap<String, String>();
                            options.put("ENCODING", CreateOrAddResourceWizard.this.initialObjectPage.getEncoding());
                            resource.save(options);
                            uris.add(resource.getURI());
                        }
                        catch (IOException e) {
                            SiriusPlugin.getDefault().error(Messages.CreateOrAddResourceWizard_resourceNotCreatedError, (Throwable)e);
                            monitor.done();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            try {
                this.getContainer().run(true, false, (IRunnableWithProgress)operation);
            }
            catch (InvocationTargetException e) {
                SiriusPlugin.getDefault().error(Messages.CreateOrAddResourceWizard_resourceCreationError, (Throwable)e);
            }
            catch (InterruptedException e) {
                SiriusPlugin.getDefault().error(Messages.CreateOrAddResourceWizard_resourceCreationError, (Throwable)e);
            }
        } else {
            SemanticResourceDialog resourceDialog = new SemanticResourceDialog(Display.getCurrent().getActiveShell(), Messages.CreateOrAddResourceWizard_selectResourceMessage, 4098);
            int result = resourceDialog.open();
            if (result == 0) {
                uris.addAll(resourceDialog.getURIs());
            }
        }
        if (!uris.isEmpty()) {
            SemanticResourceAdditionOperation semanticResourceAdditionOperation = new SemanticResourceAdditionOperation(this.sessions, uris);
            try {
                this.getContainer().run(true, false, (IRunnableWithProgress)semanticResourceAdditionOperation);
                Collection<Object> results = semanticResourceAdditionOperation.getResults();
                for (Object result : results) {
                    if (!(result instanceof Session)) continue;
                    ViewpointSelection.openViewpointsSelectionDialog((Session)result);
                }
            }
            catch (InterruptedException e) {
                SiriusPlugin.getDefault().error(Messages.CreateOrAddResourceWizard_resourceAdditionError, (Throwable)e);
                finished = false;
            }
            catch (InvocationTargetException e) {
                SiriusPlugin.getDefault().error(Messages.CreateOrAddResourceWizard_resourceAdditionError, e.getTargetException());
                finished = false;
            }
        }
        return finished;
    }

    @Override
    public boolean canApply(Collection<Session> availableSessions) {
        return true;
    }

    @Override
    public String getWizardTitle() {
        return Messages.CreateOrAddResourceWizard_wizardTitle;
    }
}

