/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.unit.tree.vsm.edit;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

class InterpretedExpression {
    private String expression;
    private EObject declaration;
    private EAttribute feature;

    public InterpretedExpression(String expression, EObject declaration, EAttribute feature) {
        this.expression = expression;
        this.declaration = declaration;
        this.feature = feature;
    }

    public String getExpression() {
        return this.expression;
    }

    public EObject getDeclaration() {
        return this.declaration;
    }

    public EAttribute getFeature() {
        return this.feature;
    }

    public String toString() {
        return String.valueOf(this.getFeature().getName()) + " : " + this.expression + " in " + this.qualifiedName(this.getDeclaration());
    }

    private String qualifiedName(EObject declaration) {
        ArrayList<String> segments = new ArrayList<String>();
        EObject cur = declaration;
        while (cur != null) {
            Object label = this.getIfThere(cur, "label");
            if (label instanceof String) {
                segments.add((String)label);
            } else {
                Object name = this.getIfThere(cur, "name");
                if (name instanceof String) {
                    segments.add((String)name);
                } else {
                    segments.add(cur.eClass().getName());
                }
            }
            cur = cur.eContainer();
        }
        return Joiner.on((char)':').join((Iterable)Lists.reverse(segments));
    }

    private Object getIfThere(EObject cur, String name) {
        EStructuralFeature feature = cur.eClass().getEStructuralFeature(name);
        if (feature != null) {
            return cur.eGet(feature);
        }
        return null;
    }
}

