/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.migration;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.sirius.business.api.migration.IMigrationParticipant;
import org.eclipse.sirius.common.tools.api.util.EclipseUtil;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.viewpoint.Messages;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.osgi.framework.Version;
import org.xml.sax.Attributes;

public abstract class AbstractSiriusMigrationService
implements IMigrationParticipant {
    public static final String OPTION_RESOURCE_MIGRATION_LOADEDVERSION = "RESOURCE_MIGRATION_LOADEDVERSION";
    public static final String OPTION_RESOURCE_NON_BATCH_MIGRATION = "RESOURCE_NON_BATCH_MIGRATION";
    private static final Version FIRST_VERSION = new Version("6.5.0.201208161001");
    private List<IMigrationParticipant> delegatesParticipants = new ArrayList<IMigrationParticipant>();
    private Version lastMigrationVersion;

    protected void loadContributions() {
        IConfigurationElement[] config;
        this.delegatesParticipants.clear();
        IConfigurationElement[] iConfigurationElementArray = config = EclipseUtil.getConfigurationElementsFor((String)"org.eclipse.sirius.migrationParticipant");
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            try {
                Object contribution;
                String kind = configurationElement.getAttribute("kind");
                if (kind.equals(this.getKind()) && (contribution = configurationElement.createExecutableExtension("class")) instanceof IMigrationParticipant) {
                    this.delegatesParticipants.add((IMigrationParticipant)contribution);
                }
            }
            catch (CoreException e) {
                SiriusPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.sirius", Messages.AbstractSiriusMigrationService_contributionInstantiationErrorMsg, (Throwable)e));
            }
            ++n2;
        }
    }

    @Override
    public EStructuralFeature getAttribute(EClass eClass, String name, String loadedVersion) {
        EStructuralFeature structuralFeature = null;
        for (IMigrationParticipant contribution : this.delegatesParticipants) {
            structuralFeature = contribution.getAttribute(eClass, name, loadedVersion);
            if (structuralFeature != null) break;
        }
        return structuralFeature;
    }

    @Override
    public EStructuralFeature getLocalElement(EClass eClass, String name, String loadedVersion) {
        EStructuralFeature structuralFeature = null;
        for (IMigrationParticipant contribution : this.delegatesParticipants) {
            structuralFeature = contribution.getLocalElement(eClass, name, loadedVersion);
            if (structuralFeature != null) break;
        }
        return structuralFeature;
    }

    @Override
    public EClassifier getType(EPackage ePackage, String name, String loadedVersion) {
        EClassifier classifier = null;
        for (IMigrationParticipant contribution : this.delegatesParticipants) {
            classifier = contribution.getType(ePackage, name, loadedVersion);
            if (classifier != null) break;
        }
        return classifier;
    }

    @Override
    public Object getValue(EObject object, EStructuralFeature feature, Object value, String loadedVersion) {
        Object returnedValue = null;
        for (IMigrationParticipant contribution : this.delegatesParticipants) {
            returnedValue = contribution.getValue(object, feature, value, loadedVersion);
            if (returnedValue != null) break;
        }
        return returnedValue;
    }

    @Override
    public Option<String> getNewFragment(String uriFragment) {
        Option<String> optionalNewFragment = Options.newNone();
        for (IMigrationParticipant contribution : this.delegatesParticipants) {
            optionalNewFragment = contribution.getNewFragment(uriFragment);
            if (optionalNewFragment.some()) break;
        }
        return optionalNewFragment;
    }

    @Override
    public void postLoad(XMLResource resource, String loadedVersion) {
        for (IMigrationParticipant contribution : this.delegatesParticipants) {
            contribution.postLoad(resource, loadedVersion);
        }
        this.removeUnknownData(resource);
    }

    private void removeUnknownData(XMLResource resource) {
        Map eObjectToExtensionMap = resource.getEObjectToExtensionMap();
        Iterator eObjectToExtensionMapEntriesIterator = eObjectToExtensionMap.entrySet().iterator();
        while (eObjectToExtensionMapEntriesIterator.hasNext()) {
            Map.Entry entry = eObjectToExtensionMapEntriesIterator.next();
            AnyType unknownData = (AnyType)entry.getValue();
            FeatureMap mixedFeatureMap = unknownData.getMixed();
            Iterator mixedFeatureMapEntriesIterator = mixedFeatureMap.iterator();
            while (mixedFeatureMapEntriesIterator.hasNext()) {
                AnyType anyType;
                FeatureMap.Entry featureMapEntry = (FeatureMap.Entry)mixedFeatureMapEntriesIterator.next();
                Object value = featureMapEntry.getValue();
                if (!(value instanceof AnyType) || (anyType = (AnyType)value).eIsProxy()) continue;
                mixedFeatureMapEntriesIterator.remove();
            }
            FeatureMap anyAttributeFeatureMap = unknownData.getAnyAttribute();
            Iterator anyAttributeFeatureMapEntriesIterator = anyAttributeFeatureMap.iterator();
            while (anyAttributeFeatureMapEntriesIterator.hasNext()) {
                AnyType anyType;
                FeatureMap.Entry featureMapEntry = (FeatureMap.Entry)anyAttributeFeatureMapEntriesIterator.next();
                Object value = featureMapEntry.getValue();
                if (!(value instanceof AnyType) || (anyType = (AnyType)value).eIsProxy()) continue;
                anyAttributeFeatureMapEntriesIterator.remove();
            }
            if (!mixedFeatureMap.isEmpty() || !anyAttributeFeatureMap.isEmpty()) continue;
            eObjectToExtensionMapEntriesIterator.remove();
        }
    }

    protected abstract String getKind();

    public Version getLastMigrationVersion() {
        if (this.lastMigrationVersion == null) {
            this.lastMigrationVersion = FIRST_VERSION;
            for (IMigrationParticipant contribution : this.delegatesParticipants) {
                if (this.lastMigrationVersion.compareTo(contribution.getMigrationVersion()) >= 0) continue;
                this.lastMigrationVersion = contribution.getMigrationVersion();
            }
        }
        return this.lastMigrationVersion;
    }

    public boolean isMigrationNeeded(Version loadedVersion) {
        return this.getLastMigrationVersion().compareTo(loadedVersion) > 0;
    }

    @Override
    public EPackage getPackage(String namespace, String version) {
        EPackage returnedValue = null;
        for (IMigrationParticipant contribution : this.delegatesParticipants) {
            returnedValue = contribution.getPackage(namespace, version);
            if (returnedValue != null) break;
        }
        return returnedValue;
    }

    @Override
    public EStructuralFeature getAffiliation(EClass eClass, EStructuralFeature eStructuralFeature, String loadedVersion) {
        EStructuralFeature returnedValue = null;
        for (IMigrationParticipant contribution : this.delegatesParticipants) {
            returnedValue = contribution.getAffiliation(eClass, eStructuralFeature, loadedVersion);
            if (returnedValue != null) break;
        }
        return returnedValue;
    }

    @Override
    public EObject updateCreatedObject(EObject newObject, String loadedVersion) {
        EObject returnedValue = newObject;
        for (IMigrationParticipant contribution : this.delegatesParticipants) {
            returnedValue = contribution.updateCreatedObject(returnedValue, loadedVersion);
        }
        return returnedValue;
    }

    @Override
    public void postXMLEndElement(Object doneObject, Attributes xmlAttributes, String uri, String localName, String qName, String loadedVersion) {
        for (IMigrationParticipant contribution : this.delegatesParticipants) {
            contribution.postXMLEndElement(doneObject, xmlAttributes, uri, localName, qName, loadedVersion);
        }
    }

    @Override
    public Version getMigrationVersion() {
        return null;
    }
}

