/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.properties.core.internal.preprocessor;

import java.util.ArrayList;
import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;
import org.eclipse.sirius.properties.AbstractGroupDescription;
import org.eclipse.sirius.properties.GroupValidationSetDescription;
import org.eclipse.sirius.properties.PropertiesFactory;
import org.eclipse.sirius.properties.PropertiesPackage;
import org.eclipse.sirius.properties.PropertyValidationRule;
import org.eclipse.sirius.properties.core.api.OverridesProvider;
import org.eclipse.sirius.properties.core.api.PreconfiguredPreprocessor;
import org.eclipse.sirius.properties.core.api.TransformationCache;
import org.eclipse.sirius.viewpoint.description.validation.SemanticValidationRule;

public class GroupDescriptionPreprocessor
extends PreconfiguredPreprocessor<AbstractGroupDescription> {
    protected static final EReference VALIDATIONSET_FEATURE = PropertiesPackage.Literals.ABSTRACT_GROUP_DESCRIPTION__VALIDATION_SET;

    public GroupDescriptionPreprocessor() {
        super(AbstractGroupDescription.class, PropertiesPackage.Literals.GROUP_DESCRIPTION);
    }

    @Override
    protected void processMonoValuedEReference(EReference eReference, AbstractGroupDescription processedDescription, AbstractGroupDescription currentDescription, TransformationCache cache, IInterpreter interpreter, IVariableManager variableManager, OverridesProvider overridesProvider) {
        if (!eReference.equals(VALIDATIONSET_FEATURE)) {
            super.processMonoValuedEReference(eReference, processedDescription, currentDescription, cache, interpreter, variableManager, overridesProvider);
        } else {
            this.processValidationSet(processedDescription, currentDescription, cache, interpreter, variableManager, overridesProvider);
        }
    }

    private void processValidationSet(AbstractGroupDescription processedDescription, AbstractGroupDescription currentDescription, TransformationCache cache, IInterpreter interpreter, IVariableManager variableManager, OverridesProvider overridesProvider) {
        if (currentDescription.eIsSet((EStructuralFeature)VALIDATIONSET_FEATURE)) {
            GroupValidationSetDescription validationSet = Optional.ofNullable(processedDescription.getValidationSet()).orElse(PropertiesFactory.eINSTANCE.createGroupValidationSetDescription());
            processedDescription.setValidationSet(validationSet);
            ArrayList newSemanticValidationRules = new ArrayList();
            currentDescription.getValidationSet().getSemanticValidationRules().forEach(rule -> {
                if (!this.isFiltered((EStructuralFeature)PropertiesPackage.eINSTANCE.getGroupValidationSetDescription_SemanticValidationRules(), (EObject)processedDescription, (EObject)rule, cache, interpreter, variableManager, overridesProvider)) {
                    newSemanticValidationRules.add((SemanticValidationRule)EcoreUtil.copy((EObject)rule));
                }
            });
            newSemanticValidationRules.addAll(processedDescription.getValidationSet().getSemanticValidationRules());
            processedDescription.getValidationSet().getSemanticValidationRules().clear();
            processedDescription.getValidationSet().getSemanticValidationRules().addAll(newSemanticValidationRules);
            ArrayList newPropertyValidationRules = new ArrayList();
            currentDescription.getValidationSet().getPropertyValidationRules().forEach(rule -> {
                if (!this.isFiltered((EStructuralFeature)PropertiesPackage.eINSTANCE.getGroupValidationSetDescription_PropertyValidationRules(), (EObject)processedDescription, (EObject)rule, cache, interpreter, variableManager, overridesProvider)) {
                    newPropertyValidationRules.add((PropertyValidationRule)EcoreUtil.copy((EObject)rule));
                }
            });
            newPropertyValidationRules.addAll(processedDescription.getValidationSet().getPropertyValidationRules());
            processedDescription.getValidationSet().getPropertyValidationRules().clear();
            processedDescription.getValidationSet().getPropertyValidationRules().addAll(newPropertyValidationRules);
        }
    }
}

