/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.session.danalysis;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.query.DAnalysisQuery;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.api.query.RepresentationDescriptionQuery;
import org.eclipse.sirius.business.api.resource.ResourceDescriptor;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSelector;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSession;
import org.eclipse.sirius.common.tools.api.util.EqualityHelper;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.ViewpointFactory;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public final class DAnalysisSessionHelper {
    private DAnalysisSessionHelper() {
    }

    public static void addNewAnalysisResource(DAnalysisSession session, Resource loadedResource) {
        boolean newAird = true;
        Iterator<Resource> iterator = session.getAllSessionResources().iterator();
        while (newAird && iterator.hasNext()) {
            Resource resource = iterator.next();
            boolean bl = newAird = !resource.getURI().equals(loadedResource.getURI());
        }
        if (newAird) {
            session.addAnalysis(loadedResource);
        }
    }

    public static DAnalysis selectAnalysis(Viewpoint viewpoint, Collection<DAnalysis> candidates, DAnalysisSelector analysisSelector, DRepresentation addedRepresentation) {
        if (candidates.size() > 1 && analysisSelector != null) {
            return analysisSelector.selectSmartlyAnalysisForAddedRepresentation(addedRepresentation, candidates);
        }
        return (DAnalysis)candidates.toArray()[0];
    }

    public DAnalysis selectAnalysis(Resource resource, Collection<DAnalysis> candidates, DAnalysisSelector analysisSelector) {
        if (candidates.size() > 1 && analysisSelector != null) {
            return analysisSelector.selectSmartlyAnalysisForAddedResource(resource, candidates);
        }
        return (DAnalysis)candidates.toArray()[0];
    }

    public static DView findContainer(EObject semanticRoot, Viewpoint viewpoint, Collection<DAnalysis> all, DAnalysisSelector analysisSelector) {
        Collection<DView> containers = DAnalysisSessionHelper.getContainers(all, viewpoint);
        if (containers.isEmpty()) {
            return null;
        }
        ArrayList<DAnalysis> candidates = new ArrayList<DAnalysis>();
        for (DView container : containers) {
            if (!(container.eContainer() instanceof DAnalysis)) continue;
            candidates.add((DAnalysis)container.eContainer());
        }
        DAnalysis analysis = (DAnalysis)candidates.iterator().next();
        DView freeContainer = null;
        for (DView container : containers) {
            if (container.eContainer() != analysis) continue;
            freeContainer = container;
            break;
        }
        return freeContainer;
    }

    public static DView findContainerForAddedRepresentation(EObject semanticRoot, Viewpoint viewpoint, Collection<DAnalysis> all, DAnalysisSelector analysisSelector, DRepresentation representation) {
        Collection<DView> containers = DAnalysisSessionHelper.getContainers(all, viewpoint);
        if (containers.isEmpty()) {
            return null;
        }
        LinkedHashSet<DAnalysis> candidates = new LinkedHashSet<DAnalysis>();
        for (DView container : containers) {
            if (!(container.eContainer() instanceof DAnalysis)) continue;
            candidates.add((DAnalysis)container.eContainer());
        }
        DAnalysis analysis = DAnalysisSessionHelper.selectAnalysis(viewpoint, candidates, analysisSelector, representation);
        DView freeContainer = null;
        for (DView container : containers) {
            if (container.eContainer() != analysis) continue;
            freeContainer = container;
            break;
        }
        if (freeContainer == null && "cdo".equals(analysis.eResource().getURI().scheme())) {
            freeContainer = DAnalysisSessionHelper.createContainer(analysis, viewpoint);
        }
        return freeContainer;
    }

    public static DView findDViewForAddedRepresentation(DAnalysis analysis, RepresentationDescription representationDescription) {
        Viewpoint viewpoint = new RepresentationDescriptionQuery(representationDescription).getParentViewpoint();
        return DAnalysisSessionHelper.getDView(analysis, viewpoint);
    }

    public static DView findFreeContainer(Viewpoint viewpoint, Collection<DAnalysis> analyses, DAnalysisSelector analysisSelector) {
        Collection<DView> views = DAnalysisSessionHelper.getContainers(analyses, null);
        if (views.isEmpty()) {
            return null;
        }
        ArrayList<DAnalysis> candidates = new ArrayList<DAnalysis>();
        for (DView view : views) {
            if (!(view.eContainer() instanceof DAnalysis)) continue;
            candidates.add((DAnalysis)view.eContainer());
        }
        DAnalysis analysis = (DAnalysis)candidates.iterator().next();
        DView freeView = null;
        for (DView view : views) {
            if (view.eContainer() != analysis) continue;
            freeView = view;
            break;
        }
        return freeView;
    }

    public static DView findFreeContainerForAddedRepresentation(Viewpoint viewpoint, EObject semantic, Collection<DAnalysis> analyses, DAnalysisSelector analysisSelector, DRepresentation representation) {
        Collection<DView> views = DAnalysisSessionHelper.getContainers(analyses, null);
        if (views.isEmpty()) {
            return null;
        }
        ArrayList<DAnalysis> candidates = new ArrayList<DAnalysis>();
        for (DView view : views) {
            if (!(view.eContainer() instanceof DAnalysis)) continue;
            candidates.add((DAnalysis)view.eContainer());
        }
        DAnalysis analysis = DAnalysisSessionHelper.selectAnalysis(viewpoint, candidates, analysisSelector, representation);
        DView freeView = null;
        for (DView view : views) {
            if (view.eContainer() != analysis) continue;
            freeView = view;
            break;
        }
        return freeView;
    }

    public static Collection<Resource> getSemanticResource(Resource diagramResource) {
        EObject root;
        HashSet<Resource> semanticResources = new HashSet<Resource>();
        if (diagramResource.getContents().size() > 0 && (root = (EObject)diagramResource.getContents().get(0)) instanceof DAnalysis) {
            for (EObject model : ((DAnalysis)root).getModels()) {
                Resource modelResource = model.eResource();
                if (modelResource == null) continue;
                semanticResources.add(modelResource);
            }
        }
        return semanticResources;
    }

    public static void updateModelsReferences(DView dView) {
        DAnalysis analysis = (DAnalysis)dView.eContainer();
        EList<DRepresentationDescriptor> repDescriptors = dView.getOwnedRepresentationDescriptors();
        for (DRepresentationDescriptor repDescriptor : repDescriptors) {
            DAnalysisSessionHelper.updateModelsReferences(analysis, repDescriptor.getTarget());
            UnmodifiableIterator iterator = Iterators.filter((Iterator)repDescriptor.getRepresentation().eAllContents(), DSemanticDecorator.class);
            while (iterator.hasNext()) {
                EObject semanticTarget = ((DSemanticDecorator)iterator.next()).getTarget();
                DAnalysisSessionHelper.updateModelsReferences(analysis, semanticTarget);
            }
        }
    }

    private static void updateModelsReferences(DAnalysis analysis, EObject semanticObject) {
        EObject rootContainerInSameResource;
        if (semanticObject != null && (rootContainerInSameResource = new EObjectQuery(semanticObject).getResourceContainer()) != null) {
            boolean isMainModelOfReferencedAnalysis = false;
            for (DAnalysis referencedAnalysis : new DAnalysisQuery(analysis).getAllReferencedAnalyses()) {
                Option<EObject> optionalMainModel = new DAnalysisQuery(referencedAnalysis).getMainModel();
                if (!optionalMainModel.some() || !((EObject)optionalMainModel.get()).equals(rootContainerInSameResource)) continue;
                isMainModelOfReferencedAnalysis = true;
            }
            if (!isMainModelOfReferencedAnalysis) {
                analysis.getSemanticResources().add((Object)new ResourceDescriptor(rootContainerInSameResource.eResource().getURI()));
            }
        }
    }

    private static Collection<DView> getContainers(Iterable<DAnalysis> allAnalysis, Viewpoint viewpoint) {
        ArrayList<DView> containers = new ArrayList<DView>();
        for (DAnalysis analysis : allAnalysis) {
            DView container = DAnalysisSessionHelper.getDView(analysis, viewpoint);
            if (container == null) continue;
            containers.add(container);
        }
        return containers;
    }

    private static DView getDView(DAnalysis analysis, Viewpoint viewpoint) {
        DView result = null;
        for (DView view : analysis.getOwnedViews()) {
            if (viewpoint == null || !EqualityHelper.areEquals((EObject)viewpoint, (EObject)view.getViewpoint())) continue;
            result = view;
            break;
        }
        return result;
    }

    private static DView createContainer(DAnalysis analysis, Viewpoint viewpoint) {
        DView newContainer = ViewpointFactory.eINSTANCE.createDView();
        newContainer.setViewpoint(viewpoint);
        analysis.getOwnedViews().add((Object)newContainer);
        analysis.getSelectedViews().add((Object)newContainer);
        return newContainer;
    }
}

