/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.server.diagram.internal;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.sirius.services.diagram.api.AbstractSiriusDiagramAction;

public class SiriusServerDiagramTypeAdapter
extends TypeAdapter<AbstractSiriusDiagramAction> {
    private static final String KIND = "kind";
    private Map<String, TypeAdapter<AbstractSiriusDiagramAction>> kindToTypeAdapter = new LinkedHashMap<String, TypeAdapter<AbstractSiriusDiagramAction>>();
    private Map<Class<? extends AbstractSiriusDiagramAction>, String> typeToKind = new LinkedHashMap<Class<? extends AbstractSiriusDiagramAction>, String>();
    private Map<Class<? extends AbstractSiriusDiagramAction>, TypeAdapter<AbstractSiriusDiagramAction>> typeToTypeAdapter = new LinkedHashMap<Class<? extends AbstractSiriusDiagramAction>, TypeAdapter<AbstractSiriusDiagramAction>>();

    public SiriusServerDiagramTypeAdapter(Map<String, TypeAdapter<AbstractSiriusDiagramAction>> kindToTypeAdapter, Map<Class<? extends AbstractSiriusDiagramAction>, String> typeToKind, Map<Class<? extends AbstractSiriusDiagramAction>, TypeAdapter<AbstractSiriusDiagramAction>> typeToTypeAdapter) {
        this.kindToTypeAdapter = kindToTypeAdapter;
        this.typeToKind = typeToKind;
        this.typeToTypeAdapter = typeToTypeAdapter;
    }

    public AbstractSiriusDiagramAction read(JsonReader in) throws IOException {
        JsonElement jsonElement = Streams.parse((JsonReader)in);
        JsonElement kindJsonElement = jsonElement.getAsJsonObject().remove(KIND);
        String kind = kindJsonElement.getAsString();
        TypeAdapter<AbstractSiriusDiagramAction> typeAdapter = this.kindToTypeAdapter.get(kind);
        Object object = typeAdapter.fromJsonTree(jsonElement);
        if (object instanceof AbstractSiriusDiagramAction) {
            return (AbstractSiriusDiagramAction)object;
        }
        return null;
    }

    public void write(JsonWriter out, AbstractSiriusDiagramAction value) throws IOException {
        Class<?> type = value.getClass();
        String kind = this.typeToKind.get(type);
        TypeAdapter<AbstractSiriusDiagramAction> delegate = this.typeToTypeAdapter.get(type);
        JsonObject jsonObject = delegate.toJsonTree((Object)value).getAsJsonObject();
        JsonObject clone = new JsonObject();
        clone.add(KIND, (JsonElement)new JsonPrimitive(kind));
        jsonObject.entrySet().forEach(entry -> clone.add((String)entry.getKey(), (JsonElement)entry.getValue()));
        Streams.write((JsonElement)clone, (JsonWriter)out);
    }
}

