/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.swtbot.support.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.sirius.business.api.metamodel.helper.FontFormatHelper;
import org.eclipse.sirius.tests.swtbot.support.api.editor.SWTBotSiriusDiagramEditor;
import org.eclipse.sirius.tests.swtbot.support.utils.SiriusContextMenuFinder;
import org.eclipse.sirius.tests.swtbot.support.utils.menu.SWTBotContextMenu;
import org.eclipse.sirius.viewpoint.FontFormat;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.gef.finder.SWTGefBot;
import org.eclipse.swtbot.eclipse.gef.finder.widgets.SWTBotGefEditPart;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.matchers.WidgetMatcherFactory;
import org.eclipse.swtbot.swt.finder.results.BoolResult;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.results.WidgetResult;
import org.eclipse.swtbot.swt.finder.waits.DefaultCondition;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBot;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotMenu;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotToolbarDropDownButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.swtbot.swt.finder.widgets.TimeoutException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public final class SWTBotUtils {
    public static final long CLOSE_PROGRESS_MONITOR_TIMEOUT = TimeUnit.SECONDS.toSeconds(60L);
    private static SWTWorkbenchBot bot = new SWTWorkbenchBot();

    private SWTBotUtils() {
    }

    public static void directEditWithKeyboard(Widget widget, String text) {
        char[] charArray = text.toCharArray();
        if (charArray.length > 0) {
            char[] cArray = charArray;
            int n = charArray.length;
            int n2 = 0;
            while (n2 < n) {
                char element = cArray[n2];
                SWTBotUtils.pressKeyboardKey(widget, element);
                ++n2;
            }
        }
    }

    public static void pressKeyboardKey(final Widget widget, final int key) {
        UIThreadRunnable.asyncExec((VoidResult)new VoidResult(){

            public void run() {
                Event event = SWTBotUtils.keyEvent(0, (char)key, key, widget);
                widget.notifyListeners(1, event);
                widget.notifyListeners(2, event);
            }
        });
    }

    public static void pressKeyboardKey(final Widget widget, final int key, final char c) {
        UIThreadRunnable.asyncExec((VoidResult)new VoidResult(){

            public void run() {
                Event event = SWTBotUtils.keyEvent(key, c, 13, widget);
                widget.notifyListeners(1, event);
                widget.notifyListeners(2, event);
            }
        });
    }

    public static void pressEnterKey(final Widget widget) {
        UIThreadRunnable.asyncExec((VoidResult)new VoidResult(){

            public void run() {
                widget.notifyListeners(31, SWTBotUtils.keyEvent(0, '\r', 13, widget));
            }
        });
    }

    private static Event keyEvent(int modificationKey, char c, int keyCode, Widget widget) {
        Event keyEvent = SWTBotUtils.createEvent(widget);
        keyEvent.stateMask = modificationKey;
        keyEvent.character = c;
        keyEvent.keyCode = keyCode;
        return keyEvent;
    }

    private static Event createEvent(Widget widget) {
        Event event = new Event();
        event.time = (int)System.currentTimeMillis();
        event.widget = widget;
        event.display = bot.getDisplay();
        return event;
    }

    public static void clickContextMenu(final SWTBotTreeItem treeItem, final String text) {
        UIThreadRunnable.asyncExec((VoidResult)new VoidResult(){

            public void run() {
                SWTBotContextMenu menu = new SWTBotContextMenu(treeItem);
                menu.click(text);
            }
        });
    }

    public static boolean hasContextMenu(final SWTBotTreeItem treeItem, final String text) {
        return (Boolean)UIThreadRunnable.syncExec((Display)treeItem.display, (Result)new BoolResult(){

            public Boolean run() {
                SWTBotContextMenu swtBotContextMenu = new SWTBotContextMenu(treeItem);
                return swtBotContextMenu.exist(text);
            }
        });
    }

    public static boolean isContextMenuEnabled(final SWTBotTreeItem treeItem, String text) {
        Matcher withMnemonic = WidgetMatcherFactory.withMnemonic((String)text);
        final Matcher matcher = Matchers.allOf((Matcher)WidgetMatcherFactory.widgetOfType(MenuItem.class), (Matcher)withMnemonic);
        return (Boolean)UIThreadRunnable.syncExec((Result)new BoolResult(){

            public Boolean run() {
                return new SiriusContextMenuFinder((Control)((TreeItem)treeItem.widget).getParent()).findMenuEnablement((Matcher<MenuItem>)matcher);
            }
        });
    }

    public static void clickContextMenu(final SWTBotTree tree, final String text) {
        UIThreadRunnable.asyncExec((VoidResult)new VoidResult(){

            public void run() {
                SWTBotContextMenu menu = new SWTBotContextMenu(tree);
                menu.click(text);
            }
        });
    }

    public static void waitAllUiEvents() {
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
            }
        });
    }

    public static void waitProgressMonitorClose(String dialogTaskLabel) throws TimeoutException {
        SWTBotUtils.waitProgressMonitorClose("Progress Information", dialogTaskLabel, CLOSE_PROGRESS_MONITOR_TIMEOUT, TimeUnit.SECONDS);
    }

    public static void waitProgressMonitorClose(String dialogTitle, String dialogTaskLabel, long timeout, TimeUnit unit) throws TimeoutException {
        SWTBotUtils.waitProgressMonitorClose(dialogTitle, dialogTaskLabel, timeout, unit, true);
    }

    public static void waitProgressMonitorClose(final String dialogTitle, String dialogTaskLabel, long timeout, TimeUnit unit, final boolean wholeTitle) throws TimeoutException {
        bot.sleep(800L);
        final Shell[] shells = bot.getFinder().getShells();
        Shell progressShell = (Shell)UIThreadRunnable.syncExec((Display)bot.getDisplay(), (Result)new WidgetResult<Shell>(){

            public Shell run() {
                Shell[] shellArray = shells;
                int n = shells.length;
                int n2 = 0;
                while (n2 < n) {
                    Shell shell = shellArray[n2];
                    if (!shell.isDisposed() && (wholeTitle && shell.getText().equalsIgnoreCase(dialogTitle) || !wholeTitle && shell.getText().contains(dialogTitle))) {
                        return shell;
                    }
                    ++n2;
                }
                return null;
            }
        });
        if (progressShell != null) {
            long begin = System.currentTimeMillis();
            boolean noTimeOut = true;
            while (noTimeOut && SWTBotUtils.isShellNotClosed(progressShell)) {
                long now = System.currentTimeMillis();
                if (now - begin > unit.toMillis(timeout)) {
                    noTimeOut = false;
                    continue;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            if (!noTimeOut) {
                SWTBotUtils.waitAllUiEvents();
                if (SWTBotUtils.isShellNotClosed(progressShell)) {
                    throw new TimeoutException("'" + dialogTaskLabel + "' progress monitor dialog did not close in " + unit.toSeconds(CLOSE_PROGRESS_MONITOR_TIMEOUT) + "s");
                }
            }
        }
    }

    private static boolean isShellNotClosed(final Shell progressShell) {
        return (Boolean)UIThreadRunnable.syncExec((Display)bot.getDisplay(), (Result)new BoolResult(){

            public Boolean run() {
                return !progressShell.isDisposed();
            }
        });
    }

    public static List<FontFormat> getWidgetFormat(final TreeItem widget) {
        return (List)UIThreadRunnable.syncExec((Result)new Result<List<FontFormat>>(){

            public List<FontFormat> run() {
                ArrayList<FontFormat> result = new ArrayList<FontFormat>();
                Font font = widget.getFont(0);
                if (font.getFontData().length > 0) {
                    switch (font.getFontData()[0].getStyle()) {
                        case 1: {
                            FontFormatHelper.setFontFormat(result, (FontFormat)FontFormat.BOLD_LITERAL);
                            break;
                        }
                        case 2: {
                            FontFormatHelper.setFontFormat(result, (FontFormat)FontFormat.ITALIC_LITERAL);
                            break;
                        }
                        case 3: {
                            FontFormatHelper.setFontFormat(result, (FontFormat)FontFormat.BOLD_LITERAL);
                            FontFormatHelper.setFontFormat(result, (FontFormat)FontFormat.ITALIC_LITERAL);
                            break;
                        }
                    }
                }
                return result;
            }
        });
    }

    public static void clickOnTreeColumn(final SWTBotTree tree, final int columnIndex) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                TreeColumn column = ((Tree)tree.widget).getColumn(columnIndex);
                new SWTBotTreeColumn(column).clickOnColumn();
            }
        });
    }

    public static SWTBotTreeItem getTreeItem(SWTBotTreeItem[] treeElements, String name) {
        return SWTBotUtils.getTreeItem(treeElements, name, false, false);
    }

    public static SWTBotTreeItem getTreeItem(SWTBotTreeItem[] treeElements, String searchedLabel, boolean enabledItemsOnly, boolean expandItems) {
        SWTBotTreeItem treeItem = null;
        if (treeElements != null) {
            SWTBotTreeItem[] sWTBotTreeItemArray = treeElements;
            int n = treeElements.length;
            int n2 = 0;
            while (n2 < n) {
                SWTBotTreeItem item = sWTBotTreeItemArray[n2];
                String text = item.getText();
                if ((!enabledItemsOnly || item.isEnabled()) && Objects.equals(searchedLabel, text)) {
                    treeItem = item;
                } else {
                    boolean oldExpanded = item.isExpanded();
                    if (expandItems) {
                        item.expand();
                    }
                    if ((treeItem = SWTBotUtils.getTreeItem(item.getItems(), searchedLabel, enabledItemsOnly, expandItems)) == null && expandItems && !oldExpanded) {
                        item.collapse();
                    }
                }
                if (treeItem != null) break;
                ++n2;
            }
        }
        return treeItem;
    }

    public static void checkLabelInShell(String labelToLookFor, SWTBotShell shell) {
        Assert.assertTrue((String)("No label '" + labelToLookFor + "' has been found in the given Composite"), (boolean)((Boolean)UIThreadRunnable.syncExec((Display)bot.getDisplay(), (Result)new LabelChecker(labelToLookFor, (Composite)shell.widget))));
    }

    public static SWTBotShell checkForShellWithTitle(String title) {
        SWTBotShell[] shells = bot.shells();
        SWTBotShell shellWithTitle = null;
        SWTBotShell[] sWTBotShellArray = shells;
        int n = shells.length;
        int n2 = 0;
        while (n2 < n) {
            SWTBotShell swtBotShell = sWTBotShellArray[n2];
            if (title != null && title.equals(swtBotShell.getText())) {
                shellWithTitle = swtBotShell;
            }
            ++n2;
        }
        Assert.assertNotNull((String)("No shell was found with label: " + title), shellWithTitle);
        return shellWithTitle;
    }

    public static void checkLabelsInPalette(SWTBotSiriusDiagramEditor editor, List<String> labelsToCheck) {
        List children = editor.getPaletteRootEditPartBot().children();
        for (SWTBotGefEditPart child : children) {
            child.part();
            SWTBotUtils.checkLabelsInPalette(child, labelsToCheck);
        }
        Assert.assertTrue((String)("The following tools or sections have not been found in the palette: " + labelsToCheck), (boolean)labelsToCheck.isEmpty());
    }

    private static void checkLabelsInPalette(SWTBotGefEditPart swtBotGefEditPart, List<String> labelsToCheck) {
        if (labelsToCheck.isEmpty()) {
            return;
        }
        List children = swtBotGefEditPart.children();
        for (SWTBotGefEditPart child : children) {
            PaletteEntry paletteEntry;
            if (child.part() instanceof GraphicalEditPart && ((GraphicalEditPart)child.part()).getModel() instanceof PaletteEntry && labelsToCheck.contains((paletteEntry = (PaletteEntry)((GraphicalEditPart)child.part()).getModel()).getLabel())) {
                labelsToCheck.remove(paletteEntry.getLabel());
            }
            child.part();
            SWTBotUtils.checkLabelsInPalette(child, labelsToCheck);
        }
    }

    public static void checkLabelsInDiagramToolBar(SWTBotSiriusDiagramEditor editor, String toolTip, List<String> labelsToCheck) {
        if (labelsToCheck.isEmpty()) {
            return;
        }
        SWTBotToolbarDropDownButton toolMenuButton = editor.bot().toolbarDropDownButtonWithTooltip(toolTip);
        List menuItems = toolMenuButton.menuItems(WidgetMatcherFactory.widgetOfType(MenuItem.class));
        for (SWTBotMenu menuItem : menuItems) {
            if (!labelsToCheck.contains(menuItem.getText())) continue;
            labelsToCheck.remove(menuItem.getText());
        }
        Assert.assertTrue((String)("The following menu items have not been found in the " + toolTip + " toolBars contribution : " + labelsToCheck), (boolean)labelsToCheck.isEmpty());
        try {
            toolMenuButton.pressShortcut(new KeyStroke[]{KeyStroke.getInstance((String)"ESC")});
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static Menu checkContextualMenus(Display display, final Control control, List<String> labelsToCheck) {
        final ArrayList<String> labelToFind = new ArrayList<String>(labelsToCheck);
        return (Menu)UIThreadRunnable.syncExec((Display)display, (Result)new WidgetResult<Menu>(){

            public Menu run() {
                this.checkMenu(control.getMenu());
                Assert.assertTrue((String)("Some label have not been found :" + labelToFind), (boolean)labelToFind.isEmpty());
                return control.getMenu();
            }

            private void checkMenu(Menu menu) {
                try {
                    menu.notifyListeners(22, new Event());
                    MenuItem[] menuItemArray = menu.getItems();
                    int n = menuItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MenuItem menuItem = menuItemArray[n2];
                        if (labelToFind.contains(menuItem.getText())) {
                            labelToFind.remove(menuItem.getText());
                        }
                        if (menuItem.getMenu() != null) {
                            this.checkMenu(menuItem.getMenu());
                        }
                        ++n2;
                    }
                }
                finally {
                    menu.notifyListeners(23, new Event());
                }
            }
        });
    }

    public static boolean isMenuEnabled(Display display, final Control control, final String label) throws WidgetNotFoundException {
        final boolean[] status = new boolean[2];
        UIThreadRunnable.syncExec((Display)display, (Result)new WidgetResult<Menu>(){

            public Menu run() {
                this.checkMenu(control.getMenu());
                return control.getMenu();
            }

            private void checkMenu(Menu menu) {
                try {
                    menu.notifyListeners(22, new Event());
                    MenuItem[] menuItemArray = menu.getItems();
                    int n = menuItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MenuItem menuItem = menuItemArray[n2];
                        if (label.equals(menuItem.getText())) {
                            status[0] = true;
                            status[1] = menuItem.isEnabled();
                            break;
                        }
                        if (menuItem.getMenu() != null) {
                            this.checkMenu(menuItem.getMenu());
                        }
                        ++n2;
                    }
                }
                finally {
                    menu.notifyListeners(23, new Event());
                }
            }
        });
        if (status[0]) {
            return status[1];
        }
        throw new WidgetNotFoundException("The menu item \"" + label + "\" has not been found.");
    }

    public static void dragAndDropFileToAirdEditor(SWTGefBot currentBot, final SWTBotTree semanticAirdTree, SWTBotTreeItem sampleFile) {
        final int modelNumber = semanticAirdTree.getAllItems().length;
        currentBot.getDisplay().asyncExec(() -> {
            sampleFile.select();
            sampleFile.dragAndDrop((AbstractSWTBot)semanticAirdTree);
        });
        currentBot.waitUntil((ICondition)new DefaultCondition(){

            public boolean test() throws Exception {
                return semanticAirdTree.getAllItems().length > modelNumber;
            }

            public String getFailureMessage() {
                return "No model was added after the drag and drop.";
            }
        });
    }

    private static class LabelChecker
    implements BoolResult {
        String labelToLookFor;
        Composite compositeToInvestigate;

        LabelChecker(String label, Composite composite) {
            this.labelToLookFor = label;
            this.compositeToInvestigate = composite;
        }

        public Boolean run() {
            return this.findLabelAmongChildren(this.compositeToInvestigate);
        }

        private boolean findLabelAmongChildren(Composite composite) {
            boolean result = false;
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                if (child instanceof Composite) {
                    result = result || this.findLabelAmongChildren((Composite)child);
                } else if (child instanceof Label && this.labelToLookFor.equals(((Label)child).getText())) {
                    return true;
                }
                ++n2;
            }
            return result;
        }
    }

    public static final class SWTBotTreeColumn
    extends AbstractSWTBot<TreeColumn> {
        public SWTBotTreeColumn(TreeColumn w) throws WidgetNotFoundException {
            super((Widget)w);
        }

        public void clickOnColumn() {
            this.notify(13);
            this.notify(4, this.createMouseEvent(0, 0, 1, 524288, 1), (Widget)((TreeColumn)this.widget).getParent());
        }
    }
}

