/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayerConstraint;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public class BigNodesIntermediateProcessor
implements ILayoutProcessor<LGraph> {
    private LGraph layeredGraph;

    public void process(LGraph theLayeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Big nodes intermediate-processing", 1.0f);
        this.layeredGraph = theLayeredGraph;
        for (Layer layer : this.layeredGraph) {
            LinkedList nodes = Lists.newLinkedList(layer.getNodes());
            Iterable bigNodes = Iterables.filter((Iterable)nodes, (Predicate)new Predicate<LNode>(){

                public boolean apply(LNode node) {
                    return BigNodesIntermediateProcessor.this.isInitialBigNode(node);
                }
            });
            for (LNode node : bigNodes) {
                if (node.getProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT) == LayerConstraint.LAST || node.getProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT) == LayerConstraint.LAST_SEPARATE) {
                    LNode last = this.condenseBigNodesChain(node, false);
                    last.setProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT, (Object)((LayerConstraint)((Object)node.getProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT))));
                    node.setProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT, (Object)LayerConstraint.NONE);
                    continue;
                }
                this.condenseBigNodesChain(node, true);
            }
        }
        monitor.done();
    }

    private LNode condenseBigNodesChain(LNode start, boolean left) {
        LinkedList outs = Lists.newLinkedList(start.getOutgoingEdges());
        for (LEdge edge : outs) {
            LNode target = edge.getTarget().getNode();
            if (this.isInitialBigNode(target) || target.getType() != LNode.NodeType.BIG_NODE || ((Boolean)edge.getProperty(InternalProperties.REVERSED)).booleanValue() || edge.getTarget().getSide() != PortSide.WEST) continue;
            int gap = target.getLayer().getIndex() - start.getLayer().getIndex();
            if (gap > 1) {
                int newIndex = 0;
                newIndex = left ? start.getLayer().getIndex() + 1 : target.getLayer().getIndex() - 1;
                assert (newIndex >= 0);
                assert (newIndex < this.layeredGraph.getLayers().size());
                Layer newLayer = this.layeredGraph.getLayers().get(newIndex);
                target.setLayer(newLayer);
            }
            this.condenseBigNodesChain(target, left);
        }
        return start;
    }

    private boolean isInitialBigNode(LNode node) {
        return (Boolean)node.getProperty(InternalProperties.BIG_NODE_INITIAL) != false && node.getProperty(InternalProperties.ORIGIN) != null;
    }
}

