/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.ui.tools.api.dialog.quickoutline;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Optional;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.bindings.Trigger;
import org.eclipse.jface.bindings.keys.IKeyLookup;
import org.eclipse.jface.bindings.keys.KeyLookupFactory;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sirius.common.ui.Messages;
import org.eclipse.sirius.common.ui.tools.api.dialog.quickoutline.IQuickOutlineLabelProvider;
import org.eclipse.sirius.common.ui.tools.api.dialog.quickoutline.QuickOutlineDescriptor;
import org.eclipse.sirius.common.ui.tools.api.dialog.quickoutline.QuickOutlinePageDescriptor;
import org.eclipse.sirius.ext.e3.ui.dialogs.FilteredTree;
import org.eclipse.sirius.ext.e3.ui.dialogs.PatternFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class QuickOutlineControl
extends PopupDialog
implements IInformationControl,
IInformationControlExtension,
IInformationControlExtension2,
DisposeListener {
    private FilteredTree filteredTree;
    private TreeViewer treeViewer;
    private QuickOutlineDescriptor descriptor;
    private QuickOutlinePageDescriptor currentPage;

    public QuickOutlineControl(Shell parentShell, int shellStyle, QuickOutlineDescriptor descriptor) {
        super(parentShell, shellStyle, true, true, true, true, false, null, null);
        this.descriptor = descriptor;
        Optional<QuickOutlinePageDescriptor> firstPage = this.descriptor.getFirstPage();
        Preconditions.checkArgument((boolean)firstPage.isPresent(), (Object)Messages.QuickOutlineControl_errorNoPage);
        this.currentPage = firstPage.get();
        this.create();
    }

    public void addDisposeListener(DisposeListener listener) {
        this.getShell().addDisposeListener(listener);
    }

    public void addFocusListener(FocusListener listener) {
        this.getShell().addFocusListener(listener);
    }

    public Point computeSizeHint() {
        return this.getShell().getSize();
    }

    public final void dispose() {
        this.filteredTree.dispose();
        this.close();
    }

    public boolean hasContents() {
        return true;
    }

    public boolean isFocusControl() {
        return this.getShell() == Display.getCurrent().getActiveShell();
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.getShell().removeDisposeListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.getShell().removeFocusListener(listener);
    }

    public void setBackgroundColor(Color background) {
        this.applyBackgroundColor(background, this.getContents());
    }

    public void setFocus() {
        this.getShell().forceFocus();
        this.filteredTree.setFocus();
    }

    public void setForegroundColor(Color foreground) {
        this.applyForegroundColor(foreground, this.getContents());
    }

    public void setInformation(String information) {
    }

    public void setInput(Object input) {
        this.treeViewer.setInput(input);
        this.treeViewer.expandToLevel(3);
    }

    public void setLocation(Point location) {
        this.getShell().setLocation(location);
    }

    public void setSize(int width, int height) {
        this.getShell().setSize(width, height);
    }

    public void setSizeConstraints(int maxWidth, int maxHeight) {
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.open();
        } else {
            this.saveDialogBounds(this.getShell());
            this.getShell().setVisible(false);
        }
    }

    public void widgetDisposed(DisposeEvent event) {
        this.filteredTree = null;
        this.treeViewer = null;
    }

    protected Control createDialogArea(Composite parent) {
        this.createTreeViewer(parent);
        this.setInfoText(this.currentPage.getPageDescription());
        this.addDisposeListener(this);
        return this.treeViewer.getControl();
    }

    protected Object getSelectedElement() {
        if (this.treeViewer == null) {
            return null;
        }
        return ((IStructuredSelection)this.treeViewer.getSelection()).getFirstElement();
    }

    private void gotoSelectedElement() {
        Object selectedElement = this.getSelectedElement();
        this.currentPage.getQuickOutlineCallback().select(selectedElement);
        this.dispose();
    }

    protected void createTreeViewer(Composite parent) {
        this.filteredTree = new FilteredTree(parent, 772, new CustomPatternFilter(), true){

            protected void updateToolbar(boolean visible) {
                super.updateToolbar(visible);
                this.treeViewer.expandToLevel(3);
            }

            protected void updateTreeSelection(boolean setFocus) {
                TreeItem root;
                super.updateTreeSelection(setFocus);
                Tree t = this.treeViewer.getTree();
                if (this.getFilterControl().getText().trim().length() == 0 && t.getSelectionCount() == 0 && t.getItemCount() > 0 && (root = t.getItem(0)) != null) {
                    t.setSelection(root);
                }
            }
        };
        this.filteredTree.setQuickSelectionMode(true);
        this.treeViewer = this.filteredTree.getViewer();
        final Tree tree = this.treeViewer.getTree();
        this.filteredTree.getFilterControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                Trigger trigger;
                int accelerator = SWTKeySupport.convertEventToUnmodifiedAccelerator((KeyEvent)event);
                KeySequence keySequence = KeySequence.getInstance((KeyStroke)SWTKeySupport.convertAcceleratorToKeyStroke((int)accelerator));
                if (keySequence.getTriggers().length == 1 && (trigger = keySequence.getTriggers()[0]) instanceof KeyStroke) {
                    KeyStroke keyStroke = (KeyStroke)trigger;
                    IKeyLookup lookup = KeyLookupFactory.getDefault();
                    if (keyStroke.getModifierKeys() == lookup.getCtrl() && keyStroke.getNaturalKey() == 79) {
                        event.doit = false;
                        QuickOutlineControl.this.gotoNextPage();
                    }
                }
                if (event.keyCode == 13) {
                    QuickOutlineControl.this.gotoSelectedElement();
                    return;
                }
                ((IQuickOutlineLabelProvider)QuickOutlineControl.this.treeViewer.getLabelProvider()).clear();
                TreeItem target = null;
                if (event.keyCode == 0x1000002) {
                    target = QuickOutlineControl.this.getTargetDown();
                }
                if (event.keyCode == 0x1000001) {
                    target = QuickOutlineControl.this.getTargetUp();
                }
                if (target != null) {
                    event.doit = false;
                    tree.setSelection(new TreeItem[]{target});
                }
                QuickOutlineControl.this.setFocus();
            }
        });
        tree.addKeyListener((KeyListener)new TreeKeyListener(tree));
        tree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                QuickOutlineControl.this.gotoSelectedElement();
            }
        });
        this.treeViewer.setContentProvider(this.currentPage.getContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.currentPage.getLabelProvider());
    }

    private void gotoNextPage() {
        Optional<QuickOutlinePageDescriptor> newPage = this.descriptor.getNextPage(this.currentPage);
        if (newPage.isPresent() && newPage.get() != this.currentPage) {
            this.currentPage = newPage.get();
            this.treeViewer.setContentProvider(this.currentPage.getContentProvider());
            this.treeViewer.setLabelProvider((IBaseLabelProvider)this.currentPage.getLabelProvider());
            this.setInfoText(this.currentPage.getPageDescription());
        }
    }

    private TreeItem getTargetDown() {
        Object source = this.getSelectedElement();
        CustomPatternFilter filter = (CustomPatternFilter)this.filteredTree.getPatternFilter();
        Tree tree = this.filteredTree.getViewer().getTree();
        ArrayList<TreeItem> matchingItems = filter.getMatchingItems((Viewer)this.filteredTree.getViewer(), tree.getItems(), new ArrayList<TreeItem>());
        if (matchingItems.size() == 0) {
            return null;
        }
        boolean sourceFound = false;
        int i = 0;
        TreeItem target = matchingItems.get(i);
        while (i < matchingItems.size()) {
            if (!sourceFound && matchingItems.get(i).getData().equals(source)) {
                sourceFound = true;
            } else if (sourceFound) {
                target = matchingItems.get(i);
                break;
            }
            ++i;
        }
        return target;
    }

    private TreeItem getTargetUp() {
        Object source = this.getSelectedElement();
        CustomPatternFilter filter = (CustomPatternFilter)this.filteredTree.getPatternFilter();
        Tree tree = this.filteredTree.getViewer().getTree();
        ArrayList<TreeItem> matchingItems = filter.getMatchingItems((Viewer)this.filteredTree.getViewer(), tree.getItems(), new ArrayList<TreeItem>());
        if (matchingItems.size() == 0) {
            return null;
        }
        int i = matchingItems.size() - 1;
        TreeItem target = matchingItems.get(i);
        boolean sourceFound = false;
        while (i >= 0) {
            if (!sourceFound && matchingItems.get(i).getData().equals(source)) {
                sourceFound = true;
            } else if (sourceFound) {
                target = matchingItems.get(i);
                break;
            }
            --i;
        }
        return target;
    }

    protected boolean hasTitleArea() {
        return false;
    }

    private final class CustomPatternFilter
    extends PatternFilter {
        private CustomPatternFilter() {
        }

        protected boolean isLeafMatch(Viewer viewer, Object element) {
            String filterText;
            boolean result = false;
            IQuickOutlineLabelProvider labelProvider = (IQuickOutlineLabelProvider)((StructuredViewer)viewer).getLabelProvider();
            String labelText = labelProvider.getText(element);
            if (labelText != null) {
                result = this.wordMatches(labelText);
            }
            if (!(filterText = QuickOutlineControl.this.filteredTree.getFilterControl().getText()).equals("") && !filterText.equals("*")) {
                EObject eObj = (EObject)element;
                for (EAttribute attribute : eObj.eClass().getEAllAttributes()) {
                    if (attribute.getEAttributeType().getInstanceClass() != String.class || eObj.eGet((EStructuralFeature)attribute) == null) continue;
                    boolean match = this.wordMatches(eObj.eGet((EStructuralFeature)attribute).toString());
                    if (match) {
                        labelProvider.addMatch(eObj, attribute.getName());
                    }
                    boolean bl = result = result || match;
                }
            }
            return result;
        }

        public boolean isElementVisible(Viewer viewer, Object element) {
            return this.isLeafMatch(viewer, element) || this.isParentMatch(viewer, element);
        }

        public ArrayList<TreeItem> getMatchingItems(Viewer viewer, TreeItem[] items, ArrayList<TreeItem> listItems) {
            ArrayList<TreeItem> resultList = listItems;
            TreeItem[] treeItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                Object data = item.getData();
                if (data != null && this.isLeafMatch(viewer, data)) {
                    resultList.add(item);
                }
                resultList = this.getMatchingItems(viewer, item.getItems(), resultList);
                ++n2;
            }
            return resultList;
        }
    }

    private final class TreeKeyListener
    extends KeyAdapter {
        private final Tree tree;

        private TreeKeyListener(Tree tree) {
            this.tree = tree;
        }

        public void keyPressed(KeyEvent event) {
            Trigger trigger;
            int accelerator = SWTKeySupport.convertEventToUnmodifiedAccelerator((KeyEvent)event);
            KeySequence keySequence = KeySequence.getInstance((KeyStroke)SWTKeySupport.convertAcceleratorToKeyStroke((int)accelerator));
            if (keySequence.getTriggers().length == 1 && (trigger = keySequence.getTriggers()[0]) instanceof KeyStroke) {
                KeyStroke keyStroke = (KeyStroke)trigger;
                IKeyLookup lookup = KeyLookupFactory.getDefault();
                if (keyStroke.getModifierKeys() == lookup.getCtrl() && keyStroke.getNaturalKey() == 79) {
                    event.doit = false;
                    QuickOutlineControl.this.gotoNextPage();
                }
            }
            if (event.character == '\u001b') {
                QuickOutlineControl.this.dispose();
            }
            if (event.keyCode == 13) {
                QuickOutlineControl.this.gotoSelectedElement();
                return;
            }
            ((IQuickOutlineLabelProvider)QuickOutlineControl.this.treeViewer.getLabelProvider()).clear();
            TreeItem target = null;
            if (event.keyCode == 0x1000002) {
                target = QuickOutlineControl.this.getTargetDown();
            }
            if (event.keyCode == 0x1000001) {
                target = QuickOutlineControl.this.getTargetUp();
            }
            if (target != null) {
                event.doit = false;
                this.tree.setSelection(new TreeItem[]{target});
            }
            QuickOutlineControl.this.setFocus();
        }
    }
}

