/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.graphviz.layouter;

import com.google.common.collect.Lists;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.elk.alg.graphviz.dot.transform.Command;
import org.eclipse.elk.alg.graphviz.layouter.EclipseRuntimeDetector;
import org.eclipse.elk.alg.graphviz.layouter.GraphvizException;
import org.eclipse.elk.alg.graphviz.layouter.preferences.GraphvizLayouterPreferenceStoreAccess;
import org.eclipse.elk.core.util.Maybe;
import org.eclipse.elk.core.util.WrappedException;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class GraphvizTool {
    public static final String PREF_GRAPHVIZ_EXECUTABLE = "graphviz.executable";
    public static final String PREF_TIMEOUT = "graphviz.timeout";
    public static final int PROCESS_DEF_TIMEOUT = 20000;
    public static final int PROCESS_MIN_TIMEOUT = 200;
    private static final String[] PROGRAM_FILES_FOLDERS = new String[]{"Program Files", "Program Files (x86)", "Programme", "Programme (x86)"};
    private static final List<String> DEFAULT_LOCS = new ArrayList<String>();
    private static final String ARG_COMMAND = "-K";
    private static final String ARG_NOWARNINGS = "-q";
    private static final String ARG_INVERTYAXIS = "-y";
    private Process process;
    private Command command;
    private Watchdog watchdog;
    private InputStream graphvizStream;
    private static final int MAX_ERROR_OUTPUT = 512;
    private static final int PROC_ERROR_TIME = 500;
    private Object nextJob = new Object();

    static {
        String envPath = System.getenv("PATH");
        if (envPath != null) {
            String[] envPaths = envPath.split(File.pathSeparator);
            int i = 0;
            while (i < envPaths.length) {
                if (envPaths[i].trim().length() > 0) {
                    String path = envPaths[i].startsWith("\"") && envPaths[i].endsWith("\"") ? envPaths[i].substring(1, envPaths[i].length() - 1) : envPaths[i];
                    if (path.endsWith(File.separator)) {
                        DEFAULT_LOCS.add(path);
                    } else {
                        DEFAULT_LOCS.add(String.valueOf(path) + File.separator);
                    }
                }
                ++i;
            }
        }
        if (File.separator.equals("/")) {
            DEFAULT_LOCS.add("/opt/local/bin/");
            DEFAULT_LOCS.add("/usr/local/bin/");
            DEFAULT_LOCS.add("/usr/bin/");
        } else if (File.separator.equals("\\")) {
            String[] stringArray = PROGRAM_FILES_FOLDERS;
            int n = PROGRAM_FILES_FOLDERS.length;
            int n2 = 0;
            while (n2 < n) {
                File[] graphvizDirs;
                String programFilesName = stringArray[n2];
                File programFilesFolder = new File("C:\\" + programFilesName);
                if (programFilesFolder.exists() && programFilesFolder.isDirectory() && programFilesFolder.canRead() && (graphvizDirs = programFilesFolder.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.isDirectory() && pathname.canRead() && pathname.getName().toLowerCase().startsWith("graphviz");
                    }
                })) != null) {
                    File[] fileArray = graphvizDirs;
                    int n3 = graphvizDirs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        File graphvizDir = fileArray[n4];
                        DEFAULT_LOCS.add(String.valueOf(graphvizDir.toString()) + File.separator + "bin" + File.separator);
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    public GraphvizTool(Command thecommand) {
        if (thecommand == Command.INVALID) {
            throw new IllegalArgumentException("Invalid Graphviz command.");
        }
        this.command = thecommand;
    }

    public void initialize() {
        this.initialize(null);
    }

    public synchronized void initialize(List<String> arguments) {
        if (this.watchdog == null) {
            this.watchdog = new Watchdog();
            this.watchdog.setName("Graphviz Watchdog");
            this.watchdog.start();
        }
        if (this.process == null) {
            String dotExecutable = GraphvizTool.getDotExecutable();
            ArrayList args = Lists.newArrayList((Object[])new String[]{dotExecutable, ARG_NOWARNINGS, ARG_INVERTYAXIS, ARG_COMMAND + this.command});
            if (arguments != null) {
                args.addAll(arguments);
            }
            try {
                this.process = Runtime.getRuntime().exec(args.toArray(new String[args.size()]));
            }
            catch (IOException exception) {
                throw new WrappedException("Failed to start Graphviz process. Please check your Graphviz installation.", (Throwable)exception);
            }
        }
    }

    public static String getDotExecutable() {
        String executable = GraphvizTool.getDotExecutable(true);
        if (executable == null) {
            throw new RuntimeException("The Dot executable was not found in default paths. Please check your Graphviz installation.");
        }
        return executable;
    }

    public static String getDotExecutable(boolean promptUser) {
        File dotFile;
        String dotExecutable = null;
        if (EclipseRuntimeDetector.isEclipseRunning() && (dotExecutable = GraphvizLayouterPreferenceStoreAccess.getUISaveString(PREF_GRAPHVIZ_EXECUTABLE)) != null && (dotFile = new File(dotExecutable)).exists() && dotFile.canExecute()) {
            return dotExecutable;
        }
        for (String location : DEFAULT_LOCS) {
            dotExecutable = String.valueOf(location) + "dot";
            dotFile = new File(dotExecutable);
            if (dotFile.exists() && dotFile.canExecute()) {
                return dotExecutable;
            }
            dotExecutable = String.valueOf(location) + "dot.exe";
            dotFile = new File(dotExecutable);
            if (!dotFile.exists() || !dotFile.canExecute()) continue;
            return dotExecutable;
        }
        if (promptUser && EclipseRuntimeDetector.isEclipseRunning() && GraphvizTool.handleExecPath() && (dotExecutable = GraphvizLayouterPreferenceStoreAccess.getUISaveString(PREF_GRAPHVIZ_EXECUTABLE)) != null && (dotFile = new File(dotExecutable)).exists() && dotFile.canExecute()) {
            return dotExecutable;
        }
        return null;
    }

    private static boolean handleExecPath() {
        try {
            final Display display = PlatformUI.getWorkbench().getDisplay();
            final Maybe dialogResult = Maybe.create();
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    PreferenceDialog preferenceDialog = PreferencesUtil.createPreferenceDialogOn((Shell)display.getActiveShell(), (String)"org.eclipse.elk.alg.graphviz.preferences", (String[])new String[0], null);
                    dialogResult.set((Object)preferenceDialog.open());
                }
            });
            return (Integer)dialogResult.get() == 0;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return false;
        }
    }

    public OutputStream input() {
        if (this.process != null) {
            return new BufferedOutputStream(this.process.getOutputStream());
        }
        throw new IllegalStateException("Graphviz tool has not been initialized.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream output() {
        if (this.process != null) {
            Object object = this.nextJob;
            synchronized (object) {
                this.graphvizStream = new GraphvizStream(this.process.getInputStream());
                this.nextJob.notify();
            }
            return this.graphvizStream;
        }
        throw new IllegalStateException("Graphviz tool has not been initialized.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void cleanup(Cleanup c) {
        StringBuilder error = null;
        if (this.process != null) {
            InputStream errorStream = this.process.getErrorStream();
            try {
                if (c == Cleanup.ERROR && this.graphvizStream != null) {
                    int exitValue;
                    int ch;
                    Thread.sleep(500L);
                    error = new StringBuilder();
                    do {
                        if ((ch = errorStream.read()) < 0) continue;
                        error.append((char)ch);
                    } while (error.length() < 512 && ch >= 0);
                    if (error.length() == 0 && (exitValue = this.process.exitValue()) != 0) {
                        this.exitValueError(exitValue, error);
                    }
                }
                while (errorStream.available() > 0) {
                    errorStream.read();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (c == Cleanup.ERROR || c == Cleanup.STOP) {
                try {
                    this.process.getOutputStream().close();
                    this.process.getInputStream().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.process.destroy();
                this.process = null;
            }
        }
        if (error == null) {
            Object object = this.nextJob;
            synchronized (object) {
                this.graphvizStream = null;
                if (this.watchdog != null) {
                    this.watchdog.interrupt();
                    if (c == Cleanup.STOP) {
                        this.watchdog = null;
                    }
                }
            }
        } else if (error.length() > 0) {
            throw new GraphvizException("Graphviz error: " + error.toString());
        }
    }

    private void exitValueError(int exitValue, StringBuilder error) {
        error.append("Process terminated with exit value ").append(exitValue);
        if (exitValue > 128) {
            switch (exitValue - 128) {
                case 2: {
                    error.append(" (interrupted)");
                    break;
                }
                case 3: {
                    error.append(" (quit)");
                    break;
                }
                case 4: {
                    error.append(" (illegal instruction)");
                    break;
                }
                case 6: {
                    error.append(" (aborted)");
                    break;
                }
                case 8: {
                    error.append(" (floating point error)");
                    break;
                }
                case 9: {
                    error.append(" (killed)");
                    break;
                }
                case 11: {
                    error.append(" (segmentation fault)");
                    break;
                }
                case 13: {
                    error.append(" (broken pipe)");
                    break;
                }
                case 15: {
                    error.append(" (terminated)");
                }
            }
        }
        error.append('.');
    }

    static /* synthetic */ Object access$0(GraphvizTool graphvizTool) {
        return graphvizTool.nextJob;
    }

    static /* synthetic */ InputStream access$1(GraphvizTool graphvizTool) {
        return graphvizTool.graphvizStream;
    }

    static /* synthetic */ Watchdog access$2(GraphvizTool graphvizTool) {
        return graphvizTool.watchdog;
    }

    static /* synthetic */ Process access$3(GraphvizTool graphvizTool) {
        return graphvizTool.process;
    }

    static /* synthetic */ void access$4(GraphvizTool graphvizTool, InputStream inputStream) {
        graphvizTool.graphvizStream = inputStream;
    }

    public static enum Cleanup {
        NORMAL,
        ERROR,
        STOP;

    }

    private static class GraphvizStream
    extends InputStream {
        private InputStream stream;
        private int depth = 0;
        private int finished = 0;
        private int buf = -1;

        GraphvizStream(InputStream thestream) {
            this.stream = thestream;
        }

        @Override
        public int read() throws IOException {
            if (this.buf >= 0) {
                int c = this.buf;
                this.buf = -1;
                return c;
            }
            if (this.finished > 0 && this.stream.available() == 0) {
                return -1;
            }
            int c = this.stream.read();
            if (c == 123) {
                ++this.depth;
            } else if (c == 125) {
                --this.depth;
                if (this.depth == 0) {
                    ++this.finished;
                }
            } else if (c == 92) {
                this.buf = this.stream.read();
                if (this.buf == 10 || this.buf == 13) {
                    c = this.stream.read();
                    if (this.buf == 13 && c == 10) {
                        c = this.stream.read();
                    }
                    this.buf = -1;
                }
            }
            return c;
        }

        @Override
        public int available() throws IOException {
            return this.stream.available();
        }
    }

    private class Watchdog
    extends Thread {
        private Watchdog() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            do {
                block15: {
                    var1_2 = GraphvizTool.access$0(GraphvizTool.this);
                    synchronized (var1_2) {
                        while (true) lbl-1000:
                        // 3 sources

                        {
                            if (GraphvizTool.access$1(GraphvizTool.this) != null) {
                                break block15;
                            }
                            try {
                                GraphvizTool.access$0(GraphvizTool.this).wait();
                            }
                            catch (InterruptedException ex) {
                                if (GraphvizTool.access$2(GraphvizTool.this) == null) ** break;
                                continue;
                                return;
                            }
                            break;
                        }
                        ** GOTO lbl-1000
                    }
                }
                timeout = 20000;
                if (EclipseRuntimeDetector.isEclipseRunning() && (timeoutPreference = GraphvizLayouterPreferenceStoreAccess.getUISaveInt("graphviz.timeout")) >= 200) {
                    timeout = timeoutPreference;
                }
                interrupted = false;
                try {
                    Thread.sleep(timeout);
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                }
                if (interrupted) continue;
                var3_6 = GraphvizTool.access$0(GraphvizTool.this);
                synchronized (var3_6) {
                    myProcess = GraphvizTool.access$3(GraphvizTool.this);
                    if (myProcess != null) {
                        GraphvizTool.access$4(GraphvizTool.this, null);
                        myProcess.destroy();
                    }
                }
            } while (GraphvizTool.access$2(GraphvizTool.this) != null);
        }
    }
}

