/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.support.api;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.internal.framework.EquinoxBundle;
import org.eclipse.osgi.storage.BundleInfo;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.core.target.LoadTargetDefinitionJob;
import org.eclipse.pde.internal.core.target.TargetPlatformService;
import org.eclipse.sirius.tests.support.api.ICondition;
import org.eclipse.ui.PlatformUI;
import org.junit.Assert;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public final class TestsUtil {
    private static final String UI_WORKBENCH_JUNO_START = "3.103";
    private static final String UI_WORKBENCH_KEPLER_START = "3.105";
    private static final String UI_WORKBENCH_LUNA_START = "3.106";
    private static final String UI_WORKBENCH_OXYGEN_START = "3.110";
    private static final String UI_WORKBENCH_PHOTON_START = "3.111";
    private static final String UI_WORKBENCH_202006_START = "3.119";
    private static final String CREATE_REPRESENTATATION_IN_SEPARATE_RESOURCE = "createLocalRepresentationInSeparateResource";

    protected TestsUtil() {
    }

    public static void emptyEventsFromUIThread() {
        boolean shouldRetry = false;
        do {
            try {
                TestsUtil.synchronizationWithUIThread();
                shouldRetry = false;
            }
            catch (Exception exception) {
                shouldRetry = true;
            }
        } while (shouldRetry);
    }

    public static void synchronizationWithUIThread() {
        while (PlatformUI.getWorkbench().getDisplay().readAndDispatch()) {
        }
    }

    public static boolean shouldSkipLongTests() {
        return "true".equals(System.getProperty("org.eclipse.sirius.tests.skipLongTests"));
    }

    public static boolean isGTK3supported() {
        boolean isGTK3supported = true;
        String stringVersion = System.getProperty("org.eclipse.swt.internal.gtk.version");
        if (stringVersion != null) {
            Version currentVersion = new Version(stringVersion);
            Version minimalRequiredVersion = new Version("3.14.0");
            isGTK3supported = currentVersion.compareTo(minimalRequiredVersion) >= 0;
        }
        return isGTK3supported;
    }

    public static boolean shouldRunUnreliableTests() {
        return !TestsUtil.shouldSkipUnreliableTests();
    }

    public static boolean shouldSkipUnreliableTests() {
        return "true".equals(System.getProperty("org.eclipse.sirius.tests.skipUnreliableTests"));
    }

    public static boolean shouldRunLongTests() {
        return !TestsUtil.shouldSkipLongTests();
    }

    public static boolean isCreateRepresentationInSeparateResource() {
        return Boolean.getBoolean(CREATE_REPRESENTATATION_IN_SEPARATE_RESOURCE);
    }

    public static boolean setCreateRepresentationInSeparateResource(boolean value) {
        String property = System.setProperty(CREATE_REPRESENTATATION_IN_SEPARATE_RESOURCE, String.valueOf(value));
        return Boolean.valueOf(property);
    }

    public static boolean isEEFBasedPropertiesViewsSupportInstalled() {
        return Platform.getBundle((String)"org.eclipse.sirius.ui.properties") != null;
    }

    public static boolean isJuno3Platform() {
        boolean isJuno3Platform = false;
        String platformVersion = (String)Platform.getBundle((String)"org.eclipse.core.runtime").getHeaders().get("Bundle-Version");
        if (platformVersion.startsWith("3.8")) {
            isJuno3Platform = true;
        }
        return isJuno3Platform && !TestsUtil.isJuno4Platform();
    }

    public static boolean isEclipse4xPlatform() {
        Version junoStart = Version.parseVersion((String)UI_WORKBENCH_JUNO_START);
        return TestsUtil.checkUiWorkbenchVersion(junoStart, null);
    }

    public static boolean isJuno4Platform() {
        Version junoStart = Version.parseVersion((String)UI_WORKBENCH_JUNO_START);
        Version keplerStart = Version.parseVersion((String)UI_WORKBENCH_KEPLER_START);
        return TestsUtil.checkUiWorkbenchVersion(junoStart, keplerStart);
    }

    private static boolean checkUiWorkbenchVersion(Version versiontStart, Version versionEnd) {
        Bundle uiWorkbenchBundle = Platform.getBundle((String)"org.eclipse.ui.workbench");
        if (uiWorkbenchBundle != null) {
            return !(versiontStart != null && uiWorkbenchBundle.getVersion().compareTo(versiontStart) < 0 || versionEnd != null && uiWorkbenchBundle.getVersion().compareTo(versionEnd) >= 0);
        }
        return false;
    }

    public static boolean isKeplerPlatform() {
        Version keplerStart = Version.parseVersion((String)UI_WORKBENCH_KEPLER_START);
        Version lunaStart = Version.parseVersion((String)UI_WORKBENCH_LUNA_START);
        return TestsUtil.checkUiWorkbenchVersion(keplerStart, lunaStart);
    }

    public static boolean isLunaPlatform() {
        return TestsUtil.checkUiWorkbenchVersion(Version.parseVersion((String)UI_WORKBENCH_LUNA_START), null);
    }

    public static boolean isBeforeOxygenPlatform() {
        return TestsUtil.checkUiWorkbenchVersion(null, Version.parseVersion((String)UI_WORKBENCH_OXYGEN_START));
    }

    public static boolean isOxygenPlatform() {
        return TestsUtil.checkUiWorkbenchVersion(Version.parseVersion((String)UI_WORKBENCH_OXYGEN_START), null);
    }

    public static boolean isPhotonPlatformOrLater() {
        return TestsUtil.checkUiWorkbenchVersion(Version.parseVersion((String)UI_WORKBENCH_PHOTON_START), null);
    }

    public static boolean is202006Platform() {
        return TestsUtil.checkUiWorkbenchVersion(Version.parseVersion((String)UI_WORKBENCH_202006_START), null);
    }

    public static void waitUntil(ICondition condition, long timeout, long interval) {
        Assert.assertTrue((String)"interval value is negative", (interval >= 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)"timeout value is negative", (timeout >= 0L ? 1 : 0) != 0);
        long limit = System.currentTimeMillis() + timeout;
        while (true) {
            try {
                if (condition.test()) {
                    return;
                }
            }
            catch (Throwable throwable) {}
            try {
                Thread.sleep(interval);
            }
            catch (InterruptedException e) {
                Assert.fail((String)e.getMessage());
            }
            if (System.currentTimeMillis() <= limit) continue;
            Assert.fail((String)("Timeout after: " + timeout + " ms.: " + condition.getFailureMessage()));
        }
    }

    public static void waitUntil(ICondition condition, long timeout) {
        TestsUtil.waitUntil(condition, timeout, 500L);
    }

    public static void waitUntil(ICondition condition) {
        TestsUtil.waitUntil(condition, 5000L, 500L);
    }

    public static void setTargetPlatform(String currentPluginSymbolicName) throws CoreException, InterruptedException {
        String targetName = "PDE Platgorm from OSGi bundles";
        ITargetPlatformService tpService = TargetPlatformService.getDefault();
        ITargetHandle targetHandle = tpService.getWorkspaceTargetHandle();
        if (targetHandle == null || !targetName.equals(targetHandle.getTargetDefinition().getName())) {
            ITargetDefinition targetDef = tpService.newTarget();
            targetDef.setName(targetName);
            Bundle[] bundles = Platform.getBundle((String)"org.eclipse.core.runtime").getBundleContext().getBundles();
            ArrayList<ITargetLocation> bundleContainers = new ArrayList<ITargetLocation>();
            HashSet<File> dirs = new HashSet<File>();
            Bundle[] bundleArray = bundles;
            int n = bundles.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle bundle = bundleArray[n2];
                EquinoxBundle bundleImpl = (EquinoxBundle)bundle;
                BundleInfo.Generation generation = (BundleInfo.Generation)bundleImpl.getModule().getCurrentRevision().getRevisionInfo();
                File file = generation.getBundleFile().getBaseFile();
                File folder = file.getParentFile();
                if (!dirs.contains(folder)) {
                    dirs.add(folder);
                    if (!currentPluginSymbolicName.equals(bundleImpl.getSymbolicName())) {
                        bundleContainers.add(tpService.newDirectoryLocation(folder.getAbsolutePath()));
                    }
                }
                ++n2;
            }
            targetDef.setTargetLocations(bundleContainers.toArray(new ITargetLocation[bundleContainers.size()]));
            targetDef.setArch(Platform.getOSArch());
            targetDef.setOS(Platform.getOS());
            targetDef.setWS(Platform.getWS());
            targetDef.setNL(Platform.getNL());
            tpService.saveTargetDefinition(targetDef);
            LoadTargetDefinitionJob job = new LoadTargetDefinitionJob(targetDef);
            job.schedule();
            job.join();
        }
    }
}

