/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.ui.tools.internal.editor.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.sirius.tree.ui.provider.Messages;
import org.eclipse.sirius.tree.ui.tools.internal.editor.DTreeViewerManager;
import org.eclipse.sirius.tree.ui.tools.internal.editor.actions.AbstractToolAction;
import org.eclipse.sirius.tree.ui.tools.internal.editor.actions.CreateToolItemAction;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class EditorCreateTreeItemMenuAction
extends Action
implements IMenuCreator {
    public static final String ID = "CreateTreeItemMenu";
    private final MenuManager menuManager = new MenuManager();
    private Action lastCreateTreeItemAction;
    private final List<CreateToolItemAction> createTreeItemActionsForTree = new ArrayList<CreateToolItemAction>();
    private final Listener menuItemListener = new Listener(){

        public void handleEvent(Event event) {
            if (13 == event.type && !event.widget.isDisposed()) {
                ActionContributionItem item = (ActionContributionItem)event.widget.getData();
                EditorCreateTreeItemMenuAction.this.setLastAction((CreateToolItemAction)item.getAction());
            }
        }
    };
    private final MenuListener menuListener = new MenuAdapter(){

        public void menuShown(MenuEvent e) {
            MenuItem[] menuItems;
            MenuItem[] menuItemArray = menuItems = EditorCreateTreeItemMenuAction.this.menuManager.getMenu().getItems();
            int n = menuItems.length;
            int n2 = 0;
            while (n2 < n) {
                MenuItem menuItem = menuItemArray[n2];
                if (menuItem.getStyle() != 2) {
                    menuItem.removeListener(13, EditorCreateTreeItemMenuAction.this.menuItemListener);
                    menuItem.addListener(13, EditorCreateTreeItemMenuAction.this.menuItemListener);
                }
                ++n2;
            }
        }
    };

    public EditorCreateTreeItemMenuAction() {
        super(Messages.EditorCreateTreeItemMenuAction_name, DTreeViewerManager.getImageRegistry().getDescriptor("tree/newTreeItem"));
        this.setId(ID);
        this.setMenuCreator(this);
        this.setEnabled(false);
    }

    public void run() {
        if (this.lastCreateTreeItemAction != null && this.lastCreateTreeItemAction.isEnabled()) {
            this.lastCreateTreeItemAction.run();
        }
    }

    public void addActionToMenu(Action action) {
        ActionContributionItem contribution = new ActionContributionItem((IAction)action);
        this.menuManager.add((IContributionItem)contribution);
    }

    public void dispose() {
        if (this.menuManager.getMenu() != null) {
            MenuItem[] menuItems;
            MenuItem[] menuItemArray = menuItems = this.menuManager.getMenu().getItems();
            int n = menuItems.length;
            int n2 = 0;
            while (n2 < n) {
                MenuItem menuItem = menuItemArray[n2];
                if (menuItem.getStyle() != 2) {
                    menuItem.removeListener(13, this.menuItemListener);
                }
                ++n2;
            }
            this.menuManager.getMenu().removeMenuListener(this.menuListener);
            this.menuManager.getMenu().dispose();
        }
        this.menuManager.dispose();
    }

    public Menu getMenu(Control parent) {
        if (this.menuManager.getMenu() == null) {
            this.menuManager.createContextMenu(parent);
            this.menuManager.getMenu().addMenuListener(this.menuListener);
            this.update();
        }
        return this.menuManager.getMenu();
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public void update(List<AbstractToolAction> createActionsForTable) {
        this.getCreateTreeItemActionsForTree().clear();
        for (AbstractToolAction toolAction : createActionsForTable) {
            if (!(toolAction instanceof CreateToolItemAction)) continue;
            this.getCreateTreeItemActionsForTree().add((CreateToolItemAction)toolAction);
        }
        if (!createActionsForTable.isEmpty()) {
            this.setLastAction((CreateToolItemAction)createActionsForTable.get(0));
        }
        this.update();
    }

    protected void update() {
        this.menuManager.removeAll();
        this.setEnabled(!this.createTreeItemActionsForTree.isEmpty());
        if (this.createTreeItemActionsForTree.isEmpty()) {
            this.setText(Messages.EditorCreateTreeItemMenuAction_name);
        } else {
            for (CreateToolItemAction createAction : this.createTreeItemActionsForTree) {
                if (!createAction.canExecute()) continue;
                this.menuManager.add((IAction)createAction);
            }
        }
    }

    public void setLastAction(CreateToolItemAction createLineAction) {
        this.lastCreateTreeItemAction = createLineAction;
        this.setText(this.lastCreateTreeItemAction.getText());
    }

    protected List<CreateToolItemAction> getCreateTreeItemActionsForTree() {
        return this.createTreeItemActionsForTree;
    }
}

