/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p5edges.orthogonal;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.eclipse.elk.alg.layered.DebugUtil;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.PortType;
import org.eclipse.elk.alg.layered.p5edges.orthogonal.AbstractRoutingDirectionStrategy;
import org.eclipse.elk.alg.layered.p5edges.orthogonal.HyperEdgeCycleBreaker;
import org.eclipse.elk.alg.layered.p5edges.orthogonal.HyperEdgeSegment;
import org.eclipse.elk.alg.layered.p5edges.orthogonal.RoutingDirection;
import org.eclipse.elk.alg.layered.p5edges.orthogonal.SegmentDependency;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class OrthogonalRoutingGenerator {
    public static final double TOLERANCE = 0.001;
    private static final double CONFL_THRESH_FACTOR = 0.2;
    private static final int CONFLICT_PENALTY = 16;
    private final AbstractRoutingDirectionStrategy routingStrategy;
    private final double edgeSpacing;
    private final double conflictThreshold;
    private final String debugPrefix;

    public OrthogonalRoutingGenerator(RoutingDirection direction, double edgeSpacing, String debugPrefix) {
        this.routingStrategy = direction.strategy();
        this.edgeSpacing = edgeSpacing;
        this.conflictThreshold = 0.2 * edgeSpacing;
        this.debugPrefix = debugPrefix;
    }

    public int routeEdges(IElkProgressMonitor monitor, LGraph layeredGraph, Iterable<LNode> sourceLayerNodes, int sourceLayerIndex, Iterable<LNode> targetLayerNodes, double startPos) {
        HashMap portToEdgeSegmentMap = Maps.newHashMap();
        ArrayList edgeSegments = Lists.newArrayList();
        this.createHyperEdgeSegments(sourceLayerNodes, this.routingStrategy.getSourcePortSide(), edgeSegments, portToEdgeSegmentMap);
        this.createHyperEdgeSegments(targetLayerNodes, this.routingStrategy.getTargetPortSide(), edgeSegments, portToEdgeSegmentMap);
        int firstIdx = 0;
        while (firstIdx < edgeSegments.size() - 1) {
            HyperEdgeSegment firstSegment = (HyperEdgeSegment)edgeSegments.get(firstIdx);
            int secondIdx = firstIdx + 1;
            while (secondIdx < edgeSegments.size()) {
                HyperEdgeSegment secondSegment = (HyperEdgeSegment)edgeSegments.get(secondIdx);
                OrthogonalRoutingGenerator.createDependency(firstSegment, secondSegment, this.conflictThreshold);
                ++secondIdx;
            }
            ++firstIdx;
        }
        if (this.debugPrefix != null && monitor.isLoggingEnabled()) {
            DebugUtil.logDebugGraph(monitor, layeredGraph, sourceLayerNodes == null ? 0 : sourceLayerIndex + 1, edgeSegments, this.debugPrefix, "full");
        }
        HyperEdgeCycleBreaker.breakCycles(edgeSegments, (Random)layeredGraph.getProperty(InternalProperties.RANDOM));
        if (this.debugPrefix != null && monitor.isLoggingEnabled()) {
            DebugUtil.logDebugGraph(monitor, layeredGraph, sourceLayerNodes == null ? 0 : sourceLayerIndex + 1, edgeSegments, this.debugPrefix, "acyclic");
        }
        OrthogonalRoutingGenerator.topologicalNumbering(edgeSegments);
        int rankCount = -1;
        for (HyperEdgeSegment node : edgeSegments) {
            if (Math.abs(node.getStartPos() - node.getEndPos()) < 0.001) continue;
            rankCount = Math.max(rankCount, node.getRoutingSlot());
            this.routingStrategy.calculateBendPoints(node, startPos, this.edgeSpacing);
        }
        this.routingStrategy.clearCreatedJunctionPoints();
        return rankCount + 1;
    }

    private void createHyperEdgeSegments(Iterable<LNode> nodes, PortSide portSide, List<HyperEdgeSegment> hyperNodes, Map<LPort, HyperEdgeSegment> portToHyperNodeMap) {
        if (nodes != null) {
            for (LNode node : nodes) {
                for (LPort port : node.getPorts(PortType.OUTPUT, portSide)) {
                    HyperEdgeSegment hyperNode = portToHyperNodeMap.get((Object)port);
                    if (hyperNode != null) continue;
                    hyperNode = new HyperEdgeSegment(this.routingStrategy);
                    hyperNodes.add(hyperNode);
                    hyperNode.addPortPositions(port, portToHyperNodeMap);
                }
            }
        }
    }

    private static void createDependency(HyperEdgeSegment hn1, HyperEdgeSegment hn2, double minDiff) {
        int crossings2;
        int depValue2;
        if (Math.abs(hn1.getStartPos() - hn1.getEndPos()) < 0.001 || Math.abs(hn2.getStartPos() - hn2.getEndPos()) < 0.001) {
            return;
        }
        int conflicts1 = OrthogonalRoutingGenerator.countConflicts(hn1.getTargetPosis(), hn2.getSourcePosis(), minDiff);
        int conflicts2 = OrthogonalRoutingGenerator.countConflicts(hn2.getTargetPosis(), hn1.getSourcePosis(), minDiff);
        int crossings1 = OrthogonalRoutingGenerator.countCrossings(hn1.getTargetPosis(), hn2.getStartPos(), hn2.getEndPos()) + OrthogonalRoutingGenerator.countCrossings(hn2.getSourcePosis(), hn1.getStartPos(), hn1.getEndPos());
        int depValue1 = 16 * conflicts1 + crossings1;
        if (depValue1 < (depValue2 = 16 * conflicts2 + (crossings2 = OrthogonalRoutingGenerator.countCrossings(hn2.getTargetPosis(), hn1.getStartPos(), hn1.getEndPos()) + OrthogonalRoutingGenerator.countCrossings(hn1.getSourcePosis(), hn2.getStartPos(), hn2.getEndPos())))) {
            new SegmentDependency(hn1, hn2, depValue2 - depValue1);
        } else if (depValue1 > depValue2) {
            new SegmentDependency(hn2, hn1, depValue1 - depValue2);
        } else if (depValue1 > 0 && depValue2 > 0) {
            new SegmentDependency(hn1, hn2, 0);
            new SegmentDependency(hn2, hn1, 0);
        }
    }

    private static int countConflicts(List<Double> posis1, List<Double> posis2, double minDiff) {
        int conflicts = 0;
        if (!posis1.isEmpty() && !posis2.isEmpty()) {
            Iterator<Double> iter1 = posis1.iterator();
            Iterator<Double> iter2 = posis2.iterator();
            double pos1 = iter1.next();
            double pos2 = iter2.next();
            boolean hasMore = true;
            do {
                if (pos1 > pos2 - minDiff && pos1 < pos2 + minDiff) {
                    ++conflicts;
                }
                if (pos1 <= pos2 && iter1.hasNext()) {
                    pos1 = iter1.next();
                    continue;
                }
                if (pos2 <= pos1 && iter2.hasNext()) {
                    pos2 = iter2.next();
                    continue;
                }
                hasMore = false;
            } while (hasMore);
        }
        return conflicts;
    }

    private static int countCrossings(List<Double> posis, double start, double end) {
        int crossings = 0;
        for (double pos : posis) {
            if (pos > end) break;
            if (!(pos >= start)) continue;
            ++crossings;
        }
        return crossings;
    }

    private static void topologicalNumbering(List<HyperEdgeSegment> nodes) {
        ArrayList sources = Lists.newArrayList();
        ArrayList rightwardTargets = Lists.newArrayList();
        for (HyperEdgeSegment node2 : nodes) {
            node2.setInWeight(node2.getIncomingDependencies().size());
            node2.setOutWeight(node2.getOutgoingDependencies().size());
            if (node2.getInWeight() == 0) {
                sources.add(node2);
            }
            if (node2.getOutWeight() != 0 || node2.getSourcePosis().size() != 0) continue;
            rightwardTargets.add(node2);
        }
        int maxRank = -1;
        while (!sources.isEmpty()) {
            HyperEdgeSegment node3 = (HyperEdgeSegment)sources.remove(0);
            for (SegmentDependency segmentDependency : node3.getOutgoingDependencies()) {
                HyperEdgeSegment target = segmentDependency.getTarget();
                target.setRoutingSlot(Math.max(target.getRoutingSlot(), node3.getRoutingSlot() + 1));
                maxRank = Math.max(maxRank, target.getRoutingSlot());
                target.setInWeight(target.getInWeight() - 1);
                if (target.getInWeight() != 0) continue;
                sources.add(target);
            }
        }
        if (maxRank > -1) {
            for (HyperEdgeSegment node : rightwardTargets) {
                node.setRoutingSlot(maxRank);
            }
            while (!rightwardTargets.isEmpty()) {
                HyperEdgeSegment node;
                node = (HyperEdgeSegment)rightwardTargets.remove(0);
                for (SegmentDependency segmentDependency : node.getIncomingDependencies()) {
                    HyperEdgeSegment source = segmentDependency.getSource();
                    if (source.getSourcePosis().size() > 0) continue;
                    source.setRoutingSlot(Math.min(source.getRoutingSlot(), node.getRoutingSlot() - 1));
                    source.setOutWeight(source.getOutWeight() - 1);
                    if (source.getOutWeight() != 0) continue;
                    rightwardTargets.add(source);
                }
            }
        }
    }
}

