/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.rectpacking.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.elk.graph.ElkNode;

public class BlockRow {
    private double x;
    private double y;
    private double width = 0.0;
    private double height = 0.0;
    private final double nodeNodeSpacing;
    private List<ElkNode> rects = new ArrayList<ElkNode>();

    public BlockRow(double x, double y, double nodeNodeSpacing) {
        this.x = x;
        this.y = y;
        this.nodeNodeSpacing = nodeNodeSpacing;
    }

    public boolean addRectangle(ElkNode rect) {
        this.rects.add(rect);
        rect.setX(this.x + this.width);
        rect.setY(this.y);
        this.height = Math.max(this.height, rect.getHeight() + this.nodeNodeSpacing);
        this.width += rect.getWidth() + this.nodeNodeSpacing;
        return true;
    }

    public void removeRectangle(ElkNode rect, boolean update) {
        this.rects.remove(rect);
        if (update) {
            this.updateRow();
        }
    }

    public void updateRow() {
        double width = 0.0;
        double height = 0.0;
        for (ElkNode rect : this.rects) {
            rect.setX(this.x + width);
            rect.setY(this.y);
            width += rect.getWidth() + this.nodeNodeSpacing;
            height = Math.max(height, rect.getHeight() + this.nodeNodeSpacing);
        }
        this.width = width;
        this.height = height;
    }

    public void expand(double widthForRow, double additionalHeightForRow, int index) {
        double additionalWidthForRect = (widthForRow - this.width) / (double)this.rects.size();
        int i = 0;
        this.height += additionalHeightForRow;
        this.width = widthForRow;
        for (ElkNode rect : this.rects) {
            rect.setX(rect.getX() + (double)i * additionalWidthForRect);
            rect.setY(rect.getY() + (double)index * additionalHeightForRow);
            rect.setWidth(rect.getWidth() + additionalWidthForRect);
            rect.setHeight(this.height - this.nodeNodeSpacing);
            ++i;
        }
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public List<ElkNode> getNodes() {
        return this.rects;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }
}

