/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.part;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.gmf.runtime.common.core.command.FileModificationValidator;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.image.ImageFileFormat;
import org.eclipse.gmf.runtime.diagram.ui.render.clipboard.DiagramGenerator;
import org.eclipse.gmf.runtime.diagram.ui.render.internal.DiagramUIRenderPlugin;
import org.eclipse.gmf.runtime.diagram.ui.render.util.CopyToImageUtil;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.image.ImageExporter;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.SVGImage;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.SVGImageConverter;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.ui.internal.refresh.layout.SiriusCanonicalLayoutHandler;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.preferences.SiriusDiagramUiPreferencesKeys;
import org.eclipse.sirius.diagram.ui.tools.internal.part.OffscreenEditPartFactory;
import org.eclipse.sirius.diagram.ui.tools.internal.render.SiriusDiagramImageGenerator;
import org.eclipse.sirius.diagram.ui.tools.internal.render.SiriusDiagramSVGGenerator;
import org.eclipse.sirius.ui.tools.api.actions.export.SizeTooLargeException;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;

public class DiagramEditPartService
extends CopyToImageUtil {
    private static Class<?> exportToHtmlClass;
    private static Boolean canExportToHtml;
    private boolean exportToHtml;
    private boolean autoScalingEnabled = true;
    private Integer diagramScaleLevel = 100;
    private boolean allowDownScaling = true;
    private double scalingFactor;

    public static boolean canExportToHtml() {
        if (canExportToHtml == null) {
            try {
                exportToHtmlClass = Class.forName("org.eclipse.gmf.runtime.diagram.ui.render.util.CopyToHTMLImageUtil");
                canExportToHtml = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                canExportToHtml = false;
            }
        }
        return canExportToHtml;
    }

    public void arrangeCreatedViews(DiagramEditPart diagramEditPart) {
        SiriusCanonicalLayoutHandler.launchArrangeCommand(diagramEditPart);
    }

    public void exportToHtml() {
        this.exportToHtml = true;
    }

    public DiagramEditPart createDiagramEditPart(Diagram diagram, Shell shell, PreferencesHint preferencesHint) {
        return OffscreenEditPartFactory.getInstance().createDiagramEditPart(diagram, shell, preferencesHint);
    }

    public void setAutoScalingEnabled(boolean autoScalingEnabled) {
        this.autoScalingEnabled = autoScalingEnabled;
    }

    public void setDiagramScaleLevel(Integer theDiagramScaleLevel) {
        this.diagramScaleLevel = theDiagramScaleLevel;
    }

    public void setAllowDownScaling(boolean allowDownScaling) {
        this.allowDownScaling = allowDownScaling;
    }

    public double getScalingFactor() {
        return this.scalingFactor;
    }

    public byte[] copyToImageByteArray(DiagramEditPart diagramEP, List editParts, int maxWidth, int maxHeight, ImageFileFormat format, IProgressMonitor monitor, boolean useMargins) throws CoreException {
        Assert.isNotNull((Object)diagramEP);
        byte[] result = null;
        try {
            Throwable throwable = null;
            Object var10_12 = null;
            try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
                DiagramGenerator gen = this.getDiagramGenerator(diagramEP, format);
                if (editParts == null || editParts.isEmpty()) {
                    editParts = diagramEP.getPrimaryEditParts();
                }
                if (format.equals((Object)ImageFileFormat.SVG) || format.equals((Object)ImageFileFormat.PDF)) {
                    gen.createConstrainedSWTImageDecriptorForParts(editParts, maxWidth, maxHeight, useMargins);
                    monitor.worked(1);
                    this.saveToOutputStream((OutputStream)stream, (SiriusDiagramSVGGenerator)gen, format, monitor);
                } else {
                    org.eclipse.swt.graphics.Image image = gen.createConstrainedSWTImageDecriptorForParts(editParts, maxWidth, maxHeight, useMargins).createImage();
                    monitor.worked(1);
                    this.saveToOutputStream((OutputStream)stream, image, format, monitor);
                    image.dispose();
                }
                result = stream.toByteArray();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.sirius", -1, MessageFormat.format(Messages.DiagramEditPartService_imageExportException, "i/o exception"), (Throwable)e));
        }
        monitor.worked(1);
        return result;
    }

    public DiagramGenerator copyToImage(DiagramEditPart diagramEP, IPath destination, ImageFileFormat format, IProgressMonitor monitor) throws CoreException {
        if (this.exportToHtml && DiagramEditPartService.canExportToHtml()) {
            try {
                CopyToImageUtil copyToHmlUtil = (CopyToImageUtil)exportToHtmlClass.newInstance();
                return copyToHmlUtil.copyToImage(diagramEP, destination, format, monitor);
            }
            catch (InstantiationException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.sirius", -1, MessageFormat.format(Messages.DiagramEditPartService_imageExportException, "InstanciationException"), (Throwable)e));
            }
            catch (IllegalAccessException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.sirius", -1, MessageFormat.format(Messages.DiagramEditPartService_imageExportException, "IllegalAccessException"), (Throwable)e));
            }
            catch (OutOfMemoryError e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.sirius", -1, MessageFormat.format(Messages.DiagramEditPartService_imageExportException, "OutofMemoryError"), (Throwable)e));
            }
        }
        if (this.isTooBig(this.getDiagramGenerator(diagramEP, format), diagramEP, format, 1.0)) {
            String representationName = ((DSemanticDiagram)((Diagram)diagramEP.getModel()).getElement()).getName();
            throw new SizeTooLargeException((IStatus)new Status(4, "org.eclipse.sirius", representationName));
        }
        return super.copyToImage(diagramEP, destination, format, monitor);
    }

    private boolean isTooBig(DiagramGenerator gen, DiagramEditPart diagramEP, ImageFileFormat format, double factor) {
        if (Double.isNaN(factor)) {
            return true;
        }
        List editParts = diagramEP.getPrimaryEditParts();
        Rectangle imageRect = gen.calculateImageRectangle(editParts);
        int maxSize = this.getMaximumTotalSize();
        return (double)imageRect.height * factor * ((double)imageRect.width * factor) > (double)maxSize && format != ImageFileFormat.SVG;
    }

    protected int getMaximumTotalSize() {
        SiriusDiagramUiPreferencesKeys pref = SiriusDiagramUiPreferencesKeys.PREF_MAXIMUM_EXPORT_BUFFER_SIZE;
        if ("win32".equals(SWT.getPlatform())) {
            pref = SiriusDiagramUiPreferencesKeys.PREF_MAXIMUM_EXPORT_BUFFER_SIZE_WINDOWS;
        }
        return DiagramUIPlugin.getPlugin().getPreferenceStore().getInt(pref.name());
    }

    protected double getExportResolutionFactor(DiagramEditPart diagramEP, SiriusDiagramImageGenerator gen) {
        double factor = 1.0;
        if (this.autoScalingEnabled) {
            List editParts = diagramEP.getPrimaryEditParts();
            Rectangle imageRect = gen.calculateImageRectangle(editParts);
            factor = Math.floor(Math.sqrt(Double.valueOf(this.getMaximumTotalSize()) / (double)(imageRect.width * imageRect.height)) * 100.0) / 100.0;
            factor = factor < 1.0 && !this.allowDownScaling ? 1.0 : 1.0 + (factor - 1.0) * (double)this.diagramScaleLevel.intValue() / 100.0;
        }
        return factor;
    }

    protected DiagramGenerator getDiagramGenerator(DiagramEditPart diagramEP, ImageFileFormat format) {
        if (format.equals((Object)ImageFileFormat.SVG) || format.equals((Object)ImageFileFormat.PDF)) {
            return new SiriusDiagramSVGGenerator(diagramEP);
        }
        SiriusDiagramImageGenerator generator = new SiriusDiagramImageGenerator(diagramEP);
        double factor = this.getExportResolutionFactor(diagramEP, generator);
        if (!this.isTooBig((DiagramGenerator)generator, diagramEP, format, factor)) {
            generator.setResolutionScale(factor);
            this.scalingFactor = factor;
        }
        return generator;
    }

    protected void copyToImage(DiagramGenerator gen, List editParts, Rectangle imageRect, IPath destination, ImageFileFormat format, IProgressMonitor monitor) throws CoreException {
        boolean found = false;
        if (format.equals((Object)ImageFileFormat.SVG) || format.equals((Object)ImageFileFormat.PDF)) {
            gen.createSWTImageDescriptorForParts(editParts, imageRect);
            monitor.worked(1);
            this.saveToFile(destination, (SiriusDiagramSVGGenerator)gen, format, monitor);
            found = true;
        } else if (format.equals((Object)ImageFileFormat.PNG)) {
            String exportFormat = "PNG";
            Image image = gen.createAWTImageForParts(editParts, imageRect);
            monitor.worked(1);
            if (image instanceof BufferedImage) {
                ImageExporter.exportToFile((IPath)destination, (BufferedImage)((BufferedImage)image), (String)exportFormat, (IProgressMonitor)monitor, (float)format.getQuality());
                found = true;
            }
        }
        if (!found) {
            org.eclipse.swt.graphics.Image image = null;
            try {
                image = gen.createSWTImageDescriptorForParts(editParts, imageRect).createImage();
                monitor.worked(1);
                this.saveToFile(destination, image, format, monitor);
            }
            finally {
                if (image != null) {
                    image.dispose();
                }
            }
        }
    }

    protected void saveToFile(IPath destination, org.eclipse.swt.graphics.Image image, ImageFileFormat imageFormat, IProgressMonitor monitor) throws CoreException {
        IStatus fileModificationStatus = this.createFile(destination);
        if (!fileModificationStatus.isOK()) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (FileOutputStream stream = new FileOutputStream(destination.toOSString());){
                this.saveToOutputStream((OutputStream)stream, image, imageFormat, monitor);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            SiriusPlugin.getDefault().error(e.getMessage(), (Throwable)e);
            Status status = new Status(4, "exportToFile", 0, e.getMessage(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        this.refreshLocal(destination);
    }

    private void saveToOutputStream(OutputStream stream, org.eclipse.swt.graphics.Image image, ImageFileFormat imageFormat, IProgressMonitor monitor) {
        monitor.worked(1);
        ImageData imageData = image.getImageData();
        if (imageFormat.equals((Object)ImageFileFormat.GIF)) {
            imageData = this.createImageData(image);
        }
        monitor.worked(1);
        ImageLoader imageLoader = new ImageLoader();
        imageLoader.data = new ImageData[]{imageData};
        imageLoader.logicalScreenHeight = image.getBounds().width;
        imageLoader.logicalScreenHeight = image.getBounds().height;
        if (imageFormat.equals((Object)ImageFileFormat.JPG)) {
            imageLoader.compression = 100;
        }
        imageLoader.save(stream, imageFormat.getOrdinal());
        monitor.worked(1);
    }

    protected void saveSVGToFile(IPath destination, SiriusDiagramSVGGenerator generator, IProgressMonitor monitor) throws CoreException {
        this.saveToFile(destination, generator, ImageFileFormat.SVG, monitor);
    }

    protected void saveToFile(IPath destination, SiriusDiagramSVGGenerator generator, ImageFileFormat format, IProgressMonitor monitor) throws CoreException {
        IStatus fileModificationStatus = this.createFile(destination);
        if (!fileModificationStatus.isOK()) {
            return;
        }
        monitor.worked(1);
        try {
            FileOutputStream os = new FileOutputStream(destination.toOSString());
            monitor.worked(1);
            this.saveToOutputStream((OutputStream)os, generator, format == ImageFileFormat.JPEG ? ImageFileFormat.JPG : format, monitor);
            os.close();
            monitor.worked(1);
            this.refreshLocal(destination);
        }
        catch (IOException ex) {
            Log.error((Plugin)DiagramUIRenderPlugin.getInstance(), (int)4, (String)ex.getMessage(), (Throwable)ex);
            Status status = new Status(4, "exportToFile", 0, ex.getMessage(), null);
            throw new CoreException((IStatus)status);
        }
    }

    private void saveToOutputStream(OutputStream stream, SiriusDiagramSVGGenerator generator, ImageFileFormat format, IProgressMonitor monitor) throws CoreException {
        if (format == ImageFileFormat.PDF) {
            SVGImageConverter.exportToPDF((SVGImage)((SVGImage)generator.getRenderedImage()), (OutputStream)stream);
        } else if (format == ImageFileFormat.SVG) {
            generator.stream(stream);
        } else {
            throw new IllegalArgumentException("Unexpected format: " + format.getName());
        }
        monitor.worked(1);
    }

    private IStatus createFile(IPath destination) throws CoreException {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(destination);
        if (file != null && !file.exists()) {
            File osFile = new File(destination.toOSString());
            if (osFile.exists()) {
                file.refreshLocal(0, null);
            } else {
                ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, null);
                ByteArrayInputStream input = new ByteArrayInputStream(new byte[0]);
                file.create((InputStream)input, false, null);
            }
        }
        if (file != null) {
            return FileModificationValidator.approveFileModification((IFile[])new IFile[]{file});
        }
        return Status.OK_STATUS;
    }

    private void refreshLocal(IPath destination) throws CoreException {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(destination);
        if (file != null) {
            file.refreshLocal(0, null);
        }
    }

    private ImageData createImageData(org.eclipse.swt.graphics.Image image) {
        ImageData imageData = image.getImageData();
        if (imageData.depth <= 8) {
            return imageData;
        }
        ImageData newImageData = this.get8BitPaletteImageData(imageData);
        if (newImageData == null) {
            newImageData = this.getWebSafePalletteImageData(imageData);
        }
        return newImageData;
    }

    private ImageData get8BitPaletteImageData(ImageData imageData) {
        PaletteData palette = imageData.palette;
        RGB[] colours = new RGB[256];
        PaletteData newPaletteData = new PaletteData(colours);
        ImageData newImageData = new ImageData(imageData.width, imageData.height, 8, newPaletteData);
        int lastPixel = -1;
        int newPixel = -1;
        int i = 0;
        while (i < imageData.width) {
            int j = 0;
            while (j < imageData.height) {
                int pixel = imageData.getPixel(i, j);
                if (pixel != lastPixel) {
                    lastPixel = pixel;
                    RGB colour = palette.getRGB(pixel);
                    newPixel = 0;
                    while (newPixel < 256) {
                        if (colours[newPixel] == null) {
                            colours[newPixel] = colour;
                            break;
                        }
                        if (colours[newPixel].equals((Object)colour)) break;
                        ++newPixel;
                    }
                    if (newPixel >= 256) {
                        return null;
                    }
                }
                newImageData.setPixel(i, j, newPixel);
                ++j;
            }
            ++i;
        }
        RGB colour = new RGB(0, 0, 0);
        int k = 0;
        while (k < 256) {
            if (colours[k] == null) {
                colours[k] = colour;
            }
            ++k;
        }
        return newImageData;
    }

    private ImageData getWebSafePalletteImageData(ImageData imageData) {
        PaletteData palette = imageData.palette;
        RGB[] webSafePallette = this.getWebSafePallette();
        PaletteData newPaletteData = new PaletteData(webSafePallette);
        ImageData newImageData = new ImageData(imageData.width, imageData.height, 8, newPaletteData);
        int lastPixel = -1;
        int newPixel = -1;
        int i = 0;
        while (i < imageData.width) {
            int j = 0;
            while (j < imageData.height) {
                int pixel = imageData.getPixel(i, j);
                if (pixel != lastPixel) {
                    lastPixel = pixel;
                    RGB colour = palette.getRGB(pixel);
                    RGB webSafeColour = this.getWebSafeColour(colour);
                    newPixel = 0;
                    while (newPixel < 256) {
                        if (webSafePallette[newPixel].equals((Object)webSafeColour)) break;
                        ++newPixel;
                    }
                    Assert.isTrue((newPixel < 216 ? 1 : 0) != 0);
                }
                newImageData.setPixel(i, j, newPixel);
                ++j;
            }
            ++i;
        }
        return newImageData;
    }

    private RGB getWebSafeColour(RGB colour) {
        int red = Math.round((colour.red + 25) / 51) * 51;
        int green = Math.round((colour.green + 25) / 51) * 51;
        int blue = Math.round((colour.blue + 25) / 51) * 51;
        return new RGB(red, green, blue);
    }

    private RGB[] getWebSafePallette() {
        RGB[] colours = new RGB[256];
        int i = 0;
        int red = 0;
        while (red <= 255) {
            int green = 0;
            while (green <= 255) {
                int blue = 0;
                while (blue <= 255) {
                    RGB colour = new RGB(red, green, blue);
                    colours[i++] = colour;
                    blue += 51;
                }
                green += 51;
            }
            red += 51;
        }
        RGB colour = new RGB(0, 0, 0);
        int k = 0;
        while (k < 256) {
            if (colours[k] == null) {
                colours[k] = colour;
            }
            ++k;
        }
        return colours;
    }
}

