/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.metamodel.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreEList;
import org.eclipse.sirius.diagram.business.api.helper.layers.LayerService;
import org.eclipse.sirius.diagram.business.internal.metamodel.description.operations.EdgeMappingImportWrapper;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.ContentLayerHelper;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.LayerHelper;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.AdditionalLayer;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.DescriptionPackage;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.DiagramExtensionDescription;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.EdgeMappingImport;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.diagram.description.NodeMappingImport;

public final class ContentHelper {
    private ContentHelper() {
    }

    public static EList<EdgeMapping> getAllEdgeMappings(DiagramDescription diagramDescription, boolean withoutOptionalLayers) {
        ArrayList<EdgeMapping> result = new ArrayList<EdgeMapping>();
        if (LayerService.withoutLayersMode(diagramDescription)) {
            result.addAll((Collection<EdgeMapping>)diagramDescription.getEdgeMappings());
            Iterator iterMappingImport = diagramDescription.getEdgeMappingImports().iterator();
            while (iterMappingImport.hasNext()) {
                result.add(EdgeMappingImportWrapper.getWrapper((EdgeMappingImport)iterMappingImport.next()));
            }
            for (DiagramElementMapping eObj : diagramDescription.getReusedMappings()) {
                if (!(eObj instanceof EdgeMapping)) continue;
                result.add((EdgeMapping)eObj);
            }
        } else {
            ArrayList<Object> layers = withoutOptionalLayers ? new ArrayList(1) : new ArrayList<AdditionalLayer>((Collection<AdditionalLayer>)diagramDescription.getAdditionalLayers());
            layers.add(diagramDescription.getDefaultLayer());
            for (Layer layer : layers) {
                result.addAll((Collection<EdgeMapping>)ContentLayerHelper.getAllEdgeMappings(layer));
            }
        }
        return new EcoreEList.UnmodifiableEList((InternalEObject)diagramDescription, (EStructuralFeature)DescriptionPackage.eINSTANCE.getDiagramDescription_AllEdgeMappings(), result.size(), result.toArray());
    }

    public static Collection<EdgeMapping> getAllEdgeMappings(DiagramExtensionDescription diagramExtensionDescription) {
        ArrayList<EdgeMapping> result = new ArrayList<EdgeMapping>();
        for (Layer layer : diagramExtensionDescription.getLayers()) {
            result.addAll((Collection<EdgeMapping>)ContentLayerHelper.getAllEdgeMappings(layer));
        }
        return result;
    }

    public static EList<NodeMapping> getAllNodeMappings(DiagramDescription diagramDescription, boolean withoutOptionalLayers) {
        ArrayList<NodeMapping> result = new ArrayList<NodeMapping>();
        if (LayerService.withoutLayersMode(diagramDescription)) {
            result.addAll((Collection<NodeMapping>)diagramDescription.getNodeMappings());
            for (DiagramElementMapping mapping : diagramDescription.getReusedMappings()) {
                if (!(mapping instanceof NodeMapping)) continue;
                result.add((NodeMapping)mapping);
            }
        } else {
            ArrayList<Object> layers = withoutOptionalLayers ? new ArrayList(1) : new ArrayList<AdditionalLayer>((Collection<AdditionalLayer>)diagramDescription.getAdditionalLayers());
            layers.add(diagramDescription.getDefaultLayer());
            for (Layer layer : layers) {
                result.addAll((Collection<NodeMapping>)layer.getNodeMappings());
                for (DiagramElementMapping mapping : ContentLayerHelper.getReuseMappings(layer)) {
                    if (!(mapping instanceof NodeMapping)) continue;
                    result.add((NodeMapping)mapping);
                }
            }
        }
        return new BasicEList(result);
    }

    public static Collection<NodeMapping> getAllNodeMappings(DiagramExtensionDescription diagramExtensionDescription) {
        ArrayList<NodeMapping> result = new ArrayList<NodeMapping>();
        for (Layer layer : diagramExtensionDescription.getLayers()) {
            result.addAll((Collection<NodeMapping>)layer.getNodeMappings());
            for (EObject eObj : ContentLayerHelper.getReuseMappings(layer)) {
                if (!(eObj instanceof NodeMapping)) continue;
                result.add((NodeMapping)eObj);
            }
        }
        return result;
    }

    public static EList<ContainerMapping> getAllContainerMappings(DiagramDescription diagramDescription, boolean withoutOptionalLayers) {
        ArrayList<ContainerMapping> result = new ArrayList<ContainerMapping>();
        if (LayerService.withoutLayersMode(diagramDescription)) {
            result.addAll((Collection<ContainerMapping>)diagramDescription.getContainerMappings());
            for (EObject eObj : diagramDescription.getReusedMappings()) {
                if (!(eObj instanceof ContainerMapping)) continue;
                result.add((ContainerMapping)eObj);
            }
        } else {
            ArrayList<Object> layers = withoutOptionalLayers ? new ArrayList(1) : new ArrayList<AdditionalLayer>((Collection<AdditionalLayer>)diagramDescription.getAdditionalLayers());
            layers.add(diagramDescription.getDefaultLayer());
            for (Layer layer : layers) {
                result.addAll((Collection<ContainerMapping>)layer.getContainerMappings());
                for (EObject eObj : ContentLayerHelper.getReuseMappings(layer)) {
                    if (!(eObj instanceof ContainerMapping)) continue;
                    result.add((ContainerMapping)eObj);
                }
            }
        }
        return new BasicEList(result);
    }

    public static Collection<ContainerMapping> getAllContainerMappings(DiagramExtensionDescription diagramExtensionDescription) {
        ArrayList<ContainerMapping> result = new ArrayList<ContainerMapping>();
        for (Layer layer : diagramExtensionDescription.getLayers()) {
            result.addAll((Collection<ContainerMapping>)layer.getContainerMappings());
            for (EObject eObj : ContentLayerHelper.getReuseMappings(layer)) {
                if (!(eObj instanceof ContainerMapping)) continue;
                result.add((ContainerMapping)eObj);
            }
        }
        return result;
    }

    public static EList<NodeMapping> getAllAvalaibleBorderedNodeMappings(AbstractNodeMapping nodeMapping) {
        List<NodeMapping> result = new ArrayList<NodeMapping>();
        result.addAll((Collection<NodeMapping>)nodeMapping.getBorderedNodeMappings());
        result.addAll((Collection<NodeMapping>)nodeMapping.getReusedBorderedNodeMappings());
        if (!LayerHelper.withoutLayersMode(nodeMapping)) {
            result = ContentHelper.developMappingsInheritance(result);
        }
        return new BasicEList(result);
    }

    private static List<NodeMapping> developMappingsInheritance(List<NodeMapping> mappings) {
        ArrayList<NodeMapping> result = new ArrayList<NodeMapping>(mappings);
        for (NodeMapping mapping : mappings) {
            if (!(mapping instanceof NodeMappingImport)) continue;
            result.addAll(ContentHelper.developMappingInheritance((NodeMappingImport)mapping));
        }
        return result;
    }

    private static List<NodeMapping> developMappingInheritance(NodeMappingImport mappingImport) {
        ArrayList<NodeMapping> result = new ArrayList<NodeMapping>();
        NodeMapping importedMapping = mappingImport.getImportedMapping();
        while (importedMapping != null) {
            result.add(importedMapping);
            importedMapping = importedMapping instanceof NodeMappingImport ? ((NodeMappingImport)importedMapping).getImportedMapping() : null;
        }
        return result;
    }

    public static DiagramDescription getParentDescription(DiagramElementMapping mapping) {
        DiagramDescription result = null;
        EObject current = mapping.eContainer();
        while (current != null && result == null) {
            if (current instanceof DiagramDescription) {
                result = (DiagramDescription)current;
                continue;
            }
            current = current.eContainer();
        }
        return result;
    }
}

