/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.elk;

import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.elk.core.service.LayoutConnectorsService;
import org.eclipse.elk.core.service.LayoutMapping;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.sirius.common.tools.api.util.EclipseUtil;
import org.eclipse.sirius.diagram.elk.DiagramElkPlugin;
import org.eclipse.sirius.diagram.elk.ELKLayoutExtensionCommand;
import org.eclipse.sirius.diagram.elk.ElkDiagramLayoutConnector;
import org.eclipse.sirius.diagram.elk.GmfLayoutCommand;
import org.eclipse.sirius.diagram.elk.IELKLayoutExtension;
import org.eclipse.sirius.diagram.ui.tools.api.layout.LayoutExtender;
import org.eclipse.sirius.diagram.ui.tools.api.layout.provider.DefaultLayoutProvider;
import org.eclipse.sirius.diagram.ui.tools.api.layout.provider.ExtendableLayoutProvider;
import org.eclipse.sirius.viewpoint.DRepresentation;

public class ELKLayoutNodeProvider
extends DefaultLayoutProvider
implements ExtendableLayoutProvider {
    private final LayoutExtender extender = new LayoutExtender((ExtendableLayoutProvider)this);

    public Command layoutEditParts(List selectedObjects, IAdaptable layoutHint) {
        List<IELKLayoutExtension> elkLayoutExtensions = this.getLayoutExtensions();
        DiagramEditPart diagramEditPart = (DiagramEditPart)layoutHint.getAdapter(DiagramEditPart.class);
        Injector injector = LayoutConnectorsService.getInstance().getInjector(null, (Object)selectedObjects);
        ElkDiagramLayoutConnector connector = (ElkDiagramLayoutConnector)injector.getInstance(ElkDiagramLayoutConnector.class);
        connector.setLayoutConfiguration(this.layoutConfiguration);
        LayoutMapping layoutMapping = connector.buildLayoutGraph(diagramEditPart, (Object)selectedObjects);
        if (DiagramElkPlugin.getDefault().isDebugging()) {
            ElkDiagramLayoutConnector.storeResult(layoutMapping.getLayoutGraph(), ((DRepresentation)((Diagram)diagramEditPart.getModel()).getElement()).getName(), "initialState", false);
        }
        elkLayoutExtensions.forEach(e -> e.beforeELKLayout(layoutMapping));
        if (DiagramElkPlugin.getDefault().isDebugging()) {
            ElkDiagramLayoutConnector.storeResult(layoutMapping.getLayoutGraph(), ((DRepresentation)((Diagram)diagramEditPart.getModel()).getElement()).getName(), "beforeELKLayout", false);
        }
        connector.layout(layoutMapping);
        if (DiagramElkPlugin.getDefault().isDebugging()) {
            ElkDiagramLayoutConnector.storeResult(layoutMapping.getLayoutGraph(), ((DRepresentation)((Diagram)diagramEditPart.getModel()).getElement()).getName(), "afterELKLayout", false);
        }
        elkLayoutExtensions.forEach(e -> e.afterELKLayout(layoutMapping));
        if (DiagramElkPlugin.getDefault().isDebugging()) {
            ElkDiagramLayoutConnector.storeResult(layoutMapping.getLayoutGraph(), ((DRepresentation)((Diagram)diagramEditPart.getModel()).getElement()).getName(), "afterExtensionUpdate", false);
        }
        connector.transferLayout(layoutMapping);
        Command gmfLayoutCommand = connector.getApplyCommand(layoutMapping);
        Optional<GmfLayoutCommand> concreteGmfLayoutCommand = this.getConcreteGMFLayoutCommand(gmfLayoutCommand);
        if (concreteGmfLayoutCommand.isPresent()) {
            return gmfLayoutCommand.chain((Command)new ICommandProxy((ICommand)new ELKLayoutExtensionCommand(concreteGmfLayoutCommand.get(), elkLayoutExtensions, layoutMapping)));
        }
        return gmfLayoutCommand;
    }

    private Optional<GmfLayoutCommand> getConcreteGMFLayoutCommand(Command gmfLayoutCommand) {
        return Optional.ofNullable(gmfLayoutCommand).filter(ICommandProxy.class::isInstance).map(c -> ((ICommandProxy)c).getICommand()).filter(GmfLayoutCommand.class::isInstance).map(GmfLayoutCommand.class::cast);
    }

    private List<IELKLayoutExtension> getLayoutExtensions() {
        IConfigurationElement[] config;
        ArrayList<IELKLayoutExtension> layoutExtensions = new ArrayList<IELKLayoutExtension>();
        IConfigurationElement[] iConfigurationElementArray = config = EclipseUtil.getConfigurationElementsFor((String)"org.eclipse.sirius.diagram.elk.layout.extension");
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            try {
                Object contribution = configurationElement.createExecutableExtension("class");
                if (contribution instanceof IELKLayoutExtension) {
                    layoutExtensions.add((IELKLayoutExtension)contribution);
                }
            }
            catch (CoreException coreException) {}
            ++n2;
        }
        return layoutExtensions;
    }

    public boolean handleConnectableListItems() {
        return true;
    }

    public Rectangle provideNodeMetrics(Node node) {
        return null;
    }

    public LayoutExtender getExtender() {
        return this.extender;
    }
}

