/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.swtbot.support.api.condition;

import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeCompartmentEditPart;
import org.eclipse.sirius.tests.swtbot.support.api.editor.SWTBotSiriusDiagramEditor;
import org.eclipse.swtbot.eclipse.gef.finder.widgets.SWTBotGefEditPart;
import org.eclipse.swtbot.swt.finder.waits.DefaultCondition;

public class DragAndDropCondition
extends DefaultCondition {
    private final String dropedElementName;
    private final Class<? extends EditPart> droppedElementClass;
    private final String targetContainerName;
    private final Class<? extends EditPart> targetContainerClass;
    private final SWTBotSiriusDiagramEditor editor;

    public DragAndDropCondition(String dropedElementName, Class<? extends EditPart> droppedElementClass, String targetContainerName, Class<? extends EditPart> targetContainerClass, SWTBotSiriusDiagramEditor editor) {
        this.dropedElementName = dropedElementName;
        this.droppedElementClass = droppedElementClass;
        this.targetContainerName = targetContainerName;
        this.targetContainerClass = targetContainerClass;
        this.editor = editor;
    }

    public String getFailureMessage() {
        return "The dropped element has not been found in the target container";
    }

    public boolean test() throws Exception {
        SWTBotGefEditPart droppedEditPart = this.editor.getEditPart(this.dropedElementName, this.droppedElementClass);
        SWTBotGefEditPart targetEditPart = this.editor.getEditPart(this.targetContainerName, this.targetContainerClass);
        return droppedEditPart != null && droppedEditPart.parent() != null && droppedEditPart.parent().part() instanceof ShapeCompartmentEditPart && droppedEditPart.parent().parent().equals(targetEditPart);
    }
}

