/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.part;

import java.util.Optional;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gef.Disposable;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.ui.services.action.internal.CommonUIServicesActionPlugin;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramActionBarContributor;
import org.eclipse.jface.action.AbstractGroupMarker;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditor;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.action.ConcernComboContributionItem;
import org.eclipse.sirius.diagram.ui.tools.api.action.SiriusActionBarActionContributionItem;
import org.eclipse.sirius.diagram.ui.tools.api.preferences.SiriusDiagramUiPreferencesKeys;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.LaunchBehaviorToolAction;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.SelectHiddenElementsAction;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.TabbarRouterAction;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.delete.DeleteFromDiagramAction;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.delete.DeleteFromModelAction;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.layout.CopyFormatAction;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.layout.PasteFormatAction;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.layout.PasteLayoutAction;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.layout.PasteStyleAction;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.refresh.RefreshDiagramAction;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.style.SetStyleToWorkspaceImageAction;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.visibility.HideDDiagramElementAction;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.visibility.HideDDiagramElementLabelAction;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.visibility.RevealAllElementsAction;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class SiriusDiagramActionBarContributor
extends DiagramActionBarContributor {
    boolean disposed;
    public static final String LAUNCH_BEHAVIOR = Messages.SiriusDiagramActionBarContributor_launchBehavior;
    public static final String REFRESH_DIAGRAM = Messages.SiriusDiagramActionBarContributor_refreshDiagram;
    public static final String HIDE_ELEMENT = Messages.SiriusDiagramActionBarContributor_hideElement;
    public static final String SHOW_ELEMENT = Messages.SiriusDiagramActionBarContributor_showElement;
    public static final String HIDE_LABEL = Messages.SiriusDiagramActionBarContributor_hideLabel;
    public static final String SHOW_LABEL = Messages.RevealOutlineLabelsAction_label;
    public static final String REVEAL_ELEMENTS = Messages.SiriusDiagramActionBarContributor_revealElement;
    public static final String DELETE_FROM_DIAGRAM = Messages.SiriusDiagramActionBarContributor_deleteFromDiagram;
    public static final String DELETE_FROM_MODEL = Messages.SiriusDiagramActionBarContributor_deleteFromModel;

    protected Class<?> getEditorClass() {
        return SiriusDiagramEditor.class;
    }

    protected String getEditorId() {
        return "org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorID";
    }

    protected void buildActions() {
        super.buildActions();
        LaunchBehaviorToolAction action = new LaunchBehaviorToolAction(LAUNCH_BEHAVIOR, DiagramUIPlugin.Implementation.getBundledImageDescriptor("images/Go.gif"));
        this.addAction((IAction)action);
        RefreshDiagramAction refresh = new RefreshDiagramAction(REFRESH_DIAGRAM, DiagramUIPlugin.Implementation.getBundledImageDescriptor("images/refresh.gif"));
        this.addAction((IAction)refresh);
        SetStyleToWorkspaceImageAction setStyleToWorkspaceImageAction = new SetStyleToWorkspaceImageAction();
        this.addAction((IAction)setStyleToWorkspaceImageAction);
        HideDDiagramElementAction hideElementAction = new HideDDiagramElementAction(HIDE_ELEMENT);
        this.addAction((IAction)hideElementAction);
        HideDDiagramElementLabelAction hideElementLabelAction = new HideDDiagramElementLabelAction(HIDE_LABEL);
        this.addAction((IAction)hideElementLabelAction);
        RevealAllElementsAction revealElementsAction = new RevealAllElementsAction(REVEAL_ELEMENTS);
        this.addAction((IAction)revealElementsAction);
        DeleteFromDiagramAction deleteFromDiagramAction = new DeleteFromDiagramAction(DiagramUIMessages.DiagramEditor_Delete_from_Diagram, DELETE_FROM_DIAGRAM, "deleteFromDiagramAction", DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/delete.gif"));
        this.addAction((IAction)deleteFromDiagramAction);
        DeleteFromModelAction deleteFromModelAction = new DeleteFromModelAction(DiagramUIMessages.DiagramEditor_Delete_from_Model, DELETE_FROM_MODEL, "deleteFromModelAction", DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/deleteModel.gif"));
        this.addAction((IAction)deleteFromModelAction);
        CopyFormatAction copyLayoutAction = new CopyFormatAction(this.getPage());
        this.addAction((IAction)copyLayoutAction);
        this.addAction((IAction)TabbarRouterAction.createTreeRouterAction(this.getPage()));
        this.addAction((IAction)TabbarRouterAction.createObliqueRouterAction(this.getPage()));
        this.addAction((IAction)TabbarRouterAction.createRectilinearRouterAction(this.getPage()));
        PasteFormatAction pasteFormatAction = new PasteFormatAction(this.getPage());
        this.addAction((IAction)pasteFormatAction);
        PasteLayoutAction pasteLayoutAction = new PasteLayoutAction(this.getPage());
        this.addAction((IAction)pasteLayoutAction);
        PasteStyleAction pasteStyleAction = new PasteStyleAction(this.getPage());
        this.addAction((IAction)pasteStyleAction);
        SelectHiddenElementsAction selectHiddenElementsAction = new SelectHiddenElementsAction(this.getPage());
        this.addAction((IAction)selectHiddenElementsAction);
    }

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        super.contributeToToolBar(toolBarManager);
        if (this.isOldUIEnabled()) {
            toolBarManager.add(this.getActionRegistry().getAction((Object)REFRESH_DIAGRAM));
            toolBarManager.add((IContributionItem)new Separator());
            toolBarManager.add((IContributionItem)new ConcernComboContributionItem((IPartService)this.getPage(), ""));
            toolBarManager.add(this.getActionRegistry().getAction((Object)LAUNCH_BEHAVIOR));
            toolBarManager.add((IContributionItem)new Separator());
            toolBarManager.add((IContributionItem)new SiriusActionBarActionContributionItem(this.getActionRegistry().getAction((Object)"org.eclipse.sirius.diagram.tools.internal.actions.style"), (IPartService)this.getPage()));
            toolBarManager.add(this.getActionRegistry().getAction((Object)HIDE_ELEMENT));
            toolBarManager.add(this.getActionRegistry().getAction((Object)HIDE_LABEL));
            toolBarManager.add(this.getActionRegistry().getAction((Object)REVEAL_ELEMENTS));
            toolBarManager.add(this.getActionRegistry().getAction((Object)"deleteFromModelAction"));
            toolBarManager.add(this.getActionRegistry().getAction((Object)"copyFormatAction"));
            toolBarManager.add(this.getActionRegistry().getAction((Object)"pasteFormatAction"));
            toolBarManager.add(this.getActionRegistry().getAction((Object)"selectHiddenElementsAction"));
            toolBarManager.add(this.getActionRegistry().getAction((Object)"treeRoutingStyleAction"));
            toolBarManager.add(this.getActionRegistry().getAction((Object)"obliqueRoutingStyleAction"));
            toolBarManager.add(this.getActionRegistry().getAction((Object)"rectilinearRoutingStyleAction"));
        }
    }

    public void init(IActionBars bars) {
        this.disableActionBarUIUpdates();
        try {
            super.init(bars);
            IToolBarManager toolBarManager = bars.getToolBarManager();
            toolBarManager.remove("compartmentMenu");
            toolBarManager.remove("allCompartmentsAction");
            toolBarManager.remove("noCompartmentsAction");
            toolBarManager.remove("hideConnectorLabels");
            toolBarManager.remove("showConnectorLabels");
            toolBarManager.remove("showCompartmentTitle");
            if (!this.isOldUIEnabled()) {
                this.cleanOldToolBarGMFAction(toolBarManager, "fontNameContributionItem");
                this.cleanOldToolBarGMFAction(toolBarManager, "fontColorContributionItem");
                this.cleanOldToolBarGMFAction(toolBarManager, "fontSizeContributionItem");
                this.cleanOldToolBarGMFAction(toolBarManager, "fontItalicAction");
                this.cleanOldToolBarGMFAction(toolBarManager, "fontBoldAction");
                this.cleanOldToolBarGMFAction(toolBarManager, "fillColorContributionItem");
                this.cleanOldToolBarGMFAction(toolBarManager, "lineColorContributionItem");
                this.cleanOldToolBarGMFAction(toolBarManager, "makeSameSizeBothAction");
                this.cleanOldToolBarGMFAction(toolBarManager, "autoSizeAction");
                this.cleanOldToolBarGMFAction(toolBarManager, "copyAppearancePropertiesAction");
                this.removeExistingItem("toolbarSelectAllShapesAction", "/selectMenu", (IContributionManager)bars.getToolBarManager(), false).ifPresent(contributionItem -> this.disposeIfPossible((IContributionItem)contributionItem));
                this.removeExistingItem(ActionFactory.SELECT_ALL.getId(), "/diagramMenu/selectMenu", (IContributionManager)bars.getMenuManager(), true).ifPresent(contributionItem -> this.disposeIfPossible((IContributionItem)contributionItem));
                this.removeExistingItem("selectAllShapesAction", "/diagramMenu/selectMenu", (IContributionManager)bars.getMenuManager(), true).ifPresent(contributionItem -> this.disposeIfPossible((IContributionItem)contributionItem));
                this.removeExistingItem("toolbarSelectAllConnectorsAction", "/selectMenu", (IContributionManager)bars.getToolBarManager(), false).ifPresent(contributionItem -> this.disposeIfPossible((IContributionItem)contributionItem));
                this.removeExistingItem("selectAllConnectorsAction", "/diagramMenu/selectMenu", (IContributionManager)bars.getMenuManager(), true).ifPresent(contributionItem -> this.disposeIfPossible((IContributionItem)contributionItem));
                this.removeExistingItem("toolbarSelectAllAction", "/selectMenu", (IContributionManager)bars.getToolBarManager(), false).ifPresent(contributionItem -> this.disposeIfPossible((IContributionItem)contributionItem));
                this.cleanOldToolBarGMFAction(toolBarManager, "zoomContributionItem");
                this.cleanOldToolBarGMFAction(toolBarManager, "arrangeMenu");
                this.cleanOldToolBarGMFAction(toolBarManager, "arrangeAllAction");
                this.cleanOldToolBarGMFAction(toolBarManager, "arrangeSelectionAction");
                this.cleanOldToolBarGMFAction(toolBarManager, "arrangeMenuToolbar");
                this.cleanOldToolBarGMFAction(toolBarManager, "toolbarArrangeAllAction");
                this.cleanOldToolBarGMFAction(toolBarManager, "toolbarArrangeSelectionAction");
                this.cleanOldToolBarGMFAction(toolBarManager, "selectMenu");
                this.cleanOldToolBarGMFAction(toolBarManager, "selectAllConnectorsAction");
                this.cleanOldToolBarGMFAction(toolBarManager, "selectAllShapesAction");
                this.cleanOldToolBarGMFAction(toolBarManager, "selectMenuToolbar");
                this.cleanOldToolBarGMFAction(toolBarManager, "toolbarSelectAllShapesAction");
                this.cleanOldToolBarGMFAction(toolBarManager, "toolbarSelectAllConnectorsAction");
                this.cleanOldToolBarGMFAction(toolBarManager, "toolbarSelectAllAction");
                this.cleanOldToolBarGMFAction(toolBarManager, "alignMenu");
                this.cleanOldToolBarGMFAction(toolBarManager, "alignBottomAction");
                this.cleanOldToolBarGMFAction(toolBarManager, "alignCenterAction");
                this.cleanOldToolBarGMFAction(toolBarManager, "alignLeftAction");
                this.cleanOldToolBarGMFAction(toolBarManager, "alignMiddleAction");
                this.cleanOldToolBarGMFAction(toolBarManager, "alignRightAction");
                this.cleanOldToolBarGMFAction(toolBarManager, "alignTopAction");
                this.cleanOldToolBarGMFAction(toolBarManager, "routerMenu");
                this.cleanOldToolBarGMFAction(toolBarManager, "obliqueRouterAction");
                this.cleanOldToolBarGMFAction(toolBarManager, "rectilinearRouterAction");
                this.cleanOldToolBarGMFAction(toolBarManager, "treeRouterAction");
            } else {
                Bundle uiWorkbenchBundle = Platform.getBundle((String)"org.eclipse.ui.workbench");
                Version junoStart = Version.parseVersion((String)"3.103");
                if (uiWorkbenchBundle != null && uiWorkbenchBundle.getVersion().compareTo(junoStart) < 0) {
                    IContributionItem arrange = toolBarManager.find("arrangeMenu");
                    IContributionItem diagram = toolBarManager.find(REFRESH_DIAGRAM);
                    if (arrange != null && diagram != null) {
                        toolBarManager.remove(arrange);
                        toolBarManager.insertBefore(REFRESH_DIAGRAM, arrange);
                        IContributionItem select = toolBarManager.find("selectMenu");
                        if (select != null) {
                            toolBarManager.remove(select);
                            toolBarManager.insertAfter("arrangeMenu", select);
                            IContributionItem align = toolBarManager.find("alignMenu");
                            if (align != null) {
                                toolBarManager.remove(align);
                                toolBarManager.insertAfter("selectMenu", align);
                                toolBarManager.insertAfter("alignMenu", (IContributionItem)new Separator());
                            }
                        }
                    }
                    IContributionItem setStyleItem = toolBarManager.find("org.eclipse.sirius.diagram.tools.internal.actions.style");
                    IContributionItem copyApparenceItem = toolBarManager.find("copyAppearancePropertiesAction");
                    if (setStyleItem != null && copyApparenceItem != null) {
                        toolBarManager.remove(setStyleItem);
                        toolBarManager.insertBefore("copyAppearancePropertiesAction", setStyleItem);
                    }
                    IContributionItem zoom = toolBarManager.find("zoomContributionItem");
                    IContributionItem launchBehavior = toolBarManager.find(LAUNCH_BEHAVIOR);
                    if (zoom != null && launchBehavior != null) {
                        toolBarManager.remove(zoom);
                        toolBarManager.insertAfter(LAUNCH_BEHAVIOR, zoom);
                    }
                }
            }
        }
        finally {
            this.reenableActionBarUIUpdates();
        }
    }

    private void disableActionBarUIUpdates() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window instanceof WorkbenchWindow) {
            ((WorkbenchWindow)window).largeUpdateStart();
        }
    }

    private void reenableActionBarUIUpdates() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window instanceof WorkbenchWindow) {
            ((WorkbenchWindow)window).largeUpdateEnd();
        }
    }

    private void cleanOldToolBarGMFAction(IToolBarManager toolBarManager, String actionId) {
        IContributionItem contribution = toolBarManager.find(actionId);
        this.disposeIfPossible(contribution);
        toolBarManager.remove(contribution);
    }

    private void disposeIfPossible(IContributionItem contribution) {
        if (contribution instanceof ActionContributionItem) {
            if (((ActionContributionItem)contribution).getAction() instanceof Disposable) {
                ((Disposable)((ActionContributionItem)contribution).getAction()).dispose();
            }
        } else if (contribution instanceof SubContributionItem) {
            this.disposeIfPossible(((SubContributionItem)contribution).getInnerItem());
        }
    }

    private Optional<IContributionItem> removeExistingItem(String id, String path, IContributionManager contributionManager, boolean useIdForRemoval) {
        if (id == null) {
            return Optional.empty();
        }
        IContributionManager parent = contributionManager;
        if (path.length() > 1 && (parent = this.findMenuUsingPath(contributionManager, path.substring(1))) == null) {
            Log.info((Plugin)CommonUIServicesActionPlugin.getDefault(), (int)4, (String)"The contribution item path is invalid");
            return Optional.empty();
        }
        IContributionItem predefinedItem = parent.find(id);
        if (predefinedItem == null) {
            Log.info((Plugin)CommonUIServicesActionPlugin.getDefault(), (int)4, (String)"The contribution item path is invalid");
            return Optional.empty();
        }
        if (predefinedItem instanceof AbstractGroupMarker) {
            IContributionItem[] allItems = parent.getItems();
            int groupIndex = 0;
            while (groupIndex < allItems.length) {
                IContributionItem item = allItems[groupIndex];
                if (item.equals(predefinedItem)) break;
                ++groupIndex;
            }
            int j = groupIndex + 1;
            while (j < allItems.length) {
                IContributionItem item = allItems[j];
                if (item instanceof AbstractGroupMarker) break;
                parent.remove(item);
                ++j;
            }
        }
        if (useIdForRemoval) {
            return Optional.of(parent.remove(predefinedItem.getId()));
        }
        return Optional.of(parent.remove(predefinedItem));
    }

    private IMenuManager findMenuUsingPath(IContributionManager parent, String path) {
        IContributionItem item = null;
        String id = path;
        String rest = null;
        int separator = path.indexOf(47);
        if (separator != -1) {
            id = path.substring(0, separator);
            rest = path.substring(separator + 1);
        } else {
            item = parent.find(path);
            if (item instanceof IMenuManager) {
                return (IMenuManager)item;
            }
        }
        item = parent.find(id);
        if (item instanceof IMenuManager) {
            IMenuManager manager = (IMenuManager)item;
            return manager.findMenuUsingPath(rest);
        }
        return null;
    }

    private boolean isOldUIEnabled() {
        return Platform.getPreferencesService().getBoolean("org.eclipse.sirius.diagram.ui", SiriusDiagramUiPreferencesKeys.PREF_OLD_UI.name(), false, null);
    }

    public void dispose() {
        if (!this.disposed) {
            this.disposed = true;
            super.dispose();
        }
    }
}

