/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.figure;

import com.google.common.base.Preconditions;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.ui.business.internal.query.EdgeTargetQuery;
import org.eclipse.sirius.diagram.ui.edit.api.part.IAbstractDiagramNodeEditPart;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.tools.internal.commands.ToggleFoldingStateCommand;
import org.eclipse.sirius.ext.draw2d.figure.ActionTriggerImageFigure;
import org.eclipse.swt.graphics.Image;

public class FoldingToggleImageFigure
extends ActionTriggerImageFigure {
    protected static final int FOLD_ICON_WIDTH = 9;
    protected static final int FOLD_ICON_HEIGHT = 9;
    private static final Image MINUS_IMAGE = DiagramUIPlugin.getPlugin().getImage(DiagramUIPlugin.Implementation.getBundledImageDescriptor("/icons/collapse.gif"));
    private static final Image PLUS_IMAGE = DiagramUIPlugin.getPlugin().getImage(DiagramUIPlugin.Implementation.getBundledImageDescriptor("/icons/expand.gif"));
    private final IAbstractDiagramNodeEditPart part;

    public FoldingToggleImageFigure(IAbstractDiagramNodeEditPart part) {
        this.part = (IAbstractDiagramNodeEditPart)Preconditions.checkNotNull((Object)part);
        this.setSize(new Dimension(9, 9));
        this.show(null);
        DDiagramElement element = part.resolveDiagramElement();
        if (element instanceof EdgeTarget) {
            this.updateImage();
        }
    }

    public void paint(Graphics graphics) {
        this.updateImage();
        super.paint(graphics);
    }

    public void trigger() {
        DDiagramElement element = this.part.resolveDiagramElement();
        if (element instanceof EdgeTarget) {
            TransactionalEditingDomain domain = this.part.getEditingDomain();
            domain.getCommandStack().execute((Command)new ToggleFoldingStateCommand(domain, this.part));
            this.updateImage();
        }
    }

    private void updateImage() {
        DDiagramElement element;
        if (this.part.isActive() && (element = this.part.resolveDiagramElement()) instanceof EdgeTarget) {
            EdgeTargetQuery query = new EdgeTargetQuery((EdgeTarget)element);
            if (!query.isFoldingPoint()) {
                this.show(null);
            } else {
                switch (query.getFoldingState()) {
                    case FOLDED: {
                        this.show(PLUS_IMAGE);
                        break;
                    }
                    default: {
                        this.show(MINUS_IMAGE);
                    }
                }
            }
        }
    }

    private void show(Image img) {
        this.setImageWOFocus(img);
        this.setImageWFocus(img);
        if (img == null) {
            this.setSize(0, 0);
        } else {
            this.setSize(9, 9);
        }
    }
}

