/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.actions.pinning;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.Disposable;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.tools.api.layout.PinHelper;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramEdgeEditPart;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractPinUnpinElementsEclipseAction
extends Action
implements IObjectActionDelegate,
Disposable {
    private static final Class<?>[] EXCEPTIONS = new Class[]{IDiagramEdgeEditPart.class};
    private ISelection sel;

    public AbstractPinUnpinElementsEclipseAction(String text, String actionId, String toolTipText, String iconPath) {
        super(text, DiagramUIPlugin.Implementation.getBundledImageDescriptor(iconPath));
        this.setId(actionId);
        this.setToolTipText(toolTipText);
    }

    private Collection<DDiagramElement> getSelectedDiagramElements(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            UnmodifiableIterator iter = Iterators.filter((Iterator)((IStructuredSelection)selection).iterator(), IGraphicalEditPart.class);
            ArrayList<DDiagramElement> elements = new ArrayList<DDiagramElement>();
            while (iter.hasNext()) {
                EObject semanticElement;
                IGraphicalEditPart part = (IGraphicalEditPart)iter.next();
                if (!this.keepElement(part) || !((semanticElement = part.resolveSemanticElement()) instanceof DDiagramElement)) continue;
                elements.add((DDiagramElement)semanticElement);
            }
            return elements;
        }
        return Collections.emptyList();
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        Collection<DDiagramElement> elements = this.getSelectedDiagramElements(this.sel);
        if (!elements.isEmpty()) {
            Command cmd = this.createCommand(elements);
            TransactionUtil.getEditingDomain((EObject)((EObject)elements.iterator().next())).getCommandStack().execute(cmd);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.sel = selection;
    }

    protected abstract Command createCommand(Collection<DDiagramElement> var1);

    public void run() {
        this.sel = this.getCurrentSelection();
        this.run((IAction)this);
    }

    private ISelection getCurrentSelection() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (page != null) {
            return page.getSelection();
        }
        return new StructuredSelection();
    }

    protected abstract boolean doIsEnabled(Collection<DDiagramElement> var1);

    public final boolean isEnabled() {
        Predicate<DDiagramElement> pred;
        Collection<DDiagramElement> selectedDiagramElements = this.getSelectedDiagramElements(this.getCurrentSelection());
        if (!selectedDiagramElements.isEmpty() && Iterables.all(selectedDiagramElements, (Predicate)(pred = new Predicate<DDiagramElement>(){

            public boolean apply(DDiagramElement input) {
                return PinHelper.allowsPinUnpin((DDiagramElement)input);
            }
        }))) {
            return this.doIsEnabled(selectedDiagramElements);
        }
        return false;
    }

    private boolean keepElement(IGraphicalEditPart editPart) {
        boolean result = true;
        int i = 0;
        while (i < EXCEPTIONS.length && result) {
            result = !EXCEPTIONS[i].isAssignableFrom(editPart.getClass());
            ++i;
        }
        return result;
    }

    public void dispose() {
        this.sel = null;
    }
}

