/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.services.diagram.internal.converter;

import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.EdgeArrows;
import org.eclipse.sirius.diagram.EdgeStyle;
import org.eclipse.sirius.services.diagram.api.entities.AbstractSiriusDiagramElement;
import org.eclipse.sirius.services.diagram.api.entities.SiriusDiagramEdge;
import org.eclipse.sirius.services.diagram.api.entities.SiriusDiagramEdgeArrowStyle;
import org.eclipse.sirius.services.diagram.api.entities.SiriusDiagramEdgeLineStyle;
import org.eclipse.sirius.services.diagram.api.entities.SiriusDiagramLabel;
import org.eclipse.sirius.services.diagram.api.entities.SiriusDiagramRGBColor;
import org.eclipse.sirius.services.diagram.internal.converter.ISiriusDiagramElementConverter;
import org.eclipse.sirius.services.diagram.internal.converter.SiriusDiagramColorConverter;
import org.eclipse.sirius.viewpoint.BasicLabelStyle;

public class SiriusDiagramEdgeConverter
implements ISiriusDiagramElementConverter {
    private DEdge dEdge;

    public SiriusDiagramEdgeConverter(DEdge dEdge) {
        this.dEdge = dEdge;
    }

    @Override
    public Optional<AbstractSiriusDiagramElement> convert() {
        Optional<EdgeStyle> optionalStyle = Optional.of(this.dEdge.getStyle()).filter(EdgeStyle.class::isInstance).map(EdgeStyle.class::cast);
        return optionalStyle.map(style -> {
            String identifier = this.getIdentifier();
            return SiriusDiagramEdge.newEdge(identifier, this.getSourceId(), this.getTargetId()).color(this.getColor((EdgeStyle)style)).size(this.getSize((EdgeStyle)style)).lineStyle(this.getLineStyle((EdgeStyle)style)).sourceArrowStyle(this.getArrowStyle(style.getSourceArrow())).targetArrowStyle(this.getArrowStyle(style.getTargetArrow())).label(this.getLabel(identifier, (BasicLabelStyle)style.getCenterLabelStyle())).build();
        });
    }

    private String getIdentifier() {
        return EcoreUtil.getURI((EObject)this.dEdge).toString();
    }

    private String getSourceId() {
        return EcoreUtil.getURI((EObject)this.dEdge.getSourceNode()).toString();
    }

    private String getTargetId() {
        return EcoreUtil.getURI((EObject)this.dEdge.getTargetNode()).toString();
    }

    private SiriusDiagramRGBColor getColor(EdgeStyle style) {
        return SiriusDiagramColorConverter.convert(style.getStrokeColor());
    }

    private int getSize(EdgeStyle style) {
        return Optional.ofNullable(style.getSize()).orElse(1);
    }

    private SiriusDiagramLabel getLabel(String identifier, BasicLabelStyle style) {
        SiriusDiagramRGBColor labelColor = SiriusDiagramColorConverter.convert(style.getLabelColor());
        return new SiriusDiagramLabel(String.valueOf(identifier) + "__label", this.dEdge.getName(), labelColor);
    }

    private SiriusDiagramEdgeLineStyle getLineStyle(EdgeStyle style) {
        SiriusDiagramEdgeLineStyle diagramEdgeLineStyle = SiriusDiagramEdgeLineStyle.SOLID;
        switch (style.getLineStyle()) {
            case SOLID_LITERAL: {
                diagramEdgeLineStyle = SiriusDiagramEdgeLineStyle.SOLID;
                break;
            }
            case DASH_DOT_LITERAL: {
                diagramEdgeLineStyle = SiriusDiagramEdgeLineStyle.DASH_DOT;
                break;
            }
            case DASH_LITERAL: {
                diagramEdgeLineStyle = SiriusDiagramEdgeLineStyle.DASH;
                break;
            }
            case DOT_LITERAL: {
                diagramEdgeLineStyle = SiriusDiagramEdgeLineStyle.DOT;
                break;
            }
        }
        return diagramEdgeLineStyle;
    }

    private SiriusDiagramEdgeArrowStyle getArrowStyle(EdgeArrows arrowStyle) {
        SiriusDiagramEdgeArrowStyle diagramEdgeArrowStyle = SiriusDiagramEdgeArrowStyle.NO_DECORATION;
        switch (arrowStyle) {
            case DIAMOND_LITERAL: {
                diagramEdgeArrowStyle = SiriusDiagramEdgeArrowStyle.DIAMOND;
                break;
            }
            case FILL_DIAMOND_LITERAL: {
                diagramEdgeArrowStyle = SiriusDiagramEdgeArrowStyle.FILL_DIAMOND;
                break;
            }
            case INPUT_ARROW_LITERAL: {
                diagramEdgeArrowStyle = SiriusDiagramEdgeArrowStyle.INPUT_ARROW;
                break;
            }
            case INPUT_ARROW_WITH_DIAMOND_LITERAL: {
                diagramEdgeArrowStyle = SiriusDiagramEdgeArrowStyle.INPUT_ARROW_WITH_DIAMOND;
                break;
            }
            case INPUT_ARROW_WITH_FILL_DIAMOND_LITERAL: {
                diagramEdgeArrowStyle = SiriusDiagramEdgeArrowStyle.INPUT_ARROW_WITH_FILL_DIAMOND;
                break;
            }
            case INPUT_CLOSED_ARROW_LITERAL: {
                diagramEdgeArrowStyle = SiriusDiagramEdgeArrowStyle.INPUT_CLOSED_ARROW;
                break;
            }
            case INPUT_FILL_CLOSED_ARROW_LITERAL: {
                diagramEdgeArrowStyle = SiriusDiagramEdgeArrowStyle.INPUT_FILL_CLOSED_ARROW;
                break;
            }
            case NO_DECORATION_LITERAL: {
                diagramEdgeArrowStyle = SiriusDiagramEdgeArrowStyle.NO_DECORATION;
                break;
            }
            case OUTPUT_ARROW_LITERAL: {
                diagramEdgeArrowStyle = SiriusDiagramEdgeArrowStyle.OUTPUT_ARROW;
                break;
            }
            case OUTPUT_CLOSED_ARROW_LITERAL: {
                diagramEdgeArrowStyle = SiriusDiagramEdgeArrowStyle.OUTPUT_CLOSED_ARROW;
                break;
            }
            case OUTPUT_FILL_CLOSED_ARROW_LITERAL: {
                diagramEdgeArrowStyle = SiriusDiagramEdgeArrowStyle.OUTPUT_FILL_CLOSED_ARROW;
                break;
            }
        }
        return diagramEdgeArrowStyle;
    }
}

