/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.services.diagram.internal.converter;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.BorderedStyle;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.Square;
import org.eclipse.sirius.services.diagram.api.entities.AbstractSiriusDiagramElement;
import org.eclipse.sirius.services.diagram.api.entities.SiriusDiagramRGBColor;
import org.eclipse.sirius.services.diagram.api.entities.SiriusDiagramSquareNode;
import org.eclipse.sirius.services.diagram.internal.converter.AbstractSiriusDiagramNodeConverter;
import org.eclipse.sirius.services.diagram.internal.converter.ISiriusDiagramElementConverter;
import org.eclipse.sirius.services.diagram.internal.converter.SiriusDiagramColorConverter;
import org.eclipse.sirius.services.diagram.internal.converter.SiriusDiagramElementSwitch;
import org.eclipse.sirius.viewpoint.BasicLabelStyle;

public class SiriusDiagramSquareNodeConverter
extends AbstractSiriusDiagramNodeConverter {
    private AbstractDNode abstractDNode;

    public SiriusDiagramSquareNodeConverter(AbstractDNode abstractDNode) {
        this.abstractDNode = abstractDNode;
    }

    @Override
    protected AbstractDNode getDNode() {
        return this.abstractDNode;
    }

    @Override
    public Optional<AbstractSiriusDiagramElement> convert() {
        Optional<Square> optionalStyle = Optional.of(this.abstractDNode.getStyle()).filter(Square.class::isInstance).map(Square.class::cast);
        return optionalStyle.map(style -> {
            String identifier = this.getIdentifier();
            return SiriusDiagramSquareNode.newSquareNode(identifier, this.getSemanticElementIdentifier()).color(this.getColor((Square)style)).bordercolor(this.getBorderColor((BorderedStyle)style)).borderSize(this.getBorderSize((BorderedStyle)style)).label(this.getLabel(identifier, (BasicLabelStyle)style)).imagePath(this.getImagePath()).ports(this.getPorts()).withChildren(this.getChildren()).build();
        });
    }

    private SiriusDiagramRGBColor getColor(Square style) {
        return SiriusDiagramColorConverter.convert(style.getColor());
    }

    private List<AbstractSiriusDiagramElement> getChildren() {
        List ownedElements = (List)Optional.of(this.abstractDNode).filter(DNodeContainer.class::isInstance).map(DNodeContainer.class::cast).map(DNodeContainer::getOwnedDiagramElements).orElseGet(BasicEList::new);
        return ownedElements.stream().filter(DDiagramElement::isVisible).map(new SiriusDiagramElementSwitch()::doSwitch).map(ISiriusDiagramElementConverter::convert).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }
}

