/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.elk;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.elk.core.data.LayoutAlgorithmData;
import org.eclipse.elk.core.data.LayoutMetaDataService;
import org.eclipse.elk.core.data.LayoutOptionData;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.sirius.diagram.description.LayoutOption;
import org.eclipse.sirius.diagram.description.LayoutOptionTarget;
import org.eclipse.sirius.diagram.elk.ELKLayoutNodeProvider;
import org.eclipse.sirius.diagram.ui.api.layout.CustomLayoutAlgorithm;
import org.eclipse.sirius.diagram.ui.api.layout.CustomLayoutAlgorithmProvider;
import org.eclipse.sirius.diagram.ui.api.layout.EnumChoice;
import org.eclipse.sirius.diagram.ui.api.layout.LayoutOptionFactory;

public class ELKAlgorithmProvider
implements CustomLayoutAlgorithmProvider {
    public List<CustomLayoutAlgorithm> getCustomLayoutAlgorithms() {
        ArrayList<CustomLayoutAlgorithm> layoutAlgorithms = new ArrayList<CustomLayoutAlgorithm>();
        Collection algorithmData = LayoutMetaDataService.getInstance().getAlgorithmData();
        for (LayoutAlgorithmData layoutAlgorithmData : algorithmData) {
            HashMap<String, LayoutOption> layoutOptions = new HashMap<String, LayoutOption>();
            LayoutOptionFactory layoutOptionFactory = new LayoutOptionFactory();
            this.handleOptionsData(LayoutMetaDataService.getInstance().getOptionData(layoutAlgorithmData, LayoutOptionData.Target.PARENTS), layoutOptions, layoutOptionFactory);
            this.handleOptionsData(LayoutMetaDataService.getInstance().getOptionData(layoutAlgorithmData, LayoutOptionData.Target.NODES), layoutOptions, layoutOptionFactory);
            this.handleOptionsData(LayoutMetaDataService.getInstance().getOptionData(layoutAlgorithmData, LayoutOptionData.Target.EDGES), layoutOptions, layoutOptionFactory);
            this.handleOptionsData(LayoutMetaDataService.getInstance().getOptionData(layoutAlgorithmData, LayoutOptionData.Target.PORTS), layoutOptions, layoutOptionFactory);
            this.handleOptionsData(LayoutMetaDataService.getInstance().getOptionData(layoutAlgorithmData, LayoutOptionData.Target.LABELS), layoutOptions, layoutOptionFactory);
            CustomLayoutAlgorithm customLayoutAlgorithm = CustomLayoutAlgorithm.newCustomLayoutAlgorithm((String)layoutAlgorithmData.getId()).setLabel(layoutAlgorithmData.getName()).setDescription(layoutAlgorithmData.getDescription()).setLayoutSupplier(() -> new ELKLayoutNodeProvider()).setLayoutOptions(layoutOptions).setLaunchSnapAfter(false).setStandardArrangeSelectionMechanism(false).reverseLayoutsOrder(true).build();
            layoutAlgorithms.add(customLayoutAlgorithm);
        }
        return layoutAlgorithms;
    }

    private void handleOptionsData(List<LayoutOptionData> optionDatas, Map<String, LayoutOption> layoutOptions, LayoutOptionFactory layoutOptionFactory) {
        for (LayoutOptionData layoutOptionData : optionDatas) {
            if (CoreOptions.ALGORITHM.getId().equals(layoutOptionData.getId()) || layoutOptionData.getVisibility().equals((Object)LayoutOptionData.Visibility.HIDDEN) || layoutOptions.containsKey(layoutOptionData.getId())) continue;
            switch (layoutOptionData.getType()) {
                case STRING: {
                    layoutOptions.put(layoutOptionData.getId(), layoutOptionFactory.createStringOption((String)layoutOptionData.getDefaultDefault(), layoutOptionData.getId(), layoutOptionData.getDescription(), layoutOptionData.getName(), this.getOptionTargets(layoutOptionData.getTargets())));
                    break;
                }
                case BOOLEAN: {
                    layoutOptions.put(layoutOptionData.getId(), layoutOptionFactory.createBooleanOption((Boolean)layoutOptionData.getDefaultDefault(), layoutOptionData.getId(), layoutOptionData.getDescription(), layoutOptionData.getName(), this.getOptionTargets(layoutOptionData.getTargets())));
                    break;
                }
                case INT: {
                    layoutOptions.put(layoutOptionData.getId(), layoutOptionFactory.createIntegerOption((Integer)layoutOptionData.getDefaultDefault(), layoutOptionData.getId(), layoutOptionData.getDescription(), layoutOptionData.getName(), this.getOptionTargets(layoutOptionData.getTargets())));
                    break;
                }
                case DOUBLE: {
                    layoutOptions.put(layoutOptionData.getId(), layoutOptionFactory.createDoubleOption((Double)layoutOptionData.getDefaultDefault(), layoutOptionData.getId(), layoutOptionData.getDescription(), layoutOptionData.getName(), this.getOptionTargets(layoutOptionData.getTargets())));
                    break;
                }
                case ENUM: 
                case ENUMSET: {
                    EnumSet enumSet;
                    String[] choices = layoutOptionData.getChoices();
                    ArrayList<EnumChoice> choicesList = new ArrayList<EnumChoice>();
                    int i = 0;
                    while (i < choices.length) {
                        String choiceId = choices[i];
                        choicesList.add(new EnumChoice(choiceId, ""));
                        ++i;
                    }
                    Object defaultObject = layoutOptionData.getDefaultDefault();
                    if (layoutOptionData.getType() == LayoutOptionData.Type.ENUM) {
                        String defaultValue = null;
                        if (defaultObject instanceof Enum) {
                            defaultValue = ((Enum)defaultObject).name();
                        }
                        layoutOptions.put(layoutOptionData.getId(), layoutOptionFactory.createEnumOption(choicesList, layoutOptionData.getId(), layoutOptionData.getDescription(), layoutOptionData.getName(), defaultValue, this.getOptionTargets(layoutOptionData.getTargets())));
                        break;
                    }
                    ArrayList enumValues = new ArrayList();
                    if (defaultObject instanceof EnumSet && (enumSet = (EnumSet)defaultObject).size() > 0) {
                        enumSet.forEach(enumValue -> {
                            boolean bl = enumValues.add(enumValue.name());
                        });
                    }
                    layoutOptions.put(layoutOptionData.getId(), layoutOptionFactory.createEnumSetOption(choicesList, layoutOptionData.getId(), layoutOptionData.getDescription(), layoutOptionData.getName(), enumValues, this.getOptionTargets(layoutOptionData.getTargets())));
                    break;
                }
            }
        }
    }

    private Set<LayoutOptionTarget> getOptionTargets(Set<LayoutOptionData.Target> targets) {
        HashSet<LayoutOptionTarget> result = new HashSet<LayoutOptionTarget>();
        for (LayoutOptionData.Target target : targets) {
            switch (target) {
                case PARENTS: {
                    result.add(LayoutOptionTarget.PARENT);
                    break;
                }
                case NODES: {
                    result.add(LayoutOptionTarget.NODE);
                    break;
                }
                case EDGES: {
                    result.add(LayoutOptionTarget.EDGE);
                    break;
                }
                case PORTS: {
                    result.add(LayoutOptionTarget.PORTS);
                    break;
                }
                case LABELS: {
                    result.add(LayoutOptionTarget.LABEL);
                    break;
                }
            }
        }
        return result;
    }
}

