/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.elk;

import com.google.common.collect.BiMap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.elk.alg.layered.options.CrossingMinimizationStrategy;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.IGraphLayoutEngine;
import org.eclipse.elk.core.data.LayoutMetaDataService;
import org.eclipse.elk.core.data.LayoutOptionData;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.EdgeLabelPlacement;
import org.eclipse.elk.core.options.NodeLabelPlacement;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.options.PortLabelPlacement;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.options.SizeConstraint;
import org.eclipse.elk.core.service.IDiagramLayoutConnector;
import org.eclipse.elk.core.service.LayoutMapping;
import org.eclipse.elk.core.util.BasicProgressMonitor;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.graph.ElkBendPoint;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkEdgeSection;
import org.eclipse.elk.graph.ElkGraphElement;
import org.eclipse.elk.graph.ElkLabel;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.ElkPort;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.IPropertyHolder;
import org.eclipse.elk.graph.properties.Property;
import org.eclipse.elk.graph.util.ElkGraphUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.diagram.ui.editparts.AbstractBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.LabelEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ResizableCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.TopGraphicEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.LabelPosition;
import org.eclipse.sirius.diagram.NodeStyle;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.business.api.query.DNodeQuery;
import org.eclipse.sirius.diagram.business.internal.query.DDiagramElementContainerExperimentalQuery;
import org.eclipse.sirius.diagram.business.internal.query.DNodeContainerExperimentalQuery;
import org.eclipse.sirius.diagram.description.BooleanLayoutOption;
import org.eclipse.sirius.diagram.description.CustomLayoutConfiguration;
import org.eclipse.sirius.diagram.description.DoubleLayoutOption;
import org.eclipse.sirius.diagram.description.EnumLayoutOption;
import org.eclipse.sirius.diagram.description.EnumLayoutValue;
import org.eclipse.sirius.diagram.description.EnumSetLayoutOption;
import org.eclipse.sirius.diagram.description.IntegerLayoutOption;
import org.eclipse.sirius.diagram.description.LayoutOption;
import org.eclipse.sirius.diagram.description.LayoutOptionTarget;
import org.eclipse.sirius.diagram.description.StringLayoutOption;
import org.eclipse.sirius.diagram.description.style.Side;
import org.eclipse.sirius.diagram.elk.ApplyLayoutRequest;
import org.eclipse.sirius.diagram.elk.DiagramElkPlugin;
import org.eclipse.sirius.diagram.elk.IEditPartFilter;
import org.eclipse.sirius.diagram.ui.business.api.query.EditPartQuery;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramElementContainerEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IAbstractDiagramNodeEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramElementEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.AbstractDNodeContainerCompartmentEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.AbstractDNodeListCompartmentEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNodeListElementEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.SiriusDescriptionCompartmentEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.SiriusNoteEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.SiriusTextEditPart;
import org.eclipse.sirius.diagram.ui.internal.refresh.GMFHelper;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.IBorderItemOffsets;
import org.eclipse.sirius.ext.gmf.runtime.editparts.GraphicalHelper;
import org.eclipse.sirius.ext.gmf.runtime.gef.ui.figures.AlphaDropShadowBorder;
import org.eclipse.sirius.ext.gmf.runtime.gef.ui.figures.SiriusWrapLabel;
import org.eclipse.sirius.viewpoint.LabelAlignment;
import org.eclipse.sirius.viewpoint.LabelStyle;
import org.eclipse.sirius.viewpoint.Style;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

@Singleton
public class ElkDiagramLayoutConnector
implements IDiagramLayoutConnector {
    protected CustomLayoutConfiguration layoutConfiguration;
    public static final IProperty<List<ConnectionEditPart>> CONNECTIONS = new Property("gmf.connections");
    public static final IProperty<DiagramEditPart> DIAGRAM_EDIT_PART = new Property("gmf.diagramEditPart");
    public static final IProperty<Command> LAYOUT_COMMAND = new Property("gmf.applyLayoutCommand");
    public static final IProperty<KVector> COORDINATE_OFFSET = new Property("gmf.coordinateOffset");
    public static final String PREF_EXEC_TIME_MEASUREMENT = "elk.exectime.measure";
    public static final IProperty<Boolean> NODE_SIZE_FIXED_SIZE = new Property("org.eclipse.sirius.diagram.elk.fixedNodeSize", (Object)false, null, null);
    @Inject
    private IEditPartFilter editPartFilter;
    @Inject
    private IGraphLayoutEngine graphLayoutEngine;

    public static void storeResult(ElkNode graphToStore, String diagramName, String suffix, boolean openDialog) {
        String fileName = StringUtil.isEmpty((String)suffix) ? String.valueOf(diagramName) + ".elkg" : String.valueOf(diagramName) + "_" + suffix + ".elkg";
        URI exportUri = URI.createFileURI((String)(String.valueOf(System.getProperty("java.io.tmpdir")) + fileName));
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(exportUri);
        graphToStore.setProperty(CoreOptions.NO_LAYOUT, (Object)true);
        resource.getContents().add((Object)graphToStore);
        try {
            resource.save(Collections.emptyMap());
            if (openDialog) {
                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"Export diagram as ELK Graph", (String)MessageFormat.format("Current diagram has been successfully exported into {0}", URI.decode((String)exportUri.toString())));
            }
        }
        catch (IOException e) {
            System.out.println(e);
        }
        graphToStore.setProperty(CoreOptions.NO_LAYOUT, (Object)false);
    }

    public static Rectangle getAbsoluteBounds(IFigure figure) {
        Rectangle bounds = new Rectangle(figure.getBounds()){
            static final long serialVersionUID = 1L;

            public void performScale(double factor) {
            }
        };
        figure.translateToAbsolute((Translatable)bounds);
        return bounds;
    }

    public void setLayoutConfiguration(CustomLayoutConfiguration layoutConfiguration) {
        this.layoutConfiguration = layoutConfiguration;
    }

    public static double getShadowBorderSize(EditPart editPart) {
        double shadowBorderSize = 0.0;
        if (editPart instanceof AbstractDiagramElementContainerEditPart && ((AbstractDiagramElementContainerEditPart)editPart).isShadowBorderNeeded()) {
            shadowBorderSize = AlphaDropShadowBorder.getDefaultShadowSize();
        }
        return shadowBorderSize;
    }

    public static KVector getDefaultDimension(AbstractDiagramElementContainerEditPart editPart) {
        Dimension defaultDimension = editPart.getDefaultDimension();
        KVector result = new KVector(defaultDimension.preciseWidth(), defaultDimension.preciseHeight());
        double shadowBorderSize = ElkDiagramLayoutConnector.getShadowBorderSize((EditPart)editPart);
        return result.sub(shadowBorderSize, shadowBorderSize);
    }

    protected DiagramEditor getDiagramEditor(IWorkbenchPart workbenchPart) {
        if (workbenchPart instanceof DiagramEditor) {
            return (DiagramEditor)workbenchPart;
        }
        return null;
    }

    public LayoutMapping buildLayoutGraph(DiagramEditPart diagramEditPart, Object layoutedPart, boolean isArrangeAll, boolean isArrangeAtOpening) {
        IGraphicalEditPart layoutRootPart = null;
        ArrayList<ShapeNodeEditPart> selectedParts = null;
        if (layoutedPart instanceof ShapeNodeEditPart || layoutedPart instanceof DiagramEditPart) {
            layoutRootPart = (IGraphicalEditPart)layoutedPart;
        } else if (layoutedPart instanceof IGraphicalEditPart) {
            TopGraphicEditPart tgEditPart = ((IGraphicalEditPart)layoutedPart).getTopGraphicEditPart();
            if (tgEditPart instanceof ShapeNodeEditPart) {
                layoutRootPart = (IGraphicalEditPart)tgEditPart;
            }
        } else if (layoutedPart instanceof Collection) {
            Collection selection = (Collection)layoutedPart;
            for (Object object : selection) {
                if (!(object instanceof IGraphicalEditPart)) continue;
                if (layoutRootPart != null) {
                    EditPart parent = ElkDiagramLayoutConnector.commonParent(layoutRootPart, (IGraphicalEditPart)object);
                    if (parent == null || parent instanceof RootEditPart) continue;
                    layoutRootPart = (IGraphicalEditPart)parent;
                    continue;
                }
                if (object instanceof ConnectionEditPart) continue;
                layoutRootPart = selection.size() == 1 && isArrangeAll ? ElkDiagramLayoutConnector.getTopGraphicParentEditPartIfPresent((IGraphicalEditPart)object) : (IGraphicalEditPart)object;
            }
            if (layoutRootPart != null) {
                selectedParts = new ArrayList<ShapeNodeEditPart>(selection.size());
                for (Object object : selection) {
                    if (!(object instanceof IGraphicalEditPart)) continue;
                    IGraphicalEditPart editPart = (IGraphicalEditPart)object;
                    while (editPart != null && ElkDiagramLayoutConnector.getTopGraphicParentEditPartIfPresent(editPart) != layoutRootPart) {
                        editPart = ElkDiagramLayoutConnector.getTopGraphicParentEditPartIfPresent(editPart);
                    }
                    if (!(editPart instanceof ShapeNodeEditPart) || !this.editPartFilter.filter((EditPart)editPart) || selectedParts.contains(editPart)) continue;
                    if (editPart instanceof SiriusNoteEditPart) {
                        if (!new EditPartQuery((IGraphicalEditPart)((SiriusNoteEditPart)editPart)).isMovableByAutomaticLayout(Collections.EMPTY_LIST)) continue;
                        selectedParts.add((ShapeNodeEditPart)editPart);
                        continue;
                    }
                    selectedParts.add((ShapeNodeEditPart)editPart);
                }
            }
        }
        if (layoutRootPart == null) {
            layoutRootPart = diagramEditPart;
        }
        LayoutMapping mapping = this.buildLayoutGraph(layoutRootPart, selectedParts, diagramEditPart, isArrangeAll, isArrangeAtOpening);
        return mapping;
    }

    protected static EditPart commonParent(IGraphicalEditPart editPart1, IGraphicalEditPart editPart2) {
        IGraphicalEditPart ep1 = editPart1;
        IGraphicalEditPart ep2 = editPart2;
        do {
            if (ElkDiagramLayoutConnector.isParent((EditPart)ep1, (EditPart)ep2)) {
                return ep1;
            }
            if (ElkDiagramLayoutConnector.isParent((EditPart)ep2, (EditPart)ep1)) {
                return ep2;
            }
            ep1 = ElkDiagramLayoutConnector.getTopGraphicParentEditPartIfPresent(ep1);
            ep2 = ElkDiagramLayoutConnector.getTopGraphicParentEditPartIfPresent(ep2);
        } while (ep1 != null && ep2 != null);
        return null;
    }

    private static IGraphicalEditPart getTopGraphicParentEditPartIfPresent(IGraphicalEditPart node) {
        EditPart parentEditPart = node.getParent();
        if (parentEditPart instanceof IGraphicalEditPart) {
            IGraphicalEditPart graphicalParentEditPart = (IGraphicalEditPart)parentEditPart;
            TopGraphicEditPart topGraphicEditPart = graphicalParentEditPart.getTopGraphicEditPart();
            return topGraphicEditPart != null ? topGraphicEditPart : graphicalParentEditPart;
        }
        return null;
    }

    protected static boolean isParent(EditPart parent, EditPart child) {
        EditPart editPart = child;
        do {
            if (editPart != parent) continue;
            return true;
        } while ((editPart = editPart.getParent()) != null);
        return false;
    }

    public <E extends Enum<E>> EnumSet<E> of(E e, EnumSet<E> enumSet) {
        enumSet.add(e);
        return enumSet;
    }

    protected LayoutMapping buildLayoutGraph(IGraphicalEditPart layoutRootPart, List<ShapeNodeEditPart> selection, DiagramEditPart diagramEditPart, boolean isArrangeAll, boolean isArrangeAtOpening) {
        ElkNode topNode;
        LayoutMapping mapping = new LayoutMapping(null);
        mapping.setProperty(CONNECTIONS, new LinkedList());
        mapping.setParentElement((Object)layoutRootPart);
        mapping.setProperty(DIAGRAM_EDIT_PART, (Object)diagramEditPart);
        Map<LayoutOptionTarget, Set<LayoutOption>> elkTargetToOptionsOevrrideMap = this.constructElkOptionTargetToOptionsMap();
        ElkNode parentNode = topNode = ElkGraphUtil.createGraph();
        this.applyOptionsRelatedToElementTarget((ElkGraphElement)topNode, elkTargetToOptionsOevrrideMap);
        Point parentLocation = new Point(0, 0);
        if (layoutRootPart instanceof ShapeNodeEditPart) {
            Rectangle childAbsoluteBounds = GraphicalHelper.getAbsoluteBoundsIn100Percent((GraphicalEditPart)layoutRootPart, (boolean)true);
            IGraphicalEditPart parentEditPart = ElkDiagramLayoutConnector.getTopGraphicParentEditPartIfPresent(layoutRootPart);
            if (parentEditPart != null && !(parentEditPart instanceof DiagramEditPart)) {
                parentLocation = GraphicalHelper.getAbsoluteBoundsIn100Percent((GraphicalEditPart)parentEditPart).getTopLeft();
            }
            topNode.setLocation(0.0, 0.0);
            topNode.setDimensions(childAbsoluteBounds.preciseX() + childAbsoluteBounds.preciseWidth(), childAbsoluteBounds.preciseY() + childAbsoluteBounds.preciseHeight());
            if (selection.isEmpty()) {
                selection.add((ShapeNodeEditPart)layoutRootPart);
            } else if (isArrangeAtOpening) {
                parentNode = this.createNode(mapping, layoutRootPart, topNode, elkTargetToOptionsOevrrideMap);
                parentNode.setProperty(CoreOptions.NODE_SIZE_MINIMUM, (Object)new KVector(parentNode.getHeight(), parentNode.getWidth()));
            } else {
                if (layoutRootPart == diagramEditPart) {
                    String labelText = diagramEditPart.getDiagramView().getName();
                    if (labelText.length() > 0) {
                        ElkLabel label = ElkGraphUtil.createLabel((ElkGraphElement)topNode);
                        label.setText(labelText);
                    }
                } else {
                    topNode.setLocation((double)childAbsoluteBounds.x, (double)childAbsoluteBounds.y);
                }
                topNode.setDimensions((double)childAbsoluteBounds.width, (double)childAbsoluteBounds.height);
                mapping.getGraphMap().put((Object)topNode, (Object)layoutRootPart);
                parentNode.setProperty(NODE_SIZE_FIXED_SIZE, (Object)true);
            }
        } else {
            Rectangle rootBounds = layoutRootPart.getFigure().getBounds();
            if (layoutRootPart == diagramEditPart) {
                String labelText = diagramEditPart.getDiagramView().getName();
                if (labelText.length() > 0) {
                    ElkLabel label = ElkGraphUtil.createLabel((ElkGraphElement)topNode);
                    label.setText(labelText);
                }
            } else {
                topNode.setLocation((double)rootBounds.x, (double)rootBounds.y);
            }
            topNode.setDimensions((double)rootBounds.width, (double)rootBounds.height);
            mapping.getGraphMap().put((Object)topNode, (Object)layoutRootPart);
        }
        topNode.setProperty(CoreOptions.ALGORITHM, (Object)this.layoutConfiguration.getId().trim());
        if (((View)diagramEditPart.getModel()).getElement() instanceof DSemanticDiagram) {
            topNode.setIdentifier(String.valueOf(((DSemanticDiagram)((View)diagramEditPart.getModel()).getElement()).getName()) + "_graph");
        }
        mapping.setLayoutGraph(topNode);
        if (selection != null && !selection.isEmpty()) {
            double minx = 2.147483647E9;
            double miny = 2.147483647E9;
            for (ShapeNodeEditPart editPart : selection) {
                ElkNode node = this.createNode(mapping, (IGraphicalEditPart)editPart, parentNode, elkTargetToOptionsOevrrideMap);
                minx = Math.min(minx, node.getX());
                miny = Math.min(miny, node.getY());
                boolean childrenLayouted = this.buildLayoutGraphRecursively(mapping, node, (IGraphicalEditPart)editPart, elkTargetToOptionsOevrrideMap);
                if (childrenLayouted || !(editPart instanceof AbstractDiagramElementContainerEditPart)) continue;
                node.setProperty(CoreOptions.NODE_SIZE_MINIMUM, (Object)ElkDiagramLayoutConnector.getDefaultDimension((AbstractDiagramElementContainerEditPart)editPart));
            }
            if (layoutRootPart instanceof ShapeNodeEditPart) {
                Dimension topLeftInsets = GMFHelper.getContainerTopLeftInsetsAfterLabel((Node)((Node)layoutRootPart.getNotationView()), (boolean)true);
                if (selection.size() == 1 && selection.get(0).equals(layoutRootPart)) {
                    if (isArrangeAtOpening) {
                        mapping.setProperty(COORDINATE_OFFSET, (Object)new KVector(minx - (double)parentLocation.x() + (double)topLeftInsets.width, miny - (double)parentLocation.y() + (double)topLeftInsets.height));
                    } else {
                        mapping.setProperty(COORDINATE_OFFSET, (Object)new KVector(minx - (double)parentLocation.x(), miny - (double)parentLocation.y()));
                    }
                } else if (!isArrangeAtOpening) {
                    mapping.setProperty(COORDINATE_OFFSET, (Object)new KVector(minx, miny));
                } else {
                    mapping.setProperty(COORDINATE_OFFSET, (Object)new KVector(parentNode.getX() - (double)parentLocation.x() - (double)topLeftInsets.width, parentNode.getY() - (double)parentLocation.y() - (double)topLeftInsets.height));
                }
            } else if (isArrangeAll || isArrangeAtOpening) {
                mapping.setProperty(COORDINATE_OFFSET, (Object)new KVector(20.0, 20.0));
            } else {
                mapping.setProperty(COORDINATE_OFFSET, (Object)new KVector(minx - (double)parentLocation.x(), miny - (double)parentLocation.y()));
            }
        } else {
            this.buildLayoutGraphRecursively(mapping, topNode, layoutRootPart, elkTargetToOptionsOevrrideMap);
        }
        this.processConnections(mapping, elkTargetToOptionsOevrrideMap);
        return mapping;
    }

    private Map<LayoutOptionTarget, Set<LayoutOption>> constructElkOptionTargetToOptionsMap() {
        HashMap<LayoutOptionTarget, Set<LayoutOption>> resultMap = new HashMap<LayoutOptionTarget, Set<LayoutOption>>();
        resultMap.put(LayoutOptionTarget.EDGE, new HashSet());
        resultMap.put(LayoutOptionTarget.LABEL, new HashSet());
        resultMap.put(LayoutOptionTarget.NODE, new HashSet());
        resultMap.put(LayoutOptionTarget.PARENT, new HashSet());
        resultMap.put(LayoutOptionTarget.PORTS, new HashSet());
        if (this.layoutConfiguration != null) {
            EList layoutOptions = this.layoutConfiguration.getLayoutOptions();
            for (LayoutOption layoutOption : layoutOptions) {
                EList targets = layoutOption.getTargets();
                for (LayoutOptionTarget layoutOptionTarget : targets) {
                    Set optionsSet = (Set)resultMap.get(layoutOptionTarget);
                    optionsSet.add(layoutOption);
                }
            }
        }
        return resultMap;
    }

    private void applyOptionsRelatedToElementTarget(ElkGraphElement elkElement, Map<LayoutOptionTarget, Set<LayoutOption>> elkTargetToOptionsOverrideMap) {
        if (this.layoutConfiguration != null) {
            if (elkElement instanceof ElkNode) {
                Set<LayoutOption> layoutOptionsSet = elkTargetToOptionsOverrideMap.get(LayoutOptionTarget.NODE);
                this.applyOptions(elkElement, layoutOptionsSet);
            } else if (elkElement instanceof ElkLabel) {
                Set<LayoutOption> layoutOptionsSet = elkTargetToOptionsOverrideMap.get(LayoutOptionTarget.LABEL);
                this.applyOptions(elkElement, layoutOptionsSet);
            } else if (elkElement instanceof ElkPort) {
                Set<LayoutOption> layoutOptionsSet = elkTargetToOptionsOverrideMap.get(LayoutOptionTarget.PORTS);
                this.applyOptions(elkElement, layoutOptionsSet);
            } else if (elkElement instanceof ElkEdge) {
                Set<LayoutOption> layoutOptionsSet = elkTargetToOptionsOverrideMap.get(LayoutOptionTarget.EDGE);
                this.applyOptions(elkElement, layoutOptionsSet);
            }
        }
    }

    private void applyParentNodeOption(ElkGraphElement elkElement, Map<LayoutOptionTarget, Set<LayoutOption>> elkTargetToOptionsOverrideMap) {
        Set<LayoutOption> layoutOptionsSet = elkTargetToOptionsOverrideMap.get(LayoutOptionTarget.PARENT);
        this.applyOptions(elkElement, layoutOptionsSet);
    }

    private void applyOptions(ElkGraphElement elkElement, Set<LayoutOption> layoutOptionsSet) {
        for (LayoutOption layoutOption : layoutOptionsSet) {
            LayoutOptionData layoutProperty = LayoutMetaDataService.getInstance().getOptionData(layoutOption.getId());
            switch (layoutOption.eClass().getClassifierID()) {
                case 24: {
                    EnumLayoutOption enumOption = (EnumLayoutOption)layoutOption;
                    int enumValueCount = layoutProperty.getEnumValueCount();
                    Enum elkEnum = null;
                    int i = 0;
                    while (i < enumValueCount && elkEnum == null) {
                        layoutProperty.getEnumValue(i);
                        Enum enumValue = layoutProperty.getEnumValue(i);
                        if (enumOption.getValue().getName().equals(enumValue.name())) {
                            elkEnum = enumValue;
                        }
                        ++i;
                    }
                    elkElement.setProperty((IProperty)layoutProperty, elkEnum);
                    break;
                }
                case 25: {
                    int i;
                    EnumSetLayoutOption enumSetOption = (EnumSetLayoutOption)layoutOption;
                    int enumValueCount = layoutProperty.getEnumValueCount();
                    if (enumValueCount <= 0) break;
                    EnumSet<Object> enumSet = EnumSet.noneOf(layoutProperty.getEnumValue(0).getDeclaringClass());
                    EList values = enumSetOption.getValues();
                    block10: for (EnumLayoutValue enumLayoutValue : values) {
                        i = 0;
                        while (i < enumValueCount) {
                            Enum enumValue = layoutProperty.getEnumValue(i);
                            if (enumLayoutValue.getName().equals(enumValue.name())) {
                                enumSet = this.of(enumValue, enumSet);
                                continue block10;
                            }
                            ++i;
                        }
                    }
                    elkElement.setProperty((IProperty)layoutProperty, enumSet);
                    break;
                }
                case 20: {
                    BooleanLayoutOption booleanOption = (BooleanLayoutOption)layoutOption;
                    elkElement.setProperty((IProperty)layoutProperty, (Object)booleanOption.isValue());
                    break;
                }
                case 22: {
                    IntegerLayoutOption integerOption = (IntegerLayoutOption)layoutOption;
                    elkElement.setProperty((IProperty)layoutProperty, (Object)integerOption.getValue());
                    break;
                }
                case 23: {
                    DoubleLayoutOption doubleOption = (DoubleLayoutOption)layoutOption;
                    elkElement.setProperty((IProperty)layoutProperty, (Object)doubleOption.getValue());
                    break;
                }
                case 21: {
                    StringLayoutOption stringOption = (StringLayoutOption)layoutOption;
                    elkElement.setProperty((IProperty)layoutProperty, (Object)stringOption.getValue().trim());
                    break;
                }
            }
        }
    }

    public void transferLayout(LayoutMapping mapping, boolean isArrangeAllOrArrangeAtOpeningOnDiagram) {
        DiagramEditPart diagramEditPart;
        ApplyLayoutRequest applyLayoutRequest = new ApplyLayoutRequest();
        for (Map.Entry entry : mapping.getGraphMap().entrySet()) {
            if (entry.getValue() instanceof DiagramEditPart) continue;
            ElkGraphElement graphElement = (ElkGraphElement)entry.getKey();
            IGraphicalEditPart part = (IGraphicalEditPart)entry.getValue();
            if (part instanceof AbstractDNodeListCompartmentEditPart || part instanceof AbstractDNodeContainerCompartmentEditPart || ((Boolean)graphElement.getProperty(NODE_SIZE_FIXED_SIZE)).booleanValue()) continue;
            applyLayoutRequest.addElement(graphElement, part);
        }
        ElkNode layoutGraph = mapping.getLayoutGraph();
        applyLayoutRequest.setUpperBound(layoutGraph.getWidth(), layoutGraph.getHeight());
        KVector offset = (KVector)mapping.getProperty(COORDINATE_OFFSET);
        if (offset != null) {
            ElkDiagramLayoutConnector.addOffset(mapping.getLayoutGraph(), offset);
        }
        if (DiagramElkPlugin.getDefault().isDebugging()) {
            ElkDiagramLayoutConnector.storeResult(mapping.getLayoutGraph(), mapping.getLayoutGraph().getIdentifier(), "5_afterAddingOffset", false);
        }
        if (isArrangeAllOrArrangeAtOpeningOnDiagram) {
            ElkDiagramLayoutConnector.resetOrigin(mapping.getLayoutGraph());
            if (DiagramElkPlugin.getDefault().isDebugging()) {
                ElkDiagramLayoutConnector.storeResult(mapping.getLayoutGraph(), mapping.getLayoutGraph().getIdentifier(), "6_afterResetOrigin", false);
            }
        }
        if (((InternalTransactionalEditingDomain)(diagramEditPart = (DiagramEditPart)mapping.getProperty(DIAGRAM_EDIT_PART)).getEditingDomain()).getChangeRecorder() != null) {
            Command applyLayoutCommand = diagramEditPart.getCommand((Request)applyLayoutRequest);
            mapping.setProperty(LAYOUT_COMMAND, (Object)applyLayoutCommand);
        }
    }

    public static void resetOrigin(ElkNode parentNode) {
        double minx = 2.147483647E9;
        double miny = 2.147483647E9;
        for (ElkNode child : parentNode.getChildren()) {
            minx = Math.min(minx, child.getX());
            miny = Math.min(miny, child.getY());
            for (ElkPort port : child.getPorts()) {
                KVector absolutePortLocation = ElkUtil.absolutePosition((ElkGraphElement)port);
                minx = Math.min(minx, absolutePortLocation.x);
                miny = Math.min(miny, absolutePortLocation.y);
                for (ElkLabel label : port.getLabels()) {
                    KVector absoluteLabelLocation = ElkUtil.absolutePosition((ElkGraphElement)label);
                    minx = Math.min(minx, absoluteLabelLocation.x);
                    miny = Math.min(miny, absoluteLabelLocation.y);
                }
            }
        }
        for (ElkEdge edge : parentNode.getContainedEdges()) {
            for (ElkEdgeSection section : edge.getSections()) {
                minx = Math.min(minx, section.getStartX());
                miny = Math.min(miny, section.getStartY());
                for (ElkBendPoint bendPoint : section.getBendPoints()) {
                    minx = Math.min(minx, bendPoint.getX());
                    miny = Math.min(miny, bendPoint.getY());
                }
                minx = Math.min(minx, section.getEndX());
                miny = Math.min(miny, section.getEndY());
            }
            for (ElkLabel label : edge.getLabels()) {
                KVector absoluteLabelLocation = ElkUtil.absolutePosition((ElkGraphElement)label);
                minx = Math.min(minx, absoluteLabelLocation.x);
                miny = Math.min(miny, absoluteLabelLocation.y);
            }
        }
        ElkUtil.translate((ElkNode)parentNode, (double)(20.0 - minx), (double)(20.0 - miny));
    }

    protected static void addOffset(ElkNode parentNode, KVector offset) {
        double minx = 2.147483647E9;
        double miny = 2.147483647E9;
        for (ElkNode child : parentNode.getChildren()) {
            minx = Math.min(minx, child.getX());
            miny = Math.min(miny, child.getY());
        }
        offset.add(-minx, -miny);
        ElkUtil.translate((ElkNode)parentNode, (double)offset.x, (double)offset.y);
    }

    public Command getApplyCommand(LayoutMapping mapping) {
        Command applyLayoutCommand = (Command)mapping.getProperty(LAYOUT_COMMAND);
        return applyLayoutCommand;
    }

    protected boolean buildLayoutGraphRecursively(LayoutMapping mapping, ElkNode parentLayoutNode, IGraphicalEditPart currentEditPart, Map<LayoutOptionTarget, Set<LayoutOption>> elkTargetToOptionsOverrideMap) {
        boolean childrenLayouted = false;
        double maxChildShadowBorderSize = -1.0;
        for (Object obj : currentEditPart.getChildren()) {
            ElkLabel newNodeLabel;
            IFigure figure;
            if (obj instanceof IGraphicalEditPart && !(figure = ((IGraphicalEditPart)obj).getFigure()).isVisible()) continue;
            if (obj instanceof AbstractBorderItemEditPart) {
                AbstractBorderItemEditPart borderItem = (AbstractBorderItemEditPart)obj;
                if (this.editPartFilter.filter((EditPart)borderItem)) {
                    this.createPort(mapping, borderItem, currentEditPart, parentLayoutNode, elkTargetToOptionsOverrideMap);
                }
            } else if (obj instanceof ResizableCompartmentEditPart && ((CompartmentEditPart)obj).getChildren().size() > 0) {
                CompartmentEditPart compartment = (CompartmentEditPart)obj;
                if (this.editPartFilter.filter((EditPart)compartment)) {
                    boolean compExp = true;
                    IFigure compartmentFigure = compartment.getFigure();
                    if (compartmentFigure instanceof ResizableCompartmentFigure) {
                        ResizableCompartmentFigure resizCompFigure = (ResizableCompartmentFigure)compartmentFigure;
                        compExp = resizCompFigure.isExpanded();
                    }
                    if (compExp) {
                        ElkNode intermediateNode = parentLayoutNode;
                        if (currentEditPart instanceof IDiagramElementEditPart) {
                            DNodeContainerExperimentalQuery query;
                            IDiagramElementEditPart ideep = (IDiagramElementEditPart)currentEditPart;
                            DDiagramElement dde = ideep.resolveDiagramElement();
                            if (dde instanceof DNodeList || dde instanceof DNodeContainer && new DNodeContainerExperimentalQuery((DNodeContainer)dde).isHorizontaltackContainer() || new DNodeContainerExperimentalQuery((DNodeContainer)dde).isVerticalStackContainer()) {
                                childrenLayouted = true;
                                intermediateNode = this.createNode(mapping, (IGraphicalEditPart)compartment, parentLayoutNode, elkTargetToOptionsOverrideMap);
                                Dimension topLeftInsets = GMFHelper.getContainerTopLeftInsetsAfterLabel((Node)((Node)compartment.getNotationView()), (boolean)true);
                                Dimension borderSize = GMFHelper.getBorderSize((DDiagramElementContainer)((DDiagramElementContainer)dde));
                                boolean separatorLineHeight = true;
                                ElkPadding padding = dde instanceof DNodeList ? new ElkPadding(topLeftInsets.preciseHeight() + (double)separatorLineHeight, topLeftInsets.preciseWidth(), (double)borderSize.height(), topLeftInsets.preciseWidth()) : new ElkPadding(topLeftInsets.preciseHeight(), borderSize.preciseWidth(), borderSize.preciseHeight(), borderSize.preciseWidth());
                                parentLayoutNode.setProperty(CoreOptions.PADDING, (Object)padding);
                                parentLayoutNode.setProperty(CoreOptions.SPACING_NODE_NODE, (Object)0.0);
                                parentLayoutNode.setProperty(CoreOptions.NODE_LABELS_PADDING, (Object)new ElkPadding());
                                parentLayoutNode.setProperty(LayeredOptions.CROSSING_MINIMIZATION_STRATEGY, (Object)CrossingMinimizationStrategy.INTERACTIVE);
                                if (dde instanceof DNodeContainer) {
                                    intermediateNode.setProperty(CoreOptions.PADDING, (Object)new ElkPadding(0.0, 0.0, 0.0, 0.0));
                                    intermediateNode.setProperty(CoreOptions.SPACING_NODE_NODE, (Object)0.0);
                                    intermediateNode.setProperty(LayeredOptions.CROSSING_MINIMIZATION_STRATEGY, (Object)CrossingMinimizationStrategy.INTERACTIVE);
                                }
                                intermediateNode.setProperty(CoreOptions.NODE_LABELS_PADDING, (Object)new ElkPadding());
                            } else if (dde instanceof DNodeContainer && !(query = new DNodeContainerExperimentalQuery((DNodeContainer)dde)).isHorizontaltackContainer() && query.isVerticalStackContainer()) {
                                Dimension topLeftInsets = GMFHelper.getContainerTopLeftInsets((Node)((Node)compartment.getNotationView()), (boolean)true);
                                ElkPadding padding = new ElkPadding(topLeftInsets.preciseHeight(), topLeftInsets.preciseWidth(), topLeftInsets.preciseHeight(), topLeftInsets.preciseWidth());
                                parentLayoutNode.setProperty(CoreOptions.PADDING, (Object)padding);
                                parentLayoutNode.setProperty(CoreOptions.SPACING_NODE_NODE, (Object)0.0);
                                parentLayoutNode.setProperty(LayeredOptions.CROSSING_MINIMIZATION_STRATEGY, (Object)CrossingMinimizationStrategy.INTERACTIVE);
                            }
                        }
                        childrenLayouted = this.buildLayoutGraphRecursively(mapping, intermediateNode, (IGraphicalEditPart)compartment, elkTargetToOptionsOverrideMap) || childrenLayouted;
                    }
                }
            } else if (obj instanceof ShapeNodeEditPart) {
                ShapeNodeEditPart childNodeEditPart = (ShapeNodeEditPart)obj;
                if (this.editPartFilter.filter((EditPart)childNodeEditPart)) {
                    childrenLayouted = true;
                    ElkNode node = this.createNode(mapping, (IGraphicalEditPart)childNodeEditPart, parentLayoutNode, elkTargetToOptionsOverrideMap);
                    maxChildShadowBorderSize = Math.max(maxChildShadowBorderSize, ElkDiagramLayoutConnector.getShadowBorderSize((EditPart)childNodeEditPart));
                    boolean currentChildrenLayouted = this.buildLayoutGraphRecursively(mapping, node, (IGraphicalEditPart)childNodeEditPart, elkTargetToOptionsOverrideMap);
                    if (!currentChildrenLayouted && childNodeEditPart instanceof AbstractDiagramElementContainerEditPart) {
                        Dimension defaultDimension = ((AbstractDiagramElementContainerEditPart)childNodeEditPart).getDefaultDimension();
                        node.setProperty(CoreOptions.NODE_SIZE_MINIMUM, (Object)new KVector((double)defaultDimension.width(), (double)defaultDimension.height()));
                    }
                }
            } else if (obj instanceof IGraphicalEditPart && (newNodeLabel = this.createNodeLabel(mapping, (IGraphicalEditPart)obj, currentEditPart, parentLayoutNode, elkTargetToOptionsOverrideMap)) != null) {
                parentLayoutNode.getLabels().add((Object)newNodeLabel);
            }
            if (!(maxChildShadowBorderSize >= 0.0) || !(currentEditPart.getNotationView() instanceof Node) || currentEditPart instanceof ResizableCompartmentEditPart) continue;
            Dimension topLeftInsets = GMFHelper.getContainerTopLeftInsets((Node)((Node)currentEditPart.getNotationView()), (boolean)true);
            ElkPadding ei = new ElkPadding(topLeftInsets.preciseHeight(), topLeftInsets.preciseWidth() + maxChildShadowBorderSize, topLeftInsets.preciseWidth() + maxChildShadowBorderSize, topLeftInsets.preciseWidth());
            parentLayoutNode.setProperty(CoreOptions.PADDING, (Object)ei);
        }
        return childrenLayouted;
    }

    protected ElkNode createNode(LayoutMapping mapping, IGraphicalEditPart nodeEditPart, ElkNode parentElkNode, Map<LayoutOptionTarget, Set<LayoutOption>> elkTargetToOptionsOverrideMap) {
        ElkLabel newNodeLabel;
        IFigure nodeFigure = nodeEditPart.getFigure();
        ElkNode newNode = ElkGraphUtil.createNode((ElkNode)parentElkNode);
        this.applyOptionsRelatedToElementTarget((ElkGraphElement)newNode, elkTargetToOptionsOverrideMap);
        Rectangle childAbsoluteBounds = GraphicalHelper.getAbsoluteBoundsIn100Percent((GraphicalEditPart)nodeEditPart, (boolean)true);
        KVector containerAbsoluteLocation = new KVector();
        ElkUtil.toAbsolute((KVector)containerAbsoluteLocation, (ElkNode)parentElkNode);
        newNode.setX((double)childAbsoluteBounds.x - containerAbsoluteLocation.x);
        newNode.setY((double)childAbsoluteBounds.y - containerAbsoluteLocation.y);
        double shadowBorderSize = ElkDiagramLayoutConnector.getShadowBorderSize((EditPart)nodeEditPart);
        newNode.setDimensions((double)childAbsoluteBounds.width - shadowBorderSize, (double)childAbsoluteBounds.height - shadowBorderSize);
        if (nodeEditPart instanceof AbstractDNodeListCompartmentEditPart || nodeEditPart instanceof AbstractDNodeContainerCompartmentEditPart) {
            newNode.setIdentifier("Compartment");
        } else if (((View)nodeEditPart.getModel()).getElement() instanceof DDiagramElement) {
            newNode.setIdentifier(((DDiagramElement)((View)nodeEditPart.getModel()).getElement()).getName());
        }
        try {
            Dimension minSize = nodeFigure.getMinimumSize();
            newNode.setProperty(CoreOptions.NODE_SIZE_MINIMUM, (Object)new KVector((double)minSize.width, (double)minSize.height));
        }
        catch (SWTException sWTException) {}
        if (nodeEditPart instanceof SiriusNoteEditPart || nodeEditPart instanceof SiriusTextEditPart) {
            newNode.setProperty(CoreOptions.NODE_SIZE_CONSTRAINTS, (Object)SizeConstraint.fixed());
        }
        if (parentElkNode != null) {
            parentElkNode.getChildren().add((Object)newNode);
            this.applyParentNodeOption((ElkGraphElement)parentElkNode, elkTargetToOptionsOverrideMap);
        }
        mapping.getGraphMap().put((Object)newNode, (Object)nodeEditPart);
        EObject eObj = nodeEditPart.resolveSemanticElement();
        if (eObj instanceof DNode && ((NodeStyle)((DNode)eObj).getStyle()).getLabelPosition() == LabelPosition.NODE_LITERAL && (newNodeLabel = this.createNodeLabel(mapping, nodeEditPart, (IGraphicalEditPart)nodeEditPart.getParent(), parentElkNode, elkTargetToOptionsOverrideMap)) != null) {
            newNode.getLabels().add((Object)newNodeLabel);
        }
        this.addConnections(mapping, nodeEditPart);
        return newNode;
    }

    protected Insets calcSpecificInsets(IFigure parent, IFigure child) {
        Insets result = new Insets(0);
        IFigure currentChild = child;
        IFigure currentParent = child.getParent();
        Point coordsToAdd = null;
        boolean isRelative = false;
        while (currentChild != parent && currentParent != null) {
            if (currentParent.isCoordinateSystem()) {
                isRelative = true;
                result.add(currentParent.getInsets());
                if (coordsToAdd != null) {
                    result.left += coordsToAdd.x;
                    result.top += coordsToAdd.y;
                }
                coordsToAdd = currentParent.getBounds().getLocation();
            } else if (currentParent == parent && coordsToAdd != null) {
                Point parentCoords = parent.getBounds().getLocation();
                result.left += coordsToAdd.x - parentCoords.x;
                result.top += coordsToAdd.y - parentCoords.y;
            }
            currentChild = currentParent;
            currentParent = currentChild.getParent();
        }
        if (!isRelative) {
            Rectangle parentBounds = parent.getBounds();
            currentParent = child.getParent();
            Rectangle containerBounds = currentParent.getBounds();
            result.left = containerBounds.x - parentBounds.x;
            result.top = containerBounds.y - parentBounds.y;
        }
        result.right = result.left;
        result.bottom = result.left;
        return result;
    }

    protected ElkPort createPort(LayoutMapping mapping, AbstractBorderItemEditPart portEditPart, IGraphicalEditPart nodeEditPart, ElkNode elknode, Map<LayoutOptionTarget, Set<LayoutOption>> elkTargetToOptionsOverrideMap) {
        ElkPort port = ElkGraphUtil.createPort((ElkNode)elknode);
        this.applyOptionsRelatedToElementTarget((ElkGraphElement)port, elkTargetToOptionsOverrideMap);
        elknode.setProperty(CoreOptions.PORT_LABELS_PLACEMENT, (Object)PortLabelPlacement.fixed());
        Rectangle portBounds = ElkDiagramLayoutConnector.getAbsoluteBounds(portEditPart.getFigure());
        Rectangle nodeBounds = ElkDiagramLayoutConnector.getAbsoluteBounds(nodeEditPart.getFigure());
        double xpos = portBounds.x - nodeBounds.x;
        double ypos = portBounds.y - nodeBounds.y;
        port.setLocation(xpos, ypos);
        port.setDimensions((double)portBounds.width, (double)portBounds.height);
        double borderNodeOffset = -IBorderItemOffsets.DEFAULT_OFFSET.preciseWidth();
        EObject eObj = portEditPart.resolveSemanticElement();
        if (eObj instanceof DDiagramElement && new DDiagramElementQuery((DDiagramElement)eObj).isIndirectlyCollapsed()) {
            borderNodeOffset = -IBorderItemOffsets.COLLAPSE_FILTER_OFFSET.preciseWidth();
        }
        port.setProperty(CoreOptions.PORT_BORDER_OFFSET, (Object)borderNodeOffset);
        if (eObj instanceof DNode) {
            PortSide authorizedSide = PortSide.UNDEFINED;
            DNodeQuery query = new DNodeQuery((DNode)eObj);
            List forbiddenSides = query.getForbiddenSide();
            HashSet authorizedSides = new HashSet(PortSide.SIDES_NORTH_EAST_SOUTH_WEST);
            for (Side side : forbiddenSides) {
                authorizedSides.remove(this.convertSideToPortSide(side));
            }
            if (authorizedSides.size() != 4) {
                if (authorizedSides.size() > 1) {
                    if (authorizedSides.contains(PortSide.WEST)) {
                        authorizedSide = PortSide.WEST;
                    } else if (authorizedSides.contains(PortSide.SOUTH)) {
                        authorizedSide = PortSide.SOUTH;
                    } else if (authorizedSides.contains(PortSide.EAST)) {
                        authorizedSide = PortSide.EAST;
                    } else if (authorizedSides.contains(PortSide.NORTH)) {
                        authorizedSide = PortSide.NORTH;
                    }
                } else {
                    authorizedSide = (PortSide)authorizedSides.iterator().next();
                }
                elknode.setProperty(CoreOptions.PORT_CONSTRAINTS, (Object)PortConstraints.FIXED_SIDE);
                port.setProperty(CoreOptions.PORT_SIDE, (Object)authorizedSide);
            }
        }
        mapping.getGraphMap().put((Object)port, (Object)portEditPart);
        this.addConnections(mapping, (IGraphicalEditPart)portEditPart);
        for (Object portChildObj : portEditPart.getChildren()) {
            if (!(portChildObj instanceof IGraphicalEditPart)) continue;
            IFigure labelFigure = ((IGraphicalEditPart)portChildObj).getFigure();
            String text = null;
            if (labelFigure instanceof WrappingLabel) {
                text = ((WrappingLabel)labelFigure).getText();
            } else if (labelFigure instanceof Label) {
                text = ((Label)labelFigure).getText();
            } else if (labelFigure instanceof SiriusWrapLabel) {
                SiriusWrapLabel label = (SiriusWrapLabel)labelFigure;
                text = label.getText();
            }
            if (text == null) continue;
            ElkLabel portLabel = ElkGraphUtil.createLabel((ElkGraphElement)port);
            this.applyOptionsRelatedToElementTarget((ElkGraphElement)portLabel, elkTargetToOptionsOverrideMap);
            portLabel.setText(text);
            mapping.getGraphMap().put((Object)portLabel, portChildObj);
            Rectangle labelBounds = ElkDiagramLayoutConnector.getAbsoluteBounds(labelFigure);
            portLabel.setLocation(portBounds.preciseWidth() / 2.0 - labelBounds.preciseWidth() / 2.0, (double)(portBounds.height + 1));
            try {
                Dimension size = labelFigure.getPreferredSize();
                portLabel.setDimensions((double)size.width, (double)size.height);
            }
            catch (SWTException sWTException) {}
        }
        return port;
    }

    private PortSide convertSideToPortSide(Side side) {
        PortSide result = PortSide.UNDEFINED;
        if (Side.WEST.equals((Object)side)) {
            result = PortSide.WEST;
        } else if (Side.EAST.equals((Object)side)) {
            result = PortSide.EAST;
        } else if (Side.NORTH.equals((Object)side)) {
            result = PortSide.NORTH;
        } else if (Side.SOUTH.equals((Object)side)) {
            result = PortSide.SOUTH;
        }
        return result;
    }

    protected ElkLabel createNodeLabel(LayoutMapping mapping, IGraphicalEditPart labelEditPart, IGraphicalEditPart nodeEditPart, ElkNode elknode, Map<LayoutOptionTarget, Set<LayoutOption>> elkTargetToOptionsOverrideMap) {
        if (!(labelEditPart instanceof SiriusDescriptionCompartmentEditPart)) {
            Label label;
            Object labelFigure = labelEditPart instanceof IAbstractDiagramNodeEditPart ? ((IAbstractDiagramNodeEditPart)labelEditPart).getNodeLabel() : labelEditPart.getFigure();
            String text = null;
            if (labelFigure instanceof WrappingLabel) {
                WrappingLabel wrappingLabel = (WrappingLabel)labelFigure;
                text = wrappingLabel.getText();
            } else if (labelFigure instanceof Label) {
                label = (Label)labelFigure;
                text = label.getText();
            } else if (labelFigure instanceof SiriusWrapLabel) {
                label = (SiriusWrapLabel)labelFigure;
                text = label.getText();
            }
            if (text != null) {
                Rectangle nodeBounds;
                label = ElkGraphUtil.createLabel((ElkGraphElement)elknode);
                this.applyOptionsRelatedToElementTarget((ElkGraphElement)label, elkTargetToOptionsOverrideMap);
                if (StringUtil.isEmpty((String)text)) {
                    label.setText(" ");
                } else {
                    label.setText(text);
                }
                Rectangle labelBounds = ElkDiagramLayoutConnector.getAbsoluteBounds(labelFigure);
                if (!(labelEditPart instanceof IAbstractDiagramNodeEditPart)) {
                    mapping.getGraphMap().put((Object)label, (Object)labelEditPart);
                    nodeBounds = ElkDiagramLayoutConnector.getAbsoluteBounds(nodeEditPart.getFigure());
                } else {
                    nodeBounds = ElkDiagramLayoutConnector.getAbsoluteBounds(labelEditPart.getFigure());
                }
                label.setLocation((double)(labelBounds.x - nodeBounds.x), (double)(labelBounds.y - nodeBounds.y));
                try {
                    Dimension size = labelFigure.getPreferredSize();
                    label.setDimensions((double)size.width, (double)size.height);
                }
                catch (SWTException sWTException) {}
                NodeLabelPlacement insideLabelPlacement = NodeLabelPlacement.INSIDE;
                NodeLabelPlacement verticalNodeLabelPlacement = NodeLabelPlacement.V_TOP;
                NodeLabelPlacement horizontalLabelPlacement = NodeLabelPlacement.H_CENTER;
                if (labelEditPart instanceof DNodeListElementEditPart) {
                    verticalNodeLabelPlacement = NodeLabelPlacement.V_CENTER;
                } else {
                    EObject siriusObject = labelEditPart instanceof IAbstractDiagramNodeEditPart ? labelEditPart.resolveSemanticElement() : nodeEditPart.resolveSemanticElement();
                    boolean forcedValue = false;
                    if (siriusObject instanceof DDiagramElement) {
                        if (siriusObject instanceof DNodeContainer) {
                            if (new DDiagramElementContainerExperimentalQuery((DDiagramElementContainer)((DNodeContainer)siriusObject)).isRegionInVerticalStack()) {
                                forcedValue = true;
                                verticalNodeLabelPlacement = NodeLabelPlacement.V_CENTER;
                            } else if (new DDiagramElementContainerExperimentalQuery((DDiagramElementContainer)((DNodeContainer)siriusObject)).isRegionInHorizontalStack()) {
                                forcedValue = true;
                            }
                        }
                        if (!forcedValue) {
                            DDiagramElement dde = (DDiagramElement)siriusObject;
                            Style style = dde.getStyle();
                            if (style instanceof LabelStyle) {
                                LabelAlignment labelAlignment = ((LabelStyle)style).getLabelAlignment();
                                if (labelAlignment.equals((Object)LabelAlignment.LEFT)) {
                                    horizontalLabelPlacement = NodeLabelPlacement.H_LEFT;
                                } else if (labelAlignment.equals((Object)LabelAlignment.RIGHT)) {
                                    horizontalLabelPlacement = NodeLabelPlacement.H_RIGHT;
                                }
                            }
                            if (style instanceof NodeStyle) {
                                if (((NodeStyle)style).getLabelPosition().equals((Object)LabelPosition.BORDER_LITERAL)) {
                                    insideLabelPlacement = NodeLabelPlacement.OUTSIDE;
                                }
                                verticalNodeLabelPlacement = NodeLabelPlacement.V_CENTER;
                            }
                        }
                    }
                }
                EnumSet<NodeLabelPlacement> enumSet = EnumSet.of(insideLabelPlacement, horizontalLabelPlacement, verticalNodeLabelPlacement);
                label.setProperty(CoreOptions.NODE_LABELS_PLACEMENT, enumSet);
                return label;
            }
        }
        return null;
    }

    protected void addConnections(LayoutMapping mapping, IGraphicalEditPart editPart) {
        for (Object targetConn : editPart.getTargetConnections()) {
            ConnectionEditPart connectionEditPart;
            if (!(targetConn instanceof ConnectionEditPart) || !this.editPartFilter.filter((EditPart)(connectionEditPart = (ConnectionEditPart)targetConn))) continue;
            ((List)mapping.getProperty(CONNECTIONS)).add(connectionEditPart);
            this.addConnections(mapping, (IGraphicalEditPart)connectionEditPart);
        }
    }

    protected void processConnections(LayoutMapping mapping, Map<LayoutOptionTarget, Set<LayoutOption>> elkTargetToOptionsOverrideMap) {
        HashMap<EReference, ElkEdge> reference2EdgeMap = new HashMap<EReference, ElkEdge>();
        for (ConnectionEditPart connection : (List)mapping.getProperty(CONNECTIONS)) {
            ElkGraphElement targetElem;
            ElkGraphElement sourceElem;
            ElkEdge edge;
            boolean isOppositeEdge = false;
            Optional<EdgeLabelPlacement> edgeLabelPlacement = Optional.empty();
            EObject modelObject = connection.getNotationView().getElement();
            if (modelObject instanceof EReference) {
                EReference reference = (EReference)modelObject;
                edge = (ElkEdge)reference2EdgeMap.get(reference.getEOpposite());
                if (edge != null) {
                    edgeLabelPlacement = Optional.of(EdgeLabelPlacement.TAIL);
                    isOppositeEdge = true;
                } else {
                    edge = ElkGraphUtil.createEdge(null);
                    reference2EdgeMap.put(reference, edge);
                }
            } else {
                edge = ElkGraphUtil.createEdge(null);
            }
            this.applyOptionsRelatedToElementTarget((ElkGraphElement)edge, elkTargetToOptionsOverrideMap);
            BiMap inverseGraphMap = mapping.getGraphMap().inverse();
            EditPart sourceObj = connection.getSource();
            if (sourceObj instanceof ConnectionEditPart) {
                sourceElem = (ElkGraphElement)inverseGraphMap.get((Object)((ConnectionEditPart)sourceObj).getSource());
                if (sourceElem == null) {
                    sourceElem = (ElkGraphElement)inverseGraphMap.get((Object)((ConnectionEditPart)sourceObj).getTarget());
                }
            } else {
                sourceElem = (ElkGraphElement)inverseGraphMap.get((Object)sourceObj);
            }
            ElkNode sourceShape = null;
            ElkPort sourcePort = null;
            ElkNode sourceNode = null;
            if (sourceElem instanceof ElkNode) {
                sourceShape = sourceNode = (ElkNode)sourceElem;
            } else {
                if (!(sourceElem instanceof ElkPort)) continue;
                sourcePort = (ElkPort)sourceElem;
                sourceNode = sourcePort.getParent();
                sourceShape = sourcePort;
            }
            EditPart targetObj = connection.getTarget();
            if (targetObj instanceof ConnectionEditPart) {
                targetElem = (ElkGraphElement)inverseGraphMap.get((Object)((ConnectionEditPart)targetObj).getTarget());
                if (targetElem == null) {
                    targetElem = (ElkGraphElement)inverseGraphMap.get((Object)((ConnectionEditPart)targetObj).getSource());
                }
            } else {
                targetElem = (ElkGraphElement)inverseGraphMap.get((Object)targetObj);
            }
            ElkNode targetShape = null;
            ElkNode targetNode = null;
            ElkPort targetPort = null;
            if (targetElem instanceof ElkNode) {
                targetShape = targetNode = (ElkNode)targetElem;
            } else {
                if (!(targetElem instanceof ElkPort)) continue;
                targetPort = (ElkPort)targetElem;
                targetNode = targetPort.getParent();
                targetShape = targetPort;
            }
            ElkNode edgeContainment = ElkGraphUtil.findLowestCommonAncestor((ElkNode)sourceNode, (ElkNode)targetNode);
            KVector offset = new KVector();
            ElkUtil.toAbsolute((KVector)offset, (ElkNode)edgeContainment);
            if (!isOppositeEdge) {
                edge.getSources().add((Object)sourceShape);
                edge.getTargets().add((Object)targetShape);
                edgeContainment.getContainedEdges().add((Object)edge);
                mapping.getGraphMap().put((Object)edge, (Object)connection);
                this.setEdgeLayout(edge, connection, offset);
            }
            this.processEdgeLabels(mapping, connection, edge, edgeLabelPlacement, offset, elkTargetToOptionsOverrideMap);
        }
    }

    protected void setEdgeLayout(ElkEdge edge, ConnectionEditPart connection, KVector offset) {
        double currentSize;
        Connection figure = connection.getConnectionFigure();
        PointList pointList = figure.getPoints();
        ElkEdgeSection edgeSection = ElkGraphUtil.createEdgeSection((ElkEdge)edge);
        Point firstPoint = pointList.getPoint(0);
        edgeSection.setStartX((double)firstPoint.x - offset.x);
        edgeSection.setStartY((double)firstPoint.y - offset.y);
        int i = 1;
        while (i < pointList.size() - 1) {
            Point point = pointList.getPoint(i);
            ElkGraphUtil.createBendPoint((ElkEdgeSection)edgeSection, (double)((double)point.x - offset.x), (double)((double)point.y - offset.y));
            ++i;
        }
        Point lastPoint = pointList.getPoint(pointList.size() - 1);
        edgeSection.setEndX((double)lastPoint.x - offset.x);
        edgeSection.setEndY((double)lastPoint.y - offset.y);
        if (figure instanceof Shape && (currentSize = (double)((Shape)figure).getLineWidth()) != (Double)CoreOptions.EDGE_THICKNESS.getDefault()) {
            edge.setProperty(CoreOptions.EDGE_THICKNESS, (Object)currentSize);
        }
    }

    protected void processEdgeLabels(LayoutMapping mapping, ConnectionEditPart connection, ElkEdge edge, Optional<EdgeLabelPlacement> placement, KVector offset, Map<LayoutOptionTarget, Set<LayoutOption>> elkTargetToOptionsOverrideMap) {
        for (Object obj : connection.getChildren()) {
            Label label;
            LabelEditPart labelEditPart;
            IFigure labelFigure;
            if (!(obj instanceof LabelEditPart) || (labelFigure = (labelEditPart = (LabelEditPart)obj).getFigure()) == null || !labelFigure.isVisible()) continue;
            Rectangle labelBounds = ElkDiagramLayoutConnector.getAbsoluteBounds(labelFigure);
            String labelText = null;
            Dimension iconBounds = null;
            if (labelFigure instanceof WrappingLabel) {
                WrappingLabel wrappingLabel = (WrappingLabel)labelFigure;
                labelText = wrappingLabel.getText();
                if (wrappingLabel.getIcon() != null) {
                    iconBounds = new Dimension();
                    iconBounds.width = wrappingLabel.getIcon().getBounds().width + wrappingLabel.getIconTextGap();
                    iconBounds.height = wrappingLabel.getIcon().getBounds().height;
                    labelText = "O " + labelText;
                }
            } else if (labelFigure instanceof Label) {
                label = (Label)labelFigure;
                labelText = label.getText();
                if (label.getIcon() != null) {
                    iconBounds = label.getIconBounds().getSize();
                    iconBounds.width += label.getIconTextGap();
                    labelText = "O " + labelText;
                }
            } else if (labelFigure instanceof SiriusWrapLabel) {
                label = (SiriusWrapLabel)labelFigure;
                labelText = label.getText();
                if (label.getIcon() != null) {
                    iconBounds = label.getIconBounds().getSize();
                    iconBounds.width += label.getIconTextGap();
                    labelText = "O " + labelText;
                }
            }
            if (labelText != null && labelText.length() > 0) {
                label = ElkGraphUtil.createLabel((ElkGraphElement)edge);
                this.applyOptionsRelatedToElementTarget((ElkGraphElement)label, elkTargetToOptionsOverrideMap);
                if (!placement.isPresent()) {
                    switch (labelEditPart.getKeyPoint()) {
                        case 2: {
                            label.setProperty(CoreOptions.EDGE_LABELS_PLACEMENT, (Object)EdgeLabelPlacement.HEAD);
                            break;
                        }
                        case 4: {
                            label.setProperty(CoreOptions.EDGE_LABELS_PLACEMENT, (Object)EdgeLabelPlacement.CENTER);
                            break;
                        }
                        case 3: {
                            label.setProperty(CoreOptions.EDGE_LABELS_PLACEMENT, (Object)EdgeLabelPlacement.TAIL);
                        }
                    }
                } else {
                    label.setProperty(CoreOptions.EDGE_LABELS_PLACEMENT, (Object)placement.get());
                }
                label.setLocation((double)labelBounds.x - offset.x, (double)labelBounds.y - offset.y);
                label.setWidth((double)labelBounds.width);
                label.setHeight((double)labelBounds.height);
                label.setText(labelText);
                mapping.getGraphMap().put((Object)label, (Object)labelEditPart);
                continue;
            }
            label = ElkGraphUtil.createLabel(null);
            mapping.getGraphMap().put((Object)label, (Object)labelEditPart);
        }
    }

    public void layout(LayoutMapping layoutMapping) {
        BasicProgressMonitor basicProgressMonitor = new BasicProgressMonitor(0);
        this.graphLayoutEngine.layout(layoutMapping.getLayoutGraph(), basicProgressMonitor.subTask(1.0f));
    }

    public void applyLayout(LayoutMapping mapping, IPropertyHolder settings) {
    }

    public LayoutMapping buildLayoutGraph(IWorkbenchPart workbenchPart, Object diagramPart) {
        return null;
    }
}

