/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session.danalysis;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.transaction.util.ValidateEditSupport;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.helper.RepresentationHelper;
import org.eclipse.sirius.business.api.migration.AirdResourceVersionMismatchException;
import org.eclipse.sirius.business.api.migration.DescriptionResourceVersionMismatchException;
import org.eclipse.sirius.business.api.migration.ResourceVersionMismatchDiagnostic;
import org.eclipse.sirius.business.api.query.DAnalysisQuery;
import org.eclipse.sirius.business.api.query.DRepresentationQuery;
import org.eclipse.sirius.business.api.query.FileQuery;
import org.eclipse.sirius.business.api.query.RepresentationDescriptionQuery;
import org.eclipse.sirius.business.api.query.ResourceQuery;
import org.eclipse.sirius.business.api.query.SiriusReferenceFinder;
import org.eclipse.sirius.business.api.resource.ResourceDescriptor;
import org.eclipse.sirius.business.api.resource.strategy.ResourceStrategyRegistry;
import org.eclipse.sirius.business.api.session.ModelChangeTrigger;
import org.eclipse.sirius.business.api.session.ReloadingPolicy;
import org.eclipse.sirius.business.api.session.SavingPolicy;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionEventBroker;
import org.eclipse.sirius.business.api.session.SessionListener;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.SessionService;
import org.eclipse.sirius.business.api.session.SessionStatus;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSelector;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSelectorService;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSession;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSessionHelper;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSessionService;
import org.eclipse.sirius.business.internal.representation.DRepresentationLocationManager;
import org.eclipse.sirius.business.internal.resource.ResourceModifiedFieldUpdater;
import org.eclipse.sirius.business.internal.session.IsModifiedSavingPolicy;
import org.eclipse.sirius.business.internal.session.ReloadingPolicyImpl;
import org.eclipse.sirius.business.internal.session.RepresentationNameListener;
import org.eclipse.sirius.business.internal.session.SessionEventBrokerImpl;
import org.eclipse.sirius.business.internal.session.danalysis.ControlledResourcesDetector;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionServicesImpl;
import org.eclipse.sirius.business.internal.session.danalysis.DViewOperations;
import org.eclipse.sirius.business.internal.session.danalysis.DanglingRefRemovalTrigger;
import org.eclipse.sirius.business.internal.session.danalysis.IResourceCollector;
import org.eclipse.sirius.business.internal.session.danalysis.LocalResourceCollectorCrossReferencer;
import org.eclipse.sirius.business.internal.session.danalysis.RepresentationsChangeAdapter;
import org.eclipse.sirius.business.internal.session.danalysis.Saver;
import org.eclipse.sirius.business.internal.session.danalysis.SessionResourcesSynchronizer;
import org.eclipse.sirius.business.internal.session.danalysis.SessionResourcesTracker;
import org.eclipse.sirius.business.internal.session.danalysis.SessionVSMUpdater;
import org.eclipse.sirius.business.internal.session.danalysis.SiriusReferenceFinderImpl;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.query.NotificationQuery;
import org.eclipse.sirius.common.tools.api.resource.ResourceSetSync;
import org.eclipse.sirius.common.tools.api.resource.ResourceSyncClient;
import org.eclipse.sirius.common.tools.api.util.CommandStackUtil;
import org.eclipse.sirius.common.tools.api.util.EqualityHelper;
import org.eclipse.sirius.common.tools.api.util.SiriusCrossReferenceAdapter;
import org.eclipse.sirius.ecore.extender.business.api.accessor.EcoreMetamodelDescriptor;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.sirius.ecore.extender.business.api.permission.exception.LockedInstanceException;
import org.eclipse.sirius.ecore.extender.business.internal.accessor.ModelAccessorAdapter;
import org.eclipse.sirius.tools.api.command.ui.NoUICallback;
import org.eclipse.sirius.tools.api.interpreter.InterpreterRegistry;
import org.eclipse.sirius.tools.api.profiler.SiriusTasksKey;
import org.eclipse.sirius.tools.api.ui.RefreshEditorsPrecommitListener;
import org.eclipse.sirius.tools.internal.interpreter.SessionInterpreter;
import org.eclipse.sirius.tools.internal.resource.ResourceSetUtil;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.Messages;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.impl.DAnalysisSessionEObjectImpl;

public class DAnalysisSessionImpl
extends DAnalysisSessionEObjectImpl
implements Session,
DAnalysisSession,
ResourceSyncClient {
    protected SiriusReferenceFinder siriusReferenceFinder;
    private SavingPolicy savingPolicy;
    private TransactionalEditingDomain transactionalEditingDomain;
    private Resource sessionResource;
    private DAnalysis mainDAnalysis;
    private SessionResourcesTracker tracker = new SessionResourcesTracker(this);
    private final Saver saver;
    private ReloadingPolicy reloadingPolicy;
    private IResourceCollector currentResourceCollector;
    private SessionVSMUpdater vsmUpdater = new SessionVSMUpdater(this);
    private final SessionResourcesSynchronizer resourcesSynchronizer = new SessionResourcesSynchronizer(this);
    private SessionEventBroker broker;
    private SessionService services;
    private LocalResourceCollectorCrossReferencer crossReferencer;
    private IInterpreter interpreter;
    private final ListenerList listeners = new ListenerList();
    private int lastNotification = -1;
    private RefreshEditorsPrecommitListener refreshEditorsListeners;
    private RepresentationsChangeAdapter representationsChangeAdapter;
    private RepresentationNameListener representationNameListener;
    private DRepresentationChangeListener dRepresentationChangeListener;
    private ChangeIdUpdaterListener changeIdUpdaterListener;
    private final String id;

    public DAnalysisSessionImpl(DAnalysis mainDAnalysis) {
        Preconditions.checkNotNull((Object)mainDAnalysis);
        this.sessionResource = mainDAnalysis.eResource();
        Preconditions.checkNotNull((Object)this.sessionResource, (Object)Messages.DAnalysisSessionImpl_noRessourceErrorMsg);
        this.id = this.sessionResource.getURI().toString();
        this.transactionalEditingDomain = (TransactionalEditingDomain)Preconditions.checkNotNull((Object)TransactionUtil.getEditingDomain((EObject)mainDAnalysis), (Object)Messages.DAnalysisSessionImpl_noEditingDomainErrorMsg);
        this.mainDAnalysis = mainDAnalysis;
        this.saver = new Saver(this);
        this.interpreter = new SessionInterpreter();
        this.representationsChangeAdapter = new RepresentationsChangeAdapter(this);
        super.getAnalyses().add((Object)mainDAnalysis);
        super.getResources().add((Object)this.sessionResource);
        this.setAnalysisSelector(DAnalysisSelectorService.getSelector(this));
        LocalResourceCollectorCrossReferencer semanticCrossReferencer = this.getSemanticCrossReferencer();
        this.setResourceCollector(semanticCrossReferencer);
        this.setDeferSaveToPostCommit(true);
        this.setSaveInExclusiveTransaction(true);
        this.dRepresentationChangeListener = new DRepresentationChangeListener(this);
        this.getTransactionalEditingDomain().addResourceSetListener((ResourceSetListener)this.dRepresentationChangeListener);
        this.changeIdUpdaterListener = new ChangeIdUpdaterListener();
        this.getTransactionalEditingDomain().addResourceSetListener((ResourceSetListener)this.changeIdUpdaterListener);
    }

    @Override
    public IInterpreter getInterpreter() {
        return this.interpreter;
    }

    void configureInterpreter() {
        ArrayList<String> filePaths = new ArrayList<String>();
        for (Viewpoint vp : this.getSelectedViewpointsSpecificToGeneric()) {
            Resource vpResource = vp.eResource();
            if (vpResource == null) continue;
            filePaths.add(vpResource.getURI().toPlatformString(true));
        }
        this.interpreter.setProperty((Object)"files", null);
        this.interpreter.setProperty((Object)"files", filePaths);
        InterpreterRegistry.prepareImportsFromSession(this.interpreter, this);
    }

    public LocalResourceCollectorCrossReferencer getSemanticCrossReferencer() {
        if (this.crossReferencer == null) {
            this.crossReferencer = this.createSemanticCrossReferencer();
            this.crossReferencer.setFeatureToBeCrossReferencedWhiteList(Arrays.asList(ViewpointPackage.eINSTANCE.getDRepresentationDescriptor_Representation()));
            this.interpreter.setCrossReferencer((ECrossReferenceAdapter)this.crossReferencer);
        }
        return this.crossReferencer;
    }

    protected LocalResourceCollectorCrossReferencer createSemanticCrossReferencer() {
        return new LocalResourceCollectorCrossReferencer(this);
    }

    public void registerResourceInCrossReferencer(Resource newResource) {
        if (this.crossReferencer != null && !newResource.eAdapters().contains((Object)this.crossReferencer)) {
            newResource.eAdapters().add((Object)this.crossReferencer);
        }
    }

    protected void unregisterResourceInCrossReferencer(Resource resource) {
        if (this.crossReferencer != null && resource.eAdapters().contains((Object)this.crossReferencer)) {
            resource.eAdapters().remove((Object)this.crossReferencer);
        }
    }

    protected void disableAndRemoveECrossReferenceAdapters() {
        ResourceSet resourceSet = this.getTransactionalEditingDomain().getResourceSet();
        ArrayList<Adapter> adaptersToRemove = new ArrayList<Adapter>();
        for (Adapter next : resourceSet.eAdapters()) {
            if (!(next instanceof SiriusCrossReferenceAdapter)) continue;
            ((SiriusCrossReferenceAdapter)next).disableResolveProxy();
            adaptersToRemove.add(next);
        }
        resourceSet.eAdapters().removeAll(adaptersToRemove);
        for (Resource resource : resourceSet.getResources()) {
            this.disableCrossReferencerResolve(resource);
            resource.eAdapters().clear();
        }
        Collection<Resource> semanticResources = this.getSemanticResources();
        EList<Resource> controlledResources = this.getControlledResources();
        Set<Resource> allSessionResources = this.getAllSessionResources();
        Collection<Resource> srmResources = this.getSrmResources();
        LocalResourceCollectorCrossReferencer semanticCrossReferencer = this.getSemanticCrossReferencer();
        Iterable resources = Iterables.concat(semanticResources, controlledResources, allSessionResources, srmResources);
        for (Resource resource : resources) {
            if (resourceSet.getResources().contains((Object)resource)) continue;
            this.disableCrossReferencerResolve(resource);
            resource.eAdapters().remove((Object)semanticCrossReferencer);
        }
        for (DAnalysis analysis : Iterables.filter(this.allAnalyses(), (Predicate)Predicates.notNull())) {
            this.removeAdaptersOnAnalysis(analysis);
        }
    }

    @Override
    public void addAnalysis(Resource analysisResource) {
        Preconditions.checkArgument((boolean)(analysisResource.getContents().get(0) instanceof DAnalysis));
        DAnalysis analysis = (DAnalysis)analysisResource.getContents().get(0);
        super.getResources().add((Object)analysisResource);
        super.getAnalyses().add((Object)analysis);
        this.registerResourceInCrossReferencer(analysisResource);
        this.addAdaptersOnAnalysis(analysis);
        this.notifyListeners(10);
        DViewOperations.on(this).updateSelectedViewpointsData((IProgressMonitor)new NullProgressMonitor());
        this.configureInterpreter();
    }

    @Override
    public void removeAnalysis(Resource analysisResource) {
        Preconditions.checkArgument((boolean)(analysisResource.getContents().get(0) instanceof DAnalysis));
        DAnalysis analysis = (DAnalysis)analysisResource.getContents().get(0);
        super.getResources().remove((Object)analysisResource);
        super.getAnalyses().remove((Object)analysis);
        for (DAnalysis potentialRef : this.allAnalyses()) {
            if (!potentialRef.getReferencedAnalysis().contains((Object)analysis)) continue;
            potentialRef.getReferencedAnalysis().remove((Object)analysis);
        }
        this.unregisterResourceInCrossReferencer(analysisResource);
        this.transactionalEditingDomain.getResourceSet().getResources().remove((Object)analysisResource);
        this.removeAdaptersOnAnalysis(analysis);
        this.notifyListeners(10);
    }

    @Override
    public void addReferencedAnalysis(DAnalysis newAnalysis) {
        DAnalysis referencer;
        assert (newAnalysis.eResource() != null);
        ArrayList<DAnalysis> sources = new ArrayList<DAnalysis>();
        if (!super.getAnalyses().isEmpty() && (referencer = (DAnalysis)super.getAnalyses().iterator().next()) != null) {
            sources.add(referencer);
        }
        this.addReferencedAnalysis(newAnalysis, sources);
    }

    @Override
    public void addReferencedAnalysis(DAnalysis newAnalysis, Collection<DAnalysis> referencers) {
        if (referencers != null && !referencers.isEmpty()) {
            this.registerResourceInCrossReferencer(newAnalysis.eResource());
            for (DAnalysis referencer : referencers) {
                referencer.getReferencedAnalysis().add((Object)newAnalysis);
            }
            this.addAdaptersOnAnalysis(newAnalysis);
            for (DAnalysis dAnalysis : new DAnalysisQuery(newAnalysis).getAllReferencedAnalyses()) {
                this.registerResourceInCrossReferencer(dAnalysis.eResource());
                this.addAdaptersOnAnalysis(dAnalysis);
            }
        } else {
            throw new IllegalStateException(Messages.DAnalysisSessionImpl_addNoParentAnalysisErrorMsg);
        }
        this.notifyListeners(10);
    }

    @Override
    public void removeReferencedAnalysis(DAnalysis analysis) {
        assert (analysis.eResource() != null);
        ArrayList<DAnalysis> referencers = new ArrayList<DAnalysis>();
        for (DAnalysis potentialRef : this.allAnalyses()) {
            if (!potentialRef.getReferencedAnalysis().contains((Object)analysis)) continue;
            referencers.add(potentialRef);
        }
        if (!referencers.isEmpty()) {
            for (DAnalysis referencer : referencers) {
                referencer.getReferencedAnalysis().remove((Object)analysis);
            }
        } else {
            throw new IllegalStateException(Messages.DAnalysisSessionImpl_removeNoParentAnalysisErrorMsg);
        }
        this.removeAdaptersOnAnalysis(analysis);
        this.notifyListeners(10);
    }

    @Override
    public Collection<DAnalysis> allAnalyses() {
        LinkedHashSet<DAnalysis> analysisAndReferenced = new LinkedHashSet<DAnalysis>();
        for (DAnalysis analysis : new ArrayList<DAnalysis>((Collection<DAnalysis>)super.getAnalyses())) {
            if (analysis == null) continue;
            analysisAndReferenced.add(analysis);
            this.addAllReferencedAnalyses(analysisAndReferenced, analysis);
        }
        return analysisAndReferenced;
    }

    Collection<Resource> getAllSemanticResources() {
        LinkedHashSet<Resource> semanticResources = new LinkedHashSet<Resource>(this.getSemanticResources());
        semanticResources.addAll((Collection<Resource>)this.getControlledResources());
        return semanticResources;
    }

    private void addAllReferencedAnalyses(Collection<DAnalysis> analysisAndReferenced, DAnalysis analysis) {
        for (DAnalysis referenced : Sets.newLinkedHashSet(analysis.getReferencedAnalysis())) {
            if (analysisAndReferenced.contains(referenced) || referenced.eResource() == null) continue;
            analysisAndReferenced.add(referenced);
            this.addAllReferencedAnalyses(analysisAndReferenced, referenced);
        }
    }

    DAnalysis getMainAnalysis() {
        return this.mainDAnalysis;
    }

    @Override
    public void addAdaptersOnAnalysis(DAnalysis analysis) {
        if (this.representationsChangeAdapter != null) {
            this.representationsChangeAdapter.registerAnalysis(analysis);
        }
        if (this.tracker != null) {
            this.tracker.addAdaptersOnAnalysis(analysis);
        }
    }

    @Override
    public void removeAdaptersOnAnalysis(DAnalysis analysis) {
        if (this.representationsChangeAdapter != null) {
            this.representationsChangeAdapter.unregisterAnalysis(analysis);
        }
        if (this.tracker != null) {
            this.tracker.removeAdaptersOnAnalysis(analysis);
        }
    }

    @Override
    public void moveRepresentation(DAnalysis newDAnalysisContainer, DRepresentationDescriptor repDescriptor) {
        IPermissionAuthority receiverAuthority;
        IPermissionAuthority authority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(repDescriptor.eContainer());
        NullProgressMonitor pm = new NullProgressMonitor();
        if (!authority.canDeleteInstance((EObject)repDescriptor)) {
            throw new LockedInstanceException(new EObject[]{repDescriptor});
        }
        DView dView = (DView)repDescriptor.eContainer();
        EObject semantic = !dView.getModels().isEmpty() ? (EObject)dView.getModels().iterator().next() : null;
        Viewpoint viewpoint = dView.getViewpoint();
        DView receiverDView = DAnalysisSessionImpl.findViewForRepresentation(viewpoint, newDAnalysisContainer);
        if (receiverDView == null) {
            IPermissionAuthority analysisAuthority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority((EObject)newDAnalysisContainer);
            if (analysisAuthority.canCreateIn((EObject)newDAnalysisContainer)) {
                this.createView(viewpoint, Lists.newArrayList((Object[])new EObject[]{semantic}), false, (IProgressMonitor)pm);
                receiverDView = DAnalysisSessionImpl.findViewForRepresentation(viewpoint, newDAnalysisContainer);
            } else {
                throw new LockedInstanceException(new EObject[]{newDAnalysisContainer});
            }
        }
        if ((receiverAuthority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority((EObject)receiverDView)).canCreateIn((EObject)receiverDView)) {
            DRepresentation dRepresentation = repDescriptor.getRepresentation();
            Resource sourceRepResource = dRepresentation.eResource();
            Resource targetRepResource = new DRepresentationLocationManager().getOrCreateRepresentationResource(dRepresentation, receiverDView.eResource());
            if (targetRepResource != null) {
                targetRepResource.getContents().add((Object)dRepresentation);
                repDescriptor.updateRepresentation(dRepresentation);
                receiverDView.getOwnedRepresentationDescriptors().add((Object)repDescriptor);
                if (receiverDView.eContainer() instanceof DAnalysis) {
                    DAnalysisSessionHelper.updateModelsReferences(receiverDView);
                }
                Arrays.asList(sourceRepResource, targetRepResource).stream().filter(res -> res.getContents().isEmpty()).forEach(res -> {
                    try {
                        res.delete(Collections.emptyMap());
                    }
                    catch (IOException e) {
                        SiriusPlugin.getDefault().error(Messages.SiriusUncontrolCommand_resourceDeletionFailedMsg, e);
                    }
                });
            }
        } else {
            throw new LockedInstanceException(new EObject[]{receiverDView});
        }
        for (EObject object : this.getServices().getCustomData("GMF_DIAGRAMS", repDescriptor.getRepresentation())) {
            this.getServices().putCustomData("GMF_DIAGRAMS", repDescriptor.getRepresentation(), object);
        }
    }

    private static DView findViewForRepresentation(Viewpoint vp, DAnalysis analysis) {
        for (DView view : analysis.getOwnedViews()) {
            if (view.getViewpoint() == null || !EqualityHelper.areEquals((EObject)view.getViewpoint(), (EObject)vp)) continue;
            return view;
        }
        return null;
    }

    protected Collection<Resource> collectAllReferencedResources(Resource res) {
        Collection<Resource> result = Collections.emptyList();
        if (this.currentResourceCollector != null) {
            result = this.currentResourceCollector.getAllReferencedResources(res);
        }
        return result;
    }

    protected Collection<Resource> collectAllReferencingResources(Resource res) {
        Collection<Resource> result = Collections.emptyList();
        if (this.currentResourceCollector != null) {
            result = this.currentResourceCollector.getAllReferencingResources(res);
        }
        return result;
    }

    @Override
    public synchronized void addSemanticResource(URI semanticModelURI, IProgressMonitor monitor) {
        if (semanticModelURI != null) {
            FileQuery fileQuery = new FileQuery(semanticModelURI.fileExtension());
            if (fileQuery.isSessionResourceFile() || fileQuery.isSrmFile()) {
                throw new IllegalArgumentException(Messages.DAnalysisSessionImpl_addSemanticErrorMsg);
            }
            ResourceSet resourceSet = this.transactionalEditingDomain.getResourceSet();
            try {
                monitor.beginTask(MessageFormat.format(Messages.DAnalysisSessionImpl_addSemanticResourceMsg, semanticModelURI.lastSegment()), 3);
                Resource newSemanticResource = resourceSet.getResource(semanticModelURI, false);
                if (newSemanticResource != null && newSemanticResource.getContents().isEmpty()) {
                    newSemanticResource.unload();
                }
                monitor.worked(1);
                ResourceSetUtil.setProgressMonitor(resourceSet, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                newSemanticResource = resourceSet.getResource(semanticModelURI, true);
                HashSet<Resource> alreadyKnownResources = new HashSet<Resource>(this.getSemanticResources());
                if (!alreadyKnownResources.contains(newSemanticResource)) {
                    this.doAddSemanticResource(newSemanticResource, resourceSet, alreadyKnownResources);
                }
            }
            finally {
                monitor.done();
                ResourceSetUtil.resetProgressMonitor(resourceSet);
            }
        }
    }

    protected void doAddSemanticResource(Resource newResource, ResourceSet set, Set<Resource> collector) {
        collector.add(newResource);
        if (new ResourceQuery(newResource).isAirdOrSrmResource()) {
            throw new IllegalArgumentException(Messages.DAnalysisSessionImpl_addSemanticErrorMsg);
        }
        if (newResource.getResourceSet() != set) {
            set.getResources().add((Object)newResource);
        }
        this.notifyNewMetamodels(newResource);
        for (DAnalysis analysis : this.allAnalyses()) {
            analysis.getSemanticResources().add((Object)new ResourceDescriptor(newResource.getURI()));
        }
        ControlledResourcesDetector.refreshControlledResources(this);
        this.registerResourceInCrossReferencer(newResource);
        for (Resource res : this.collectAllReferencedResources(newResource)) {
            if (collector.contains(res)) continue;
            this.doAddSemanticResource(res, set, collector);
        }
    }

    private void notifyNewMetamodels(Resource newResource) {
        if (Boolean.valueOf(System.getProperty("org.eclipse.sirius.enableUnsafeOptimisations", "false")).booleanValue()) {
            return;
        }
        Collection<EPackage> collectedMetamodels = this.collectMetamodels((TreeIterator<EObject>)newResource.getAllContents());
        ModelAccessor accessor = this.getModelAccessor();
        if (accessor != null) {
            ArrayList<EcoreMetamodelDescriptor> descriptors = new ArrayList<EcoreMetamodelDescriptor>();
            for (EPackage package1 : collectedMetamodels) {
                descriptors.add(new EcoreMetamodelDescriptor(package1));
            }
            accessor.activateMetamodels(descriptors);
        }
    }

    private Collection<EPackage> collectMetamodels(TreeIterator<EObject> allContents) {
        LinkedHashSet<EPackage> result = new LinkedHashSet<EPackage>();
        while (allContents.hasNext()) {
            result.add(((EObject)allContents.next()).eClass().getEPackage());
        }
        return result;
    }

    void setSemanticResourcesNotUptodate() {
        this.tracker.setSemanticResourcesNotUptodate();
    }

    @Override
    public Collection<Resource> getSemanticResources() {
        if (this.tracker != null) {
            return this.tracker.getSemanticResources();
        }
        return Collections.emptyList();
    }

    @Override
    public void removeSemanticResource(Resource semanticResource, IProgressMonitor monitor, boolean removeReferencingResources) {
        if (removeReferencingResources) {
            for (Resource res : this.collectAllReferencingResources(semanticResource)) {
                this.doRemoveSemanticResource(res);
            }
        }
        this.doRemoveSemanticResource(semanticResource);
    }

    protected void doRemoveSemanticResource(Resource res) {
        ResourceSet resourceSet = res.getResourceSet();
        if (resourceSet != null) {
            for (DAnalysis analysis : this.allAnalyses()) {
                analysis.getSemanticResources().remove((Object)new ResourceDescriptor(res.getURI()));
            }
            this.unregisterResourceInCrossReferencer(res);
            this.disableCrossReferencerResolve(res);
            ResourceStrategyRegistry.getInstance().unloadAtResourceSetDispose(res, (IProgressMonitor)new NullProgressMonitor());
            this.enableCrossReferencerResolve(res);
            resourceSet.getResources().remove((Object)res);
            ControlledResourcesDetector.refreshControlledResources(this);
        }
    }

    void discoverAutomaticallyLoadedResources(List<Resource> allResources) {
        SessionResourcesTracker.manageAutomaticallyLoadedResources(this, allResources);
    }

    @Override
    public Resource getSessionResource() {
        return this.sessionResource;
    }

    @Override
    public Set<Resource> getReferencedSessionResources() {
        return this.getSessionResources(false);
    }

    @Override
    public Set<Resource> getAllSessionResources() {
        return this.getSessionResources(true);
    }

    private Set<Resource> getSessionResources(boolean includeMainResource) {
        ArrayList<Resource> result = new ArrayList<Resource>();
        for (DAnalysis analysis : this.allAnalyses()) {
            Resource res = analysis.eResource();
            if (res == null || !includeMainResource && res == this.sessionResource) continue;
            result.add(res);
        }
        return ImmutableSet.copyOf(result);
    }

    protected void setSynchronizeStatusofEveryResource() {
        this.setSynchronizeStatusofEveryResource((Iterable<Resource>)this.transactionalEditingDomain.getResourceSet().getResources());
    }

    protected final void setSynchronizeStatusofEveryResource(Iterable<Resource> resourcesToConsider) {
        ResourceSetSync rsSetSync = ResourceSetSync.getOrInstallResourceSetSync((TransactionalEditingDomain)this.transactionalEditingDomain);
        ArrayList<ResourceSyncClient.ResourceStatusChange> changes = new ArrayList<ResourceSyncClient.ResourceStatusChange>();
        for (Resource resource : Sets.newHashSet(resourcesToConsider)) {
            ResourceSetSync.ResourceStatus oldStatus = ResourceSetSync.getStatus((Resource)resource);
            ResourceSetSync.ResourceStatus newStatus = resource.isModified() ? ResourceSetSync.ResourceStatus.CHANGED : ResourceSetSync.ResourceStatus.SYNC;
            changes.add(new ResourceSyncClient.ResourceStatusChange(resource, newStatus, oldStatus));
        }
        rsSetSync.statusesChanged(changes);
    }

    @Override
    public final void save(IProgressMonitor monitor) {
        this.save(null, monitor);
    }

    @Override
    public void save(Map<?, ?> options, IProgressMonitor monitor) {
        this.saver.save(options, monitor);
    }

    protected void doSave(final Map<?, ?> options, final IProgressMonitor monitor, boolean runExclusive) {
        try {
            try {
                monitor.beginTask(Messages.DAnalysisSessionImpl_saveMsg, 3);
                final ArrayList<Resource> allResources = new ArrayList<Resource>();
                allResources.addAll(this.getAllSessionResources());
                Collection<Resource> semanticResourcesCollection = this.getSemanticResources();
                allResources.addAll(semanticResourcesCollection);
                allResources.addAll((Collection<Resource>)this.getControlledResources());
                allResources.addAll(this.getSrmResources());
                monitor.worked(1);
                RunnableWithResult.Impl<Collection<Resource>> save = new RunnableWithResult.Impl<Collection<Resource>>(){

                    public void run() {
                        Collection<Resource> savedResources = DAnalysisSessionImpl.this.getSavingPolicy().save(allResources, options, (IProgressMonitor)new SubProgressMonitor(monitor, 7));
                        this.setResult(savedResources);
                    }
                };
                if (runExclusive && !this.saver.domainDisposed.get()) {
                    this.getTransactionalEditingDomain().runExclusive((Runnable)save);
                } else {
                    save.run();
                }
                Collection savedResources = (Collection)save.getResult();
                if (savedResources != null) {
                    CommandStack commandStack = this.transactionalEditingDomain.getCommandStack();
                    if (commandStack instanceof BasicCommandStack) {
                        ((BasicCommandStack)commandStack).saveIsDone();
                    }
                    if (this.allResourcesAreInSync()) {
                        this.notifyListeners(3);
                    } else {
                        this.notifyListeners(2);
                    }
                    monitor.worked(1);
                }
            }
            catch (InterruptedException e) {
                SiriusPlugin.getDefault().warning(Messages.DAnalysisSessionImpl_saveInterruptedMsg, e);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    public void statusChanged(Resource resource, ResourceSetSync.ResourceStatus oldStatus, ResourceSetSync.ResourceStatus newStatus) {
        this.resourcesSynchronizer.statusChanged(resource, oldStatus, newStatus);
    }

    public void statusesChanged(Collection<ResourceSyncClient.ResourceStatusChange> changes) {
        this.resourcesSynchronizer.statusesChanged(changes);
    }

    protected boolean isResourceOfSession(Resource resource, Iterable<Resource> resources) {
        for (Resource input : resources) {
            if (resource != input && (input.getURI() == null || !Objects.equal((Object)resource.getURI(), (Object)input.getURI()))) continue;
            return true;
        }
        return false;
    }

    void sessionResourceReloaded(Resource newSessionResource) {
        this.sessionResource = newSessionResource;
        this.mainDAnalysis = (DAnalysis)this.sessionResource.getContents().get(0);
    }

    @Override
    public void setReloadingPolicy(ReloadingPolicy reloadingPolicy) {
        this.reloadingPolicy = reloadingPolicy;
    }

    @Override
    public ReloadingPolicy getReloadingPolicy() {
        return this.reloadingPolicy != null ? this.reloadingPolicy : new ReloadingPolicyImpl(new NoUICallback());
    }

    @Override
    public void setSavingPolicy(SavingPolicy savingPolicy) {
        this.savingPolicy = savingPolicy;
    }

    @Override
    public SavingPolicy getSavingPolicy() {
        return this.savingPolicy != null ? this.savingPolicy : new IsModifiedSavingPolicy(this.transactionalEditingDomain);
    }

    protected boolean allResourcesAreInSync() {
        return this.resourcesSynchronizer.allResourcesAreInSync();
    }

    protected final boolean checkResourcesAreInSync(Iterable<? extends Resource> resourcesToConsider) {
        return this.resourcesSynchronizer.checkResourcesAreInSync(resourcesToConsider);
    }

    @Override
    public SessionStatus getStatus() {
        if (this.allResourcesAreInSync()) {
            return SessionStatus.SYNC;
        }
        return SessionStatus.DIRTY;
    }

    public void setDeferSaveToPostCommit(boolean deferSaveOnPostCommit) {
        this.saver.deferSaveToPostCommit = deferSaveOnPostCommit;
    }

    public boolean isDeferSaveToPostCommit() {
        return this.saver.deferSaveToPostCommit;
    }

    public void setSaveInExclusiveTransaction(boolean saveInExclusiveTransaction) {
        this.saver.saveInExclusiveTransaction = saveInExclusiveTransaction;
    }

    public boolean isSaveInExclusiveTransaction() {
        return this.saver.saveInExclusiveTransaction;
    }

    private void initializeAccessor() {
        ModelAccessor accessor = this.getModelAccessor();
        if (accessor != null) {
            accessor.init(this.transactionalEditingDomain.getResourceSet());
        }
    }

    @Override
    public ModelAccessor getModelAccessor() {
        return SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(this.transactionalEditingDomain.getResourceSet());
    }

    protected void initLocalTriggers() {
        Predicate danglingRemovalPredicate = Predicates.or(DanglingRefRemovalTrigger.IS_DETACHMENT, DanglingRefRemovalTrigger.IS_ATTACHMENT);
        DanglingRefRemovalTrigger danglingRemovalTrigger = new DanglingRefRemovalTrigger(this);
        this.getEventBroker().addLocalTrigger(SessionEventBrokerImpl.asFilter((Predicate<Notification>)danglingRemovalPredicate), (ModelChangeTrigger)danglingRemovalTrigger);
        this.addRefreshEditorsListener();
        for (DAnalysis analysis : this.allAnalyses()) {
            this.addAdaptersOnAnalysis(analysis);
        }
    }

    @Override
    public void addListener(SessionListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeListener(SessionListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void notifyListeners(int notification) {
        if (notification == 10 || notification == 0 || notification == 16 || notification != this.lastNotification) {
            for (SessionListener listener : Iterables.filter((Iterable)Lists.newArrayList((Object[])this.listeners.getListeners()), SessionListener.class)) {
                listener.notify(notification);
            }
            this.lastNotification = notification;
        }
    }

    @Override
    public void notifyControlledModel(Resource newControlled) {
        for (Resource controlledResource : super.getControlledResources()) {
            controlledResource.setModified(true);
        }
        super.getControlledResources().add((Object)newControlled);
        this.notifyListeners(11);
    }

    @Override
    public void notifyUnControlledModel(EObject uncontrolled, Resource resource) {
        if (resource.getContents().size() == 0) {
            super.getControlledResources().remove((Object)resource);
        }
        this.notifyListeners(11);
    }

    @Override
    public SessionEventBroker getEventBroker() {
        if (this.broker == null) {
            this.broker = new SessionEventBrokerImpl(this.transactionalEditingDomain);
        }
        return this.broker;
    }

    protected void addRefreshEditorsListener() {
        if (this.refreshEditorsListeners == null) {
            this.refreshEditorsListeners = new RefreshEditorsPrecommitListener(this.transactionalEditingDomain);
            this.getEventBroker().addLocalTrigger(RefreshEditorsPrecommitListener.IS_IMPACTING, (ModelChangeTrigger)this.refreshEditorsListeners);
            this.addListener(this.refreshEditorsListeners);
        }
    }

    @Override
    public RefreshEditorsPrecommitListener getRefreshEditorsListener() {
        return this.refreshEditorsListeners;
    }

    @Override
    public void setAnalysisSelector(DAnalysisSelector selector) {
        if (this.getServices() instanceof DAnalysisSessionService) {
            ((DAnalysisSessionService)((Object)this.getServices())).setAnalysisSelector(selector);
        }
    }

    public void setResourceCollector(IResourceCollector collector) {
        this.currentResourceCollector = collector;
    }

    @Override
    public Collection<Viewpoint> getSelectedViewpoints(boolean includeReferencedAnalysis) {
        return DViewOperations.on(this).getSelectedViewpoints(includeReferencedAnalysis);
    }

    public Collection<Viewpoint> getSelectedViewpointsSpecificToGeneric() {
        return DViewOperations.on(this).getSelectedViewpointsSpecificToGeneric();
    }

    @Override
    public Collection<DView> getSelectedViews() {
        return DViewOperations.on(this).getSelectedViews(this.allAnalyses());
    }

    @Override
    public void addSelectedView(DView view, IProgressMonitor monitor) throws IllegalArgumentException {
        DViewOperations.on(this).addSelectedView(view, monitor);
    }

    @Override
    public void removeSelectedView(DView view, IProgressMonitor monitor) {
        DViewOperations.on(this).removeSelectedView(view, monitor);
    }

    @Override
    public Collection<DView> getOwnedViews() {
        return DViewOperations.on(this).getOwnedViews();
    }

    @Override
    public void createView(Viewpoint viewpoint, Collection<EObject> semantics, IProgressMonitor monitor) {
        this.createView(viewpoint, semantics, true, monitor);
    }

    @Override
    public void createView(Viewpoint viewpoint, Collection<EObject> semantics, boolean createNewRepresentations, IProgressMonitor monitor) {
        DViewOperations.on(this).createView(viewpoint, semantics, createNewRepresentations, monitor);
    }

    @Override
    public void open(final IProgressMonitor monitor) {
        try {
            try {
                monitor.beginTask(Messages.DAnalysisSessionImpl_openMsg, 33);
                SessionManager.INSTANCE.add(this);
                monitor.worked(1);
                this.notifyListeners(6);
                monitor.worked(1);
                DslCommonPlugin.PROFILER.startWork(SiriusTasksKey.OPEN_SESSION_KEY);
                ResourceSetSync.getOrInstallResourceSetSync((TransactionalEditingDomain)this.transactionalEditingDomain).registerClient((ResourceSyncClient)this.resourcesSynchronizer);
                monitor.worked(1);
                this.representationNameListener = new RepresentationNameListener(this);
                monitor.worked(1);
                RecordingCommand initializeTrackerCommand = new RecordingCommand(this.transactionalEditingDomain){

                    protected void doExecute() {
                        DAnalysisSessionImpl.this.tracker.initialize(monitor);
                    }
                };
                this.transactionalEditingDomain.getCommandStack().execute((Command)initializeTrackerCommand);
                monitor.worked(1);
                this.setSynchronizeStatusofEveryResource();
                monitor.worked(1);
                this.configureInterpreter();
                monitor.worked(1);
                this.initializeAccessor();
                monitor.worked(1);
                ViewpointRegistry.getInstance().addListener(this.vsmUpdater);
                TransactionalEditingDomain.DefaultOptions options = (TransactionalEditingDomain.DefaultOptions)TransactionUtil.getAdapter((TransactionalEditingDomain)this.getTransactionalEditingDomain(), TransactionalEditingDomain.DefaultOptions.class);
                if (options != null) {
                    Object value = options.getDefaultTransactionOptions().get("validate_edit");
                    ValidateEditSupport delegate = null;
                    if (value instanceof ValidateEditSupport) {
                        delegate = (ValidateEditSupport)value;
                    }
                    if (!(delegate instanceof ResourceModifiedFieldUpdater) && this.getTransactionalEditingDomain() instanceof InternalTransactionalEditingDomain) {
                        InternalTransactionalEditingDomain internalDomain = (InternalTransactionalEditingDomain)this.getTransactionalEditingDomain();
                        new ResourceModifiedFieldUpdater(internalDomain, delegate);
                    }
                }
                this.registerResourceInCrossReferencer(this.sessionResource);
                DViewOperations.on(this).updateSelectedViewpointsData((IProgressMonitor)new SubProgressMonitor(monitor, 10));
                this.initLocalTriggers();
                this.checkResourceErrors();
                super.setOpen(true);
                DslCommonPlugin.PROFILER.stopWork(SiriusTasksKey.OPEN_SESSION_KEY);
                this.notifyListeners(7);
                monitor.worked(1);
            }
            catch (RuntimeException e) {
                super.setOpen(true);
                this.close((IProgressMonitor)new SubProgressMonitor(monitor, 10));
                throw e;
            }
        }
        finally {
            monitor.done();
        }
    }

    private void checkResourceErrors() {
        ArrayList<ResourceVersionMismatchDiagnostic> diagnostics = new ArrayList<ResourceVersionMismatchDiagnostic>();
        Collection<Viewpoint> activatedViewpoints = this.getSelectedViewpoints(true);
        for (Viewpoint viewpoint : activatedViewpoints) {
            for (Resource.Diagnostic diagnostic : viewpoint.eResource().getErrors()) {
                if (!(diagnostic instanceof ResourceVersionMismatchDiagnostic)) continue;
                diagnostics.add((ResourceVersionMismatchDiagnostic)diagnostic);
            }
        }
        if (!diagnostics.isEmpty()) {
            throw new DescriptionResourceVersionMismatchException(diagnostics);
        }
        Iterable representationResources = Iterables.concat(this.getReferencedSessionResources(), (Iterable)Sets.newHashSet((Object[])new Resource[]{this.getSessionResource()}));
        for (Resource resource : representationResources) {
            for (Resource.Diagnostic diagnostic : resource.getErrors()) {
                if (!(diagnostic instanceof ResourceVersionMismatchDiagnostic)) continue;
                diagnostics.add((ResourceVersionMismatchDiagnostic)diagnostic);
            }
        }
        if (!diagnostics.isEmpty()) {
            throw new AirdResourceVersionMismatchException(diagnostics);
        }
    }

    @Override
    public void close(IProgressMonitor monitor) {
        boolean isOpened = this.isOpen();
        if (isOpened) {
            ViewpointRegistry.getInstance().removeListener(this.vsmUpdater);
        }
        this.vsmUpdater = null;
        if (isOpened) {
            this.notifyListeners(8);
        }
        this.disableAndRemoveECrossReferenceAdapters();
        if (isOpened && this.getRefreshEditorsListener() != null) {
            this.removeListener(this.getRefreshEditorsListener());
        }
        this.getTransactionalEditingDomain().removeResourceSetListener((ResourceSetListener)this.dRepresentationChangeListener);
        this.dRepresentationChangeListener = null;
        this.getTransactionalEditingDomain().removeResourceSetListener((ResourceSetListener)this.changeIdUpdaterListener);
        this.changeIdUpdaterListener = null;
        this.refreshEditorsListeners = null;
        this.reloadingPolicy = null;
        this.savingPolicy = null;
        if (this.interpreter != null) {
            this.interpreter.dispose();
        }
        if (isOpened) {
            ResourceSetSync.getOrInstallResourceSetSync((TransactionalEditingDomain)this.transactionalEditingDomain).unregisterClient((ResourceSyncClient)this.resourcesSynchronizer);
            ResourceSetSync.uninstallResourceSetSync((TransactionalEditingDomain)this.transactionalEditingDomain);
            super.setOpen(false);
        }
        ResourceSet resourceSet = this.getTransactionalEditingDomain().getResourceSet();
        if (this.currentResourceCollector != null) {
            this.currentResourceCollector.dispose();
            this.currentResourceCollector = null;
        }
        this.interpreter = null;
        if (isOpened && this.representationNameListener != null) {
            this.representationNameListener.dispose();
            this.representationNameListener = null;
        }
        this.representationsChangeAdapter = null;
        if (this.broker != null) {
            this.broker.dispose();
            this.broker = null;
        }
        CommandStackUtil.flushOperations((CommandStack)this.transactionalEditingDomain.getCommandStack());
        this.unloadAllResources(monitor);
        if (isOpened) {
            this.notifyListeners(9);
            SessionManager.INSTANCE.remove(this);
        }
        if (this.tracker != null) {
            this.tracker.dispose();
            this.tracker = null;
        }
        this.crossReferencer = null;
        this.saver.dispose();
        this.transactionalEditingDomain.dispose();
        this.doDisposePermissionAuthority(resourceSet);
        ModelAccessorAdapter.disposeModelAccessor((ResourceSet)resourceSet);
        this.transactionalEditingDomain = null;
        this.getActivatedViewpoints().clear();
        this.services = null;
        this.sessionResource = null;
        this.mainDAnalysis = null;
    }

    void disableCrossReferencerResolve(Resource resource) {
        for (Adapter adapter : resource.eAdapters()) {
            if (!(adapter instanceof SiriusCrossReferenceAdapter)) continue;
            ((SiriusCrossReferenceAdapter)adapter).disableResolveProxy();
        }
    }

    void enableCrossReferencerResolve(Resource resource) {
        for (Adapter adapter : resource.eAdapters()) {
            if (!(adapter instanceof SiriusCrossReferenceAdapter)) continue;
            ((SiriusCrossReferenceAdapter)adapter).enableResolveProxy();
        }
    }

    protected void doDisposePermissionAuthority(ResourceSet resourceSet) {
        PermissionAuthorityRegistry.getDefault().getPermissionAuthority(resourceSet).dispose(resourceSet);
    }

    private void unloadAllResources(IProgressMonitor monitor) {
        ResourceSet rs = this.transactionalEditingDomain.getResourceSet();
        for (Resource resource : new ArrayList(rs.getResources())) {
            ResourceStrategyRegistry.getInstance().unloadAtResourceSetDispose(resource, monitor);
        }
        for (Resource resource : new ArrayList(rs.getResources())) {
            rs.getResources().remove((Object)resource);
        }
        super.getAnalyses().clear();
        super.getResources().clear();
        super.getControlledResources().clear();
    }

    @Override
    public TransactionalEditingDomain getTransactionalEditingDomain() {
        return this.transactionalEditingDomain;
    }

    @Override
    public SessionService getServices() {
        if (this.services == null) {
            this.services = new DAnalysisSessionServicesImpl(this);
        }
        return this.services;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public String toString() {
        return MessageFormat.format(Messages.DAnalysisSessionImpl_toStringMsg, this.getID());
    }

    public Collection<DView> getAvailableRepresentationContainers(RepresentationDescription representationDescription) {
        Viewpoint viewpoint = new RepresentationDescriptionQuery(representationDescription).getParentViewpoint();
        Collection<DAnalysis> allAnalysis = this.allAnalyses();
        ArrayList<DView> containers = new ArrayList<DView>();
        for (DAnalysis analysis : allAnalysis) {
            DView container = null;
            for (DView view : analysis.getOwnedViews()) {
                if (view == null || viewpoint != view.getViewpoint() || !(view.eContainer() instanceof DAnalysis)) continue;
                container = view;
                break;
            }
            if (container == null) continue;
            containers.add(container);
        }
        return containers;
    }

    @Override
    public Collection<Resource> getSrmResources() {
        LinkedHashSet<Resource> repFiles = new LinkedHashSet<Resource>();
        if (this.transactionalEditingDomain != null && this.transactionalEditingDomain.getResourceSet() != null) {
            ArrayList allResources = new ArrayList(this.transactionalEditingDomain.getResourceSet().getResources());
            for (Resource res : allResources) {
                if (res.getContents().isEmpty() || !(res.getContents().get(0) instanceof DRepresentation)) continue;
                repFiles.add(res);
            }
        }
        return repFiles;
    }

    public SiriusReferenceFinder getSiriusReferenceFinder() {
        if (this.siriusReferenceFinder == null) {
            this.siriusReferenceFinder = new SiriusReferenceFinderImpl(this);
        }
        return this.siriusReferenceFinder;
    }

    public class ChangeIdUpdaterListener
    extends ResourceSetListenerImpl {
        Set<EObject> notifierWithoutRepresentationDescriptors;
        Map<EObject, DRepresentationDescriptor> notifierToDRepMap;

        public boolean isPrecommitOnly() {
            return true;
        }

        public boolean isAggregatePrecommitListener() {
            return true;
        }

        public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
            List notifications = event.getNotifications();
            this.notifierWithoutRepresentationDescriptors = new HashSet<EObject>();
            this.notifierToDRepMap = new HashMap<EObject, DRepresentationDescriptor>();
            final HashSet<DRepresentationDescriptor> descriptorsToUpdate = new HashSet<DRepresentationDescriptor>();
            HashSet<DRepresentationDescriptor> descriptorsToIgnore = new HashSet<DRepresentationDescriptor>();
            for (Notification notification : notifications) {
                DRepresentationDescriptor representationDescriptor;
                EClass eClass;
                EPackage ePackage;
                boolean isTransient;
                Object notifier = notification.getNotifier();
                boolean isEObject = notifier instanceof EObject;
                boolean bl = isTransient = notification.getFeature() instanceof EStructuralFeature && ((EStructuralFeature)notification.getFeature()).isTransient();
                if (isEObject && !isTransient && ViewpointPackage.Literals.IDENTIFIED_ELEMENT.isInstance(notifier)) {
                    DRepresentationDescriptor representationDescriptor2 = this.getDRepresentationDescriptor((EObject)notifier);
                    if (representationDescriptor2 != null) {
                        descriptorsToUpdate.add(representationDescriptor2);
                    }
                    if (!ViewpointPackage.Literals.DREPRESENTATION_DESCRIPTOR.isInstance(notifier) || !ViewpointPackage.Literals.DREPRESENTATION_DESCRIPTOR__CHANGE_ID.equals(notification.getFeature())) continue;
                    descriptorsToIgnore.add((DRepresentationDescriptor)notifier);
                    continue;
                }
                if (!isEObject || isTransient || !"notation".equals((ePackage = (eClass = ((EObject)notifier).eClass()).getEPackage()).getNsPrefix()) || (representationDescriptor = this.getDRepresentationDescriptor((EObject)notifier)) == null) continue;
                descriptorsToUpdate.add(representationDescriptor);
            }
            descriptorsToUpdate.removeAll(descriptorsToIgnore);
            if (!descriptorsToUpdate.isEmpty()) {
                RecordingCommand changeIdRecordingCommand = new RecordingCommand(DAnalysisSessionImpl.this.transactionalEditingDomain){

                    protected void doExecute() {
                        for (DRepresentationDescriptor dRepresentationDescriptor : descriptorsToUpdate) {
                            RepresentationHelper.updateChangeId(dRepresentationDescriptor);
                        }
                    }
                };
                return changeIdRecordingCommand;
            }
            return null;
        }

        private DRepresentationDescriptor getDRepresentationDescriptor(EObject eObject) {
            DRepresentationDescriptor dRepresentationDescriptor = null;
            DRepresentationDescriptor repAssociatedToEObject = this.notifierToDRepMap.get(eObject);
            if (repAssociatedToEObject == null && !this.notifierWithoutRepresentationDescriptors.contains(eObject)) {
                EObject eContainer = eObject.eContainer();
                if (eObject.eContainingFeature() == null || !eObject.eContainingFeature().isTransient()) {
                    if (eContainer != null && !(eObject instanceof DRepresentation)) {
                        dRepresentationDescriptor = this.getDRepresentationDescriptor(eContainer);
                        if (dRepresentationDescriptor == null) {
                            this.notifierWithoutRepresentationDescriptors.add(eObject);
                        } else {
                            this.notifierToDRepMap.put(eObject, dRepresentationDescriptor);
                        }
                    } else if (eObject instanceof DRepresentation) {
                        dRepresentationDescriptor = new DRepresentationQuery((DRepresentation)eObject).getRepresentationDescriptor();
                        this.notifierToDRepMap.put(eObject, dRepresentationDescriptor);
                    }
                } else {
                    this.notifierWithoutRepresentationDescriptors.add(eObject);
                }
            } else {
                dRepresentationDescriptor = repAssociatedToEObject;
            }
            return dRepresentationDescriptor;
        }
    }

    private final class DRepresentationChangeListener
    extends ResourceSetListenerImpl {
        private DAnalysisSession session;

        private DRepresentationChangeListener(DAnalysisSession session) {
            this.session = session;
        }

        public void resourceSetChanged(ResourceSetChangeEvent event) {
            List notifications = event.getNotifications();
            boolean subDiagramDecorationDesciptorCleared = false;
            Collection<DRepresentation> allLoadedRepresentations = DialectManager.INSTANCE.getAllLoadedRepresentations(this.session);
            for (Notification notification : notifications) {
                if (!(notification.getNewValue() instanceof DRepresentation) && !(notification.getOldValue() instanceof DRepresentation)) continue;
                allLoadedRepresentations.stream().forEach(rep -> rep.getUiState().getSubDiagramDecorationDescriptors().clear());
                subDiagramDecorationDesciptorCleared = true;
                break;
            }
            if (!subDiagramDecorationDesciptorCleared) {
                allLoadedRepresentations.stream().forEach(rep -> {
                    Iterator<Map.Entry<Object, Object>> it = rep.getUiState().getSubDiagramDecorationDescriptors().entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry<Object, Object> next = it.next();
                        if (!(next.getValue() instanceof NoSubDecorationDescriptor)) continue;
                        it.remove();
                    }
                });
            }
        }

        public NotificationFilter getFilter() {
            NotificationFilter filter = super.getFilter();
            filter.and((NotificationFilter)new NotificationFilter.Custom(){

                public boolean matches(Notification notification) {
                    Object notifier = notification.getNotifier();
                    return !notification.isTouch() && notifier instanceof EObject && !new NotificationQuery(notification).isTransientNotification();
                }
            });
            return filter;
        }

        public boolean isPostcommitOnly() {
            return true;
        }
    }

    public static final class NoSubDecorationDescriptor {
    }
}

