/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.resource;

import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.impl.XMLParserPoolImpl;
import org.eclipse.sirius.business.internal.migration.RepresentationsFileMigrationService;
import org.eclipse.sirius.business.internal.migration.RepresentationsFileVersionSAXParser;
import org.eclipse.sirius.business.internal.resource.AirDResourceImpl;
import org.eclipse.sirius.business.internal.resource.SiriusResourceFactory;
import org.eclipse.sirius.common.tools.api.resource.ResourceMigrationMarker;
import org.osgi.framework.Version;

public class AirDResourceFactory
extends SiriusResourceFactory {
    public Resource createResource(URI uri) {
        RepresentationsFileVersionSAXParser parser = new RepresentationsFileVersionSAXParser(uri);
        boolean migrationIsNeeded = true;
        String loadedVersion = parser.getVersion((IProgressMonitor)new NullProgressMonitor());
        if (loadedVersion != null) {
            migrationIsNeeded = RepresentationsFileMigrationService.getInstance().isMigrationNeeded(Version.parseVersion((String)loadedVersion));
        }
        XMIResource resource = this.doCreateAirdResourceImpl(uri);
        this.setOptions(resource, migrationIsNeeded, loadedVersion);
        if (!resource.getEncoding().equals("UTF-8")) {
            resource.setEncoding("UTF-8");
        }
        if (migrationIsNeeded) {
            ResourceMigrationMarker.addMigrationMarker((Resource)resource);
        }
        return resource;
    }

    protected XMIResource doCreateAirdResourceImpl(URI uri) {
        return new AirDResourceImpl(uri);
    }

    private void setOptions(XMIResource resource, boolean migrationIsNeeded, String loadedVersion) {
        HashMap<Object, Object> loadOptions = new HashMap<Object, Object>();
        HashMap<Object, Object> saveOptions = new HashMap<Object, Object>();
        loadOptions.putAll(AirDResourceFactory.getDefaultLoadOptions());
        saveOptions.putAll(AirDResourceFactory.getDefaultSaveOptions());
        loadOptions.put("DEFER_ATTACHMENT", true);
        loadOptions.put("DEFER_IDREF_RESOLUTION", true);
        loadOptions.put("USE_DEPRECATED_METHODS", false);
        loadOptions.put("USE_PARSER_POOL", new XMLParserPoolImpl(true));
        loadOptions.put("USE_XML_NAME_TO_FEATURE_MAP", new HashMap());
        if (migrationIsNeeded) {
            AirDResourceImpl.addMigrationOptions(loadedVersion, loadOptions, saveOptions);
        }
        loadOptions.put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
        saveOptions.put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
        resource.getDefaultSaveOptions().putAll(saveOptions);
        resource.getDefaultLoadOptions().putAll(loadOptions);
    }
}

