/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.rectpacking.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.graph.ElkNode;

public class BlockRow {
    private double x;
    private double y;
    private double width = 0.0;
    private double height = 0.0;
    private final double nodeNodeSpacing;
    private List<ElkNode> rects = new ArrayList<ElkNode>();

    public BlockRow(double x, double y, double nodeNodeSpacing) {
        this.x = x;
        this.y = y;
        this.nodeNodeSpacing = nodeNodeSpacing;
    }

    public boolean addRectangle(ElkNode rect) {
        rect.setX(this.x + this.width + (this.rects.isEmpty() ? 0.0 : this.nodeNodeSpacing));
        rect.setY(this.y);
        this.height = Math.max(this.height, rect.getHeight());
        this.width += rect.getWidth() + (this.rects.isEmpty() ? 0.0 : this.nodeNodeSpacing);
        this.rects.add(rect);
        return true;
    }

    public void removeRectangle(ElkNode rect, boolean update) {
        this.rects.remove(rect);
        if (update) {
            this.updateRow();
        }
    }

    public void updateRow() {
        double width = 0.0;
        double height = 0.0;
        for (ElkNode rect : this.rects) {
            rect.setX(this.x + width);
            rect.setY(this.y);
            width += rect.getWidth() + this.nodeNodeSpacing;
            height = Math.max(height, rect.getHeight() + this.nodeNodeSpacing);
        }
        this.width = width - this.nodeNodeSpacing;
        this.height = height - this.nodeNodeSpacing;
    }

    public void expand(double widthForRow, double additionalHeightForRow, int index) {
        double additionalWidthForRect = (widthForRow - this.width) / (double)this.rects.size();
        int i = 0;
        this.height += additionalHeightForRow;
        this.width = widthForRow;
        for (ElkNode rect : this.rects) {
            double oldWidth = rect.getWidth();
            double oldHeight = rect.getHeight();
            rect.setX(rect.getX() + (double)i * additionalWidthForRect);
            rect.setY(rect.getY() + (double)index * additionalHeightForRow);
            rect.setWidth(rect.getWidth() + additionalWidthForRect);
            rect.setHeight(this.height);
            ++i;
            double newWidth = rect.getWidth();
            double newHeight = rect.getHeight();
            ElkUtil.translate((ElkNode)rect, (KVector)new KVector(newWidth, newHeight), (KVector)new KVector(oldWidth, oldHeight));
        }
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public List<ElkNode> getNodes() {
        return this.rects;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }
}

