/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.model.business.internal.query;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.ComputedStyleDescriptionRegistry;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.DNodeListElement;
import org.eclipse.sirius.diagram.DiagramFactory;
import org.eclipse.sirius.diagram.description.DragAndDropTargetDescription;
import org.eclipse.sirius.diagram.description.filter.FilterDescription;
import org.eclipse.sirius.model.business.internal.query.DRepresentationInternalQuery;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.Style;
import org.eclipse.sirius.viewpoint.description.AnnotationEntry;
import org.eclipse.sirius.viewpoint.description.DescriptionFactory;
import org.eclipse.sirius.viewpoint.description.style.StyleDescription;

public class DDiagramInternalQuery {
    private DDiagram dDiagram;

    public DDiagramInternalQuery(DDiagram dDiagram) {
        this.dDiagram = dDiagram;
    }

    public Collection<FilterDescription> getAllFilters() {
        ArrayList<FilterDescription> result = new ArrayList<FilterDescription>();
        result.addAll((Collection<FilterDescription>)this.dDiagram.getActivatedFilters());
        return result;
    }

    public DragAndDropTargetDescription getDragAndDropDescription() {
        return this.dDiagram.getDescription();
    }

    private void addBorderNodes(AbstractDNode abstractNode, Collection<DNode> result) {
        for (DNode borderNode : abstractNode.getOwnedBorderedNodes()) {
            result.add(borderNode);
            this.addBorderNodes(borderNode, result);
        }
    }

    private void addDiagramElementContainers(DDiagram diagram, DNodeContainer container, Collection<DDiagramElementContainer> result) {
        for (DDiagramElement elem : container.getOwnedDiagramElements()) {
            if (elem instanceof DDiagramElementContainer) {
                result.add((DDiagramElementContainer)elem);
            }
            if (!(elem instanceof DNodeContainer)) continue;
            this.addDiagramElementContainers(diagram, (DNodeContainer)elem, result);
        }
    }

    private void addDNodeListElements(DDiagramElementContainer elem, Collection<DNodeListElement> result) {
        if (elem instanceof DNodeContainer) {
            DNodeContainer container = (DNodeContainer)elem;
            for (DDiagramElement subElem : container.getOwnedDiagramElements()) {
                if (subElem instanceof DNodeListElement) {
                    result.add((DNodeListElement)subElem);
                }
                if (!(subElem instanceof DDiagramElementContainer)) continue;
                this.addDNodeListElements((DDiagramElementContainer)subElem, result);
            }
        } else if (elem instanceof DNodeList) {
            DNodeList list = (DNodeList)elem;
            result.addAll((Collection<DNodeListElement>)list.getOwnedElements());
        }
    }

    private void addDNodes(DDiagramElementContainer elem, Collection<DNode> result) {
        if (elem instanceof DNodeContainer) {
            DNodeContainer container = (DNodeContainer)elem;
            this.addBorderNodes(container, result);
            for (DDiagramElement subElem : container.getOwnedDiagramElements()) {
                if (subElem instanceof DNode) {
                    result.add((DNode)subElem);
                    DNode node = (DNode)subElem;
                    this.addBorderNodes(node, result);
                }
                if (!(subElem instanceof DDiagramElementContainer)) continue;
                this.addDNodes((DDiagramElementContainer)subElem, result);
            }
        } else if (elem instanceof DNodeList) {
            this.addBorderNodes(elem, result);
        }
    }

    public Collection<DEdge> getEdges() {
        ArrayList<DEdge> result = new ArrayList<DEdge>();
        for (DDiagramElement elem : this.dDiagram.getOwnedDiagramElements()) {
            if (!(elem instanceof DEdge)) continue;
            result.add((DEdge)elem);
        }
        return result;
    }

    public Collection<DNodeListElement> getNodeListElements() {
        ArrayList<DNodeListElement> result = new ArrayList<DNodeListElement>();
        for (DDiagramElement elem : this.dDiagram.getOwnedDiagramElements()) {
            if (elem instanceof DNodeListElement) {
                DNodeListElement nodeListElement = (DNodeListElement)elem;
                result.add(nodeListElement);
            }
            if (!(elem instanceof DDiagramElementContainer)) continue;
            this.addDNodeListElements((DDiagramElementContainer)elem, result);
        }
        return result;
    }

    public Collection<DNode> getNodes() {
        ArrayList<DNode> result = new ArrayList<DNode>();
        for (DDiagramElement elem : this.dDiagram.getOwnedDiagramElements()) {
            if (elem instanceof DNode) {
                DNode node = (DNode)elem;
                result.add(node);
                this.addBorderNodes(node, result);
            }
            if (!(elem instanceof DDiagramElementContainer)) continue;
            this.addDNodes((DDiagramElementContainer)elem, result);
        }
        return result;
    }

    public Collection<DDiagramElement> getDiagramElements() {
        ArrayList<DDiagramElement> elements = new ArrayList<DDiagramElement>();
        elements.addAll(this.getEdges());
        elements.addAll(this.getNodes());
        elements.addAll(this.getNodeListElements());
        elements.addAll(this.getContainers());
        return elements;
    }

    public Collection<DDiagramElementContainer> getContainers() {
        ArrayList<DDiagramElementContainer> result = new ArrayList<DDiagramElementContainer>();
        for (DDiagramElement elem : this.dDiagram.getOwnedDiagramElements()) {
            if (elem instanceof DDiagramElementContainer) {
                result.add((DDiagramElementContainer)elem);
            }
            if (!(elem instanceof DNodeContainer)) continue;
            this.addDiagramElementContainers(this.dDiagram, (DNodeContainer)elem, result);
        }
        return result;
    }

    public Collection<Style> getAllStyles() {
        ArrayList<Style> result = new ArrayList<Style>();
        for (DDiagramElement dDiagramElement : this.getDiagramElements()) {
            Style style = dDiagramElement.getStyle();
            if (style == null) continue;
            result.add(style);
        }
        return result;
    }

    public ComputedStyleDescriptionRegistry getComputedStyleDescriptionRegistry(boolean createIfNotExists) {
        ComputedStyleDescriptionRegistry computedStyleDescriptionRegistry = null;
        AnnotationEntry annotationEntry = null;
        Collection annotationEntries = new DRepresentationInternalQuery((DRepresentation)this.dDiagram).getAnnotation("DANNOTATION_CUSTOMIZATION_KEY");
        if (annotationEntries == null || annotationEntries.isEmpty()) {
            annotationEntry = DescriptionFactory.eINSTANCE.createAnnotationEntry();
            annotationEntry.setSource("DANNOTATION_CUSTOMIZATION_KEY");
            this.dDiagram.getOwnedAnnotationEntries().add((Object)annotationEntry);
        } else {
            annotationEntry = (AnnotationEntry)annotationEntries.iterator().next();
        }
        if (annotationEntry.getData() == null || !(annotationEntry.getData() instanceof ComputedStyleDescriptionRegistry)) {
            computedStyleDescriptionRegistry = DiagramFactory.eINSTANCE.createComputedStyleDescriptionRegistry();
            annotationEntry.setData((EObject)computedStyleDescriptionRegistry);
        } else {
            computedStyleDescriptionRegistry = (ComputedStyleDescriptionRegistry)annotationEntry.getData();
        }
        return computedStyleDescriptionRegistry;
    }

    public Collection<StyleDescription> getUsedComputedStyleDescritions() {
        EList<StyleDescription> computedStyleDescriptions;
        ArrayList<StyleDescription> usedComputedStyleDescriptions = new ArrayList<StyleDescription>();
        ComputedStyleDescriptionRegistry registry = this.getComputedStyleDescriptionRegistry(false);
        if (registry != null && !(computedStyleDescriptions = registry.getComputedStyleDescriptions()).isEmpty()) {
            for (Style style : this.getAllStyles()) {
                StyleDescription usedDescription = style.getDescription();
                if (usedDescription == null) continue;
                usedComputedStyleDescriptions.add(usedDescription);
            }
        }
        return usedComputedStyleDescriptions;
    }
}

